<?php

namespace App\Controllers\admin;

use App\Models\Admin_contact_query;
use App\Models\Orders_model;
use App\Models\Partners_model;
use App\Models\Users_model;

class Dashboard extends Admin
{

    protected Users_model $user_model;
    protected Orders_model $orders;
    protected Partners_model $partner;

    public function __construct()
    {
        parent::__construct();
        $this->user_model = new \App\Models\Users_model();
        $this->orders = new \App\Models\Orders_model();
        $this->partner = new \App\Models\Partners_model();
        helper('ResponceServices');
    }
    public function cancle_elapsed_time_order()
    {
        try {
            $currentDate = date('Y-m-d');
            $currentTimestamp = time();
            $currentTime = date('H:i', $currentTimestamp);
            $prepaid_orders = fetch_details('orders', ['status' => 'awaiting', 'payment_status' => 0, 'date_of_service' => $currentDate]);
            $setting = get_settings('general_settings', true);
            $prepaid_booking_cancellation_time = (isset($setting['prepaid_booking_cancellation_time'])) ? intval($setting['prepaid_booking_cancellation_time']) : "30";
            foreach ($prepaid_orders as $order) {
                $serviceTime = strtotime($order['starting_time']);
                $checkTime = $serviceTime - ($prepaid_booking_cancellation_time * 60); // 1800 seconds = 30 minutes
                if ($checkTime <= strtotime($currentTime)) {
                    verify_transaction($order['id']);
                }
            }
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - cancle_elapsed_time_order()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function update_subscription_status()
    {
        try {
            $db = \Config\Database::connect();
            $builder1 = $db->table('users u1');
            $partners1 = $builder1->select("u1.username, u1.city, u1.latitude, u1.longitude, u1.id")
                ->join('users_groups ug1', 'ug1.user_id = u1.id')
                ->join('partner_subscriptions ps', 'ps.partner_id = u1.id')
                ->where('ps.status', 'active')
                ->where('ps.price !=', 0)
                ->where('ug1.group_id', '3')
                ->get()
                ->getResultArray();
            $ids = [];
            foreach ($partners1 as $key => $row1) {
                $ids[] = $row1['id'];
            }
            // Check order limit for each partner and deactivate subscription if reached
            foreach ($ids as $key => $id) {
                $partner_subscription_data = $db->table('partner_subscriptions ps');
                $partner_subscription_data = $partner_subscription_data->select('ps.*')->where('ps.status', 'active')->where('partner_id', $id)
                    ->get()
                    ->getRow();
                $subscription_order_limit = $partner_subscription_data->max_order_limit;
                // Fetch the count of orders placed after the purchase_date
                $orders_count = $db->table('orders')
                    ->where('partner_id', $id)
                    ->where('created_at >', $partner_subscription_data->updated_at)
                    ->countAllResults();
                if ($partner_subscription_data->order_type == "limited") {
                    if ($orders_count >= $subscription_order_limit) {
                        $data['status'] = 'deactive';
                        $where['partner_id'] = $id;
                        $where['status'] = 'active';
                        update_details($data, $where, 'partner_subscriptions');
                        log_message('error', 'updated');
                    }
                }
            }
            $subscription_list = fetch_details('partner_subscriptions', ['status' => 'active',]);
            $currentTimestamp = date("H-i A");
            $current_date = date('Y-m-d');
            $current_time = date("H:i");
            $current_date = date('Y-m-d');

            foreach ($subscription_list as $key => $row) {
                if ($row['duration'] != 'unlimited') {
                    if ($row['expiry_date'] <= $current_date) {
                        if ($current_time === "23:59") {
                            $data['status'] = 'deactive';
                            $where['id'] = $row['id'];
                            $where['status'] = 'active';
                            $where['duration !='] = 'unlimited';
                            update_details($data, $where, 'partner_subscriptions');
                            log_message('error', 'Subscription expired and updated to deactive');
                        }
                    }
                }
            }
            $currentDate = date('Y-m-d');
            $currentTimestamp = time();
            $currentTime = date('H:i', $currentTimestamp);
            //booking auto cancellation
            $orders = fetch_details('orders', ['status' => 'awaiting', 'date_of_service' => $currentDate]);
            $setting = get_settings('general_settings', true);
            $booking_auto_cancle = (isset($setting['booking_auto_cancle_duration'])) ? intval($setting['booking_auto_cancle_duration']) : "30";
            foreach ($orders as $order) {
                $serviceTime = strtotime($order['starting_time']);
                $checkTime = $serviceTime - ($booking_auto_cancle * 60); // 1800 seconds = 30 minutes
                if ($checkTime <= strtotime($currentTime)) {
                    $data = process_refund($order['id'], 'cancelled', $order['user_id']);
                    update_details(['status' => 'cancelled'], ['id' => $order['id']], 'orders');
                }
            }

            $custom_jobs = fetch_details('custom_job_requests', ['status !=' => 'booked']);
            $currentTimestamp = date('Y-m-d H:i:s');


            foreach ($custom_jobs as $job) {
                $jobEndDateTime = $job['requested_end_date'] . ' ' . $job['requested_end_time'];
                // if ($currentTimestamp == "11-59 PM") {
                if ($jobEndDateTime <= $currentTimestamp) {
                    $data['status'] = 'cancelled';
                    $where['id'] = $job['id'];
                    $where['status !='] = "cancelled";

                    update_details($data, $where, 'custom_job_requests');
                    // log_message('error', 'custom_job_requests expired and updated to cancelled');
                }
                // }
            }
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - update_subscription_status()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function index()
    {
        try {

            if ($this->isLoggedIn && $this->userIsAdmin) {
                $db = \Config\Database::connect();
                $total_users = $db->table('users u')->select('count(u.id) as `total`')->get()->getResultArray()[0]['total'];


                $total_customers = $db->table('users u')
                    ->join('users_groups ug', 'ug.user_id = u.id')
                    ->where('ug.group_id', 2)
                    ->select('COUNT(u.id) as total')
                    ->get()
                    ->getRowArray()['total'];


                $total_on_sale_service = $db->table('services s')->select('count(s.id) as `total`')->where(['discounted_price >=' => 0])->get()->getResultArray()[0]['total'];
                $this->data['total_on_sale_service'] = $total_on_sale_service;
                // Count orders with the same conditions as the Orders page for consistency
                $total_orders = $db->table('orders o')
                    ->select('count(DISTINCT(o.id)) as total')
                    ->join('order_services os', 'os.order_id=o.id')
                    ->join('users u', 'u.id=o.user_id')
                    ->join('users up', 'up.id=o.partner_id')
                    ->join('partner_details pd', 'o.partner_id = pd.partner_id')
                    ->where('o.parent_id IS NULL')
                    ->get()->getResultArray()[0]['total'];
                $symbol =   get_currency();
                $this->data['total_orders'] = $total_orders;
                $this->data['total_users']  = $total_users;
                $this->data['total_customers']  = $total_customers;

                $this->data['currency'] = $symbol;
                setPageInfo($this->data, labels('Dashboard', 'Dashboard') . ' | ' . labels('admin_panel', 'Admin Panel'), 'dashboard');
                $Partners_model = new Partners_model();
                $limit = 5;
                $offset = ($this->request->getPost('offset') && !empty($this->request->getPost('offset'))) ? $this->request->getPost('offset') : 0;
                $order = ($this->request->getPost('order') && !empty($this->request->getPost('order'))) ? $this->request->getPost('order') : 'ASC';
                $search = ($this->request->getPost('search') && !empty($this->request->getPost('search'))) ? $this->request->getPost('search') : '';
                $where = [];
                $rating_data = $Partners_model->list(true, $search, $limit, $offset, 'number_of_orders', 'desc', $where, 'partner_id', [], '');
                $income_revenue = total_income_revenue();
                $this->data['income_revenue'] = $income_revenue;
                $admin_income_revenue = admin_income_revenue();
                $this->data['admin_income_revenue'] = $admin_income_revenue;
                $provider_income_revenue = provider_income_revenue();
                $this->data['provider_income_revenue'] = $provider_income_revenue;
                $this->data['rating_data'] = $rating_data;
                $rating_wise_rating_data = $Partners_model->list(true, $search, 3, $offset, ' pd.ratings', 'desc', $where, 'pd.partner_id', [], '');
                $this->data['rating_wise_rating_data'] = $rating_wise_rating_data;
                $top_trending_services = $this->top_trending_services();
                $this->data['top_trending_services'] = $top_trending_services;
                $this->data['categories'] = get_categories_with_translated_names();
                return view('backend/admin/template', $this->data);
            } else {
                return redirect('admin/login');
            }
        } catch (\Throwable $th) {
            throw $th;
            log_the_responce($th, 'app/Controllers/admin/Dashboard.php - index()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function top_trending_services()
    {
        try {
            $top_trending_services = fetch_top_trending_services((!empty($this->request->getPost('data_trending_filter'))) ? $this->request->getPost('data_trending_filter') : "null");
            if ($this->request->isAJAX()) {
                $response = array('error' => false, 'data' => $top_trending_services);
                print_r(json_encode($response));
            } else {
                return $top_trending_services;
            }
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '-->app/Controllers/admin/Dashboard.php  - index()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function fetch_details()
    {
        try {
            if ($this->isLoggedIn && $this->userIsAdmin) {
                $sales[] = array();
                $db = \Config\Database::connect();
                $month_total_earning = $db->table('orders o')
                    ->select('sum(o.final_total) AS total_earning,DATE_FORMAT(created_at,"%b") AS month_name')
                    ->where(['status' => 4])
                    ->groupBy('year(CURDATE()),MONTH(created_at)')
                    ->orderBy('year(CURDATE()),MONTH(created_at)')
                    ->get()->getResultArray();
                $month_wise_earning['total_earning'] = array_map('intval', array_column($month_total_earning, 'total_earning'));
                $month_wise_earning['month_name'] = array_column($month_total_earning, 'month_name');
                $sales = $month_total_earning;
                print_r(json_encode($sales));
            }
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - fetch_details()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function list()
    {
        try {
            $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
            $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
            $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
            $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
            $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
            print_r(json_encode($this->partner->list(false, $search, $limit, $offset, $sort, $order)));
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - list()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function save_web_token()
    {
        try {
            $user = fetch_details('users', ['id' => $this->userId], ['id', 'fcm_id']);
            $token = $this->request->getPost('token');
            // update_details(['panel_fcm_id' => $token,], ['id' => $user[0]['id']], 'users');
            store_users_fcm_id($user[0]['id'], $token, 'admin_panel', $token);
            print_r(json_encode("admin panel token saved"));
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - save_web_token()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    // public function test()
    // {
    //     return view('main_system_settings');
    // }
    public function forgot_password()
    {
        setPageInfo($this->data, labels('commission_settlement', 'Commission Settlement') . ' | ' . labels('admin_panel', 'Admin Panel'), 'manage_commission');
        return view('backend/forgot_password_otp');
    }
    public function recent_orders()
    {
        try {
            $orders_model = new Orders_model();
            $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 7;
            $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
            $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
            $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
            $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
            $where = [];
            print_r($orders_model->list(false, $search, $limit, $offset, $sort, $order, $where, '', '', '', '', '', ''));
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - recent_orders()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function NotFoundController()
    {
        return view('404');
    }
    public function customer_queris()
    {
        try {
            helper('function');
            $uri = service('uri');
            $db      = \Config\Database::connect();
            $symbol =   get_currency();
            $this->data['currency'] = $symbol;
            if ($this->isLoggedIn && $this->userIsAdmin) {
                setPageInfo($this->data, labels('user_queries', 'User Queries') . ' | ' . labels('admin_panel', 'Admin Panel'), 'customer_query');
                return view('backend/admin/template', $this->data);
            } else {
                return redirect('admin/login');
            }
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - customer_queris()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function customer_queris_list()
    {
        try {
            helper('function');
            $uri = service('uri');
            $admin_contact_query = new Admin_contact_query();
            $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
            $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
            $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
            $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'DESC';
            $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
            $data = $admin_contact_query->list([], 'yes', false, $limit, $offset, $sort, $order, $search);
            return $data;
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - customer_queris_list()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function upload_media()
    {
        try {
            $path = FCPATH . "/public/uploads/media/";
            if (!is_dir($path)) {
                mkdir($path, 0775, true);
            }
            $request = \Config\Services::request();
            $files = $request->getFiles();
            $other_image_info_error = "";
            foreach ($files['documents'] as $file) {
                if ($file->isValid() && !$file->hasMoved()) {
                    $newName = $file->getRandomName();
                    if (!$file->move($path, $newName)) {
                        $other_image_info_error .= 'Failed to move file: ' . $file->getErrorString() . "\n";
                    }
                } else {
                    $other_image_info_error .= 'Invalid file: ' . $file->getErrorString() . "\n";
                }
            }
            $response = [];
            if (!empty($other_image_info_error)) {
                $response['error'] = true;
                $response['file_name'] = '';
                $response['message'] = $other_image_info_error;
            } else {
                $response['error'] = false;
                $response['file_name'] = $files['documents'][0]->getName();
                $response['message'] = "Files Uploaded Successfully..!";
            }
            return $this->response->setJSON($response);
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Dashboard.php - upload_media()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }

    // public function getSQLString(){
    //     function recursivelyJsonEncode($data) {
    //         foreach ($data as $key => $value) {
    //             if (is_array($value)) {
    //                 $data[$key] = addslashes(json_encode(recursivelyJsonEncode($value)));
    //             } else {

    //                 $data[$key] = $value;
    //             }
    //         }
    //         return $data;
    //     }

    //     // Custom data construction (same structure as your example JSON)
    //     $settings = [];

    //     $settings['hero_section'] = [
    //         'status' => 1,
    //         'short_headline' => "OPPORTUNITY KNOCKS",
    //         'title' => "We Provide High Quality Professional Services",
    //         'description' => "Become an ShebaCity provider and start earning extra money today. Enjoy flexibility, choose your hours, and take control of your financial future.",
    //         'images' => [
    //             ['image' => "1742990017_b7543a5a607df5412e6b.png"],
    //             ['image' => "1742990529_dc811298a4aa05b7cb85.png"],
    //             ['image' => "1742990529_5f56f34f54c25c2abf25.png"],
    //             ['image' => "1742990529_70d695d2bb7e36041338.png"],
    //         ]
    //     ];

    //     $settings['how_it_work_section'] = [
    //         'status' => 1,
    //         'short_headline' => "HOW IT WORKS",
    //         'title' => "Become a Successful Service Provider",
    //         'description' => "Easily transform your skills into a thriving business. Our platform provides the tools you need to attract customers, manage bookings, and grow your service empire.",
    //         'steps' => [
    //             ['title' => "Create an Account as a Provider", 'description' => "Register as a service provider in the system"],
    //             ['title' => "Approval from Admin", 'description' => "The admin will review and approve the providers profile"],
    //             ['title' => "Add Services", 'description' => "The provider can list the services they offer"],
    //             ['title' => "Subscription Purchase", 'description' => "Providers need to buy a subscription to be listed for customers."],
    //             ['title' => "Receive Bookings", 'description' => "Customers can book services based on the listed offerings."],
    //             ['title' => "Custom Bookings", 'description' => "Providers can receive custom booking requests."],
    //             ['title' => "Bidding System", 'description' => "Providers can bid for custom jobs, increasing their earning opportunities."],
    //             ['title' => "Service Mode Selection", 'description' => "Providers can choose to offer services at the customer’s location or at their shop."],
    //             ['title' => "Earnings Based on Work", 'description' => "Payment is received based on the completed services."],
    //             ['title' => "Track Earnings", 'description' => "Providers can view their earnings and transaction details."],
    //             ['title' => "Promocode Offers", 'description' => "Providers can offer promo codes to attract more bookings."]
    //         ]
    //     ];

    //     $settings['category_section'] = [
    //         'status' => 0,
    //         'short_headline' => "YOUR NEEDS, OUR SERVICES ",
    //         'title' => "Discover a World of Services at Your Fingertips",
    //         'description' => "Need a cleaner, a plumber, or a tech expert? We have got you covered. Discover a wide range of services, all in one place.",
    //         'category_ids' => []
    //     ];

    //     $settings['subscription_section'] = [
    //         'status' => 1,
    //         'short_headline' => "UNLOCK UNLIMITED ACCESS",
    //         'title' => "Elevate Your Business with Our Subscription",
    //         'description' => "Get more out of eDemand with our subscription plan. Enjoy increased visibility, access to premium features, and the ability to expand your service offerings."
    //     ];

    //     $settings['top_providers_section'] = [
    //         'status' => 1,
    //         'short_headline' => "TOP RATED PROVIDERS",
    //         'title' => "Trusted by Thousands: Our Top-Rated Providers",
    //         'description' => "Our top-rated providers are customer favorites. With a proven track record of excellence, they consistently deliver outstanding service."
    //     ];

    //     $settings['review_section'] = [
    //         'status' => 1,
    //         'short_headline' => "YOUR REVIEW MATTERS",
    //         'title' => "What our Customers Says About Providers",
    //         'description' => "Discover how eDemand has transformed businesses. Hear directly from our satisfied providers about their success stories and how our platform has helped them reach new heights.",
    //         'rating_ids' => []
    //     ];

    //     $settings['faq_section'] = [
    //         'status' => 1,
    //         'short_headline' => " TRANSPARENCY MATTERS ",
    //         'title' => "Need Help? We have Got Answers",
    //         'description' => "Have questions about joining eDemand or providing services? Our FAQ section offers clear and concise answers to the most common inquiries.",
    //         'faqs' => [
    //             [
    //                 'question' => " What is eDemand, and how does it help service providers?",
    //                 'answer' => "eDemand is an on-demand service platform that connects skilled service providers with customers looking for various services, including home repairs, beauty, cleaning, and more. It helps providers grow their business by getting more job requests without marketing hassle."
    //             ]
    //         ]
    //     ];

    //     $settings['feature_section'] = [
    //         'status' => 1,
    //         'features' => [
    //             [
    //                 'short_headline' => "SET YOUR OWN HOURS, SERVE YOUR WAY",
    //                 'title' => "Take Control of Your Time and Business",
    //                 'description' => "Enjoy unparalleled flexibility as you build your service empire. Our platform empowers you to set your own schedule, choose your clients, and balance your work life seamlessly.",
    //                 'position' => "left",
    //                 'image' => "1750223683_f947a8b3c6805afab971.png"
    //             ],
    //             [
    //                 'short_headline' => "CONNECT, CHAT, CARE",
    //                 'title' => "Instant Messaging for Better Service",
    //                 'description' => "Enjoy unparalleled flexibility as you build your service empire. Our platform empowers you to set your own schedule, choose your clients, and balance your work life seamlessly.",
    //                 'position' => "left",
    //                 'image' => "1750223683_4fbcfaab253c5fc28955.png"
    //             ],
    //             [
    //                 'short_headline' => "YOUR SERVICE, YOUR RULES",
    //                 'title' => "Take Charge of Your Service Business",
    //                 'description' => "Create detailed service listings including a unique name, categorize your service for easy discovery, and outline the specific tasks involved. Enhance your listing with relevant files like images or documents. Provide a clear and informative description of your service, including pricing details and frequently asked questions.\r\n\r\nManage your service status, cancellation policy, and payment options. Choose whether your service is offered at your location or at the customers doorstep.",
    //                 'position' => "left",
    //                 'image' => "1750223683_44ebbe844bd3fa6f5ecd.png"
    //             ]
    //         ]
    //     ];

    //     // Recursively encode each section's value
    //     $settings = recursivelyJsonEncode($settings);

    //     // print_r($settings);
    //     // die();
    //     // $final = addslashes($settings);
    //     $final = json_encode($settings);
    //     // echo "INSERT INTO `settings` (`variable`, `value`, `created_at`, `updated_at`) VALUES ('become_provider_page_settings', '{$final}', NOW(), NOW());\n\n";
    //     echo "Update `settings` set `value` = '{$final}' where `variable` = 'become_provider_page_settings';";
    // }

    public function getSQLString()
    {
        $db = \Config\Database::connect();
        $setting = [
            'hero_section' => json_encode([
                'status' => 1,
                'short_headline' => 'OPPORTUNITY KNOCKS',
                'title' => 'We Provide High Quality Professional Services',
                'description' => 'Become an eDemand provider and start earning extra money today. Enjoy flexibility, choose your hours, and take control of your financial future.',
                'images' => [
                    ['image' => '1742990017_b7543a5a607df5412e6b.png'],
                    ['image' => '1742990529_dc811298a4aa05b7cb85.png'],
                    ['image' => '1742990529_5f56f34f54c25c2abf25.png'],
                    ['image' => '1742990529_70d695d2bb7e36041338.png']
                ]
            ]),
            'how_it_work_section' => json_encode([
                'status' => 1,
                'short_headline' => 'HOW IT WORKS',
                'title' => 'Become a Successful Service Provider',
                'description' => 'Easily transform your skills into a thriving business. Our platform provides the tools you need to attract customers, manage bookings, and grow your service empire.',
                'steps' => json_encode([
                    ['title' => 'Create Your Provider Account', 'description' => 'Start by registering on our platform as a service provider.'],
                    ['title' => 'Build Your Service Profile', 'description' => 'Showcase your expertise by adding detailed information about the services.']
                ])
            ]),
            'category_section' => json_encode([
                'status' => 1,
                'short_headline' => 'YOUR NEEDS, OUR SERVICES ',
                'title' => 'Discover a World of Services at Your Fingertips',
                'description' => 'Need a cleaner, a plumber, or a tech expert? We have got you covered. Discover a wide range of services, all in one place.'
            ]),
            'subscription_section' => json_encode([
                'status' => 1,
                'short_headline' => 'UNLOCK UNLIMITED ACCESS',
                'title' => 'Elevate Your Business with Our Subscription',
                'description' => ' Get more out of eDemand with our subscription plan. Enjoy increased visibility, access to premium features, and the ability to expand your service offerings.'
            ]),
            'top_providers_section' => json_encode([
                'status' => 1,
                'short_headline' => 'TOP RATED PROVIDERS',
                'title' => 'Trusted by Thousands: Our Top-Rated Providers',
                'description' => 'Our top-rated providers are customer favorites. With a proven track record of excellence, they consistently deliver outstanding service.'
            ]),
            'review_section' => json_encode([
                'status' => 1,
                'short_headline' => 'YOUR REVIEW MATTERS',
                'title' => 'what our Customers Says About Providers',
                'description' => 'Discover how eDemand has transformed businesses. Hear directly from our satisfied providers about their success stories and how our platform has helped them reach new heights.'
            ]),
            'faq_section' => json_encode([
                'status' => 1,
                'short_headline' => 'TRANSPARENCY MATTERS',
                'title' => "Need Help? We have Got Answers",
                'description' => 'Have questions about joining eDemand or providing services? Our FAQ section offers clear and concise answers to the most common inquiries.'
            ]),
            'feature_section' => json_encode([
                'status' => 1,
                'features' => [
                    [
                        'short_headline' => 'SET YOUR OWN HOURS, SERVE YOUR WAY',
                        'title' => 'Take Control of Your Time and Business',
                        'description' => 'Enjoy unparalleled flexibility as you build your service empire. Our platform empowers you to set your own schedule, choose your clients, and balance your work life seamlessly.',
                        'position' => 'left',
                        'image' => '1742990476_7c946e2beefbe218e5b7.png'
                    ],
                    [
                        'short_headline' => 'CONNECT, CHAT, CARE',
                        'title' => 'Instant Messaging for Better Service',
                        'description' => 'Enjoy unparalleled flexibility as you build your service empire. Our platform empowers you to set your own schedule, choose your clients, and balance your work life seamlessly.',
                        'position' => 'right',
                        'image' => '1742990476_21fde946dc6b5480c1dc.png'
                    ],
                    [
                        'short_headline' => 'YOUR SERVICE, YOUR RULES',
                        'title' => 'Take Charge of Your Service Business',
                        'description' => "Create detailed service listings including a unique name, categorize your service for easy discovery, and outline the specific tasks involved. Enhance your listing with relevant files like images or documents. Provide a clear and informative description of your service, including pricing details and frequently asked questions.\r\n\r\nManage your service status, cancellation policy, and payment options. Choose whether your service is offered at your location or at the customers doorstep.",
                        'position' => 'left',
                        'image' => '1742990476_69bd7d61c27daa6346ce.png'
                    ]
                ]
            ])
        ];
        // Step 2: Convert full setting into JSON
        $jsonValue = json_encode($setting, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        // Step 3: Prepare raw SQL insert query
        $sql = "INSERT INTO `settings` (`id`, `variable`, `value`, `created_at`, `updated_at`)
                VALUES (NULL, 'become_provider_page_settings', " . $db->escape($jsonValue) . ", NOW(), NULL)";
        // Step 4: Execute query

        echo $sql;
    }

    // public function test()
    // {
    //     custom_email_sender('test@test.com', 'Test', 'Test', 'test@test.com', 'Test');
    // }

    /**
     * Fetch country codes from REST Countries API and store ALL flag images locally
     * HIGH PERFORMANCE VERSION - Downloads all flags using batch processing
     */
    // public function fetch_and_store_country_codes()
    // {
    //     // Performance optimizations for handling all countries
    //     set_time_limit(0);
    //     ini_set('memory_limit', '1G');

    //     try {
    //         $response = ['error' => false, 'message' => '', 'data' => []];

    //         // API call to get country data with calling codes
    //         $api_url = 'https://restcountries.com/v3.1/all?fields=name,cca2,idd';

    //         $ch = curl_init();
    //         curl_setopt($ch, CURLOPT_URL, $api_url);
    //         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //         curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    //         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

    //         $api_response = curl_exec($ch);
    //         $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    //         curl_close($ch);

    //         if ($http_code !== 200 || !$api_response) {
    //             throw new \Exception('API request failed');
    //         }

    //         $countries_data = json_decode($api_response, true);
    //         if (!$countries_data) {
    //             throw new \Exception('Invalid JSON response');
    //         }

    //         // Setup directories
    //         $flags_dir = FCPATH . 'public/backend/assets/country_flags/';
    //         $json_dir = FCPATH . 'public/';

    //         if (!is_dir($flags_dir)) {
    //             mkdir($flags_dir, 0777, true);
    //         }

    //         // Process country data with new JSON structure
    //         $country_codes_json = [];
    //         $all_country_codes = [];
    //         $processed = 0;

    //         foreach ($countries_data as $country) {
    //             $name = $country['name']['common'] ?? 'Unknown';
    //             $code = $country['cca2'] ?? '';

    //             // Extract calling code from IDD data
    //             $calling_code = '';
    //             if (isset($country['idd']['root']) && isset($country['idd']['suffixes'])) {
    //                 $root = $country['idd']['root'];
    //                 $suffixes = $country['idd']['suffixes'];

    //                 // Handle cases where there might be multiple suffixes
    //                 if (is_array($suffixes) && !empty($suffixes)) {
    //                     $calling_code = $root . $suffixes[0]; // Use first suffix
    //                 }
    //             } elseif (isset($country['idd']['root'])) {
    //                 $calling_code = $country['idd']['root'];
    //             }

    //             // Only process countries with valid data
    //             if (!empty($code) && !empty($name)) {
    //                 // Initialize JSON structure with placeholder for flag image
    //                 $flag_image = strtolower($code) . '.png'; // Expected flag filename

    //                 $country_codes_json[$name] = [
    //                     'calling_code' => $calling_code,
    //                     'country_code' => $code,
    //                     'flag_image' => '' // Will be updated after download
    //                 ];
    //                 $all_country_codes[] = $code;
    //                 $processed++;
    //             }
    //         }

    //         // Save JSON file with new structure
    //         file_put_contents($json_dir . 'country_codes.json', json_encode($country_codes_json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    //         // Download ALL flags using optimized batch processing
    //         $downloaded = 0;
    //         $batch_size = 20; // Process 20 flags at once for optimal performance
    //         $total_batches = ceil(count($all_country_codes) / $batch_size);

    //         // Process countries in batches to avoid overwhelming the server
    //         for ($batch = 0; $batch < $total_batches; $batch++) {
    //             $start_index = $batch * $batch_size;
    //             $batch_codes = array_slice($all_country_codes, $start_index, $batch_size);

    //             // Multi-curl for parallel downloads within each batch
    //             $mh = curl_multi_init();
    //             $ch_array = [];

    //             foreach ($batch_codes as $code) {
    //                 $url = "https://flagcdn.com/w40/" . strtolower($code) . ".png";
    //                 $path = $flags_dir . strtolower($code) . '.png';

    //                 // Only download if file doesn't exist
    //                 if (!file_exists($path)) {
    //                     $ch = curl_init();
    //                     curl_setopt($ch, CURLOPT_URL, $url);
    //                     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //                     curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    //                     curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
    //                     curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    //                     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    //                     curl_multi_add_handle($mh, $ch);
    //                     $ch_array[$path] = $ch;
    //                 }
    //             }

    //             // Execute all downloads in this batch in parallel
    //             if (!empty($ch_array)) {
    //                 $running = null;
    //                 do {
    //                     curl_multi_exec($mh, $running);
    //                     curl_multi_select($mh);
    //                 } while ($running > 0);

    //                 // Save flag files from this batch and update JSON structure
    //                 foreach ($ch_array as $path => $ch) {
    //                     $data = curl_multi_getcontent($ch);
    //                     $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    //                     if ($data && $http_code === 200 && strlen($data) > 100) { // Basic validation
    //                         file_put_contents($path, $data);
    //                         $downloaded++;

    //                         // Extract filename and update JSON structure
    //                         $filename = basename($path);
    //                         $country_code_from_file = strtoupper(pathinfo($filename, PATHINFO_FILENAME));

    //                         // Find and update the corresponding country in JSON
    //                         foreach ($country_codes_json as $country_name => &$country_data) {
    //                             if ($country_data['country_code'] === $country_code_from_file) {
    //                                 $country_data['flag_image'] = $filename;
    //                                 break;
    //                             }
    //                         }
    //                         unset($country_data); // Break reference
    //                     }

    //                     curl_multi_remove_handle($mh, $ch);
    //                     curl_close($ch);
    //                 }
    //             }

    //             curl_multi_close($mh);

    //             // Small pause between batches to be respectful to the API
    //             usleep(100000); // 0.1 second pause
    //         }

    //         // Save updated JSON file with flag image names after all downloads
    //         file_put_contents($json_dir . 'country_codes.json', json_encode($country_codes_json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    //         $response['message'] = "SUCCESS! Processed {$processed} countries with calling codes and downloaded {$downloaded} flag images using high-performance batch processing!";
    //         $response['data'] = [
    //             'total_countries' => $processed,
    //             'flags_downloaded' => $downloaded,
    //             'batches_processed' => $total_batches,
    //             'batch_size' => $batch_size,
    //             'json_file' => 'country_codes.json',
    //             'json_structure' => 'country_name => {calling_code, country_code, flag_image}',
    //             'flags_directory' => 'public/backend/assets/country_flags/',
    //             'sample_countries' => array_slice($country_codes_json, 0, 3, true) // Show country names as keys
    //         ];

    //         return $this->response->setJSON($response);
    //     } catch (\Exception $e) {
    //         $response['error'] = true;
    //         $response['message'] = 'Error: ' . $e->getMessage();
    //         $response['data'] = [
    //             'details' => 'Check your internet connection and API availability'
    //         ];
    //         return $this->response->setJSON($response);
    //     }
    // }
}
