<?php

namespace App\Controllers\admin;

use App\Models\Featured_sections_model;
use App\Models\TranslatedFeaturedSections_model;
use Exception;

class Featured_sections extends Admin
{
    public $validation, $sections, $creator_id;
    protected $superadmin;
    protected $translatedSectionModel;

    public function __construct()
    {
        parent::__construct();
        helper(['form', 'url', 'ResponceServices']);
        $this->sections = new Featured_sections_model();
        $this->validation = \Config\Services::validation();
        $this->translatedSectionModel = new TranslatedFeaturedSections_model();
        $this->creator_id = $this->userId;
        $this->superadmin = $this->session->get('email');
    }
    public function index()
    {
        if (!$this->isLoggedIn || !$this->userIsAdmin) {
            return redirect('admin/login');
        }
        setPageInfo($this->data, labels('featured_section', 'Featured section') . ' | ' . labels('admin_panel', 'Admin Panel'), 'featured_sections');

        // Categories with translations
        $this->data['categories_name'] = get_categories_with_translated_names();

        // Get current + default language
        $currentLanguage = get_current_language();
        $defaultLanguage = get_default_language();

        $db = \Config\Database::connect();
        // Fetch partners with translated company_name
        $partners = $db->table('users u')
            ->select('
        u.id,
        u.username,
        pd.partner_id,
        pd.company_name,
        pd.number_of_members,
        pd.at_store,
        pd.at_doorstep,
        pd.need_approval_for_the_service,
        tpd_current.company_name as current_translated_name,
        tpd_default.company_name as default_translated_name
    ')
            ->join('partner_details pd', 'pd.partner_id = u.id')
            ->join(
                'translated_partner_details tpd_current',
                'tpd_current.partner_id = pd.partner_id 
         AND tpd_current.language_code = "' . $currentLanguage . '"',
                'left'
            )
            ->join(
                'translated_partner_details tpd_default',
                'tpd_default.partner_id = pd.partner_id 
         AND tpd_default.language_code = "' . $defaultLanguage . '"',
                'left'
            )
            ->where('pd.is_approved', '1')
            ->get()
            ->getResultArray();

        $db->close();
        // Replace with translated names where available
        foreach ($partners as &$partner) {
            if (!empty($partner['current_translated_name'])) {
                $partner['display_company_name'] = $partner['current_translated_name'];
            } elseif (!empty($partner['default_translated_name'])) {
                $partner['display_company_name'] = $partner['default_translated_name'];
            } else {
                $partner['display_company_name'] = $partner['company_name'];
            }
        }

        // print_r($partners[0]);
        // die;
        $this->data['partners'] = $partners;

        // If you also want a separate provider_title (id, partner_id, company_name)
        $this->data['provider_title'] = array_map(function ($p) {
            return [
                'id' => $p['id'],
                'partner_id' => $p['partner_id'],
                'company_name' => $p['display_company_name'],
            ];
        }, $partners);

        // fetch languages
        $languages = fetch_details('languages', [], ['id', 'language', 'is_default', 'code'], "", '0', 'id', 'ACE');
        $this->data['languages'] = $languages;
        return view('backend/admin/template', $this->data);
    }
    public function add_featured_section()
    {
        try {
            $result = checkModificationInDemoMode($this->superadmin);
            if ($result !== true) {
                return $this->response->setJSON($result);
            }
            $permission = is_permitted($this->creator_id, 'create', 'featured_section');
            if (!$permission) {
                return NoPermission();
            }
            $section_type = $this->request->getPost('section_type') ?? "";

            $common_rules = [
                'section_type' => [
                    "rules" => 'required|trim',
                    "errors" => ["required" => labels("please_select_type_for_feature_section", "Please select type for feature section")]
                ]
            ];

            // Get default language for validation
            $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');
            $defaultLanguage = null;
            foreach ($languages as $language) {
                if ($language['is_default'] == 1) {
                    $defaultLanguage = $language['code'];
                    break;
                }
            }

            // Default language validation is handled by validateDefaultLanguageFields method
            if ($section_type == 'banner') {
                // Add banner-specific validation rules to existing common_rules
                $common_rules['app_image'] = ["rules" => 'uploaded[app_image]', "errors" => ["uploaded" => labels(THE_APP_IMAGE_FIELD_IS_REQUIRED, "The App image field is required"),]];
                $common_rules['web_image'] = ["rules" => 'uploaded[web_image]', "errors" => ["uploaded" => labels(THE_WEB_IMAGE_FIELD_IS_REQUIRED, "The Web image field is required"),]];

                if (isset($_FILES['app_image']) && !empty($_FILES['app_image']['name'])) {
                    $common_rules['app_image_type'] = [
                        "rules" => 'is_image[app_image]',
                        "errors" => [
                            "is_image" => labels("uploaded_app_banner_file_must_be_an_image", "Uploaded app banner file must be an image")
                        ]
                    ];
                }

                if (isset($_FILES['web_image']) && !empty($_FILES['web_image']['name'])) {
                    $common_rules['web_image_type'] = [
                        "rules" => 'is_image[web_image]',
                        "errors" => [
                            "is_image" => labels("uploaded_web_banner_file_must_be_an_image", "Uploaded web banner file must be an image")
                        ]
                    ];
                }
            }
            if ($section_type == 'partners' || $section_type == 'categories' || $section_type == 'banner') {
                if (($section_type == 'partners')) {
                    $specific_rule = 'partners_ids';
                    $specific_rule = 'title';
                } else if (($section_type == 'categories')) {
                    $specific_rule = 'category_item';
                    $specific_rule = 'title';
                } else if ($section_type == 'banner') {
                    $specific_rule = 'banner_type';
                }
                if ($section_type == 'partners') {
                    $specific_error = 'partner';
                    $specific_error = 'title';
                } else if (($section_type == 'categories')) {
                    $specific_error = 'category';
                    $specific_error = 'title';
                } else if ($section_type == 'banner') {
                    $specific_error = 'banner';
                }
                $rules = array_merge($common_rules, [
                    $specific_rule => ["rules" => 'required', "errors" => ["required" => labels("please_select_at_least_one_specific_error", "Please select at least one") . " " . $specific_error]]
                ]);
            } else {
                $rules = array_merge($common_rules, [
                    'section_type' => ["rules" => 'required', "errors" => ["required" => labels("please_choose_any_section_type", "Please choose any Section Type")]],
                    'description' => ["rules" => 'required', "errors" => ["required" => labels("please_add_description", "Please add description")]]

                ]);
            }

            $this->validation->setRules($rules);
            if (!$this->validation->withRequest($this->request)->run()) {
                $errors  = $this->validation->getErrors();
                return ErrorResponse($errors, true, [], [], 200, csrf_token(), csrf_hash());
            }

            // Additional validation for default language title and description
            $validationErrors = $this->validateDefaultLanguageFields($_POST, $defaultLanguage);
            if (!empty($validationErrors)) {
                return ErrorResponse($validationErrors, true, [], [], 200, csrf_token(), csrf_hash());
            }

            $sections = fetch_details('sections');
            if (!empty($sections)) {
                foreach ($sections as $row) {
                    if ($section_type == $row['section_type']) {
                        if ($row['section_type'] == "ongoing_order" || $row['section_type'] == "previous_order") {
                            return ErrorResponse(labels("you_may_only_include_the", "You may only include the") . " " . $section_type . " " . labels("section_once", "section once."), true, [], [], 200, csrf_token(), csrf_hash());
                        }
                    }
                }
            }
            $data = [];
            $data = [
                'partners_ids' => null,
                'category_ids' => null,
                'banner_type' => null,
                'banner_url' => null,
                'limit' => 0
            ];
            if (isset($section_type)) {
                if ($section_type == 'partners') {
                    $data['partners_ids'] = implode(',', $_POST['partners_ids']);
                } elseif ($section_type == 'categories') {
                    $data['category_ids'] = implode(',', $_POST['category_item']);
                } elseif ($section_type == 'top_rated_partner') {
                    $data['limit'] = $this->request->getPost('limit');
                } elseif ($section_type == 'previous_order') {
                    $data['limit'] = $this->request->getPost('previous_order_limit');
                } elseif ($section_type == 'ongoing_order') {
                    $data['limit'] = $this->request->getPost('ongoing_order_limit');
                } elseif ($section_type == 'near_by_provider') {
                    $data['limit'] = $this->request->getPost('limit_for_near_by_providers');
                } elseif ($section_type == 'banner') {
                    $banner_type = $this->request->getPost('banner_type');
                    $data['banner_type'] =  $banner_type;
                    if ($banner_type == "banner_category") {
                        $data['category_ids'] = $_POST['banner_category_item'];
                    } else if ($banner_type == "banner_provider") {
                        $data['partners_ids'] = $_POST['banner_providers'];
                    } else if ($banner_type == "banner_url") {
                        $data['banner_url'] = $_POST['url'];
                    }
                    $paths = [
                        'app_image' => [
                            'file' => $this->request->getFile('app_image'),
                            'path' => 'public/uploads/feature_section',
                            'error' => labels("failed_to_create_feature_section_folders", "Failed to create feature section folders"),
                            'folder' => 'feature_section'
                        ],
                        'web_image' => [
                            'file' => $this->request->getFile('web_image'),
                            'path' => 'public/uploads/feature_section',
                            'error' => labels("failed_to_create_feature_section_folders", "Failed to create feature section folders"),
                            'folder' => 'feature_section'
                        ],
                    ];
                    $uploadedFiles = [];
                    foreach ($paths as $key => $upload) {
                        if ($upload['file'] && $upload['file']->isValid()) {
                            $result = upload_file($upload['file'], $upload['path'], $upload['error'], $upload['folder']);
                            if ($result['error'] == false) {
                                $uploadedFiles[$key] = [
                                    'url' => $result['file_name'],
                                    'disk' => $result['disk']
                                ];
                            } else {
                                return ErrorResponse($result['message'], true, [], [], 200, csrf_token(), csrf_hash());
                            }
                        }
                    }
                    $data['app_banner_image'] =  $uploadedFiles['app_image']['url'] ??  $this->request->getFile('app_image')->getName();
                    $data['web_banner_image'] = $uploadedFiles['web_image']['url'] ??  $this->request->getFile('web_image')->getName();
                }
            }



            $data['status'] = isset($_POST['status']) ? 1 : 0;

            // Process translated fields from form data
            $translatedFields = $this->processTranslatedFields($_POST);

            // Remove title and description from main table - they will only be stored in translations table
            // $data['title'] = $translatedFields['title'][$defaultLanguage] ?? "";
            // $data['description'] = $translatedFields['description'][$defaultLanguage] ?? "";

            $data['section_type'] = $section_type;
            $db      = \Config\Database::connect();
            $builder = $db->table('sections');
            $builder->selectMax('rank');
            $order = $builder->get()->getResultArray();
            $data['rank'] = ($order[0]['rank']) + 1;

            // Save the main section data
            if ($this->sections->save($data)) {
                $sectionId = $this->sections->getInsertID();

                // Store translations for all languages
                if ($this->storeSectionTranslations($sectionId, $translatedFields)) {
                    return successResponse(labels(DATA_SAVED_SUCCESSFULLY, "Data saved successfully"), false, [], [], 200, csrf_token(), csrf_hash());
                } else {
                    // If translation storage fails, delete the main record and return error
                    $this->sections->delete($sectionId);
                    return ErrorResponse(labels(ERROR_OCCURED, "An error occurred"), true, [], [], 200, csrf_token(), csrf_hash());
                }
            } else {
                return ErrorResponse(labels("please_try_again", "Please try again...."), true, [], [], 200, csrf_token(), csrf_hash());
            }
        } catch (\Throwable $th) {
            throw $th;
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Featured_sections.php - add_featured_section()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function list()
    {
        try {
            $multipleWhere = '';
            $db      = \Config\Database::connect();
            $builder = $db->table('sections s');
            $sortable_fields = ['id' => 'id', 'rank' => 'rank', 'categories' => 'categories', 'style' => 'style', 'service_type' => 'service_type'];
            $sort = 'rank';
            $limit = 10;
            $condition  = [];
            $offset = 0;
            if (isset($_GET['offset'])) {
                $offset = $_GET['offset'];
            }
            if (isset($_GET['limit'])) {
                $limit = $_GET['limit'];
            }
            if (isset($_GET['sort'])) {
                if ($_GET['sort'] == 'id') {
                    $sort = (isset($sortable_fields[$sort])) ? $sortable_fields[$sort] : "id";
                } else {
                    $sort = $_GET['sort'];
                }
            }
            $order = "ASC";
            if (isset($_GET['order'])) {
                $order = $_GET['order'];
            }
            if (isset($_GET['search']) and $_GET['search'] != '') {
                $search = $_GET['search'];
                // Remove title search since title is now only in translations table
                $multipleWhere = ['`s.id`' => $search, '`s.created_at`' => $search, 'section_type' => $search];
            }
            if (isset($_GET['feature_section_filter']) && $_GET['feature_section_filter'] != '') {
                $builder->where('s.status',  $_GET['feature_section_filter']);
            }
            $total  = $builder->select(' COUNT(id) as `total` ');
            if (isset($_GET['id']) && $_GET['id'] != '') {
                $builder->where($condition);
            }
            if (isset($multipleWhere) && !empty($multipleWhere)) {
                $builder->orWhere($multipleWhere);
            }
            if (isset($where) && !empty($where)) {
                $builder->where($where);
            }
            $offer_count = $builder->get()->getResultArray();
            $total = $offer_count[0]['total'];
            $builder->select();
            if (isset($multipleWhere) && !empty($multipleWhere)) {
                $builder->orLike($multipleWhere);
            }
            if (isset($where) && !empty($where)) {
                $builder->where($where);
            }
            if (isset($_GET['feature_section_filter']) && $_GET['feature_section_filter'] != '') {
                $builder->where('s.status',  $_GET['feature_section_filter']);
            }
            $offer_recored = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
            $bulkData = array();
            $bulkData['total'] = $total;
            $rows = array();
            $tempRow = array();
            $user1 = fetch_details('users', ["phone" => $_SESSION['identity']],);
            $permissions = get_permission($user1[0]['id']);
            $disk = fetch_current_file_manager();

            // Get all section IDs for batch translation lookup
            $sectionIds = array_column($offer_recored, 'id');

            // Get current language for display
            $currentLanguage = get_current_language();
            $defaultLanguage = get_default_language();

            // Get all translations for all sections in one query for efficiency
            $allTranslations = [];
            if (!empty($sectionIds)) {
                $translationBuilder = $db->table('translated_featured_sections');
                $translations = $translationBuilder->whereIn('section_id', $sectionIds)->get()->getResultArray();

                // Organize translations by section_id and language_code
                foreach ($translations as $translation) {
                    $allTranslations[$translation['section_id']][$translation['language_code']] = $translation;
                }
            }

            foreach ($offer_recored as $row) {
                $operations = "";
                $label = ($row['status'] == 1) ?
                    "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('active', 'Active') . "
            </div>" :
                    "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 '>" . labels('deactive', 'Deactive') . "
            </div>";
                $operations = '<div class="dropdown">
                <a class="" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <button class="btn btn-secondary   btn-sm px-3"> <i class="fas fa-ellipsis-v "></i></button>
                </a>
                <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">';
                if ($permissions['update']['featured_section'] == 1) {
                    $operations .= '<a class="dropdown-item update_featured_section "data-id="' . $row['id'] . '"  data-id="' . $row['id'] . '"  data-toggle="modal" data-target="#update_modal" onclick="feature_section_id(this)"><i class="fa fa-pen mr-1 text-primary"></i>' . labels('edit', 'Edit') . '</a>';
                }
                if ($permissions['delete']['featured_section'] == 1) {
                    $operations .= '<a class="dropdown-item delete-featured_section" data-id="' . $row['id'] . '" onclick="feature_section_id(this)" data-toggle="modal" data-target="#delete_modal"> <i class="fa fa-trash text-danger mr-1"></i>' . labels('delete', 'Delete') . '</a>';
                }
                if ($row['section_type'] == "banner") {
                    if ($disk == "local_server") {
                        if (check_exists(base_url('/public/uploads/feature_section/' . $row['app_banner_image']))) {
                            $app_banner_url = base_url('/public/uploads/feature_section/' . $row['app_banner_image']);
                        } else {
                            $app_banner_url = labels('nothing_found', 'Nothing Found');
                        }
                    } else if ($disk == "aws_s3") {
                        $app_banner_url = fetch_cloud_front_url('feature_section', $row['app_banner_image']);
                    } else {
                        $app_banner_url = base_url('public/backend/assets/profiles/default.png');
                    }
                    $app_banner_image = '  <a  href="' . $app_banner_url  . '" data-lightbox="image-1"><img class="o-media__img images_in_card" src="' . $app_banner_url . '" alt="' .     $row['id'] . '"></a>';
                    if ($disk == "local_server") {
                        if (check_exists(base_url('/public/uploads/feature_section/' . $row['web_banner_image']))) {
                            $web_banner_url = base_url('/public/uploads/feature_section/' . $row['web_banner_image']);
                        } else {
                            $web_banner_url = labels('nothing_found', 'Nothing Found');
                        }
                    } else if ($disk == "aws_s3") {
                        $web_banner_url = fetch_cloud_front_url('feature_section', $row['web_banner_image']);
                    } else {
                        $web_banner_url = base_url('public/backend/assets/profiles/default.png');
                    }
                    $web_banner_image = '  <a  href="' . $web_banner_url  . '" data-lightbox="image-1"><img class="o-media__img images_in_card" src="' . $web_banner_url . '" alt="' .     $row['id'] . '"></a>';
                } else {
                    $app_banner_image = '-';
                    $web_banner_image = '-';
                }
                $operations .= '</div></div>';
                $tempRow['id'] = $row['id'];

                // Get title with proper fallback logic:
                // 1. Current language translation
                // 2. Default language translation  
                // 3. Main table data (if available)
                // 4. Fallback to "-"
                $displayTitle = $this->getDisplayTitle($row, $allTranslations, $currentLanguage, $defaultLanguage);
                $tempRow['title'] = $displayTitle;

                $tempRow['category_ids'] = $row['category_ids'];
                $tempRow['section_type'] = $row['section_type'];
                $tempRow['section_type_badge'] = feature_section_type($row['section_type']);
                $tempRow['banner_type_badge'] = banner_type($row['banner_type']);
                $tempRow['partners_ids'] = $row['partners_ids'];
                $tempRow['created_at'] = format_date($row['created_at'], 'd-m-Y');
                $tempRow['status'] = $row['status'];
                $tempRow['status_badge'] = $label;
                $tempRow['rank'] =  $row['rank'];
                $tempRow['limit'] =  $row['limit'];
                $tempRow['app_banner_image'] =  $app_banner_image;
                $tempRow['web_banner_image'] =  $web_banner_image;
                $tempRow['banner_url'] = $row['banner_url'];
                $tempRow['banner_type'] = $row['banner_type'];

                // Get description with proper fallback logic:
                // 1. Current language translation
                // 2. Default language translation  
                // 3. Main table data (if available)
                // 4. Fallback to empty string
                $displayDescription = $this->getDisplayDescription($row, $allTranslations, $currentLanguage, $defaultLanguage);
                $tempRow['description'] = $displayDescription;

                $tempRow['icon'] = '<i class="fas fa-sort text-new-primary"</i>';
                $tempRow['operations'] = $operations;
                $rows[] = $tempRow;
            }
            $bulkData['rows'] = $rows;
            return json_encode($bulkData);
        } catch (\Throwable $th) {
            // throw $th;
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Featured_sections.php - list()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function delete_featured_section()
    {
        try {
            $disk = fetch_current_file_manager();

            if (!$this->isLoggedIn || !$this->userIsAdmin) {
                return redirect('admin/login');
            }
            $result = checkModificationInDemoMode($this->superadmin);
            if ($result !== true) {
                return $this->response->setJSON($result);
            }
            $permission = is_permitted($this->creator_id, 'delete', 'featured_section');
            if (!$permission) {
                return NoPermission();
            }
            $id = $this->request->getPost('id');
            $db = \Config\Database::connect();
            $fetch_old_data = fetch_details('sections', ['id' => $id]);
            if ($fetch_old_data[0]['section_type'] == "banner") {
                if (!empty($fetch_old_data[0]['app_banner_image'])) {
                    delete_file_based_on_server('feature_section', $fetch_old_data[0]['app_banner_image'], $disk);
                }
                if (!empty($fetch_old_data[0]['web_banner_image'])) {
                    delete_file_based_on_server('feature_section', $fetch_old_data[0]['web_banner_image'], $disk);
                }
            }
            // First, delete all translations for this section
            $translationBuilder = $db->table('translated_featured_sections');
            $translationBuilder->delete(['section_id' => $id]);

            // Then delete the main section
            $builder = $db->table('sections');
            $builder->delete(['id' => $id]);
            $builder = $db->table('sections');
            $builder->orderBy('rank', 'ASC');
            $sections = $builder->get()->getResultArray();
            foreach ($sections as $index => $section) {
                $newRank = $index + 1;
                $builder->where('id', $section['id']);
                $builder->update(['rank' => $newRank]);
            }
            return successResponse(labels(DATA_DELETED_SUCCESSFULLY, "Data deleted successfully"), false, [], [], 200, csrf_token(), csrf_hash());
        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Featured_sections.php - delete_featured_section()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function update_featured_section()
    {
        try {
            if (!$this->isLoggedIn || !$this->userIsAdmin) {
                return redirect('admin/login');
            }
            $result = checkModificationInDemoMode($this->superadmin);
            if ($result !== true) {
                return $this->response->setJSON($result);
            }
            $id = $this->request->getPost('id');
            $db      = \Config\Database::connect();
            $builder = $db->table('sections');
            $permission = is_permitted($this->creator_id, 'update', 'featured_section');
            if (!$permission) {
                return NoPermission();
            }
            $section_type = ($this->request->getPost('section_type')) ? $this->request->getPost('section_type') : "";
            $common_rules = [
                'section_type' => [
                    "rules" => 'required|trim',
                    "errors" => ["required" => labels("please_select_type_for_feature_section", "Please select type for feature section")]
                ]
            ];

            // Get default language for validation
            $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');
            $defaultLanguage = null;
            foreach ($languages as $language) {
                if ($language['is_default'] == 1) {
                    $defaultLanguage = $language['code'];
                    break;
                }
            }

            // Default language validation is handled by validateDefaultLanguageFields method
            if ($section_type == 'partners' || $section_type == 'categories' || $section_type == 'banner') {
                if (($section_type == 'partners')) {
                    $specific_rule = 'partners_ids';
                    $specific_rule = 'title';
                } else if (($section_type == 'categories')) {
                    $specific_rule = 'category_item';
                    $specific_rule = 'title';
                } else if ($section_type == 'banner') {
                    $specific_rule = 'banner_type';
                }
                if ($section_type == 'partners') {
                    $specific_error = 'partner';
                    $specific_error = 'title';
                } else if (($section_type == 'categories')) {
                    $specific_error = 'category';
                    $specific_error = 'title';
                } else if ($section_type == 'banner') {
                    $specific_error = 'banner';
                }
                $rules = array_merge($common_rules, [
                    $specific_rule => ["rules" => 'required', "errors" => ["required" => labels("please_select_at_least_one", "Please select at least one") . " " . $specific_error]]
                ]);
            } else {
                $rules = array_merge($common_rules, [
                    'section_type' => ["rules" => 'required', "errors" => ["required" => labels("please_choose_any_section_type", "Please choose any Section Type")]]
                ]);
            }
            $this->validation->setRules($rules);
            if (!$this->validation->withRequest($this->request)->run()) {
                $errors  = $this->validation->getErrors();
                return ErrorResponse($errors, true, [], [], 200, csrf_token(), csrf_hash());
            }

            // Additional validation for default language title and description
            $validationErrors = $this->validateDefaultLanguageFields($_POST, $defaultLanguage);
            if (!empty($validationErrors)) {
                return ErrorResponse($validationErrors, true, [], [], 200, csrf_token(), csrf_hash());
            }

            $disk = fetch_current_file_manager();

            $partner_ids = $category_ids = null;
            $id = $this->request->getPost('id');

            // Process translated fields from form data
            $translatedFields = $this->processTranslatedFields($_POST);

            // Remove title and description from main table - they will only be stored in translations table
            // $data['title'] = $translatedFields['title'][$defaultLanguage] ?? "";
            // $data['description'] = $translatedFields['description'][$defaultLanguage] ?? "";

            $data['section_type'] = $_POST['section_type'];
            $data['category_ids'] = $category_ids;
            if ($_POST['section_type'] == 'partners') {
                $partner_ids = implode(',', $_POST['edit_partners_ids']);
                $data['partners_ids'] = $partner_ids;
            } elseif ($_POST['section_type'] == 'categories') {
                $category_ids = implode(',', $_POST['edit_Category_item']);
                $data['category_ids'] = $category_ids;
            } elseif ($_POST['section_type']  == 'previous_order') {
                $data['limit'] = $this->request->getPost('previous_order_limit');;
            } else  if (isset($section_type) && $section_type == 'ongoing_order') {
                $data['limit'] = $this->request->getPost('ongoing_order_limit');;
            } else  if (isset($section_type) && $section_type == 'near_by_provider') {
                $data['limit'] = $this->request->getPost('limit_for_near_by_providers');;
            } elseif ($section_type == 'banner') {
                // Remove title from main table - it will only be stored in translations table
                // $data['title'] = "";
                $banner_type = $this->request->getPost('banner_type');
                $data['banner_type'] =  $banner_type;
                if ($banner_type == "banner_category") {
                    $data['category_ids'] =  $_POST['banner_category_item'];
                } else if ($banner_type == "banner_provider") {
                    $data['partners_ids'] =  $_POST['banner_providers'];
                } else if ($banner_type == "banner_url") {
                    $data['banner_url'] = $_POST['url'];
                }
                $t = time();
                $old_data = fetch_details('sections', ['id' => $id]);

                $paths = [
                    'app_image' => [
                        'file' => $this->request->getFile('app_image'),
                        'path' => 'public/uploads/feature_section/',
                        'old_image' => $old_data[0]['app_banner_image'],
                        'error' => labels(FAILED_TO_UPLOAD_APP_IMAGE, "Failed to upload app image"),
                        'folder' => 'feature_section',
                        'disk' => $disk,
                    ],
                    'web_image' => [
                        'file' =>  $this->request->getFile('web_image'),
                        'path' => 'public/uploads/feature_section/',
                        'old_image' => $old_data[0]['web_banner_image'],
                        'error' => labels(FAILED_TO_UPLOAD_WEB_IMAGE, "Failed to upload web image"),
                        'folder' => 'feature_section',
                        'disk' => $disk,
                    ],
                ];
                $uploadedFiles = [];
                foreach ($paths as $key => $upload) {
                    if ($upload['file']->getName() != "") {
                        delete_file_based_on_server('feature_section', $upload['old_image'], $upload['disk']);
                        $result = upload_file($upload['file'], $upload['path'], $upload['error'], $upload['folder']);
                        if ($result['error'] === false) {
                            if ($upload['disk'] == "local_server") {
                                $upload['old_image'] = "public/uploads/feature_section/" . $upload['old_image'];
                            }
                            $uploadedFiles[$key] = [
                                'url' => $result['file_name'],
                                'disk' => $result['disk']
                            ];
                        } else {
                            return ErrorResponse($result['message'], true, [], [], 200, csrf_token(), csrf_hash());
                        }
                    } else {
                        $uploadedFiles[$key] = [
                            'url' => $upload['old_image'],
                            'disk' => $upload['disk']
                        ];
                    }
                }
                $data['app_banner_image'] = $uploadedFiles['app_image']['url'] ?? $this->request->getFile('app_image')->getName();
                $data['web_banner_image'] = $uploadedFiles['web_image']['url'] ?? $this->request->getFile('web_image')->getName();
            }
            $data['status'] = isset($_POST['edit_status']) ? 1 : 0;

            // Update the main section data
            if ($builder->update($data, ['id' => $id])) {
                // Store translations for all languages
                if ($this->storeSectionTranslations($id, $translatedFields)) {
                    return successResponse(labels(DATA_UPDATED_SUCCESSFULLY, "Data updated successfully"), false, [], [], 200, csrf_token(), csrf_hash());
                } else {
                    // If translation storage fails, return error but don't rollback main update
                    log_message('error', "Failed to save translations for section {$id}");
                    return ErrorResponse(labels(ERROR_OCCURED, "An error occurred"), true, [], [], 200, csrf_token(), csrf_hash());
                }
            } else {
                return ErrorResponse(labels(ERROR_OCCURED, "An error occurred"), true, [], [], 200, csrf_token(), csrf_hash());
            }
        } catch (\Throwable $th) {
            throw $th;
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Featured_sections.php - update_featured_section()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }
    public function change_order()
    {
        try {
            $ids = json_decode($_POST['ids']);
            $update = [];
            $db      = \Config\Database::connect();
            $builder = $db->table('sections');
            foreach ($ids as $key => $id) {
                $update = [
                    'id' => $id,
                    'rank' => ($key + 1)
                ];
                $builder->update($update, ['id' => $id]);
            }
            return successResponse(labels(ORDER_UPDATED_SUCCESSFULLY, "Order updated successfully"), false, [], [], 200, csrf_token(), csrf_hash());
        } catch (\Exception $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/admin/Featured_sections.php - change_order()');
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }

    /**
     * Process translated fields from form data
     * 
     * This private helper function processes form data to extract translated fields
     * organized by field and language code
     * 
     * @param array $postData The POST data from the form
     * @return array Array containing translated data organized by field and language
     */
    private function processTranslatedFields(array $postData): array
    {
        $translatedFields = [
            'title' => [],
            'description' => [],
        ];

        // Check if the data is already in the correct format (as objects with language keys)
        if (isset($postData['title']) && is_array($postData['title'])) {
            // Copy the data directly since it's already in the right structure
            $translatedFields['title'] = $postData['title'] ?? [];
            $translatedFields['description'] = $postData['description'] ?? [];

            return $translatedFields;
        }

        // Fallback: Process form data in the old format (field[language] format)
        // Get languages from database
        $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');

        foreach ($languages as $language) {
            $languageCode = $language['code'];

            // Process title
            $titleField = 'title[' . $languageCode . ']';
            $titleValue = $postData[$titleField] ?? null;
            if (!empty($titleValue)) {
                $translatedFields['title'][$languageCode] = trim($titleValue);
            }

            // Process description
            $descriptionField = 'description[' . $languageCode . ']';
            $descriptionValue = $postData[$descriptionField] ?? null;
            if (!empty($descriptionValue)) {
                $translatedFields['description'][$languageCode] = trim($descriptionValue);
            }
        }

        return $translatedFields;
    }

    /**
     * Store section translations in the database
     * 
     * This private helper function uses the TranslatedFeaturedSections_model
     * to store multi-language translations for section fields
     * 
     * @param int $sectionId The section ID to store translations for
     * @param array $translatedFields Array containing translated data organized by field and language
     * @return bool Success status
     * @throws Exception If translation storage fails
     */
    private function storeSectionTranslations(int $sectionId, array $translatedFields): bool
    {
        try {
            // Validate that we have a valid section ID
            if (empty($sectionId)) {
                throw new Exception('Section ID is required for storing translations');
            }

            // First, delete all existing translations for this section
            // This ensures that removed translations are properly deleted
            // When a user removes translations (like clearing Hindi fields), 
            // this step ensures those translations are deleted from the database
            $deleteResult = $this->translatedSectionModel->deleteSectionTranslations($sectionId);
            if (!$deleteResult) {
                log_message('warning', "Failed to delete existing translations for section {$sectionId}");
                // Continue anyway - we'll try to insert new translations
            }

            // Get all available languages from database
            $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');

            if (empty($languages)) {
                throw new Exception('No languages found in database');
            }

            $successCount = 0;
            $totalLanguages = count($languages);

            // Process each language
            foreach ($languages as $language) {
                $languageCode = $language['code'];

                // Prepare translation data for this language
                $translationData = [];

                // Add title translation if available
                if (isset($translatedFields['title'][$languageCode]) && !empty(trim($translatedFields['title'][$languageCode]))) {
                    $translationData['title'] = trim($translatedFields['title'][$languageCode]);
                }

                // Add description translation if available
                if (isset($translatedFields['description'][$languageCode]) && !empty(trim($translatedFields['description'][$languageCode]))) {
                    $translationData['description'] = trim($translatedFields['description'][$languageCode]);
                }

                // Only save if we have translation data for this language
                if (!empty($translationData)) {
                    try {
                        $result = $this->translatedSectionModel->saveTranslatedDetails(
                            $sectionId,
                            $languageCode,
                            $translationData
                        );

                        if ($result) {
                            $successCount++;
                        } else {
                            // Log the failure but continue with other languages
                            log_message('error', "Failed to save translation for section {$sectionId}, language {$languageCode}");
                        }
                    } catch (Exception $e) {
                        log_message('error', "Exception saving translation for section {$sectionId}, language {$languageCode}: " . $e->getMessage());
                    }
                } else {
                    // Count as success if no data to save (empty translations are valid)
                    $successCount++;
                }
            }

            // Return true if at least one language was processed successfully
            return $successCount > 0;
        } catch (Exception $e) {
            log_message('error', 'Error storing section translations: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Get section data with translations for edit modal
     * Since title and description are no longer stored in main table, only use translations from translation table
     * 
     * @return \CodeIgniter\HTTP\Response
     */
    public function get_section_data()
    {
        try {
            if (!$this->isLoggedIn || !$this->userIsAdmin) {
                return ErrorResponse(labels(UNAUTHORIZED_ACCESS, "Unauthorized access"), true, [], [], 200, csrf_token(), csrf_hash());
            }

            $sectionId = $this->request->getPost('id');

            if (empty($sectionId)) {
                return ErrorResponse(labels(SECTION_ID_REQUIRED, "Section ID is required"), true, [], [], 200, csrf_token(), csrf_hash());
            }

            // Get section data from main table
            $sectionData = $this->sections->find($sectionId);

            if (!$sectionData) {
                return ErrorResponse(labels(SECTION_NOT_FOUND, "Section not found"), true, [], [], 200, csrf_token(), csrf_hash());
            }

            // Convert image paths to full URLs for frontend use
            if (!empty($sectionData['app_banner_image'])) {
                if (check_exists(base_url('/public/uploads/feature_section/' . $sectionData['app_banner_image']))) {
                    $sectionData['app_banner_image'] = base_url('/public/uploads/feature_section/' . $sectionData['app_banner_image']);
                } else {
                    $sectionData['app_banner_image'] = '';
                }
            } else {
                $sectionData['app_banner_image'] = '';
            }

            if (!empty($sectionData['web_banner_image'])) {
                if (check_exists(base_url('/public/uploads/feature_section/' . $sectionData['web_banner_image']))) {
                    $sectionData['web_banner_image'] = base_url('/public/uploads/feature_section/' . $sectionData['web_banner_image']);
                } else {
                    $sectionData['web_banner_image'] = '';
                }
            } else {
                $sectionData['web_banner_image'] = '';
            }

            // Get all available languages
            $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');

            // Get all translations for this section
            $translations = $this->translatedSectionModel->getAllTranslationsForSection($sectionId);

            // Organize existing translations by language code for quick lookup
            $existingTranslations = [];
            foreach ($translations as $translation) {
                $existingTranslations[$translation['language_code']] = [
                    'title' => $translation['title'] ?? '',
                    'description' => $translation['description'] ?? ''
                ];
            }

            // Build complete translations array with fallback to main table title/description
            // For default language only: use main table title/description as fallback if no translation exists
            // For non-default languages: leave empty if no translation exists
            $translatedData = [];
            foreach ($languages as $language) {
                $languageCode = $language['code'];
                $isDefault = $language['is_default'] == 1;

                $translatedData[$languageCode] = [
                    'title' => $existingTranslations[$languageCode]['title'] ?? ($isDefault ? ($sectionData['title'] ?? '') : ''),
                    'description' => $existingTranslations[$languageCode]['description'] ?? ($isDefault ? ($sectionData['description'] ?? '') : '')
                ];
            }

            // Prepare response data
            $responseData = [
                'section_data' => $sectionData,
                'translations' => $translatedData,
                'languages' => $languages
            ];

            return successResponse(labels(DATA_RETRIEVED_SUCCESSFULLY, "Data retrieved successfully"), false, $responseData, [], 200, csrf_token(), csrf_hash());
        } catch (Exception $e) {
            log_message('error', 'Error getting section data: ' . $e->getMessage());
            return ErrorResponse(labels(SOMETHING_WENT_WRONG, "Something Went Wrong"), true, [], [], 200, csrf_token(), csrf_hash());
        }
    }

    /**
     * Validate that default language title and description are provided
     * 
     * @param array $postData The POST data
     * @param string $defaultLanguage The default language code
     * @return array Array of validation errors (empty if no errors)
     */
    private function validateDefaultLanguageFields(array $postData, string $defaultLanguage): array
    {
        $errors = [];

        // Check if we have translated fields in the new format (as arrays)
        if ($postData['section_type']  != "banner") {
            if (isset($postData['title']) && is_array($postData['title'])) {
                // New format: validate that default language title is provided
                if (!isset($postData['title'][$defaultLanguage]) || empty(trim($postData['title'][$defaultLanguage]))) {
                    $errors['title'] = labels("title_is_required_for_default_language", "Title is required for the default language");
                }
            } else {
                // Old format: validate individual language field
                $titleField = 'title[' . $defaultLanguage . ']';
                if (!isset($postData[$titleField]) || empty(trim($postData[$titleField]))) {
                    $errors[$titleField] = labels("title_is_required_for_default_language", "Title is required for the default language");
                }
            }
        }

        if (isset($postData['description']) && is_array($postData['description'])) {
            // New format: validate that default language description is provided
            if (!isset($postData['description'][$defaultLanguage]) || empty(trim($postData['description'][$defaultLanguage]))) {
                $errors['description'] = labels("description_is_required_for_default_language", "Description is required for the default language");
            }
        } else {
            // Old format: validate individual language field
            $descriptionField = 'description[' . $defaultLanguage . ']';
            if (!isset($postData[$descriptionField]) || empty(trim($postData[$descriptionField]))) {
                $errors[$descriptionField] = labels("description_is_required_for_default_language", "Description is required for the default language");
            }
        }

        return $errors;
    }

    /**
     * Get display title with proper fallback logic
     * 
     * @param array $row Section row data
     * @param array $allTranslations All translations organized by section_id and language_code
     * @param string $currentLanguage Current language code
     * @param string $defaultLanguage Default language code
     * @return string Display title with fallback
     */
    private function getDisplayTitle(array $row, array $allTranslations, string $currentLanguage, string $defaultLanguage): string
    {
        $sectionId = $row['id'];

        // 1. Try current language translation
        if (
            isset($allTranslations[$sectionId][$currentLanguage]['title']) &&
            !empty(trim($allTranslations[$sectionId][$currentLanguage]['title']))
        ) {
            return trim($allTranslations[$sectionId][$currentLanguage]['title']);
        }

        // 2. Try default language translation
        if (
            $currentLanguage !== $defaultLanguage &&
            isset($allTranslations[$sectionId][$defaultLanguage]['title']) &&
            !empty(trim($allTranslations[$sectionId][$defaultLanguage]['title']))
        ) {
            return trim($allTranslations[$sectionId][$defaultLanguage]['title']);
        }

        // 3. Try main table data (if available)
        if (isset($row['title']) && !empty(trim($row['title']))) {
            return trim($row['title']);
        }

        // 4. Fallback to "-"
        return "-";
    }

    /**
     * Get display description with proper fallback logic
     * 
     * @param array $row Section row data
     * @param array $allTranslations All translations organized by section_id and language_code
     * @param string $currentLanguage Current language code
     * @param string $defaultLanguage Default language code
     * @return string Display description with fallback
     */
    private function getDisplayDescription(array $row, array $allTranslations, string $currentLanguage, string $defaultLanguage): string
    {
        $sectionId = $row['id'];

        // 1. Try current language translation
        if (
            isset($allTranslations[$sectionId][$currentLanguage]['description']) &&
            !empty(trim($allTranslations[$sectionId][$currentLanguage]['description']))
        ) {
            return trim($allTranslations[$sectionId][$currentLanguage]['description']);
        }

        // 2. Try default language translation
        if (
            $currentLanguage !== $defaultLanguage &&
            isset($allTranslations[$sectionId][$defaultLanguage]['description']) &&
            !empty(trim($allTranslations[$sectionId][$defaultLanguage]['description']))
        ) {
            return trim($allTranslations[$sectionId][$defaultLanguage]['description']);
        }

        // 3. Try main table data (if available)
        if (isset($row['description']) && !empty(trim($row['description']))) {
            return trim($row['description']);
        }

        // 4. Fallback to empty string
        return "";
    }
}
