<?php

namespace App\Controllers\partner;

use App\Controllers\BaseController;

class ReportedUsers extends Partner
{
    public function __construct()
    {
        parent::__construct();
        $this->userId = $_SESSION['user_id'];
    }

    public function index()
    {
        if (!$this->isLoggedIn && !$this->userIsPartner) {
            return redirect('partner/login');
        }
        setPageInfo($this->data, labels('reported_users', 'Reported Users') . ' | ' . labels('provider_panel', 'Provider Panel'), 'reported_users');
        return view('backend/partner/template', $this->data);
    }
    public function list()
    {
        try {
            if (!$this->isLoggedIn || !$this->userIsPartner) {
                return redirect('partner/login');
            }

            $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
            $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
            $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
            $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'DESC';
            $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';

            $db = \Config\Database::connect();
            $builder = $db->table('user_reports ur')
                ->select('ur.*, 
                    reporter.username as reporter_name, 
                    reported.username as reported_name,
                    r.id as reason_id')
                ->where('ur.reporter_id', $this->userId)
                ->join('users reporter', 'reporter.id = ur.reporter_id')
                ->join('users reported', 'reported.id = ur.reported_user_id')
                ->join('reasons_for_report_and_block_chat r', 'r.id = ur.reason_id', 'left');

            if (!empty($search)) {
                $builder->groupStart()
                    ->like('reporter.username', $search)
                    ->orLike('reported.username', $search)
                    ->orLike('ur.additional_info', $search)
                    ->groupEnd();
            }

            $total = $builder->countAllResults(false);
            $builder->orderBy($sort, $order);
            $builder->limit($limit, $offset);
            $reports = $builder->get()->getResultArray();

            // Get current language for translations
            $session = session();
            $currentLanguage = $session->get('lang') ?? 'en';
            
            // If no language set in session, try to get from database
            if ($currentLanguage === 'en') {
                $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code']);
                if (!empty($defaultLanguage)) {
                    $currentLanguage = $defaultLanguage[0]['code'];
                }
            }
            
            // Get all reason IDs to fetch translations
            $reasonIds = array_column($reports, 'reason_id');
            $translatedReasonModel = new \App\Models\TranslatedReasonsForReportAndBlockChat_model();
            $translations = [];
            
            if (!empty($reasonIds)) {
                $translations = $translatedReasonModel->getTranslationsForReasons($reasonIds, $currentLanguage);
            }
            
            // Create lookup array for translations
            $translationLookup = [];
            foreach ($translations as $translation) {
                $translationLookup[$translation['reason_id']] = $translation['reason'];
            }
            
            // Get default language code
            $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code'])[0]['code'] ?? 'en';
            
            // Get default language translations
            $defaultTranslations = [];
            if (!empty($reasonIds)) {
                $defaultTranslations = $translatedReasonModel->getTranslationsForReasons($reasonIds, $defaultLanguage);
            }
            
            // Create lookup array for default translations
            $defaultTranslationLookup = [];
            foreach ($defaultTranslations as $translation) {
                $defaultTranslationLookup[$translation['reason_id']] = $translation['reason'];
            }
            
            $data = [];
            foreach ($reports as $report) {
                $tempRow = $report;
                // Add translated reason text
                $tempRow['report_reason'] = $defaultTranslationLookup[$report['reason_id']] ?? $report['report_reason'] ?? '';
                $tempRow['translated_report_reason'] = $translationLookup[$report['reason_id']] ?? null;
                $tempRow['operations'] = '<div class="btn-group">
                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <div class="dropdown-menu">
                        <a class="dropdown-item view-user-report" data-id="' . $report['id'] . '">
                            <i class="fas fa-eye text-primary"></i> ' . labels('view_details', 'View Details') . '
                        </a>
                    </div>
                </div>';
                $data[] = $tempRow;
            }

            return $this->response->setJSON([
                'total' => $total,
                'rows' => $data
            ]);

        } catch (\Throwable $th) {
            log_the_responce($th, date("Y-m-d H:i:s") . '--> app/Controllers/partner/ReportedUsers.php - list()');
            return $this->response->setJSON(['error' => true, 'message' => 'Something went wrong']);
        }
    }

    public function view($id)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('user_reports ur')
        ->select('ur.*, 
            reporter.username as reporter_name, 
            reporter.email as reporter_email,
            reported.username as reported_name,
            reported.email as reported_email,
            r.id as reason_id')
        ->join('users reporter', 'reporter.id = ur.reporter_id')
        ->join('users reported', 'reported.id = ur.reported_user_id')
        ->join('reasons_for_report_and_block_chat r', 'r.id = ur.reason_id', 'left')
        ->where('ur.id', $id);

        $report = $builder->get()->getRowArray();

        if (!$report) {
            return $this->response->setJSON([
                'error' => true,
                'message' => labels('report_not_found', 'Report not found')
            ]);
        }

        // Get translated reason text
        if (!empty($report['reason_id'])) {
            $session = session();
            $currentLanguage = $session->get('lang') ?? 'en';
            
            // If no language set in session, try to get from database
            if ($currentLanguage === 'en') {
                $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code']);
                if (!empty($defaultLanguage)) {
                    $currentLanguage = $defaultLanguage[0]['code'];
                }
            }
            
            $translatedReasonModel = new \App\Models\TranslatedReasonsForReportAndBlockChat_model();
            
            // Get default language translation
            $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code'])[0]['code'] ?? 'en';
            $defaultTranslation = $translatedReasonModel->getTranslatedReasonText($report['reason_id'], $defaultLanguage);
            
            // Get current language translation
            $currentTranslation = $translatedReasonModel->getTranslatedReasonText($report['reason_id'], $currentLanguage);
            
            // Set report_reason with default language data or main table fallback
            $report['report_reason'] = $defaultTranslation ?? $report['report_reason'] ?? '';
            
            // Set translated_report_reason with current language translation if available
            $report['translated_report_reason'] = $currentTranslation;
        } else {
            $report['report_reason'] = labels('no_reason_specified', 'No reason specified');
            $report['translated_report_reason'] = null;
        }
        
        return $this->response->setJSON([
            'error' => false,
            'data' => $report
        ]);
    }
} 