ALTER TABLE `languages` ADD COLUMN `image` VARCHAR(255) NULL DEFAULT NULL AFTER `is_rtl`;
CREATE TABLE `translated_partner_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `partner_id` int(11) NOT NULL COMMENT 'Reference to partner_details.partner_id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `company_name` varchar(255) DEFAULT NULL COMMENT 'Company name in specific language', `about` text DEFAULT NULL COMMENT 'About provider description in specific language', `long_description` longtext DEFAULT NULL COMMENT 'Detailed description in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_partner_language` (`partner_id`, `language_code`), KEY `idx_partner_id` (`partner_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated partner details for multi-language support';
ALTER TABLE `translated_partner_details` ADD CONSTRAINT `fk_translated_partner_details_partner_id` FOREIGN KEY (`partner_id`) REFERENCES `partner_details`(`partner_id`) ON DELETE CASCADE;
CREATE TABLE `translated_service_details` (`id` int UNSIGNED NOT NULL AUTO_INCREMENT, `service_id` int UNSIGNED NOT NULL COMMENT 'Reference to services.id', `language_code` varchar(10) COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `title` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Service title in specific language', `description` text COLLATE utf8mb4_general_ci COMMENT 'Short description in specific language', `long_description` longtext COLLATE utf8mb4_general_ci COMMENT 'Detailed description in specific language', `tags` text COLLATE utf8mb4_general_ci COMMENT 'Service tags in specific language', `faqs` longtext COLLATE utf8mb4_general_ci COMMENT 'FAQs in specific language (JSON format)', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_service_language` (`service_id`,`language_code`), KEY `idx_service_id` (`service_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated service details for multi-language support';
ALTER TABLE `translated_service_details` ADD CONSTRAINT `fk_translated_service_details_service` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`) ON DELETE CASCADE;
CREATE TABLE `translated_category_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `category_id` int(11) UNSIGNED NOT NULL COMMENT 'Reference to categories.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `name` varchar(255) DEFAULT NULL COMMENT 'Category name in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_category_language` (`category_id`, `language_code`), KEY `idx_category_id` (`category_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated category details for multi-language support';
ALTER TABLE `translated_category_details` ADD CONSTRAINT `fk_translated_category_details_category_id` FOREIGN KEY (`category_id`) REFERENCES `categories`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_featured_sections` (`id` int  NOT NULL AUTO_INCREMENT, `section_id` int UNSIGNED NOT NULL COMMENT 'Reference to sections.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `title` varchar(255) DEFAULT NULL COMMENT 'Section title in specific language', `description` text DEFAULT NULL COMMENT 'Section description in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_section_language` (`section_id`, `language_code`), KEY `idx_section_id` (`section_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated featured section details for multi-language support';
ALTER TABLE `translated_featured_sections` ADD CONSTRAINT `fk_translated_featured_sections_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_reasons_for_report_and_block_chat` (`id` int(11) NOT NULL AUTO_INCREMENT, `reason_id` int(11) NOT NULL COMMENT 'Reference to reasons_for_report_and_block_chat.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `reason` text DEFAULT NULL COMMENT 'Reason text in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_reason_language` (`reason_id`, `language_code`), KEY `idx_reason_id` (`reason_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated reason details for multi-language support';
ALTER TABLE `translated_reasons_for_report_and_block_chat` ADD CONSTRAINT `fk_translated_reasons_reason_id` FOREIGN KEY (`reason_id`) REFERENCES `reasons_for_report_and_block_chat`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_promocode_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `promocode_id` int(11) NOT NULL COMMENT 'Reference to promocodes.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, ar, tr)', `message` text DEFAULT NULL COMMENT 'Promocode message in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_promocode_language` (`promocode_id`, `language_code`), KEY `idx_promocode_id` (`promocode_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated promocode details for multi-language support';
ALTER TABLE `translated_promocode_details` ADD CONSTRAINT `fk_translated_promocode_details_promocode_id` FOREIGN KEY (`promocode_id`) REFERENCES `promo_codes`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_subscription_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `subscription_id` int(11) NOT NULL COMMENT 'Reference to subscriptions.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `name` varchar(255) DEFAULT NULL COMMENT 'Subscription name in specific language', `description` text DEFAULT NULL COMMENT 'Subscription description in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_subscription_language` (`subscription_id`, `language_code`), KEY `idx_subscription_id` (`subscription_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated subscription details for multi-language support';
ALTER TABLE `translated_subscription_details` ADD CONSTRAINT `fk_translated_subscription_details_subscription_id` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions`(`id`) ON DELETE CASCADE;
ALTER TABLE `blog_categories` DROP INDEX `name`;
CREATE TABLE `translated_blog_category_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `blog_category_id` int(11) NOT NULL COMMENT 'Reference to blog_categories.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `name` varchar(255) DEFAULT NULL COMMENT 'Blog category name in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_blog_category_language` (`blog_category_id`, `language_code`), KEY `idx_blog_category_id` (`blog_category_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated blog category details for multi-language support';
ALTER TABLE `translated_blog_category_details` ADD CONSTRAINT `fk_translated_blog_category_details_blog_category_id` FOREIGN KEY (`blog_category_id`) REFERENCES `blog_categories`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_blog_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `blog_id` int(11) NOT NULL COMMENT 'Reference to blogs.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `title` text DEFAULT NULL COMMENT 'Blog title in specific language', `short_description` text DEFAULT NULL COMMENT 'Blog short description in specific language', `description` longtext DEFAULT NULL COMMENT 'Blog description in specific language', `tags` text DEFAULT NULL COMMENT 'Blog tags in specific language (JSON format)', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_blog_language` (`blog_id`, `language_code`), KEY `idx_blog_id` (`blog_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated blog details for multi-language support';
ALTER TABLE `translated_blog_details` ADD CONSTRAINT `fk_translated_blog_details_blog_id`  FOREIGN KEY (`blog_id`) REFERENCES `blogs`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_blog_tag_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `tag_id` int(11) NOT NULL COMMENT 'Reference to blog_tags.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `name` varchar(255) DEFAULT NULL COMMENT 'Blog tag name in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_blog_tag_language` (`tag_id`, `language_code`), KEY `idx_blog_tag_id` (`tag_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated blog tag details for multi-language support';
ALTER TABLE `translated_blog_tag_details` ADD CONSTRAINT `fk_translated_blog_tag_details_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `blog_tags`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_faq_details` (`id` int(11) NOT NULL AUTO_INCREMENT, `faq_id` int(11) NOT NULL COMMENT 'Reference to faqs.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `question` text DEFAULT NULL COMMENT 'FAQ question in specific language', `answer` longtext DEFAULT NULL COMMENT 'FAQ answer in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_faq_language` (`faq_id`, `language_code`), KEY `idx_faq_id` (`faq_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated FAQ details for multi-language support';
ALTER TABLE `translated_faq_details` ADD CONSTRAINT `fk_translated_faq_details_faq_id` FOREIGN KEY (`faq_id`) REFERENCES `faqs`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_sms_templates` (`id` int(11) NOT NULL AUTO_INCREMENT, `template_id` int(11) NOT NULL COMMENT 'Reference to sms_templates.id', `language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)', `title` varchar(255) DEFAULT NULL COMMENT 'SMS template title in specific language', `template` longtext DEFAULT NULL COMMENT 'SMS template content in specific language', `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP, `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_template_language` (`template_id`, `language_code`), KEY `idx_template_id` (`template_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated SMS template details for multi-language support';
ALTER TABLE `translated_sms_templates` ADD CONSTRAINT `fk_translated_sms_templates_template_id` FOREIGN KEY (`template_id`) REFERENCES `sms_templates`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_tax_details` (`id` int(11) NOT NULL AUTO_INCREMENT,`tax_id` int(11) NOT NULL COMMENT 'Reference to taxes.id',`language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)',`title` varchar(255) DEFAULT NULL COMMENT 'Tax title in specific language',`created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,`updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`),UNIQUE KEY `unique_tax_language` (`tax_id`, `language_code`), KEY `idx_tax_id` (`tax_id`), KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated tax details for multi-language support';
ALTER TABLE `translated_tax_details` ADD CONSTRAINT `fk_translated_tax_details_tax_id` FOREIGN KEY (`tax_id`) REFERENCES `taxes`(`id`) ON DELETE CASCADE;
CREATE TABLE `translated_email_templates`(`id` int(11) NOT NULL AUTO_INCREMENT,`template_id` int(11) NOT NULL COMMENT 'Reference to email_templates.id',`language_code` varchar(10) NOT NULL COMMENT 'Language code (e.g. en, hi, ar)',`subject` varchar(255) DEFAULT NULL COMMENT 'Email subject in specific language',`template` longtext DEFAULT NULL COMMENT 'Email template content in specific language',`created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,`updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (`id`), UNIQUE KEY `unique_template_language`(`template_id`, `language_code`), KEY `idx_template_id`(`template_id`),KEY `idx_language_code` (`language_code`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores translated email template details for multi-language support';
ALTER TABLE `translated_email_templates` ADD CONSTRAINT `fk_translated_email_templates_template_id` FOREIGN KEY(`template_id`)REFERENCES `email_templates`(`id`) ON DELETE CASCADE;
ALTER TABLE `translated_partner_details` ADD COLUMN `username` varchar(255) DEFAULT NULL COMMENT 'Partner username in specific language' AFTER `long_description`;