<?php
function successResponse($message = "Success", $error = false, $data = null, $customData = [], $code = 200, $csrfName = null, $csrfHash = null)
{
    $response = [
        'error'     => $error,
        'message'   => labels($message, $message),
        'data'      => $data,
        'code'      => $code,
        'csrfName'  => $csrfName,
        'csrfHash'  => $csrfHash,
    ];

    return response_helper()->setJSON(array_merge($response, $customData));
}
// function ErrorResponse($message = "Success", $error = false, $data = null, $customData = [], $code = 200, $csrfName = null, $csrfHash = null)
// {
//     $response = [
//         'error'     => $error,
//         'message'   => labels($message, $message),
//         'data'      => $data,
//         'code'      => $code,
//         'csrfName'  => $csrfName,
//         'csrfHash'  => $csrfHash,
//     ];

//     return response_helper()->setJSON(array_merge($response, $customData));
// }

function ErrorResponse($message = "Success", $error = false, $data = null, $customData = [], $code = 200, $csrfName = null, $csrfHash = null)
{
    if (is_array($message)) {
        $labelMessage = implode(", ", $message); // or json_encode($message)
    } else {
        $labelMessage = $message;
    }
    $response = [
        'error'     => $error,
        'message'   => $labelMessage,
        'data'      => $data,
        'code'      => $code,
        'csrfName'  => $csrfName,
        'csrfHash'  => $csrfHash,
    ];
    return response_helper()->setJSON(array_merge($response, $customData));
}
function NoPermission($message = "Sorry! You're not permitted to take this action", $error = true, $data = null, $customData = [], $code = 200, $csrfName = null, $csrfHash = null)
{
    $response = [
        'error'     => $error,
        'message'   => $message,
        'data'      => $data,
        'code'      => $code,
        'csrfName'  => $csrfName,
        'csrfHash'  => $csrfHash,
    ];

    return response_helper()->setJSON(array_merge($response, $customData));
}
function demoModeNotAllowed()
{
    if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0) {
        $response = [
            'error'     => true,
            'message'   => DEMO_MODE_ERROR,
            'csrfName'  => csrf_token(),
            'csrfHash'  => csrf_hash(),
        ];

        return $response;
        return response_helper()->setJSON($response);
    } else {

        return ['error' => false];
    }
}

function ApiErrorResponse($message = "Success", $error = false, $data = null)
{
    $response = [
        'error'     => $error,
        'message'   => $message,
        'data'      => $data,

    ];

    return response_helper()->setJSON(array_merge($response));
}
function log_the_responce($message = "something went wrong", $controller = false, $level = 'error')
{
    $request = \Config\Services::request();

    // Build the multi-line formatted log message
    $lines = [];

    // First line: Controller and error message
    if ($controller) {
        $lines[] = "$controller";
    } else {
        $lines[] = $message;
    }

    // Second line: Line number (if exception) or custom message
    if (is_object($message) && method_exists($message, 'getLine')) {
        $lines[] = "At Line : " . $message->getLine();
    } else {
        $lines[] = "At Line : -"; // Default or you can customize this
    }

    // Get HTTP method and full URL path
    $method = $request->getMethod();
    $path = $request->getUri()->getPath();

    // Get user token from Authorization header
    $userToken = $request->getHeaderLine('Authorization');
    if (empty($userToken)) {
        $userToken = $request->getGet('token') ?? $request->getPost('token') ?? 'Not provided';
    }
    $lines[] = "User Token : $userToken";

    // Add full URL including domain
    $baseUrl = base_url();
    // Remove any duplicate paths
    if (strpos($path, '/edemand') === 0) {
        // If path already starts with /edemand, we need to avoid duplication
        $path = substr($path, strlen('/edemand'));
    }

    $fullUrl = rtrim($baseUrl, '/') . $path;
    $lines[] = "Base url : $fullUrl";
    $lines[] = "Method : $method";

    // Parameters
    $params = json_encode(array_merge($request->getGet(), $request->getPost()));
    $lines[] = "Params : $params";

    // Join all lines with line breaks
    $content = implode("\n", $lines);

    // Log with the specified level
    log_message($level, $content);
}
