<?php

use App\Libraries\Flutterwave;
use App\Libraries\Paypal;
use App\Libraries\Paystack;
use App\Libraries\Paytm;
use App\Libraries\Razorpay;
use App\Libraries\Stripe;
use App\Models\Orders_model;
use App\Models\Users_model;
use Aws\Exception\AwsException;
use Aws\S3\Exception\S3Exception;
use Aws\S3\S3Client;
use CodeIgniter\HTTP\Files\UploadedFile;
use Config\ApiResponseAndNotificationStrings;
use Google\Client;
use GuzzleHttp\Exception\ClientException;
use Nyholm\Psr7\Factory\Psr17Factory;
use Razorpay\Api\Api;
use GuzzleHttp\Client as GuzzleClient;
use Vonage\Client as VonageClient;
use Vonage\Client\Credentials\Basic;
use Vonage\SMS\Message\SMS;

function update_balance($amount, $partner_id, $action)
{
    $db = \Config\Database::connect();
    $builder = $db->table('users');
    if ($action == "add") {
        $builder->set('balance', 'balance+' . $amount, false);
    } elseif ($action == "deduct") {
        $builder->set('balance', 'balance-' . $amount, false);
    }
    return $builder->where('id', $partner_id)->update();
}

/**
 * Normalize folder names to match the format used in sample_panel.json
 * Converts folder names to lowercase and replaces spaces with underscores
 * 
 * @param string $folderName The original folder name
 * @return string The normalized folder name
 */
function normalize_folder_name($folderName)
{
    // Convert to lowercase and replace spaces with underscores
    $normalized = strtolower(str_replace(' ', '_', $folderName));

    // Handle special cases for common folder names
    $specialCases = [
        'chat_attachement' => 'chat_attachment',
        'provider_bulk_upload' => 'provider_bulk_upload',
        'featured_section' => 'featured_section',
        'seo_settings' => 'seo_settings',
        'web_settings' => 'web_settings',
        'address_id' => 'address_id',
        'country_flags' => 'country_flags',
        'national_id' => 'national_id',
        'provider_work_evidence' => 'provider_work_evidence'
    ];

    // Return special case if exists, otherwise return normalized name
    return $specialCases[$normalized] ?? $normalized;
}
function order_details($order_id)
{
    $model = new Orders_model();
    $where_in_key = 'o.status';
    $where_in_value = ['awaiting', 'confirmed', 'rescheduled'];
    $data = [];
    $order_details = $model->list(false, '', 10, 0, '', '', ['o.id' => $order_id], $where_in_key, $where_in_value);
    if (isset($order_details) && !empty($order_details)) {
        $details = json_decode($order_details);
        $data['order'] = isset($details->rows[0]) ? $details->rows[0] : '';
        $services = isset($details->rows[0]->services) ? $details->rows[0]->services : '';
        $id = (!empty($services)) ? array_column($services, 'service_id') : "";
        $data['cancellable'] = fetch_details('services', [], ['duration', 'is_cancelable', 'cancelable_till'], null, '0', '', '', 'id', $id);
        unset($data['order']->services);
        return $data;
    } else {
        return new stdClass();
    }
}
function check_cancelable($date_of_service, $starting_time, $cancellable_befor_min)
{
    $today = strtotime(date('y-m-d H:i'));
    $format_date = date('y-m-d H:i', strtotime("$date_of_service $starting_time"));
    $service_date = strtotime($format_date);
    if ($service_date >= $today) {
        $i = ($service_date - $today) / 60;
        if (intval($cancellable_befor_min) > $i) {
            return false;
        } else {
            return true;
        }
    }
}
function get_service_details($order_id)
{
    $db = \Config\Database::connect();
    $data = $db
        ->table(' order_services os')
        ->select('os.*', 'o.partner_id', 'o.')
        ->where('order_id', $order_id)
        ->where('status != ', 'cancelled')
        ->get()->getResultArray();
    $results = [];
    for ($i = 0; $i < sizeof($data); $i++) {
        $id = $data[$i]['service_id'];
        $service_data = $db
            ->table('services')
            ->select('*')
            ->where('id', $id)
            ->get()->getResultArray();
        if (isset($service_data[0]) && !empty($service_data)) {
            array_push($results, $service_data[0]);
        }
    }
    if (!empty($results)) {
        return $results;
    } else {
        $response['error'] = true;
        $response['message'] = "No such service found!";
        return $response;
    }
}

function validate_status($order_id, $status, $date = '', $selected_time = "", $otp = null, $work_proof = null, $additional_charges = null, $user_id = null, $language = null)
{
    $languageCode = $language ?? get_default_language();

    $trans = new ApiResponseAndNotificationStrings();
    if ($status == "awaiting") {
        $translated_status = $trans->awaiting;
    } else if ($status == "confirmed") {
        $translated_status = $trans->confirmed;
    } else if ($status == "rescheduled") {
        $translated_status = $trans->rescheduled;
    } else if ($status == "cancelled") {
        $translated_status = $trans->cancelled;
    } else if ($status == "cancelled") {
        $translated_status = $trans->cancelled;
    } else if ($status == "completed") {
        $translated_status = $trans->completed;
    } else if ($status == "started") {
        $translated_status = $trans->started;
    } else if ($status == "booking_ended") {
        $translated_status = $trans->bookingEnded;
    } else if ($status == "booking_ended") {
        $translated_status = $trans->bookingEnded;
    }
    $check_status = ['awaiting', 'confirmed', 'rescheduled', 'cancelled', 'completed', 'started', 'booking_ended'];
    if (in_array(($status), $check_status)) {
        $db = \Config\Database::connect();
        $builder = $db->table('orders');
        $builder->select('status,payment_method,user_id,otp,final_total,total_additional_charge,payment_status_of_additional_charge,payment_method_of_additional_charge')->where('id', $order_id);
        $active_status1 = $builder->get()->getResultArray();
        $db->close();

        $active_status = (isset($active_status1[0]['status'])) ? $active_status1[0]['status'] : "";
        if ($active_status == $status) {
            $response['error'] = true;
            $response['message'] = labels(YOU_CANT_UPDATE_THE_SAME_STATUS_AGAIN, "You can't update the same status again");
            $response['data'] = array();
            return $response;
        }
        if ($active_status == 'cancelled' || $active_status == 'completed') {
            $response['error'] = true;
            $response['message'] = labels(YOU_CANT_UPDATE_STATUS_ONCE_ITEM_CANCELLED_OR_COMPLETED, "You can't update status once item cancelled OR completed");
            $response['data'] = array();
            return $response;
        }
        if (in_array($active_status, ["booking_ended"]) && (($status == "rescheduled") || ($status == "confirmed") || ($status == "awaiting") || ($status == "pending"))) {
            $response['error'] = true;

            $response['message'] = labels(YOU_CANT_ALTER_THE_STATUS_THAT_HAS_ALREADY_BEEN_MARKED_AS, "You cannot alter the status that has already been marked as") . " " . labels(strtolower($translated_status));
            $response['data'] = array();
            return $response;
        }
        if (in_array($active_status, ["started"]) && (($status == "rescheduled") || ($status == "confirmed"))) {
            $response['error'] = true;
            $response['message'] = labels(ONCE_YOU_BEGIN_THE_BOOKING_PROCESS_YOU_CANNOT_CHANGE_THE_BOOKING_TIME, "Once you begin the booking process, you cannot change the booking time.");
            $response['data'] = array();
            return $response;
        }
        if (in_array($active_status, ["started"]) && (($status == "rescheduled") || ($status == "confirmed") || ($status == "awaiting") || ($status == "pending"))) {
            $response['error'] = true;
            $response['message'] = labels(YOU_CANT_ALTER_THE_STATUS_THAT_HAS_ALREADY_BEEN_MARKED_AS, "You cannot alter the status that has already been marked as") . " " . labels(strtolower($translated_status));
            $response['data'] = array();
            return $response;
        }
        // Prevent changing status to 'started' after booking has ended
        if (in_array($active_status, ["booking_ended"]) && $status == "started") {
            $response['error'] = true;
            $response['message'] = labels(YOU_CANT_ALTER_THE_STATUS_THAT_HAS_ALREADY_BEEN_MARKED_AS, "You cannot alter the status that has already been marked as") . " " . labels(strtolower($translated_status));
            $response['data'] = array();
            return $response;
        }
        if ($active_status == '') {
            $response['error'] = true;
            $response['message'] = labels(INVALID_BOOKING_OR_STATUS_DATA, "Invalid booking or status data");
            $response['data'] = array();
            return $response;
        }
        if (in_array($active_status, ["confirmed", "rescheduled"]) && $status == "awaiting") {
            $response['error'] = true;
            $response['message'] = labels(YOU_CANT_ALTER_THE_STATUS_THAT_HAS_ALREADY_BEEN_MARKED_AS, "You cannot alter the status that has already been marked as") . " " . labels(strtolower($translated_status));
            $response['data'] = array();
            return $response;
        }
        if (in_array($status, ["awaiting", "confirmed"])) {
            update_details(['status' => $status], ['id' => $order_id], 'orders');
            update_details(["status" => $status], ["order_id" => $order_id, "status!=" => "cancelled"], "order_services");
        }
        //if order status is completed
        if ($status == 'completed') {
            if (empty($active_status1[0]['payment_method_of_additional_charge']) || $active_status1[0]['payment_method_of_additional_charge'] != "cod") {
                if (($active_status1[0]['total_additional_charge'] != 0 || $active_status1[0]['total_additional_charge'] != "") && ($active_status1[0]['payment_status_of_additional_charge'] == '' || $active_status1[0]['payment_status_of_additional_charge'] == '0')) {
                    $response['error'] = true;
                    $response['message'] = labels(BOOKING_CANNOT_BE_COMPLETED_WITH_A_PENDING_PAYMENT, "Booking cannot be completed with a pending payment.");
                    $response['data'] = array();
                    return $response;
                }
            }
            $settings = get_settings('general_settings', true);
            if (isset($settings['otp_system']) && $settings['otp_system'] == 1) {
                $settings['otp_system'] = 1;
            } else {
                $settings['otp_system'] = 0;
            }
            //if otp system is enabled
            if ($settings['otp_system'] == "1") {
                if (empty($otp)) {
                    $response['error'] = true;
                    $response['message'] = labels(OTP_IS_REQUIRED, "OTP is required");
                    $response['data'] = [];
                    return $response;
                }
                //if otp is mathed then update status otherwise not
                if ($active_status1[0]['otp'] == $otp) {
                    $data = get_service_details($order_id);
                    $order_details = fetch_details('orders', ['id' => $order_id]);
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    if ($order_details[0]['payment_method'] != "cod") {
                        $user_details = fetch_details('users', ['id' => $order_details[0]['partner_id']]);
                        $admin_commission_percentage = get_admin_commision($order_details[0]['partner_id']);
                        $admin_commission_amount = intval($admin_commission_percentage) / 100;
                        $total = $order_details[0]['final_total'];
                        $commision = intval($total) * $admin_commission_amount;
                        $unsettled_amount = $total - $commision;
                        update_details(["balance" => $user_details[0]['balance'] + $unsettled_amount], ["id" => $order_details[0]['partner_id']], "users");
                        add_settlement_cashcollection_history('Received by admin', 'received_by_admin', date('Y-m-d'), date('h:i:s'), $unsettled_amount, $order_details[0]['partner_id'], $order_id, '', $admin_commission_percentage, $total, $commision);
                        $customer_details = fetch_details('users', ['id' => $order_details[0]['user_id']]);
                        if (!empty($customer_details[0]['email']) && check_notification_setting('rating_request_to_customer', 'email') && is_unsubscribe_enabled($customer_details[0]['id']) == 1) {
                            send_custom_email('rating_request_to_customer', $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, get_default_language());
                        }
                        if (check_notification_setting('rating_request_to_customer', 'sms')) {
                            send_custom_sms('rating_request_to_customer',  $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, get_default_language());
                        }
                    }
                    if (($order_details[0]['payment_method']) == "cod") {
                        $admin_commission_percentage = get_admin_commision($order_details[0]['partner_id']);
                        $admin_commission_amount = intval($admin_commission_percentage) / 100;
                        $total = $order_details[0]['final_total'];
                        $commision = intval($total) * $admin_commission_amount;
                        $current_commision = fetch_details('users', ['id' => $order_details[0]['partner_id']], ['payable_commision', 'email'])[0];
                        $current_commision['payable_commision'] = ($current_commision['payable_commision'] == "") ? 0 : $current_commision['payable_commision'];
                        update_details(['payment_status' => '1'], ['id' => $order_id], 'orders');
                        if (($active_status1[0]['total_additional_charge'] != 0 || $active_status1[0]['total_additional_charge'] != "")) {
                            update_details(['payment_status_of_additional_charge' => '1'], ['id' => $order_id], 'orders');
                        }
                        update_details(['payable_commision' => $current_commision['payable_commision'] + $commision], ['id' => $order_details[0]['partner_id']], 'users');
                        $cash_collecetion_data = [
                            'user_id' => $order_details[0]['user_id'],
                            'order_id' => $order_id,
                            'message' => "provider received cash",
                            'status' => 'provider_cash_recevied',
                            'commison' => intval($commision),
                            'partner_id' => $order_details[0]['partner_id'],
                            'date' => date("Y-m-d"),
                        ];
                        insert_details($cash_collecetion_data, 'cash_collection');
                        add_settlement_cashcollection_history('Cash collected by provider', 'cash_collection_by_provider', date('Y-m-d'), date('h:i:s'), $commision, $order_details[0]['partner_id'], $order_id, '', $commision, $order_details[0]['final_total'], $admin_commission_amount);
                        $customer_details = fetch_details('users', ['id' => $order_details[0]['user_id']]);
                        $transaction_details = fetch_details('transactions', ['order_id' => $order_id, 'message' => 'payment for additional charges']);
                        if (!empty($transaction_details)) {
                            update_details(['status' => 'success'], ['id' => $transaction_details[0]['id']], 'transactions');
                        }
                        if (!empty($customer_details[0]['email']) && check_notification_setting('rating_request_to_customer', 'email') && is_unsubscribe_enabled($customer_details[0]['id']) == "1") {
                            send_custom_email('rating_request_to_customer', $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, $languageCode);
                        }
                        if (check_notification_setting('rating_request_to_customer', 'sms')) {
                            send_custom_sms('rating_request_to_customer',  $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, $languageCode);
                        }
                    };
                    update_details(["status" => $status], ["order_id" => $order_id], "order_services");
                } else {
                    $response['error'] = true;
                    $response['message'] = labels(OTP_DOES_NOT_MATCH, "OTP does not match!");
                    $response['data'] = [];
                    return $response;
                }
            }
            //if otp system is disabled
            else {
                $data = get_service_details($order_id);
                $order_details = fetch_details('orders', ['id' => $order_id]);
                update_details(['status' => $status], ['id' => $order_id], 'orders');
                if ($order_details[0]['payment_method'] != "cod") {
                    $user_details = fetch_details('users', ['id' => $order_details[0]['partner_id']]);
                    $admin_commission_percentage = get_admin_commision($order_details[0]['partner_id']);
                    $admin_commission_amount = intval($admin_commission_percentage) / 100;
                    $total = $order_details[0]['final_total'];
                    $commision = intval($total) * $admin_commission_amount;
                    $unsettled_amount = $total - $commision;
                    update_details(["status" => $status], ["order_id" => $order_id], "order_services");
                    update_details(["balance" => $user_details[0]['balance'] + $unsettled_amount], ["id" => $order_details[0]['partner_id']], "users");
                    add_settlement_cashcollection_history('Received by admin', 'received_by_admin', date('Y-m-d'), date('h:i:s'), $unsettled_amount, $order_details[0]['partner_id'], $order_id, '', $admin_commission_percentage, $total, $commision);
                }
                if (($order_details[0]['payment_method']) == "cod") {
                    $admin_commission_percentage = get_admin_commision($order_details[0]['partner_id']);
                    $admin_commission_amount = intval($admin_commission_percentage) / 100;
                    $total = $order_details[0]['final_total'];
                    $commision = intval($total) * $admin_commission_amount;
                    $current_commision = fetch_details('users', ['id' => $order_details[0]['partner_id']], ['payable_commision', 'email'])[0];
                    $current_commision['payable_commision'] = ($current_commision['payable_commision'] == "") ? 0 : $current_commision['payable_commision'];
                    // update_details(['payable_commision' => $current_commision['payable_commision'] + $commision], ['id' => $order_details[0]['partner_id']], 'users');
                    $sum = $current_commision['payable_commision'] + $commision;
                    update_details(['payable_commision' => $sum == 0 ? "0" : $sum], ['id' => $order_details[0]['partner_id']], 'users');
                    update_details(['payment_status' => '1'], ['id' => $order_id], 'orders');
                    if (($active_status1[0]['total_additional_charge'] != 0 || $active_status1[0]['total_additional_charge'] != "")) {
                        update_details(['payment_status_of_additional_charge' => '1'], ['id' => $order_id], 'orders');
                    }
                    $cash_collecetion_data = [
                        'user_id' => $order_details[0]['user_id'],
                        'order_id' => $order_id,
                        'message' => "provider received cash",
                        'status' => 'provider_cash_recevied',
                        'commison' => intval($commision),
                        'partner_id' => $order_details[0]['partner_id'],
                        'date' => date("Y-m-d"),
                    ];
                    insert_details($cash_collecetion_data, 'cash_collection');
                    $actual_amount_of_provider = $order_details[0]['final_total'] - $commision;
                    add_settlement_cashcollection_history(
                        'Cash collected by provider',
                        'cash_collection_by_provider',
                        date('Y-m-d'),
                        date('h:i:s'),
                        $actual_amount_of_provider,
                        $order_details[0]['partner_id'],
                        $order_id,
                        '',
                        $admin_commission_percentage,
                        $order_details[0]['final_total'],
                        $commision
                    );
                };
                $customer_details = fetch_details('users', ['id' => $order_details[0]['user_id']]);
                if (!empty($customer_details[0]['email']) && check_notification_setting('rating_request_to_customer', 'email') && is_unsubscribe_enabled($customer_details[0]['id']) == "1") {
                    send_custom_email('rating_request_to_customer', $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, $languageCode);
                }
                if (check_notification_setting('rating_request_to_customer', 'sms')) {
                    send_custom_sms('rating_request_to_customer',  $order_details[0]['partner_id'], $customer_details[0]['email'], '', $customer_details[0]['id'], $order_id, null, null, null, null, $languageCode);
                }
            }
        }
        if ($status == 'started') {
            if (!empty($work_proof)) {
                $imagefile = $work_proof['work_started_files'];
                $work_started_images = [];
                foreach ($imagefile as $key => $img) {
                    if ($img->isValid() && !$img->hasMoved()) {
                        $result = upload_file($img, 'public/backend/assets/provider_work_evidence', labels('error_creating_provider_work_evidence_folder'), 'provider_work_evidence');
                        if ($result['disk'] == "local_server") {
                            $work_started_images[$key] = "/public/backend/assets/provider_work_evidence/" . $result['file_name'];
                        } else if ($result['disk'] == "aws_s3") {
                            $work_started_images[$key] = $result['file_name'];
                        }
                    }
                }
            }
            $dataToUpdate = [
                'status' => 'started',
                'work_started_proof' => !empty($work_started_images) ? json_encode($work_started_images) : "",
            ];
            update_details($dataToUpdate, ['id' => $order_id], 'orders', false);
            update_details(["status" => $status], ["order_id" => $order_id], "order_services");
        }
        if ($status == 'rescheduled') {
            $orders = fetch_details('orders', ['id' => $order_id]);
            if ($orders[0]['custom_job_request_id'] != "" || $orders[0]['custom_job_request_id'] != NULL) {
                $custom_job = fetch_details('partner_bids', ['custom_job_request_id' => $orders[0]['custom_job_request_id']]);
                $time_calc = $custom_job[0]['duration'];
            } else {
                $data = get_service_details($order_id);
                $sub_orders = fetch_details('orders', ['parent_id' => $order_id]);
                $time_calc = 0;
                for ($i = 0; $i < count($data); $i++) {
                    $time_calc += (int) $data[$i]['duration'];
                }
            }
            $partner_id = $orders[0]['partner_id'];
            $date_of_service = $date;
            $starting_time = $selected_time;
            $availability =  checkPartnerAvailability($partner_id, $date_of_service . ' ' . $starting_time, $orders[0]['duration'], $date_of_service, $starting_time);
            $time_slots = get_available_slots($partner_id, $date_of_service, isset($service_total_duration) ? $service_total_duration : 0, $starting_time); //working
            $current_date = date('Y-m-d');
            if (isset($availability) && $availability['error'] == "0") {
                $service_total_duration = 0;
                $service_duration = 0;
                $service_total_duration = $orders[0]['duration'];
                if (!empty($sub_orders)) {
                    $service_total_duration = $service_total_duration + $sub_orders[0]['duration'];
                }
                $time_slots = get_slot_for_place_order($partner_id, $date_of_service, $service_total_duration, $starting_time);
                $timestamp = date('Y-m-d h:i:s '); // Example timestamp format: 2023-08-08 03:30:00 PM
                if ($time_slots['suborder'] && !empty($time_slots['suborder_data'])) {
                    $total = (sizeof($time_slots['order_data']) * 30) + (sizeof($time_slots['suborder_data']) * 30);
                } else {
                    $total = (sizeof($time_slots['order_data']) * 30);
                }
                if ($service_total_duration > $total) {
                    $response['error'] = false;
                    $response['message'] = labels(THERE_ARE_CURRENTLY_NO_AVAILABLE_SLOTS, "There are currently no available slots.");
                    $response['data'] = array();
                    return $response;
                }
                if ($time_slots['slot_avaialble']) {
                    if ($time_slots['suborder']) {
                        $end_minutes = strtotime($starting_time) + ((sizeof($time_slots['order_data']) * 30) * 60);
                        $ending_time = date('H:i:s', $end_minutes);
                        $day = date('l', strtotime($date_of_service));
                        $timings = getTimingOfDay($partner_id, $day);
                        $closing_time = $timings['closing_time']; // Replace with the actual closing time
                        if ($ending_time > $closing_time) {
                            $ending_time = $closing_time;
                        }
                        $start_timestamp = strtotime($starting_time);
                        $ending_timestamp = strtotime($ending_time);
                        $duration_seconds = $ending_timestamp - $start_timestamp;
                        $duration_minutes = $duration_seconds / 60;
                    }
                    $end_minutes = strtotime($starting_time) + ($service_total_duration * 60);
                    $ending_time = date('H:i:s', $end_minutes);
                    $day = date('l', strtotime($date_of_service));
                    $timings = getTimingOfDay($partner_id, $day);
                    $closing_time = $timings['closing_time']; // Replace with the actual closing time
                    if ($ending_time > $closing_time) {
                        $ending_time = $closing_time;
                    }
                    $start_timestamp = strtotime($starting_time);
                    $ending_timestamp = strtotime($ending_time);
                    $duration_seconds = $ending_timestamp - $start_timestamp;
                    $duration_minutes = $duration_seconds / 60;
                    update_details(
                        [
                            'status' => 'rescheduled',
                            'date_of_service' => $date,
                            'starting_time' => $selected_time,
                            'ending_time' => $ending_time,
                            'duration' => $duration_minutes,
                        ],
                        ['id' => $order_id],
                        'orders'
                    );
                }
                if ($time_slots['suborder']) {
                    $next_day_date = date('Y-m-d', strtotime($date_of_service . ' +1 day'));
                    // $t=100;
                    $t = ($service_total_duration);
                    $next_day_slots = get_next_days_slots($closing_time, $date_of_service, $partner_id, $t, $current_date);
                    $next_day_available_slots = $next_day_slots['available_slots'];
                    if (empty($next_day_available_slots)) {
                        $response['error'] = false;
                        $response['message'] = labels(A_TIME_SLOT_IS_CURRENTLY_UNAVAILABLE_AT_THE_PRESENT_MOMENT, "A time slot is currently unavailable at the present moment.");
                        $response['data'] = array();
                        return $response;
                    }
                    $next_Day_minutes = strtotime($next_day_available_slots[0]) + (($service_total_duration - $duration_minutes) * 60);
                    $next_day_ending_time = date('H:i:s', $next_Day_minutes);
                    $is_update = true;
                    if (!empty($sub_orders)) {
                        update_details(
                            [
                                'status' => 'rescheduled',
                                'date_of_service' => $next_day_date,
                                'starting_time' => isset($next_day_available_slots[0]) ? $next_day_available_slots[0] : 00,
                                'ending_time' =>  $next_day_ending_time,
                                'duration' =>  $service_total_duration - $duration_minutes,
                            ],
                            ['parent_id' => $order_id],
                            'orders'
                        );
                    } else {
                        $sub_order = [
                            'partner_id' => $partner_id,
                            'user_id' => $orders[0]['user_id'],
                            'city' => $orders[0]['city_id'],
                            'total' => $orders[0]['total'],
                            'payment_method' => $orders[0]['payment_method'],
                            'address_id' => $orders[0]['address_id'],
                            'visiting_charges' => $orders[0]['visiting_charges'],
                            'address' => $orders[0]['address'],
                            'date_of_service' =>   $next_day_date,
                            'starting_time' => isset($next_day_available_slots[0]) ? $next_day_available_slots[0] : 00,
                            'ending_time' => $next_day_ending_time,
                            'duration' => $service_total_duration - $duration_minutes,
                            'status' => $status,
                            'remarks' => "sub_order",
                            'otp' => random_int(100000, 999999),
                            'parent_id' =>  $orders[0]['id'],
                            'order_latitude' =>  $orders[0]['order_latitude'],
                            'order_longitude' =>  $orders[0]['order_longitude'],
                            'created_at' => $timestamp,
                        ];
                        $sub_order['final_total'] = $orders[0]['final_total'];
                        $sub_order = insert_details($sub_order, 'orders');
                    }
                    set_time_limit(60);
                }
                $response['error'] = false;
                $response['message'] = labels(THE_BOOKING_HAS_BEEN_SUCCESSFULLY_RESCHEDULED, "The booking has been successfully rescheduled.");
                $response['data'] = array();
                $db = \Config\Database::connect();
                $order_details = fetch_details('orders', ['id' => $order_id]);
                $order_details = json_encode($order_details);
                $details = (json_decode($order_details, true));
                $customer_id = $details[0]['user_id'];
                $data['order'] = isset($details[0]) ? $details[0] : '';
                $to_send_id = $customer_id;
                // $builder = $db->table('users')->select('fcm_id,email,username,platform');
                // $users_fcm = $builder->where('id', $to_send_id)->get()->getResultArray();
                $usersEmail = fetch_details('users', ['id' => $to_send_id], ['email', 'username']);
                $users_fcm = $db->table('users_fcm_ids')
                    ->select('fcm_id,platform')
                    ->where('user_id', $to_send_id)
                    ->whereIn('platform', ['android', 'ios'])
                    ->where('status', '1')
                    ->get()
                    ->getResultArray();
                $db->close();
                foreach ($users_fcm as $ids) {
                    if ($ids['fcm_id'] != "") {
                        $fcm_ids['fcm_id'] = $ids['fcm_id'];
                        $fcm_ids['platform'] = $ids['platform'];
                    }
                }
                // // Queue booking status update notification instead of sending directly
                // if (!empty($fcm_ids) && check_notification_setting('booking_status_updated', 'notification')) {
                //     queueBookingNotification($order_id, $to_send_id, $users_fcm, $translated_status, $partner_id, $usersEmail, $details);
                // }
                if (!empty($fcm_ids) && check_notification_setting('booking_status_updated', 'notification')) {
                    $registrationIDs = $fcm_ids;
                    $trans = new ApiResponseAndNotificationStrings();
                    $title = $trans->bookingStatusChange;
                    $body = $trans->bookingStatusUpdateMessage . $translated_status;
                    $type = 'order';
                    $fcmMsg = array(
                        'content_available' => "true",
                        'title' => $title,
                        'body' => $body,
                        'type' => $type,
                        'type_id' => "$to_send_id",
                        'order_id' => "$order_id",
                        'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                    );
                    $registrationIDs_chunks = array_chunk($users_fcm, 1000);
                    send_notification($fcmMsg, $registrationIDs_chunks);
                    $store_notification = store_notifications($title, $body, $type, $to_send_id, 0, 'general', now(), 'specific_user', '', $order_id, $to_send_id, '', '', '', '');
                    $user_partner_data = fetch_details('users', ['id' => $to_send_id], ['email', 'username']);
                    if (!empty($user_partner_data[0]['email']) && check_notification_setting('new_booking_received_for_provider', 'email') && is_unsubscribe_enabled($partner_id) == 1) {
                        send_custom_email('booking_status_updated', $to_send_id, $user_partner_data[0]['email'], null, $to_send_id, $order_id, null, null, null, null, $languageCode);
                    }
                    if (check_notification_setting('booking_status_updated', 'sms')) {
                        send_custom_sms('booking_status_updated', $to_send_id, $user_partner_data[0]['email'], null, $to_send_id, $order_id, null, null, null, null, $languageCode);
                    }
                }
                return $response;
            } else {
                set_time_limit(60);
                $response['error'] = true;
                $response['message'] = $availability['message'];
                $response['data'] = array();
                return $response;
                return response_helper($availability['message'], true);
            }
        }
        if ($status == 'cancelled') {
            $provider_details = fetch_details('partner_details', ['partner_id' => $user_id], ['partner_id']);
            if (!empty($provider_details) && $provider_details[0]['partner_id'] == $user_id) {
                $order_details = fetch_details('order_services', ['order_id' => $order_id]);
                update_details(['status' => $status], ['id' => $order_id], 'orders');
                $response['error'] = false;
                $response['message'] = labels(BOOKING_IS_CANCELLED, "Booking is cancelled.");
                $response['data'] = [];
                return $response;
            } else {
                $order_details = fetch_details('orders', ['id' => $order_id]);
                $order_details = json_encode($order_details);
                $details = json_decode($order_details);
                $data['order'] = isset($details[0]) ? $details[0] : '';
                if ($details[0]->custom_job_request_id != "" || $details[0]->custom_job_request_id != NULL) {
                    $order_services = fetch_details('partner_bids', ['custom_job_request_id' =>  $details[0]->custom_job_request_id]);
                    $custom_job_request = get_settings('general_settings', true);
                    $data['cancellable'] = [];
                    $cancellable[0] = [
                        'id' => $order_services[0]['custom_job_request_id'],
                        'duration' => $order_services[0]['duration'],
                        'is_cancelable' => 1,
                        'cancelable_till' => $custom_job_request['booking_auto_cancle_duration']
                    ];
                    // $dat?a['cancellable'][] = $cancellable;
                } else {
                    $order_services = fetch_details('order_services', ['order_id' => $order_id]);
                    foreach ($order_services as $row) {
                        $services[] = $row['service_id'];
                    }
                    $data['cancellable'] = [];
                    foreach ($services as $row) {
                        $data_of_service = fetch_details('services', ['id' => $row], ['id', 'duration', 'is_cancelable', 'cancelable_till'], null, '0', '', '');
                        foreach ($data_of_service as $data1) {
                            $cancellable[] = $data1;
                        }
                    }
                }
                if (!empty($order_details)) {
                    $order = $data['order'];
                    $customer_id = $order->user_id;
                    $date_of_service = $order->date_of_service;
                    $starting_time = $order->starting_time;
                    $cancellable = ($cancellable);
                    $response = [];
                    $response['status'] = $status;
                    $can_cancle = false;

                    foreach ($cancellable as $key) {
                        $can_cancle = ($key['is_cancelable'] == 1) ? true : false;
                        if ($key['is_cancelable'] == "1"  && $key['cancelable_till']) {
                            $is_cancelable = check_cancelable(date('y-m-d', strtotime($date_of_service)), $starting_time, $key['cancelable_till']);
                            if ($is_cancelable == true) {
                                if ($can_cancle == false) {
                                    $response['error'] = true;
                                    $response['message'] = labels(BOOKING_IS_NOT_CANCELABLE, "Booking is not cancelable!");
                                    $response['data'] = [];
                                    return $response;
                                } else {
                                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                                    $refund = process_refund($order_id, $status, $customer_id);
                                    $response['is_cancelable'] = true;
                                    $response['error'] = false;
                                    $response['message'] = labels(BOOKING_UPDATED_SUCCESSFULLY, "Booking updated successfully");
                                    $response['data'] = $refund;
                                    $db = \Config\Database::connect();
                                    $order_details = fetch_details('orders', ['id' => $order_id]);
                                    $order_details = json_encode($order_details);
                                    $details = (json_decode($order_details, true));
                                    $customer_id = $details[0]['user_id'];
                                    $data['order'] = isset($details[0]) ? $details[0] : '';
                                    $to_send_id = $customer_id;
                                    $usersEmail = fetch_details('users', ['id' => $to_send_id], ['email', 'username']);
                                    // $builder = $db->table('users')->select('fcm_id,email,username,platform');
                                    // $users_fcm = $builder->where('id', $to_send_id)->get()->getResultArray();
                                    $users_fcm = $db->table('users_fcm_ids')
                                        ->select('fcm_id,platform')
                                        ->where('user_id', $to_send_id)
                                        ->whereIn('platform', ['android', 'ios', 'web'])
                                        ->where('status', '1')
                                        ->get()
                                        ->getResultArray();
                                    $db->close();
                                    foreach ($users_fcm as $ids) {
                                        if ($ids['fcm_id'] != "") {
                                            $fcm_ids['fcm_id'] = $ids['fcm_id'];
                                            $fcm_ids['platform'] = $ids['platform'];
                                        }
                                    }
                                    if (!empty($fcm_ids) && check_notification_setting('booking_status_updated', 'notification')) {
                                        $trans = new ApiResponseAndNotificationStrings();
                                        $title = $trans->bookingStatusChange;
                                        $body = $trans->bookingStatusUpdateMessage . $translated_status;
                                        $type = 'order';
                                        $fcmMsg = array(
                                            'content_available' => "true",
                                            'title' => $title,
                                            'body' => $body,
                                            'type' => $type,
                                            'type_id' => "$to_send_id",
                                            'order_id' => "$order_id",
                                            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                                        );
                                        $registrationIDs_chunks = array_chunk($users_fcm, 1000);
                                        // Use queued notifications for better performance
                                        // queue_notification($fcmMsg, $registrationIDs_chunks, [], 'default');
                                        // $store_notification = store_notifications($title, $body, $type, $to_send_id, 0, 'general', now(), 'specific_user', '', $order_id, $to_send_id, '', '', '', '');
                                        send_notification($fcmMsg, $registrationIDs_chunks);
                                        $store_notification = store_notifications($title, $body, $type, $to_send_id, 0, 'general', now(), 'specific_user', '', $order_id, $to_send_id, '', '', '', '');
                                    }
                                    return $response;
                                }
                            } else {
                                $response['error'] = true;
                                $response['message'] = labels(BOOKING_IS_NOT_CANCELABLE, "Booking is not cancelable !");
                                $response['data'] = [];
                                return $response;
                            }
                        } else {

                            $response['error'] = true;
                            $response['message'] = labels(BOOKING_IS_NOT_CANCELABLE, "Booking is not cancelable!");
                            $response['data'] = [];
                            return $response;
                        }
                    }
                } else {
                    $response['error'] = true;
                    $response['message'] = labels(BOOKING_DATA_NOT_FOUND, "Booking data not found!");
                    $response['data'] = [];
                    return $response;
                }
            }
        }
        if ($status == "booking_ended") {
            $dataToUpdate = [
                'status' => 'booking_ended',
            ];
            if ($additional_charges != "" && ($additional_charges[0]['name'] != "" && $additional_charges[0]['charge'] != "")) {
                $dataToUpdate['additional_charges'] = json_encode($additional_charges);
                $additional_total_charge = 0;
                if (isset($additional_charges)) {
                    foreach ($additional_charges as $charge) {
                        if (empty($charge['name']) || empty($charge['charge'])) {
                            $response['error'] = true;
                            $response['message'] = labels(ALL_ADDITIONAL_CHARGE_FIELDS_ARE_REQUIRED, "All additional charge fields are required");
                            $response['data'] = [];
                            return $response;
                        }
                        if ((float)$charge['charge'] < 1) {
                            $response['error'] = true;
                            $response['message'] = labels(CHARGE_AMOUNT_MUST_BE_GREATER_THAN_0, "Charge amount must be greater than 0");
                            $response['data'] = [];
                            return $response;
                        }
                    }
                    foreach ($additional_charges as $key => $charge) {
                        $additional_total_charge += $charge['charge'];
                    }
                }
                $dataToUpdate['total_additional_charge'] = $additional_total_charge;
                // $dataToUpdate['payment_status_of_additional_charge'] = '0';
                $dataToUpdate['final_total'] = $active_status1[0]['final_total'] + $additional_total_charge;
            }
            update_details($dataToUpdate, ['id' => $order_id], 'orders', false);
            if (!empty($work_proof)) {
                $imagefile = $work_proof['work_complete_files'];
                $work_completed_images = [];
                foreach ($imagefile as $key => $img) {
                    if ($img->isValid() && !$img->hasMoved()) {
                        $result = upload_file($img, 'public/backend/assets/provider_work_evidence', 'error creating provider work evidence folder', 'provider_work_evidence');
                        if ($result['disk'] == "local_server") {
                            $work_completed_images[$key] = "/public/backend/assets/provider_work_evidence/" . $result['file_name'];
                        } else if ($result['disk'] == "aws_s3") {
                            $work_completed_images[$key] = $result['file_name'];
                        }
                    }
                }
                $dataToUpdate = [
                    'work_completed_proof' => !empty($work_completed_images) ? json_encode($work_completed_images) : "",
                ];
                update_details($dataToUpdate, ['id' => $order_id], 'orders', false);
            }
        }
        $response['error'] = false;
        $response['message'] = labels(BOOKING_UPDATED_SUCCESSFULLY, "Booking updated successfully ");
        $response['data'] = [];
        $db = \Config\Database::connect();
        $order_details = fetch_details('orders', ['id' => $order_id]);
        $order_details = json_encode($order_details);
        $details = (json_decode($order_details, true));
        $customer_id = $details[0]['user_id'];
        $data['order'] = isset($details[0]) ? $details[0] : '';
        $to_send_id = $customer_id;
        // $builder = $db->table('users')->select('fcm_id,email,username,platform');
        // $users_fcm = $builder->where('id', $to_send_id)->get()->getResultArray();
        $usersEmail = fetch_details('users', ['id' => $to_send_id], ['email', 'username']);
        $users_fcm = $db->table('users_fcm_ids')
            ->select('fcm_id,platform')
            ->where('user_id', $to_send_id)
            ->whereIn('platform', ['android', 'ios', 'web'])
            ->where('status', '1')
            ->get()
            ->getResultArray();
        $db->close();
        foreach ($users_fcm as $ids) {
            if ($ids['fcm_id'] != "") {
                $fcm_ids['fcm_id'] = $ids['fcm_id'];
                $fcm_ids['platform'] = $ids['platform'];
            }
        }

        if (!empty($fcm_ids) && check_notification_setting('booking_status_updated', 'notification')) {
            $trans = new ApiResponseAndNotificationStrings();
            if ($status == "booking_ended" &&    ($additional_charges != "" && ($additional_charges[0]['name'] != "" && $additional_charges[0]['charge'] != ""))) {
                $title = $trans->bookingStatusChange;
                $body = $trans->bookingStatusUpdateMessage . " " . $translated_status . " and additional charges are added.";
                $type = 'order';
                $fcmMsg = array(
                    'content_available' => "true",
                    'title' => $title,
                    'body' => $body,
                    'type' => $type,
                    'type_id' => "$to_send_id",
                    'order_id' => "$order_id",
                    'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                );
            } else {
                $title = $trans->bookingStatusChange;
                $body = $trans->bookingStatusUpdateMessage . " " . $translated_status;
                $type = 'order';
                $fcmMsg = array(
                    'content_available' => "true",
                    'title' => $title,
                    'body' => $body,
                    'type' => $type,
                    'type_id' => "$to_send_id",
                    'order_id' => "$order_id",
                    'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                );
            }
            $registrationIDs_chunks = array_chunk($users_fcm, 1000);
            send_notification($fcmMsg, $registrationIDs_chunks);
            $store_notification = store_notifications($title, $body, $type, $to_send_id, 0, 'general', now(), 'specific_user', '', $order_id, $to_send_id, '', '', '', '');
        }
        // // Queue booking status update notification instead of sending directly
        // if (!empty($fcm_ids) && check_notification_setting('booking_status_updated', 'notification')) {
        //     queueBookingNotification($order_id, $to_send_id, $users_fcm, $translated_status, null, $usersEmail, $details, $status, $additional_charges);
        // }
        $settings = get_settings('general_settings', true);
        $icon = $settings['logo'];
        // $data = array(
        //     'name' => (!empty($username)) ? $username : "",
        //     'title' => "Booking Status Update",
        //     'logo' => base_url("public/uploads/site/" . $icon),
        //     'first_paragraph' => 'We would like to inform you that the status of your Booking has been updated.',
        //     'second_paragraph' => 'Booking status is ' . $status,
        //     'third_paragraph' => 'Thank you for choosing our services. We look forward to providing you with excellent service in the future.',
        //     'company_name' => $settings['company_title'],
        // );
        if (!empty($usersEmail[0]['email']) && check_notification_setting('booking_status_updated', 'email') && is_unsubscribe_enabled($to_send_id) == 1) {
            send_custom_email('booking_status_updated', null, $usersEmail[0]['email'], null, $to_send_id, $order_id, $details[0]['date_of_service'], null, null, null, $languageCode);
        }
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = labels(INVALID_STATUS_PASSED, "Invalid Status Passed");
        $response['data'] = array();
        return $response;
    }
}

function unsettled_commision($partner_id = '')
{
    $amount = fetch_details('orders', ['partner_id' => $partner_id, 'is_commission_settled' => '0', 'status' => 'completed'], ['sum(final_total) as total']);
    if (isset($amount) && !empty($amount)) {
        $admin_commission_percentage = get_admin_commision($partner_id);
        $admin_commission_amount = intval($admin_commission_percentage) / 100;
        $total = $amount[0]['total'];
        $commision = intval($total) * $admin_commission_amount;
        $unsettled_amount = $total - $commision;
    } else {
        $unsettled_amount = 0;
    }
    return $unsettled_amount;
}
function get_admin_commision($partner_id = '')
{
    $commision = fetch_details('partner_details', ['partner_id' => $partner_id], ['admin_commission'])[0]['admin_commission'];
    return $commision;
}
function process_refund($order_id, $status, $customer_id)
{
    $possible_status = array("cancelled");
    if (!in_array($status, $possible_status)) {
        $response['error'] = true;
        $response['message'] = 'Refund cannot be processed. Invalid status';
        $response['data'] = array();
        return $response;
    }
    /* if complete order is getting cancelled */
    $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status', 'partner_id']);
    if (isset($transaction) && !empty($transaction)) {
        $type = $transaction[0]['type'];
        $currency = $transaction[0]['currency_code'];
        $txn_id = $transaction[0]['txn_id'];
        $amount = $transaction[0]['amount'];
        $partner_id = $transaction[0]['partner_id'];
        if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
            $flutterwave = new Flutterwave();
            $payment = $flutterwave->refund_payment($txn_id, $amount);
            if (isset($payment->status) && $payment->status == 'success') {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'flutterwave',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment->status,
                    'message' => "flutterwave_refund",
                    'partner_id' => $partner_id,
                ];
                $success = insert_details($data, 'transactions');
                $response['error'] = false;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = "Payment Refund Successfully";
                if ($success) {
                    update_details(['status' => $status, 'isRefunded' => '1'], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
            } else {
                $message = json_decode($payment, true);
                $response['error'] = true;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = $message['message'];
            }
        }
        if ($type == "stripe" && $transaction[0]['status'] == 'success') {
            $amount = $transaction[0]['amount'] / 100;
            $stripe = new Stripe();
            $payment = $stripe->refund($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "succeeded") {
                $amount = intval($payment['amount']);
                $data = [
                    'transaction_type' => $payment['object'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'stripe',
                    'txn_id' => $payment['payment_intent'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                    'message' => "stripe_refund",
                    'partner_id' => $partner_id,
                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status, 'isRefunded' => '1'], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "razorpay" && $transaction[0]['status'] == "success") {
            $razorpay = new Razorpay();
            $payment = $razorpay->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "processed") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => $payment['entity'],
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'razorpay',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                    'message' => 'razorpay_refund',
                    'partner_id' => $partner_id,
                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    update_details(['status' => $status, 'isRefunded' => '1'], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "Booking can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment['body'], true);
                $msg = $res['error']['description'];
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "paystack" && $transaction[0]['status'] == "success") {
            $paystack = new Paystack();
            $amount = $transaction[0]['amount'] / 100;
            $payment = $paystack->refund($txn_id, $amount);
            $message = json_decode($payment, true);
            if (isset($message['status']) && $message['status'] == 1) {
                $amount = intval($message['data']['amount']);
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paystack',
                    'txn_id' => $message['data']['transaction']['id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $message['data']['status'],
                    'message' => 'paystack_refund',
                    'partner_id' => $partner_id
                ];
                $success = insert_details($data, 'transactions');
                update_details(['status' => $status], ['id' => $order_id, 'isRefunded' => '1'], 'orders');
                if ($success) {
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "Booking can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment, true);
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $res['message'],
                ];
                return $response;
            }
        }
        if ($type == "paypal" && $transaction[0]['status'] == 'success') {
            $paypal = new Paypal();
            $payment = $paypal->refund($txn_id, $amount, $transaction[0]['currency_code']);
            $message = json_decode($payment, true);
            if (isset($message['status']) && $message['status'] == "COMPLETED") {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paypal',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' =>  $message['status'],
                    'message' => 'paypal_refund',
                    'partner_id' => $partner_id
                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "xendit" && $transaction[0]['status'] == 'success') {
            // Initialize Xendit library
            $xendit = new \App\Libraries\Xendit();

            // Create refund through Xendit API
            $payment = $xendit->refund_payment($txn_id, $amount, 'REQUESTED_BY_CUSTOMER');

            log_message('error', 'Xendit Refund Response: ' . json_encode($payment));

            if ($payment && isset($payment['status'])) {
                // Store additional refund data in reference column as JSON
                $refund_reference_data = [
                    'refund_id' => $payment['id'] ?? '',
                    'external_id' => $payment['external_id'] ?? '',
                    'payment_id' => $payment['payment_id'] ?? $txn_id,
                    'refund_reason' => $payment['reason'] ?? 'Customer requested refund',
                    'refund_fee' => $payment['fee'] ?? 0,
                    'refund_type' => 'manual_refund',
                    'processed_at' => date('Y-m-d H:i:s'),
                    'raw_response' => $payment
                ];

                // Check if refund was successful
                $refund_status = strtolower($payment['status']);

                // Xendit refund statuses: PENDING, SUCCEEDED, FAILED
                if (in_array($refund_status, ['pending', 'succeeded'])) {
                    $data = [
                        'transaction_type' => 'refund',
                        'order_id' => $order_id,
                        'user_id' => $customer_id,
                        'type' => 'xendit',
                        'txn_id' => $payment['id'] ?? $txn_id, // Use refund ID as transaction ID
                        'amount' => isset($payment['amount']) ? ($payment['amount'] / 100) : $amount, // Convert from cents
                        'currency_code' => $currency,
                        'status' => $refund_status,
                        'message' => 'xendit_refund',
                        'partner_id' => $partner_id,
                        'reference' => json_encode($refund_reference_data)
                    ];

                    $success = insert_details($data, 'transactions');

                    if ($success) {
                        // Update order status
                        update_details(['status' => $status, 'isRefunded' => '1'], ['id' => $order_id], 'orders');

                        $response = [
                            'error' => false,
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'message' => "Refund initiated successfully. Status: " . ucfirst($refund_status),
                        ];

                        // If refund is successful immediately
                        if ($refund_status === 'succeeded') {
                            $response['message'] = "Booking cancelled and refund processed successfully!";
                        } else {
                            $response['message'] = "Booking cancelled. Refund is being processed and will be completed shortly.";
                        }

                        return $response;
                    } else {
                        $response = [
                            'error' => true,
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'message' => "Refund initiated but failed to update database",
                        ];
                        return $response;
                    }
                } else {
                    // Refund failed
                    log_message('error', 'Xendit Refund Failed: ' . json_encode($payment));

                    $response = [
                        'error' => true,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "Refund failed: " . ($payment['failure_reason'] ?? 'Unknown error'),
                    ];
                    return $response;
                }
            } else {
                // API call failed
                log_message('error', 'Xendit Refund API call failed for TXN ID: ' . $txn_id);

                // Create pending transaction entry for failed refund
                $pending_refund_data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'xendit',
                    'txn_id' => $payment['id'] ?? $txn_id,
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => 'pending',
                    'message' => 'manually_refund',
                    'partner_id' => $partner_id,
                    'reference' => json_encode([
                        'refund_id' => $payment['id'] ?? '',
                        'external_id' => $payment['external_id'] ?? '',
                        'payment_id' => $payment['payment_id'] ?? $txn_id,
                        'refund_reason' => 'Customer requested refund - Initial attempt failed',
                        'refund_type' => 'manual_refund_retry',
                        'processed_at' => date('Y-m-d H:i:s'),
                        'failure_reason' => $payment['failure_reason'] ?? 'Unknown error',
                        'raw_response' => $payment
                    ])
                ];

                $pending_success = insert_details($pending_refund_data, 'transactions');

                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Refund failed: " . ($payment['failure_reason'] ?? 'Unknown error') . ". A pending refund request has been created.",
                ];
                return $response;
            }
        }
    } else {
        $response = [
            'error' => true,
            'csrfName' => csrf_token(),
            'csrfHash' => csrf_hash(),
            'message' => 'No transactio found of this order!',
        ];
        return $response;
    }
}
function process_service_refund($order_id, $ordered_service_id, $status, $customer_id, $amount)
{
    $transaction = fetch_details('transactions', ['order_id' => $order_id, 'transaction_type' => 'transaction'], ['amount', 'txn_id', 'type', 'currency_code', 'status']);
    if (isset($transaction) && !empty($transaction)) {
        $service_id = $ordered_service_id;
        $type = $transaction[0]['type'];
        $currency = $transaction[0]['currency_code'];
        $txn_id = $transaction[0]['txn_id'];
        $amount = $amount;
        if ($type == "stripe" && $transaction[0]['status'] == 'succeeded') {
            $stripe = new Stripe();
            $payment = $stripe->refund($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "succeeded") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'stripe',
                    'txn_id' => $payment['payment_intent'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "razorpay" && $transaction[0]['status'] == "captured") {
            $razorpay = new Razorpay();
            $payment = $razorpay->refund_payment($txn_id, $amount);
            if (isset($payment['status']) && $payment['status'] == "processed") {
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'razorpay',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "order can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment['body'], true);
                $msg = $res['error']['description'];
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "paystack" && $transaction[0]['status'] == "success") {
            $paystack = new Paystack();
            $payment = $paystack->refund($txn_id, $amount);
            $message = json_decode($payment, true);
            if (isset($payment['status']) && $payment['status'] == "true") {
                update_details(['status' => $status], ['id' => $order_id], 'orders');
                $amount = intval($payment['amount']) / 100;
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paystack',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                ];
                $success = insert_details($data, 'transactions');
                if ($success) {
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                } else {
                    $response = [
                        'error' => false,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "Booking can not be cancelled",
                    ];
                    return $response;
                }
            } else {
                $res = json_decode($payment, true);
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $res['message'],
                ];
                return $response;
            }
        }
        if ($type == 'flutterwave' && $transaction[0]['status'] == "successfull") {
            $flutterwave = new Flutterwave();
            $payment = $flutterwave->refund_payment($txn_id, $amount);
            $payment = json_decode($payment);
            if (isset($payment->status) && $payment->status == 'success') {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paystack',
                    'txn_id' => $payment['payment_id'],
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => $payment['status'],
                ];
                $success = insert_details($data, 'transactions');
                $response['error'] = false;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = "Payment Refund Successfully";
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
            } else {
                $message = json_decode($payment, true);
                $response['error'] = true;
                $response['csrfName'] = csrf_token();
                $response['csrfHash'] = csrf_hash();
                $response['message'] = $message['message'];
            }
        }
        if ($type == "paypal" && $transaction[0]['status'] == 'success') {
            $paypal = new Paypal();
            $payment = $paypal->refund($txn_id, $amount, $transaction[0]['currency_code']);
            $message = json_decode($payment, true);
            if (isset($message['status']) && $message['status'] == "COMPLETED") {
                $data = [
                    'transaction_type' => 'refund',
                    'order_id' => $order_id,
                    'user_id' => $customer_id,
                    'type' => 'paypal',
                    'txn_id' => $txn_id,
                    'amount' => $amount,
                    'currency_code' => $currency,
                    'status' => 'success',
                ];
                $success = insert_details($data, 'transactions');
                $response = [
                    'error' => false,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Payment Refund Successfully",
                ];
                if ($success) {
                    update_details(['status' => $status], ['id' => $order_id], 'orders');
                    $response = [
                        'error' => false,
                        'message' => "Booking cancelled Successfully!",
                    ];
                    return $response;
                }
                return $response;
            } else {
                $res = json_decode($payment['body']);
                $msg = $res->error->message;
                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => $msg,
                ];
                return $response;
            }
        }
        if ($type == "xendit" && $transaction[0]['status'] == 'success') {
            // Initialize Xendit library
            $xendit = new \App\Libraries\Xendit();

            // Create partial refund through Xendit API
            $payment = $xendit->refund_payment($txn_id, $amount, 'REQUESTED_BY_CUSTOMER');

            log_message('error', 'Xendit Service Refund Response: ' . json_encode($payment));

            if ($payment && isset($payment['status'])) {
                // Store additional refund data in reference column as JSON
                $refund_reference_data = [
                    'refund_id' => $payment['id'] ?? '',
                    'external_id' => $payment['external_id'] ?? '',
                    'payment_id' => $payment['payment_id'] ?? $txn_id,
                    'refund_reason' => $payment['reason'] ?? 'Partial service refund requested',
                    'refund_fee' => $payment['fee'] ?? 0,
                    'refund_type' => 'service_refund',
                    'service_id' => $service_id,
                    'processed_at' => date('Y-m-d H:i:s'),
                    'raw_response' => $payment
                ];

                // Check if refund was successful
                $refund_status = strtolower($payment['status']);

                // Xendit refund statuses: PENDING, SUCCEEDED, FAILED
                if (in_array($refund_status, ['pending', 'succeeded'])) {
                    $data = [
                        'transaction_type' => 'refund',
                        'order_id' => $order_id,
                        'user_id' => $customer_id,
                        'type' => 'xendit',
                        'txn_id' => $payment['id'] ?? $txn_id, // Use refund ID as transaction ID
                        'amount' => isset($payment['amount']) ? ($payment['amount'] / 100) : $amount, // Convert from cents
                        'currency_code' => $currency,
                        'status' => $refund_status,
                        'message' => 'xendit_refund',
                        'reference' => json_encode($refund_reference_data)
                    ];

                    $success = insert_details($data, 'transactions');

                    if ($success) {
                        // Update order status
                        update_details(['status' => $status], ['id' => $order_id], 'orders');

                        $response = [
                            'error' => false,
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'message' => "Service refund initiated successfully. Status: " . ucfirst($refund_status),
                        ];

                        // If refund is successful immediately
                        if ($refund_status === 'succeeded') {
                            $response['message'] = "Service refund processed successfully!";
                        } else {
                            $response['message'] = "Service refund is being processed and will be completed shortly.";
                        }

                        return $response;
                    } else {
                        $response = [
                            'error' => true,
                            'csrfName' => csrf_token(),
                            'csrfHash' => csrf_hash(),
                            'message' => "Service refund initiated but failed to update database",
                        ];
                        return $response;
                    }
                } else {
                    // Refund failed
                    log_message('error', 'Xendit Service Refund Failed: ' . json_encode($payment));

                    $response = [
                        'error' => true,
                        'csrfName' => csrf_token(),
                        'csrfHash' => csrf_hash(),
                        'message' => "Service refund failed: " . ($payment['failure_reason'] ?? 'Unknown error'),
                    ];
                    return $response;
                }
            } else {
                // API call failed
                log_message('error', 'Xendit Service Refund API call failed for TXN ID: ' . $txn_id);

                $response = [
                    'error' => true,
                    'csrfName' => csrf_token(),
                    'csrfHash' => csrf_hash(),
                    'message' => "Failed to process service refund. Please try again or contact support.",
                ];
                return $response;
            }
        }
    } else {
        $response = [
            'error' => true,
            'csrfName' => csrf_token(),
            'csrfHash' => csrf_hash(),
            'message' => 'No transaction found of this order!',
        ];
        return $response;
    }
}
function curl($url, $method = 'GET', $header = ['Content-Type: application/x-www-form-urlencoded'], $data = [], $authorization = null)
{
    $ch = curl_init();
    $curl_options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_HEADER => 0,
        CURLOPT_HTTPHEADER => $header,
    );
    if (strtolower($method) == 'post') {
        $curl_options[CURLOPT_POST] = 1;
        $curl_options[CURLOPT_POSTFIELDS] = http_build_query($data);
    } else {
        $curl_options[CURLOPT_CUSTOMREQUEST] = 'GET';
    }
    curl_setopt_array($ch, $curl_options);
    $result = array(
        'body' => curl_exec($ch),
        'http_code' => curl_getinfo($ch, CURLINFO_HTTP_CODE),
    );
    return $result;
}
function generate_token()
{
    $jwt = new App\Libraries\JWT();
    $payload = [
        'iat' => time(), /* issued at time */
        'iss' => 'edemand',
        'exp' => time() + (30 * 60), /* expires after 1 minute */
        'sub' => 'edemand_authentication',
    ];
    $token = $jwt->encode($payload, "my_secret");
    return $token;
}
function verify_token()
{
    // to verify the token from admin pannel
    $responses = \Config\Services::response();
    $jwt = new App\Libraries\JWT;
    // verify_ip();
    try {
        $token = $jwt->getBearerToken();
    } catch (\Exception $e) {
        $response['error'] = true;
        $response['message'] = $e->getMessage();
        print_r(json_encode($response));
        return false;
    }
    if (!empty($token)) {
        $api_keys = API_SECRET;
        if (empty($api_keys)) {
            $response['error'] = true;
            $response['message'] = 'No Client(s) Data Found !';
            print_r(json_encode($response));
            return $response;
        }
        $flag = true; //For payload indication that it return some data or throws an expection.
        $error = true; //It will indicate that the payload had verified the signature and hash is valid or not.
        $message = '';
        $user_token = " ";
        try {
            $user_id = $jwt->decode_unsafe($token)->user_id;
            $user_token = fetch_details('users', ['id' => $user_id])[0]['api_key'];
        } catch (\Exception $e) {
            $message = $e->getMessage();
        }
        try {
            $payload = $jwt->decode($token, $api_keys, ['HS256']);
            if (isset($payload->iss)) {
                $error = false;
                $flag = false;
            } else {
                $error = true;
                $flag = false;
                $message = 'Invalid Hash';
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
        }
        if ($flag) {
            $response['error'] = true;
            $response['message'] = $message;
            print_r(json_encode($response));
            return false;
        } else {
            if ($error == true) {
                $response['error'] = true;
                $response['message'] = $message;
                $responses->setStatusCode(401);
                print_r(json_encode($response));
                return false;
            } else {
                return $payload->user_id;
            }
        }
    } else {
        $response['error'] = true;
        $response['message'] = "Unauthorized access not allowed";
        print_r(json_encode($response));
        return false;
    }
}
function xss_clean($data)
{
    $data = trim($data);
    // Fix &entity\n;
    $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
    $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
    $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
    $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
    // Remove any attribute starting with "on" or xmlns
    $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
    // Remove javascript: and vbscript: protocols
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
    // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);
    // Remove namespaced elements (we do not need them)
    $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
    do {
        // Remove really unwanted tags
        $old_data = $data;
        $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
    } while ($old_data !== $data);
    // we are done...
    return $data;
}
function get_settings($type = 'system_settings', $is_json = false, $bool = false)
{
    $db = \Config\Database::connect();
    $builder = $db->table('settings');
    if ($type == 'all') {
        $res = $builder->select(' * ')->get()->getResultArray();
    } else {
        $res = $builder->select(' * ')->where('variable', $type)->get()->getResultArray();
    }
    $db->close();
    if (!empty($res)) {
        if ($is_json) {
            return json_decode($res[0]['value'], true);
        } else {
            return $res[0]['value'];
        }
    } else {
        if ($bool) {
            return false;
        } else {
            return [];
        }
    }
}
function escape_array($array)
{
    $db = \Config\Database::connect();
    $posts = [];
    if (!empty($array)) {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                // Only escape strings, leave other types as is
                $posts[$key] = is_string($value) ? $db->escapeString($value) : $value;
            }
        } else {
            // Escape only if it's a string
            return is_string($array) ? $db->escapeString($array) : $array;
        }
    }
    return $posts;
}
function update_details($set, $where, $table, $escape = true)
{
    $db = \Config\Database::connect();
    $db->transStart();
    if ($escape) {
        $set = escape_array($set);
    }
    $db->table($table)->update($set, $where);
    $db->transComplete();
    $response = false;
    if ($db->transStatus() === true) {
        $response = true;
    }
    $db->close();
    // print_r($db->getLastQuery());
    // die;
    return $response;
}
function fetch_details($table, $where = [], $fields = [], $limit = "", $offset = '0', $sort = 'id', $order = 'DESC', $where_in_key = '', $where_in_value = [], $or_like = [])
{
    $db = \Config\Database::connect();
    $builder = $db->table($table);
    if (!empty($fields)) {
        $builder = $builder->select($fields);
    }
    if (!empty($where)) {
        $builder = $builder->where($where)->select($fields);
    }
    if (!empty($where_in_key) && !empty($where_in_value)) {
        $builder = $builder->whereIn($where_in_key, $where_in_value);
    }
    if (isset($or_like) && !empty($or_like)) {
        $builder->groupStart();
        $builder->orLike($or_like);
        $builder->groupEnd();
    }
    if ($limit != null && $limit != "") {
        $builder = $builder->limit($limit, $offset);
    }
    $builder = $builder->orderBy($sort, $order);
    $res = $builder->get()->getResultArray();

    $db->close();
    return $res;
}
function exists($where, $table)
{
    $db = \Config\Database::connect();
    $builder = $db->table($table);
    $builder = $builder->where($where);
    $res = count($builder->get()->getResultArray());
    if ($res > 0) {
        return true;
    } else {
        return false;
    }
}
function get_group($name = "")
{
    $db = \Config\Database::connect();
    $builder = $db->table("groups as g");
    $builder->select('ug.*,g.name');
    $builder->where('g.name', $name);
    $builder->join('users_groups as ug', 'g.id = ug.group_id ', "left");
    $group = $builder->get()->getResultArray();
    $db->close();
    return $group;
}
function slugify($text, $divider = '-')
{
    $text = preg_replace('~[^\pL\d]+~u', $divider, $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, $divider);
    $text = preg_replace('~-+~', $divider, $text);
    $text = strtolower($text);
    if (empty($text)) {
        return 'n-a';
    }
    return $text;
}
function verify_payment_transaction($txn_id, $payment_method, $additional_data = [])
{
    $db = \Config\Database::connect();
    if (empty(trim($txn_id))) {
        $response['error'] = true;
        $response['message'] = "Transaction ID is required";
        return $response;
    }
    $razorpay = new Razorpay;
    switch ($payment_method) {
        case 'razorpay':
            $payment = $razorpay->fetch_payments($txn_id);
            if (!empty($payment) && isset($payment['status'])) {
                if ($payment['status'] == 'authorized') {
                    $capture_response = $razorpay->capture_payment($payment['amount'], $txn_id, $payment['currency']);
                    if ($capture_response['status'] == 'captured') {
                        $response['error'] = false;
                        $response['message'] = "Payment captured successfully";
                        $response['amount'] = $capture_response['amount'] / 100;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    } else if ($capture_response['status'] == 'refunded') {
                        $response['error'] = true;
                        $response['message'] = "Payment is refunded.";
                        $response['amount'] = $capture_response['amount'] / 100;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    } else {
                        $response['error'] = true;
                        $response['message'] = "Payment could not be captured.";
                        $response['amount'] = (isset($capture_response['amount'])) ? $capture_response['amount'] / 100 : 0;
                        $response['data'] = $capture_response;
                        $response['status'] = $payment['status'];
                        return $response;
                    }
                } else if ($payment['status'] == 'captured') {
                    $status = 'captured';
                    $response['error'] = false;
                    $response['message'] = "Payment captured successfully";
                    $response['amount'] = $payment['amount'] / 100;
                    $response['status'] = $payment['status'];
                    $response['data'] = $payment;
                    return $response;
                } else if ($payment['status'] == 'created') {
                    $status = 'created';
                    $response['error'] = true;
                    $response['message'] = "Payment is just created and yet not authorized / captured!";
                    $response['amount'] = $payment['amount'] / 100;
                    $response['data'] = $payment;
                    $response['status'] = $payment['status'];
                    return $response;
                } else {
                    $status = 'failed';
                    $response['error'] = true;
                    $response['message'] = "Payment is " . ucwords($payment['status']) . "! ";
                    $response['amount'] = (isset($payment['amount'])) ? $payment['amount'] / 100 : 0;
                    $response['status'] = $payment['status'];
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the transaction ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                $response['status'] = 'failed';
                return $response;
            }
            break;
        case "paystack":
            $paystack = new Paystack;
            $payment = $paystack->verify_transation($txn_id);
            if (!empty($payment)) {
                $payment = json_decode($payment, true);
                if (isset($payment['data']['status']) && $payment['data']['status'] == 'success') {
                    $response['error'] = false;
                    $response['message'] = "Payment is successful";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    $response['status'] = $payment['data']['status'];
                    return $response;
                } elseif (isset($payment['data']['status']) && $payment['data']['status'] != 'success') {
                    $response['error'] = true;
                    $response['message'] = "Payment is " . ucwords($payment['data']['status']) . "! ";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    $response['status'] = $payment['data']['status'];
                    return $response;
                } else {
                    $response['error'] = true;
                    $response['message'] = "Payment is unsuccessful! ";
                    $response['amount'] = (isset($payment['data']['amount'])) ? $payment['data']['amount'] / 100 : 0;
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the transaction ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                $response['status'] = 'failed';
                return $response;
            }
            break;
        case 'paytm':
            $paytm = new Paytm;
            $payment = $paytm->transaction_status($txn_id);
            if (!empty($payment)) {
                $payment = json_decode($payment, true);
                if (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultCode'] == '01' && $payment['body']['resultInfo']['resultStatus'] == 'TXN_SUCCESS')
                ) {
                    $response['error'] = false;
                    $response['message'] = "Payment is successful";
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } elseif (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultStatus'] == 'TXN_FAILURE')
                ) {
                    $response['error'] = true;
                    $response['message'] = $payment['body']['resultInfo']['resultMsg'];
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } else if (
                    isset($payment['body']['resultInfo']['resultCode'])
                    && ($payment['body']['resultInfo']['resultStatus'] == 'PENDING')
                ) {
                    $response['error'] = true;
                    $response['message'] = $payment['body']['resultInfo']['resultMsg'];
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                } else {
                    $response['error'] = true;
                    $response['message'] = "Payment is unsuccessful!";
                    $response['amount'] = (isset($payment['body']['txnAmount'])) ? $payment['body']['txnAmount'] : 0;
                    $response['data'] = $payment;
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = "Payment not found by the Order ID!";
                $response['amount'] = 0;
                $response['data'] = [];
                return $response;
            }
            break;
    }
}
function add_transaction($transaction_details)
{
    $db = \Config\Database::connect();
    $insert = $db->table('transactions')->insert($transaction_details);
    if ($insert) {
        return $db->insertID();
    } else {
        return false;
    }
}
function valid_image($image)
{
    helper(['form', 'url']);
    $request = \Config\Services::request();
    if ($request->getFile($image)) {
        $file = $request->getFile($image);
        if (!$file->isValid()) {
            return false;
        }
        $type = $file->getMimeType();
        if ($type == 'image/jpeg' || $type == 'image/png' || $type == 'image/jpg' || $type == 'image/svg+xml' || $type = 'image/gif') {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}
function move_file($file, $path = 'public/uploads/images/', $name = '', $replace = false, $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'image/svg+xml', 'image/gif', 'application/json', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/pdf'])
{
    $type = $file->getMimeType();
    $p = FCPATH . $path;
    if (in_array($type, $allowed_types)) {
        if ($name == '') {
            $name = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->getName());
        }
        $ext = $file->guessExtension();
        if ($file->move($p, $name, $replace)) {
            $name = $file->getName();
            $response['error'] = false;
            $response['message'] = "File moved successfully";
            $response['file_name'] = $name;
            $response['extension'] = $ext;
            $response['file_size'] = $file->getSizeByUnit("kb");
            $response['path'] = $path;
            $response['full_path'] = $path . $name;
        } else {
            $response['error'] = true;
            $response['message'] = "File could not be moved!" . $file->getError();
            $response['file_name'] = $name;
            $response['extension'] = "";
            $response['file_size'] = "";
            $response['path'] = $path;
            $response['full_path'] = "";
        }
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "File could not be moved! Invalid file type uploaded";
        return $response;
    }
}
function move_chat_file($file, $path = 'public/uploads/images/', $name = '', $replace = false, $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'image/svg+xml', 'image/gif', 'application/json', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/pdf', 'application/zip'])
{
    $type = $file->getMimeType();
    $p = FCPATH . $path;
    if (in_array($type, $allowed_types)) {
        if ($name == '') {
            $name = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->getName());
        }
        $ext = $file->guessExtension();
        if ($file->move($p, $name, $replace)) {
            $name = $file->getName();
            $response['error'] = false;
            $response['message'] = "File moved successfully";
            $response['file_name'] = $name;
            $response['extension'] = $ext;
            $response['file_size'] = $file->getSizeByUnit("kb");
            $response['path'] = $path;
            $response['full_path'] = $path . $name;
        } else {
            $response['error'] = true;
            $response['message'] = "File could not be moved!" . $file->getError();
            $response['file_name'] = $name;
            $response['extension'] = "";
            $response['file_size'] = "";
            $response['path'] = $path;
            $response['full_path'] = "";
        }
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "File could not be moved! Invalid file type uploaded";
        return $response;
    }
}
function formatOffset($offset)
{
    $hours = $offset / 3600;
    $remainder = $offset % 3600;
    $sign = $hours > 0 ? '+' : '-';
    $hour = (int) abs($hours);
    $minutes = (int) abs($remainder / 60);
    if ($hour == 0 and $minutes == 0) {
        $sign = ' ';
    }
    return $sign . str_pad($hour, 2, '0', STR_PAD_LEFT) . ':' . str_pad($minutes, 2, '0');
}
function get_timezone_array()
{
    $list = DateTimeZone::listAbbreviations();
    $idents = DateTimeZone::listIdentifiers();
    $data = $offset = $added = array();
    foreach ($list as $abbr => $info) {
        foreach ($info as $zone) {
            if (
                !empty($zone['timezone_id'])
                and
                !in_array($zone['timezone_id'], $added)
                and
                in_array($zone['timezone_id'], $idents)
            ) {
                $z = new DateTimeZone($zone['timezone_id']);
                $c = new DateTime("", $z);
                $zone['time'] = $c->format('h:i A');
                $offset[] = $zone['offset'] = $z->getOffset($c);
                $data[] = $zone;
                $added[] = $zone['timezone_id'];
            }
        }
    }
    array_multisort($offset, SORT_ASC, $data);
    $i = 0;
    $temp = array();
    foreach ($data as $key => $row) {
        $temp[0] = $row['time'];
        $temp[1] = formatOffset($row['offset']);
        $temp[2] = $row['timezone_id'];
        $options[$i++] = $temp;
    }
    return $options;
}
function check_exists($file)
{
    $target_path = FCPATH . $file;
    if (!file_exists($target_path)) {
        return true;
    } else {
        return false;
    }
}
function get_system_update_info()
{
    $check_query = false;
    $query_path = "";
    $data['previous_error'] = false;
    $sub_directory = (file_exists(UPDATE_PATH . "update/updater.json")) ? "update/" : "";
    if (file_exists(UPDATE_PATH . "updater.json") || file_exists(UPDATE_PATH . "update/updater.json")) {
        $lines_array = file_get_contents(UPDATE_PATH . $sub_directory . "updater.json");
        $lines_array = json_decode($lines_array, true);
        $file_version = $lines_array['version'];
        $file_previous = $lines_array['previous'];
        $check_query = $lines_array['manual_queries'];
        $query_path = $lines_array['query_path'];
    } else {
        print_r("no json exists");
        die();
    }
    $db_version_data = fetch_details("updates");
    if (!empty($db_version_data) && isset($db_version_data[0]['version'])) {
        $db_current_version = $db_version_data[0]['version'];
    }
    if (!empty($db_current_version)) {
        $data['db_current_version'] = $db_current_version;
    } else {
        $data['db_current_version'] = $db_current_version = 1.0;
    }
    if ($db_current_version == $file_previous) {
        $data['file_current_version'] = $file_current_version = $file_version;
    } else {
        $data['previous_error'] = true;
        $data['file_current_version'] = $file_current_version = false;
    }
    if ($file_current_version != false && $file_current_version > $db_current_version) {
        $data['is_updatable'] = true;
    } else {
        $data['is_updatable'] = false;
    }
    $data['query'] = $check_query;
    $data['query_path'] = $query_path;
    return $data;
}
function labels($label, $alt = '')
{
    //If label is array
    if (is_array($label)) {
        $translated = [];
        foreach ($label as $key => $value) {
            if (is_string($value)) {
                $value = trim($value);
                if (lang('Text.' . $value) != 'Text.' . $value) {
                    $translated[$key] = (lang('Text.' . $value) == '') ? trim($alt) : trim(lang('Text.' . $value));
                } else {
                    //as alt shall be an array as well
                    if (is_array($alt)) {
                        foreach ($alt as $a) {
                            $translated[$key] = trim($a);
                        }
                    }
                }
            }
        }
        return $translated;
    }
    // If label is string
    $label = trim($label);
    if (lang('Text.' . $label) != 'Text.' . $label) {
        if (lang('Text.' . $label) == '') {
            return $alt;
        }
        return trim(lang('Text.' . $label));
    } else {
        return trim($alt);
    }
}
function get_currency()
{
    try {
        $currency = get_settings('general_settings', true)['currency'];
        if ($currency == '') {
            $currency = '₹';
        }
    } catch (Exception $e) {
        $currency = '₹';
    }
    return $currency;
}
function console_log($data)
{
    if (is_array($data)) {
        $data = json_encode($data);
    } elseif (is_object($data)) {
        $data = json_encode($data);
    }
    echo "<script>console.log('$data')</script>";
}
function delete_directory($dir)
{
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (filetype($dir . "/" . $object) == "dir") {
                    $dir_sec = $dir . "/" . $object;
                    if (is_dir($dir_sec)) {
                        $objects_sec = scandir($dir_sec);
                        foreach ($objects_sec as $object_sec) {
                            if ($object_sec != "." && $object_sec != "..") {
                                if (filetype($dir_sec . "/" . $object_sec) == "dir") {
                                    rmdir($dir_sec . "/" . $object_sec);
                                } else {
                                    unlink($dir_sec . "/" . $object_sec);
                                }
                            }
                        }
                        rmdir($dir_sec);
                    }
                } else {
                    unlink($dir . "/" . $object);
                }
            }
        }
        return rmdir($dir);
    }
}
function format_number($number, $decimals = 0, $decimal_separator = '.', $thousand_separator = ',', $currency_symbol = '', $type = 'prefix')
{
    $number = number_format($number, $decimals, $decimal_separator, $thousand_separator);
    $number = (!empty(trim($currency_symbol))) ? (($type == 'prefix') ? $currency_symbol . $number : $number . $currency_symbol) : $number;
    return $number;
}
function email_sender($user_email, $subject, $message)
{
    $email = \Config\Services::email();
    $email_settings = \get_settings('email_settings', true);
    $company_settings = \get_settings('general_settings', true);
    $smtpUsername = $email_settings['smtpUsername'];
    $company_name = $company_settings['company_title'];
    $email->setFrom($smtpUsername, $company_name);
    $email->setTo($user_email);
    $email->setSubject($subject);
    $email->setMessage($message);
    if ($email->send()) {
    } else {
        $data = $email->printDebugger(['headers']);
        return $data;
    }
}
function insert_details(array $data, string $table): array
{
    $db = \Config\Database::connect();
    $status = $db->table($table)->insert($data);
    $id = $db->insertID();
    $db->close();
    if (!$status) {
        return [
            "error" => true,
            "message" => UNKNOWN_ERROR_MESSAGE,
            "data" => [],
        ];
    }
    return [
        "error" => false,
        "message" => "Data inserted",
        "id" => $id,
        "data" => [],
    ];
}
function remove_null_values(array $data)
{
    $integer = [
        'alternate_mobile' => 0,
        'range_wise_charges' => 0,
        'per_km_charge' => 0,
        'max_deliverable_distance' => 0,
        'fixed_charge' => 0,
        'discount' => 0,
    ];
    $array = [];
    foreach ($data as $key => $value) {
        if (is_array($value) || is_object($value)) {
            $data[$key] = remove_null_values($value);
        } else {
            if (is_null($value)) {
                if (isset($integer[$key])) {
                    $data[$key] = 0;
                } else if (isset($array[$key])) {
                    $data[$key] = [];
                } else {
                    $data[$key] = '';
                }
            }
        }
    }
    return $data;
}
if (!function_exists('response_helper')) {
    function response_helper(string $message = UNKNOWN_ERROR_MESSAGE, bool $error = true, $data = [], int $status_code = 200, $additional_data = [])
    {
        $response = \Config\Services::response();
        $send = [
            "error" => $error,
            "message" => $message,
            "data" => $data,
        ];
        $send = array_merge($send, $additional_data);
        return $response->setJSON($send)->setStatusCode($status_code);
    }
}
function delete_details(array $data, string $table)
{
    $db = \Config\Database::connect();
    $builder = $db->table($table);
    if ($builder->delete($data)) {
        $db->close();
        return true;
    }
    $db->close();
    return false;
}
function validate_promo_code($user_id, $promo_code, $final_total)
{
    $db = \Config\Database::connect();
    $builder = $db->table('promo_codes pc');
    $promo_code = $builder->select('pc.*,count(o.id) as promo_used_counter ,( SELECT count(user_id) from orders where user_id =' . $user_id . ' and promocode_id ="' . $promo_code . '") as user_promo_usage_counter ')
        ->join('orders o', 'o.promocode_id=pc.id', 'left')
        ->where(['pc.id' => $promo_code, 'pc.status' => '1', ' start_date <= ' => date('Y-m-d'), '  end_date >= ' => date('Y-m-d')])
        ->get()->getResultArray();
    $db->close();
    // Add translated message to promo code data if promo code exists
    if (!empty($promo_code[0]['id'])) {
        // Get language from header using existing helper function
        $requestedLanguage = get_current_language_from_request();
        $defaultLanguage = get_default_language();

        // Initialize translation model
        $translationModel = new \App\Models\TranslatedPromocodeModel();

        // Get default language translation from translations table
        $defaultTranslation = $translationModel->getTranslation($promo_code[0]['id'], $defaultLanguage);

        // Get requested language translation
        $requestedTranslation = $translationModel->getTranslation($promo_code[0]['id'], $requestedLanguage);

        // Set translated message based on fallback logic:
        // 1. If requested language translation exists → use it
        // 2. If requested language translation doesn't exist → use empty string
        if ($requestedTranslation) {
            $promo_code[0]['translated_message'] = $requestedTranslation;
        } else {
            $promo_code[0]['translated_message'] = '';
        }

        // Update main message field with default language value from translations table
        // If no translation exists, keep the original message from main table
        if ($defaultTranslation) {
            $promo_code[0]['message'] = $defaultTranslation ?? $promo_code[0]['message'];
        }
        // If no default translation exists, message field keeps its original value from main table
        if (intval($promo_code[0]['promo_used_counter']) < intval($promo_code[0]['no_of_users'])) {
            if ($final_total >= intval($promo_code[0]['minimum_order_amount'])) {
                if ($promo_code[0]['repeat_usage'] == 1 && ($promo_code[0]['user_promo_usage_counter'] <= $promo_code[0]['no_of_repeat_usage'])) {
                    if (intval($promo_code[0]['user_promo_usage_counter']) <= intval($promo_code[0]['no_of_repeat_usage'])) {
                        $response['error'] = false;
                        $response['message'] = labels(THE_PROMO_CODE_IS_VALID, 'The promo code is valid');
                        if ($promo_code[0]['discount_type'] == 'percentage') {
                            $promo_code_discount = floatval($final_total * $promo_code[0]['discount'] / 100);
                        } else {
                            $promo_code_discount = floatval($final_total - $promo_code[0]['discount']);
                        }
                        if ($promo_code[0]['discount_type'] == 'amount') {
                            if ($promo_code[0]['discount'] > $final_total) {
                                $promo_code_discount = $final_total;
                                $total = floatval($final_total);
                            }
                        }
                        if ($promo_code_discount > $final_total) {
                            if ($promo_code[0]['discount_type'] == 'amount') {
                                $promo_code_discount = $final_total;
                                $total = floatval($final_total);
                            }
                        } else {
                            if ($promo_code_discount <= $promo_code[0]['max_discount_amount']) {
                                $promo_code[0]['discount_type'] == 'amount' ? ($total = floatval($final_total) - $promo_code_discount) : $total = $promo_code_discount;
                            } else {
                                $total = floatval($final_total) - $promo_code[0]['max_discount_amount'];
                                $promo_code_discount = $promo_code[0]['max_discount_amount'];
                            }
                        }
                        $promo_code[0]['final_total'] = strval(floatval($total));
                        $promo_code[0]['final_discount'] = strval(floatval($promo_code_discount));
                        $response['data'] = $promo_code;
                        return $response;
                    } else {
                        $response['error'] = true;
                        $response['message'] = labels(THIS_PROMO_CODE_CANNOT_BE_REDEEMED_AS_IT_EXCEEDS_THE_USAGE_LIMIT, 'This promo code cannot be redeemed as it exceeds the usage limit');
                        $response['data']['final_total'] = strval(floatval($final_total));
                        return $response;
                    }
                } else if ($promo_code[0]['repeat_usage'] == 0 && ($promo_code[0]['user_promo_usage_counter'] <= 0)) {
                    if (intval($promo_code[0]['user_promo_usage_counter']) <= intval($promo_code[0]['no_of_repeat_usage'])) {
                        $response['error'] = false;
                        $response['message'] = labels(THE_PROMO_CODE_IS_VALID, 'The promo code is valid');
                        // if ($promo_code[0]['discount_type'] == 'percentage') {
                        //     $promo_code_discount = floatval($final_total * $promo_code[0]['discount'] / 100);
                        // } else {
                        //     $promo_code_discount = floatval($final_total - $promo_code[0]['discount']);
                        // }
                        // if ($promo_code_discount > $final_total) {
                        //     $promo_code_discount = $final_total;
                        //     $total = floatval($final_total);
                        // } else {
                        //     if ($promo_code_discount <= $promo_code[0]['max_discount_amount']) {
                        //         $total = floatval($final_total) - $promo_code_discount;
                        //     } else {
                        //         $total = floatval($final_total) - $promo_code[0]['max_discount_amount'];
                        //         $promo_code_discount = $promo_code[0]['max_discount_amount'];
                        //     }
                        // }
                        if ($promo_code[0]['discount_type'] == 'percentage') {
                            $promo_code_discount = floatval($final_total * $promo_code[0]['discount'] / 100);
                        } else {
                            $promo_code_discount = floatval($final_total - $promo_code[0]['discount']);
                        }
                        if ($promo_code[0]['discount'] > $final_total) {
                            $promo_code_discount = $final_total;
                            $total = floatval($final_total);
                        }
                        if ($promo_code_discount > $final_total) {
                            $promo_code_discount = $final_total;
                            $total = floatval($final_total);
                        } else {
                            if ($promo_code_discount <= $promo_code[0]['max_discount_amount']) {
                                $total = floatval($final_total) - $promo_code_discount;
                            } else {
                                $total = floatval($final_total) - $promo_code[0]['max_discount_amount'];
                                $promo_code_discount = $promo_code[0]['max_discount_amount'];
                            }
                        }
                        $promo_code[0]['final_total'] = strval(floatval($total));
                        $promo_code[0]['final_discount'] = strval(floatval($promo_code_discount));
                        $response['data'] = $promo_code;
                        return $response;
                    } else {
                        $response['error'] = true;
                        $response['message'] = labels(THIS_PROMO_CODE_CANNOT_BE_REDEEMED_AS_IT_EXCEEDS_THE_USAGE_LIMIT, 'This promo code cannot be redeemed as it exceeds the usage limit');
                        $response['data']['final_total'] = strval(floatval($final_total));
                        return $response;
                    }
                } else {
                    $response['error'] = true;
                    $response['message'] = labels(THE_PROMO_CODE_HAS_ALREADY_BEEN_REDEEMED_CANNOT_BE_REUSED, 'The promo has already been redeemed. cannot be reused');
                    $response['data']['final_total'] = strval(floatval($final_total));
                    return $response;
                }
            } else {
                $response['error'] = true;
                $response['message'] = labels(THIS_PROMO_CODE_IS_APPLICABLE_ONLY_FOR_AMOUNT_GREATER_THAN_OR_EQUAL_TO, 'This promo code is applicable only for amount greater than or equal to ' . $promo_code[0]['minimum_order_amount']);
                $response['data']['final_total'] = strval(floatval($final_total));
                return $response;
            }
        } else {
            $response['error'] = true;
            $response['message'] = labels(PROMOCODE_USAGE_EXCEEDED, "promocode usage exceeded");
            $response['data']['final_total'] = strval(floatval($final_total));
            return $response;
        }
    } else {
        $response['error'] = true;
        $response['message'] = labels(THE_PROMO_CODE_IS_NOT_AVAILABLE_OR_EXPIRED, 'The promo code is not available or expired');
        $response['data']['final_total'] = strval(floatval($final_total));
        return $response;
    }
}
function validate_promo_code_new($user_id, $promo_code, $final_total)
{
    $db = \Config\Database::connect();
    $builder = $db->table('promo_codes pc');
    $promo_code = $builder->select('pc.*,count(o.id) as promo_used_counter ,( SELECT count(user_id) from orders where user_id =' . $user_id . ' and promocode_id ="' . $promo_code . '") as user_promo_usage_counter ')
        ->join('orders o', 'o.promocode_id=pc.id', 'left')
        ->where(['pc.id' => $promo_code, 'pc.status' => '1', ' start_date <= ' => date('Y-m-d'), '  end_date >= ' => date('Y-m-d')])
        ->get()->getResultArray();
    if (empty($promo_code_data)) {
        return generateErrorResponse('The promo code is not available or expired', $final_total);
    }
    if (intval($promo_code_data['promo_used_counter']) >= intval($promo_code_data['no_of_users'])) {
        return generateErrorResponse('Promocode usage exceeded', $final_total);
    }
    if ($final_total < intval($promo_code_data['minimum_order_amount'])) {
        return generateErrorResponse('This promo code is applicable only for amount greater than or equal to ' . $promo_code_data['minimum_order_amount'], $final_total);
    }
    if ($promo_code_data['repeat_usage'] == 1 && intval($promo_code_data['user_promo_usage_counter']) > intval($promo_code_data['no_of_repeat_usage'])) {
        return generateErrorResponse('This promo code cannot be redeemed as it exceeds the usage limit', $final_total);
    }
    if ($promo_code_data['repeat_usage'] == 0 && intval($promo_code_data['user_promo_usage_counter']) > 0) {
        return generateErrorResponse('The promo has already been redeemed. cannot be reused', $final_total);
    }
    $promo_code_discount = calculateDiscount($promo_code_data, $final_total);
    $total = $final_total - $promo_code_discount;
    $promo_code_data['final_total'] = strval(floatval($total));
    $promo_code_data['final_discount'] = strval(floatval($promo_code_discount));
    $db->close();
    return [
        'error' => false,
        'message' => 'The promo code is valid',
        'data' => $promo_code_data
    ];
}
function generateErrorResponse($message, $final_total)
{
    return [
        'error' => true,
        'message' => $message,
        'data' => ['final_total' => strval(floatval($final_total))]
    ];
}
function calculateDiscount($promo_code_data, $final_total)
{
    if ($promo_code_data['discount_type'] == 'percentage') {
        $promo_code_discount = floatval($final_total * $promo_code_data['discount'] / 100);
    } else {
        $promo_code_discount = floatval($promo_code_data['discount']);
    }
    if ($promo_code_data['discount_type'] == 'amount' && $promo_code_discount > $final_total) {
        $promo_code_discount = $final_total;
    }
    if ($promo_code_discount > $promo_code_data['max_discount_amount']) {
        $promo_code_discount = $promo_code_data['max_discount_amount'];
    }
    return $promo_code_discount;
}
function get_near_partners($latitude, $longitude, $distance, $is_array = false)
{
    $max_deliverable_distance = $distance;
    $db = \Config\Database::connect();
    $point = ($latitude > -90 && $latitude < 90) ? "POINT($latitude" : "POINT($latitude > 90";
    $point .= ($longitude > -180 && $longitude < 180) ? " $longitude)" : " $longitude > 180)";
    $builder = $db->table('users u');
    $partners = $builder->Select("u.latitude,u.longitude,u.id,st_distance_sphere(POINT($longitude, $latitude), POINT(`longitude`, `latitude` ))/1000  as distance")
        ->join('users_groups ug', 'ug.user_id=u.id')
        ->where('ug.group_id', '3')
        // ->where('ABS((u.latitude)) > 180  or  ABS((u.longitude)) > 90')
        ->having('distance < ' . $max_deliverable_distance)
        ->orderBy('distance')
        ->get()->getResultArray();
    $ids = [];
    foreach ($partners as $key => $parnter) {
        $ids[] = $parnter['id'];
    }
    if ($is_array == false) {
        $ids = implode(',', $ids);
    }
    $db->close();
    return $ids;
}
function fetch_cart($from_app = false, int $user_id = 0, string $search = '', $limit = 0, int $offset = 0, string $sort = 'c.id', string $order = 'Desc', $where = [], $additional_data = [], $reorder = null, $order_id = null)
{
    $disk = fetch_current_file_manager();
    $db = \Config\Database::connect();
    $builder = $db->table('cart c');
    $sortable_fields = [
        'c.id' => 'c.id',
    ];
    if ($search and $search != '') {
        $multipleWhere = [
            '`s.id`' => $search,
            '`s.title`' => $search,
            '`s.description`' => $search,
            '`s.status`' => $search,
            '`s.tags`' => $search,
            '`s.price`' => $search,
            '`s.discounted_price`' => $search,
            '`s.rating`' => $search,
            '`s.number_of_ratings`' => $search,
            '`s.max_quantity_allowed`' => $search,
        ];
    }
    $total = $builder->select(' COUNT(c.id) as `total` ')->where('c.user_id', $user_id);
    if (isset($multipleWhere) && !empty($multipleWhere)) {
        $builder->orWhere($multipleWhere);
    }
    if (isset($where) && !empty($where)) {
        $builder->where($where);
    }
    $service_count = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
    $total = $service_count[0]['total'];
    if (isset($multipleWhere) && !empty($multipleWhere)) {
        $builder->orLike($multipleWhere);
    }
    if (isset($where) && !empty($where)) {
        $builder->where($where);
    }
    if ($reorder == 'yes' && !empty($order_id)) {
        $builder = $db->table('order_services os');
        $service_record = $builder
            ->select('os.id as cart_id,os.service_id,os.quantity as qty,s.image as service_image,s.*,s.title as service_name,p.username as partner_name,pd.visiting_charges as visiting_charges,cat.name as category_name')
            ->join('services s', 'os.service_id=s.id', 'left')
            ->join('orders o', 'o.id=os.order_id', 'left')
            ->join('users p', 'p.id=s.user_id', 'left')
            ->join('categories cat', 'cat.id=s.category_id', 'left')
            ->join('partner_details pd', 'pd.partner_id=s.user_id', 'left')
            ->where('os.order_id', $order_id)
            ->where('o.user_id', $user_id)->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
    } else {
        $service_record = $builder
            ->select('c.id as cart_id,c.service_id,c.qty,c.is_saved_for_later,s.image as service_image,s.*,s.title as service_name,p.username as partner_name,pd.visiting_charges as visiting_charges,cat.name as category_name')
            ->join('services s', 'c.service_id=s.id', 'left')
            ->join('users p', 'p.id=s.user_id', 'left')
            ->join('categories cat', 'cat.id=s.category_id', 'left')
            ->join('partner_details pd', 'pd.partner_id=s.user_id', 'left')
            ->where('c.user_id', $user_id)->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
    }
    $bulkData = $rows = $tempRow = array();
    $bulkData['total'] = $total;
    $tax = get_settings('system_tax_settings', true)['tax'];
    foreach ($service_record as $row) {
        if ($from_app) {
            if ($disk == "local_server") {
                if (check_exists(base_url('/public/uploads/services/' . $row['service_image']))) {
                    $images = base_url($row['image']);
                } else {
                    $images = 'nothing found';
                }
            } else if ($disk == "aws_s3") {
                $images = fetch_cloud_front_url('services', $row['service_image']);
            } else {
                $images = "";
            }
        } else {
            if ($disk == "local_server") {
                if (check_exists(base_url('/public/uploads/services/' . $row['service_image']))) {
                    $image_url = base_url('/public/uploads/services/' . $row['service_image']);
                } else {
                    $image_url = 'nothing found';
                }
            } else if ($disk == "aws_s3") {
                $image_url = fetch_cloud_front_url('services', $row['service_image']);
            } else {
                $image_url = "";
            }
            $images = '<a  href="' . $image_url . '" data-lightbox="image-1"><img height="80px" class="rounded-circle" src="' . $image_url . '" alt="image of the services multiple will be here"></a>';
        }
        $status = ($row['status'] == 1) ? 'Enable' : 'Disable';
        $site_allowed = ($row['on_site_allowed'] == 1) ? 'Allowed' : 'Not Allowed';
        $pay_later = ($row['is_pay_later_allowed'] == 1) ? 'Allowed' : 'Not Allowed';
        $rating = $row['rating'] . "/5";
        $tempRow['id'] = $row['cart_id'];
        $tempRow['order_id'] = $order_id ?? "";
        $tempRow['service_id'] = $row['service_id'];
        $tempRow['is_saved_for_later'] = isset($row['is_saved_for_later']) ? $row['is_saved_for_later'] : "";
        $tempRow['qty'] = isset($row['qty']) ? $row['qty'] : 0;
        $tempRow['visiting_charges'] = $row['visiting_charges'];
        $tempRow['price'] = $row['price'];
        $tempRow['discounted_price'] = $row['discounted_price'];
        $taxPercentageData = fetch_details('taxes', ['id' => $row['tax_id']], ['percentage']);
        if (!empty($taxPercentageData)) {
            $taxPercentage = $taxPercentageData[0]['percentage'];
        } else {
            $taxPercentage = 0;
        }
        $tempRow['servic_details']['id'] = $row['id'];
        $tempRow['servic_details']['partner_id'] = $row['user_id'];
        $tempRow['servic_details']['category_id'] = $row['category_id'];
        $tempRow['servic_details']['category_name'] = $row['category_name'];

        // Get translated category data
        $categoryFallbackData = ['name' => $row['category_name'] ?? ''];
        $translatedCategoryData = get_translated_category_data_for_api($row['category_id'], $categoryFallbackData);

        $tempRow['servic_details']['partner_name'] = $row['partner_name'];
        $tempRow['servic_details']['translated_partner_name'] = get_translated_partner_field($row['user_id'], 'username', $row['partner_name']);
        $tempRow['servic_details']['tax_type'] = $row['tax_type'];
        $tempRow['servic_details']['tax_id'] = $row['tax_id'];
        $tempRow['servic_details']['current_tax_percentage'] = $taxPercentage;
        $tempRow['servic_details']['tax'] = $row['tax'];
        // Get service details for translation fallback
        $serviceFallbackData = [
            'title' => $row['title'] ?? '',
            'description' => $row['description'] ?? '',
            'long_description' => $row['long_description'] ?? '',
            'tags' => $row['tags'] ?? '',
            'faqs' => $row['faqs'] ?? ''
        ];

        // Get translated data for this service
        $translatedServiceData = get_translated_service_data_for_api($row['id'], $serviceFallbackData);

        $tempRow['servic_details']['title'] = $row['title'];
        $tempRow['servic_details']['slug'] = $row['slug'];
        $tempRow['servic_details']['description'] = $row['description'];
        $tempRow['servic_details']['tags'] = $row['tags'];
        $tempRow['servic_details']['image_of_the_service'] = $images;

        // Add translated fields
        $tempRow['servic_details']['translated_title'] = $translatedServiceData['translated_title'] ?? $row['title'];
        $tempRow['servic_details']['translated_description'] = $translatedServiceData['translated_description'] ?? $row['description'];
        $tempRow['servic_details']['translated_long_description'] = $translatedServiceData['translated_long_description'] ?? ($row['long_description'] ?? '');
        $tempRow['servic_details']['translated_tags'] = $translatedServiceData['translated_tags'] ?? $row['tags'];
        $tempRow['servic_details']['translated_faqs'] = $translatedServiceData['translated_faqs'] ?? ($row['faqs'] ?? '');

        // print_r($translatedServiceData['translated_faqs']);
        // die;

        if (isset($translatedServiceData['translated_faqs']) && is_array($translatedServiceData['translated_faqs'])) {
            $normalizedFaqs = [];

            foreach ($translatedServiceData['translated_faqs'] as $faq) {
                // Skip any invalid junk
                if (!is_array($faq) || empty($faq)) {
                    continue;
                }

                // Case 1: New format (associative with 'question' and 'answer' keys)
                if (isset($faq['question']) && isset($faq['answer'])) {
                    $question = trim($faq['question']);
                    $answer   = trim($faq['answer']);
                }

                // Case 2: Old format (numeric array, usually [0] => question, [1] => answer)
                elseif (isset($faq[0]) && isset($faq[1])) {
                    $question = trim($faq[0]);
                    $answer   = trim($faq[1]);
                }

                // Case 3: Mismatched or malformed data — skip it
                else {
                    continue;
                }

                // Double-check that both have content
                if ($question !== '' && $answer !== '') {
                    $normalizedFaqs[] = [
                        'question' => $question,
                        'answer' => $answer,
                    ];
                }
            }

            $tempRow['servic_details']['translated_faqs'] = $normalizedFaqs;
        }

        // Add translated category fields
        $tempRow['servic_details']['translated_category_name'] = $translatedCategoryData['translated_name'] ?? $row['category_name'];
        $tempRow['servic_details']['price'] = $row['price'];
        $tempRow['servic_details']['discounted_price'] = $row['discounted_price'];
        $tempRow['servic_details']['number_of_members_required'] = $row['number_of_members_required'];
        $tempRow['servic_details']['duration'] = $row['duration'];
        $tempRow['servic_details']['tags'] = json_decode((string) $row['tags'], true);
        $tempRow['servic_details']['rating'] = $rating;
        $tempRow['servic_details']['number_of_ratings'] = $row['number_of_ratings'];
        $tempRow['servic_details']['on_site_allowed'] = $site_allowed;
        $tempRow['servic_details']['max_quantity_allowed'] = $row['max_quantity_allowed'];
        $tempRow['servic_details']['is_pay_later_allowed'] = $pay_later;
        $tempRow['servic_details']['status'] = $status;
        $tempRow['servic_details']['created_at'] = $row['created_at'];
        if ($row['discounted_price'] == "0") {
            if ($row['tax_type'] == "excluded") {
                $tempRow['servic_details']['price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price'] + ($row['price'] * ($taxPercentage) / 100)), 2)));
                $tempRow['tax_value'] = number_format((intval(($row['price'] * ($taxPercentage) / 100))), 2);
                $tempRow['servic_details']['original_price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price'] + ($row['price'] * ($taxPercentage) / 100)), 2)));
            } else {
                $tempRow['servic_details']['price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price']), 2)));
                $tempRow['tax_value'] = "";
                $tempRow['servic_details']['original_price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price']), 2)));
            }
        } else {
            if ($row['tax_type'] == "excluded") {
                $tempRow['servic_details']['price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['discounted_price'] + ($row['discounted_price'] * ($taxPercentage) / 100)), 2)));
                $tempRow['tax_value'] = number_format((intval(($row['discounted_price'] * ($taxPercentage) / 100))), 2);
                $tempRow['servic_details']['original_price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price'] + ($row['price'] * ($taxPercentage) / 100)), 2)));
            } else {
                $tempRow['servic_details']['price_with_tax'] = $row['discounted_price'];
                $tempRow['tax_value'] = "";
                $tempRow['servic_details']['original_price_with_tax'] = strval(str_replace(',', '', number_format(strval($row['price']), 2)));
            }
        }
        $rows[] = $tempRow;
    }
    $db->close();
    if ($from_app) {
        $db      = \Config\Database::connect();
        $cart_builder = $db->table('cart');
        foreach ($service_record as $key => $s) {
            $detail = fetch_details('services', ['id' => $s['service_id']], ['id', 'user_id', 'approved_by_admin', 'at_store', 'at_doorstep'])[0];
            $p_detail = fetch_details('partner_details', ['partner_id' => $s['user_id']], ['id', 'at_store', 'at_doorstep', 'need_approval_for_the_service'])[0];
            if (($detail['at_store'] !=  $p_detail['at_store']) && ($detail['at_doorstep'] || $detail['at_doorstep'])) {
                unset($service_record[$key]);
                $cart_builder->delete(['service_id' => $detail['id']]);
            }
            $is_already_subscribe = fetch_details('partner_subscriptions', ['partner_id' => $detail['user_id'], 'status' => 'active']);
            if ($p_detail['need_approval_for_the_service'] == 1) {
                if ($detail['approved_by_admin'] != 1  || empty($is_already_subscribe)) {
                    unset($service_record[$key]);
                    $cart_builder->delete(['service_id' => $detail['id']]);
                }
            }
        }
        if (!empty($service_record)) {
            if (($reorder) == 'yes' && !empty($order_id)) {
                $builder = $db->table('order_services os');
                $order_record = $builder
                    ->select('os.id, os.service_id, os.quantity as qty')
                    ->join('orders o', 'o.id=os.order_id', 'left')
                    ->where('o.user_id', $user_id)
                    ->where('os.order_id', $order_id)
                    ->orderBy($sort, $order)
                    ->limit($limit, $offset)
                    ->get()
                    ->getResultArray();
                foreach ($order_record as $row) {
                    $array_ids[] = [
                        'service_id' => $row['service_id'],
                        'qty' => $row['qty'],
                    ];
                }
            } else {
                $array_ids = fetch_details('cart c', ['user_id' => $user_id], 'service_id,qty');
            }
            $s = [];
            $q = [];
            foreach ($array_ids as $ids) {
                array_push($s, $ids['service_id']);
                array_push($q, $ids['qty']);
            }
            $id = implode(',', $s);
            $qty = implode(',', $q);
            $builder = $db->table('services s');
            if (($reorder) == 'yes' && !empty($order_id)) {
                $builder = $db->table('order_services os');
                $extra_data = $builder
                    ->select('SUM(IF(s.discounted_price  > 0 , (s.discounted_price * os.quantity) , (s.price * os.quantity))) as subtotal,
                SUM(os.quantity) as total_quantity,pd.visiting_charges as visiting_charges,SUM(s.duration * os.quantity) as total_duration,pd.at_store,pd.at_doorstep,pd.advance_booking_days as advance_booking_days,pd.company_name as company_name')
                    ->join('services s', 'os.service_id=s.id', 'left')
                    ->join('partner_details pd', 'pd.partner_id=s.user_id')
                    ->where('os.order_id', $order_id)
                    ->whereIn('s.id', $s)->get()->getResultArray();
            } else {
                $builder = $db->table('services s');
                $extra_data = $builder
                    ->select('SUM(IF(s.discounted_price  > 0 , (s.discounted_price * c.qty) , (s.price * c.qty))) as subtotal,
               SUM(c.qty) as total_quantity,pd.visiting_charges as visiting_charges,SUM(s.duration * c.qty) as total_duration,pd.at_store,pd.at_doorstep,pd.advance_booking_days as advance_booking_days,pd.company_name as company_name')
                    ->join('cart c', 'c.service_id = s.id')
                    ->join('partner_details pd', 'pd.partner_id=s.user_id')
                    ->where('c.user_id', $user_id)
                    ->whereIn('s.id', $s)->get()->getResultArray();
            }
            $tax_value = 0;
            $sub_total = 0;
            foreach ($service_record as $s1) {
                $taxPercentageData = fetch_details('taxes', ['id' => $s1['tax_id']], ['percentage']);
                if (!empty($taxPercentageData)) {
                    $taxPercentage = $taxPercentageData[0]['percentage'];
                } else {
                    $taxPercentage = 0;
                }
                if ($s1['discounted_price'] == "0") {
                    $tax_value = ($s1['tax_type'] == "excluded") ? number_format(((($s1['price'] * ($taxPercentage) / 100))), 2) : 0;
                    $price = number_format($s1['price'], 2);
                } else {
                    $tax_value = ($s1['tax_type'] == "excluded") ? number_format(((($s1['discounted_price'] * ($taxPercentage) / 100))), 2) : 0;
                    $price = number_format($s1['discounted_price'], 2);
                }
                $sub_total = $sub_total + (floatval(str_replace(",", "", $price)) + floatval(str_replace(",", "", $tax_value))) * $s1['qty'];
            }
            $data['total'] = (empty($total)) ? (string) count($rows) : $total;
            $data['advance_booking_days'] = isset($extra_data[0]['advance_booking_days']) ? $extra_data[0]['advance_booking_days'] : "";
            $data['visiting_charges'] = $extra_data[0]['visiting_charges'];
            $data['company_name'] = isset($extra_data[0]['company_name']) ? $extra_data[0]['company_name'] : "";
            $data['at_store'] = isset($extra_data[0]['at_store']) ? $extra_data[0]['at_store'] : "0";
            $data['at_doorstep'] = isset($extra_data[0]['at_doorstep']) ? $extra_data[0]['at_doorstep'] : "0";
            $data['service_ids'] = $id;
            $data['qtys'] = isset($qty) ? $qty : 0;
            $data['total_quantity'] = $extra_data[0]['total_quantity'];
            $data['total_duration'] = $extra_data[0]['total_duration'];
            $data['sub_total'] = strval(str_replace(',', '', number_format(strval($sub_total), 2)));
            $data['overall_amount'] = strval(str_replace(',', '', number_format(strval($sub_total + $data['visiting_charges']), 2)));
            $data['data'] = $rows;
            $provider_data = $db->table('services s');
            $providers = $provider_data
                ->select('u.username as provider_names, u.id as provider_id')
                ->join('users u', 'u.id = s.user_id')
                ->whereIn('s.id', $s)->get()->getResultArray();
            $pds = [];
            $pid = [];
            foreach ($providers as $provider) {
                array_push($pds, $provider['provider_names']);
                array_push($pid, $provider['provider_id']);
            }
            $unique_name = array_unique($pds);
            $unique_id = array_unique($pid);
            $names = implode(',', $unique_name);
            $ids = implode(',', $unique_id);
            $data['provider_names'] = $names;
            $data['provider_id'] = $ids;
            $pay_later_array = [];
            foreach ($service_record as $service_row) {
                array_push($pay_later_array, $service_row['is_pay_later_allowed']);
            }
            $active_partner_subscription = fetch_details('partner_subscriptions', ['partner_id' => $providers[0]['provider_id'], 'status' => 'active']);
            $provider_details = fetch_details('users', ['id' => $providers[0]['provider_id']]);
            if (!empty($active_partner_subscription)) {
                if ($active_partner_subscription[0]['is_commision'] == "yes") {
                    $commission_threshold = $active_partner_subscription[0]['commission_threshold'];
                } else {
                    $commission_threshold = 0;
                }
            } else {
                $commission_threshold = 0;
            }
            $check_payment_gateway = get_settings('payment_gateways_settings', true);
            $data['is_online_payment_allowed'] =  $check_payment_gateway['payment_gateway_setting'];
            if ($check_payment_gateway['cod_setting'] == 1 && $check_payment_gateway['payment_gateway_setting'] == 0) {
                $data['is_pay_later_allowed'] = 1;
            } else if ($check_payment_gateway['cod_setting'] == 0) {
                $data['is_pay_later_allowed'] = 0;
            } else {
                $payable_commission_of_provider = $provider_details[0]['payable_commision'];
                if (($payable_commission_of_provider >= $commission_threshold) && $commission_threshold != 0) {
                    $data['is_pay_later_allowed'] = 0;
                } else {
                    if (in_array(0, $pay_later_array)) {
                        $data['is_pay_later_allowed'] = 0;
                    } else {
                        $data['is_pay_later_allowed'] = 1;
                    }
                }
            }
            $db->close();
            return $data;
        } else {
            $data = [];
            $db->close();
            return $data;
        }
    } else {
        $bulkData['rows'] = $rows;
        $db->close();
        return json_encode($bulkData);
    }
}
function get_taxable_amount($service_id)
{
    $service_details = fetch_details('services', ['id' => $service_id])[0];
    if ($service_details['tax_id'] != 0) {
        $tax_details = fetch_details('taxes', ['id' => $service_details['tax_id']])[0];
        $tax_percentage = strval(str_replace(',', '', number_format(strval($tax_details['percentage']), 2)));
    } else {
        $tax_percentage = 0;
    }
    $taxable_amount = 0;
    if ($service_details['tax_type'] == "excluded") {
        if ($service_details['discounted_price'] == 0) {
            $tax_amount = (!empty($tax_percentage)) ? ($service_details['price'] * $tax_percentage) / 100 : 0;
            $taxable_amount = strval(str_replace(',', '', number_format(strval($service_details['price'] + ($tax_amount)), 2)));
        } else {
            $tax_amount = (!empty($tax_percentage)) ? ($service_details['discounted_price'] * $tax_percentage) / 100 : 0;
            $taxable_amount = strval(str_replace(',', '', number_format(strval($service_details['discounted_price'] + ($tax_amount)), 2)));
        }
    } else {
        if ($service_details['discounted_price'] == 0) {
            $tax_amount = (!empty($tax_percentage)) ? ($service_details['price'] * $tax_percentage) / 100 : 0;
            $taxable_amount = strval(str_replace(',', '', number_format(strval($service_details['price']), 2)));
        } else {
            $tax_amount = (!empty($tax_percentage)) ? ($service_details['discounted_price'] * $tax_percentage) / 100 : 0;
            $taxable_amount = strval(str_replace(',', '', number_format(strval($service_details['discounted_price']), 2)));
        }
    }
    $result = [
        'title' => $service_details['title'],
        'tax_percentage' => $tax_percentage,
        'tax_amount' => $tax_amount,
        'price' => $service_details['price'],
        'discounted_price' => $service_details['discounted_price'],
        'taxable_amount' => $taxable_amount ?? 0,
    ];
    return $result;
}
function get_partner_ids(string $type = '', string $column_name = 'id', array $ids = [], $is_array = false, array $fields_name = ['*'])
{
    $db = \Config\Database::connect();
    if ($type == 'service') {
        $builder = $db->table('services s');
        $partners = $builder->select('s.user_id as id')
            ->whereIn('s.' . $column_name, $ids)
            ->get()->getResultArray();
    } else if ($type == 'category') {
        $builder = $db->table('services s');
        $partners = $builder->select('s.user_id as id')
            ->whereIN('s.' . $column_name, $ids)
            ->get()->getResultArray();
    } else {
        $builder = $db->table('users u');
        $partners = $builder->select($fields_name)
            ->join('users_groups ug', 'ug.user_id=u.id')
            ->where('ug.group_id', '3')
            ->whereIn($column_name, $ids)
            ->get()->getResultArray();
    }
    $ids = [];
    foreach ($partners as $key => $parnter) {
        $ids[] = $parnter['id'];
    }
    $ids = array_unique($ids);
    if ($is_array == false) {
        $ids = implode(',', $ids);
    }
    $db->close();
    return $ids;
}
function check_partner_availibility(int $partner_id)
{
    $days = [
        'Mon' => 'monday',
        'Tue' => 'tuesday',
        'Wed' => 'wednsday',
        'Thu' => 'thursday',
        'Fri' => 'friday',
        'Sat' => 'staturday',
        'Sun' => 'sunday',
    ];
    $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $days[date('D')]]);
    if (empty($partner_timing)) {
        return false;
    }
    $partner_timing = $partner_timing[0];
    $time = new DateTime($partner_timing['opening_time']);
    $opening_time = $time->format('H:i');
    $time = new DateTime($partner_timing['closing_time']);
    $closing_time = $time->format('H:i');
    $current_time = date('H:i');
    if (($opening_time <= $current_time) or ($current_time >= $closing_time)) {
        return $partner_timing;
    } else {
        return false;
    }
}
function get_time_slot()
{
    $days = [
        'Mon' => 'monday',
        'Tue' => 'tuesday',
        'Wed' => 'wednsday',
        'Thu' => 'thursday',
        'Fri' => 'friday',
        'Sat' => 'staturday',
        'Sun' => 'sunday',
    ];
    $service_id = 16;
    $partner_id = 50;
    $start_times = "5:00";
    $end_time = "6:00";
    $qty = 2;
    $date = date('Y-m-d');
    $day = $days[date('D', strtotime($date))];
    $partner_timing = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $day]);
    $service_details = fetch_details('services', ['id' => $service_id]);
    $service_duration = $service_details[0]['duration'];
    $parnter_opening_time = $partner_timing[0]['opening_time'];
    $parnter_closing_time = $partner_timing[0]['closing_time'];
    $time1 = strtotime($parnter_opening_time);
    $time2 = strtotime($parnter_closing_time);
    $total_hours = round(abs($time2 - $time1) / 3600, 2);
    $time_slotes = [];
    $increament_time = $service_duration;
    $slote_start_time = $parnter_opening_time;
    $i = 0;
    do {
        $slot_name = "time_slot_" . $i;
        $slote_end_time = date('H:i:s', strtotime('+' . $increament_time . ' minutes', strtotime($parnter_opening_time)));
        $time_slotes[$slot_name] = [
            'start_time' => date('H:i:s', strtotime($slote_start_time)),
            'end_time' => $slote_end_time,
        ];
        $increament_time += $service_duration;
        $slote_start_time = $slote_end_time;
        $i++;
    } while ($slote_end_time != $parnter_closing_time);
    return $time_slotes;
}
function check_partner_type($partner_id)
{
    $data = fetch_details('partner_details', ['partner_id' => $partner_id]);
    if (isset($data[0]['type']) && $data[0]['type'] == '1') {
        return 'organization';
    } else {
        return 'single';
    }
}
function check_available_employee($partner_id)
{
    $db = \Config\Database::connect();
    $data = $db->table('orders o')
        ->select('COUNT(o.id) AS order_count,
                    SUM(os.quantity) AS quantity,
                    (COUNT(o.id) * SUM(os.quantity)) AS order_members,
                    pd.number_of_members,
                    (pd.number_of_members -(COUNT(o.id) * SUM(os.quantity))) AS available_members')
        ->join('partner_details pd', 'pd.partner_id = o.partner_id', 'left')
        ->join('order_services os', 'o.id = os.order_id', 'left')
        ->where("o.partner_id = $partner_id AND o.status IN('confirmed', 'rescheduled')")
        ->get()->getResultArray();
    $type = check_partner_type($partner_id);
    if (!empty($type) && $type == 'organization' && !empty($data[0]['order_count']) && $data[0]['available_members'] != 0) {
        $response['error'] = false;
        $response['message'] = "Partner is available";
        $response['data'] = $data;
    } else {
        $response['error'] = true;
        $response['message'] = "Partner is not available";
        $response['data'] = $data;
    }
    $db->close();
    return $response;
}
function is_bookmarked($user_id, $partner_id)
{
    $db = \Config\Database::connect();
    $builder = $db->table('bookmarks');
    $data = $builder
        ->select('COUNT(id) as total')
        ->where('user_id', $user_id)
        ->where('partner_id', $partner_id)->get()->getResultArray();
    $db->close();
    return $data;
}
function delete_bookmark($user_id, $partner_id)
{
    $db = \Config\Database::connect();
    $builder = $db->table('bookmarks');
    $data = $builder->where(['user_id' => $user_id, 'partner_id' => $partner_id])
        ->delete();
    $db->close();
    if ($data) {
        return true;
    } else {
        return false;
    }
}
function send_customer_web_notification($fcmMsg, $registrationIDs_chunks)
{
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = $settings['value'];
    $settings = json_decode($settings, true);
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';
    foreach ($registrationIDs_chunks as $registrationIDs) {
        $message1 = [
            "message" => [
                "token" => $registrationIDs['web_fcm_id'],
                "data" => $fcmMsg
            ]
        ];
        $data1 = json_encode($message1);
        sendNotificationToFCM($url, $access_token, $data1);
    }
}
function send_notification($fcmMsg, $registrationIDs_chunks)
{
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = $settings['value'];
    $settings = json_decode($settings, true);
    $message1 = [];
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';
    foreach ($registrationIDs_chunks[0] as $registrationIDs) {
        $message1 = [
            "message" => [
                "token" => $registrationIDs['fcm_id'],
                "data" => $fcmMsg,
                // Android notification
                "android" => [
                    "notification" => [
                        "title" => $fcmMsg["title"],
                        "body" => $fcmMsg["body"],
                        "sound" => $fcmMsg["type"] == "order" || $fcmMsg["type"] == "new_order" ? "order_sound" : "default",
                        "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                    ]
                ],
                // iOS notification
                "apns" => [
                    "payload" => [
                        "aps" => [
                            "alert" => [
                                "title" => $fcmMsg["title"],
                                "body" => $fcmMsg["body"]
                            ],
                            "sound" => $fcmMsg["type"] == "order" || $fcmMsg["type"] == "new_order" ? "order_sound.aiff" : "default",
                            "mutable-content" => 1
                        ]
                    ],
                    "fcm_options" => [
                        "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                    ]
                ],
                "notification" => [
                    "title" => $fcmMsg["title"],
                    "body" => $fcmMsg["body"],
                    "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                ]
            ]
        ];
        $data1 = json_encode($message1);
        sendNotificationToFCM($url, $access_token, $data1);
    }
}

/**
 * Queue notification for background processing
 * 
 * This function replaces direct send_notification() calls by queuing
 * the notification for background processing. This improves performance
 * and prevents blocking the main request thread.
 * 
 * @param array $fcmMsg The FCM message data
 * @param array $registrationIDs_chunks Array of registration ID chunks
 * @param array $web_registrationIDs Array of web registration IDs (optional)
 * @param string $priority Queue priority ('high', 'default', 'low')
 * @return bool True if queued successfully, false otherwise
 */
function queue_notification($fcmMsg, $registrationIDs_chunks, $web_registrationIDs = [], $priority = 'default')
{
    try {
        // Prepare job data for general notification
        $notificationData = [
            'notification_type' => 'general_notification',
            'fcmMsg' => $fcmMsg,
            'registrationIDs_chunks' => $registrationIDs_chunks
        ];

        // Get queue service and dispatch the job
        $queue = service('queue');
        $jobId = $queue->push('notifications', 'notification', $notificationData, $priority);

        log_message('info', 'General notification queued successfully with job ID: ' . $jobId);

        // Queue web notification if web registration IDs are provided
        if (!empty($web_registrationIDs)) {
            $webNotificationData = [
                'notification_type' => 'web_notification',
                'fcmMsg' => $fcmMsg,
                'web_registrationIDs' => $web_registrationIDs
            ];

            $webJobId = $queue->push('notifications', 'notification', $webNotificationData, $priority);
            log_message('info', 'Web notification queued successfully with job ID: ' . $webJobId);
        }

        return true; // Return true to indicate the notification was queued successfully
    } catch (\Exception $e) {
        log_message('error', 'Failed to queue notification: ' . $e->getMessage());

        // Fallback: send notification directly if queue fails
        log_message('warning', 'Falling back to direct notification sending');

        try {
            // Send notification directly as fallback
            send_notification($fcmMsg, $registrationIDs_chunks);

            // Send web notification if provided
            if (!empty($web_registrationIDs)) {
                send_customer_web_notification($fcmMsg, $web_registrationIDs);
            }

            return true;
        } catch (\Exception $fallbackException) {
            log_message('error', 'Fallback notification sending also failed: ' . $fallbackException->getMessage());
            return false;
        }
    }
}

function get_permission($user_id)
{
    $db = \Config\Database::connect();
    $builder = $db->table('user_permissions');
    $builder->select('role,permissions');
    $builder->where('user_id', $user_id);
    $permissions = $builder->get()->getResultArray();
    $db->close();
    if (!empty($permissions[0]['permissions'])) {
        $permissions = json_decode($permissions[0]['permissions'], true);
    } else {
        $permissions = [
            'create' => [
                'order' => 0,
                'subscription' => 1,
                'categories' => 1,
                'sliders' => 1,
                'tax' => 1,
                'services' => 1,
                'promo_code' => 1,
                'featured_section' => 1,
                'partner' => 1,
                'customers' => 0,
                'send_notification' => 1,
                'faq' => 1,
                'settings' => 1,
                'system_user' => 1,
                'seo_settings' => 1,
                'blog' => 1,
            ],
            'read' => [
                'orders' => 1,
                'subscription' => 1,
                'categories' => 1,
                'sliders' => 1,
                'tax' => 1,
                'services' => 1,
                'promo_code' => 1,
                'featured_section' => 1,
                'partner' => 1,
                'customers' => 1,
                'send_notification' => 1,
                'faq' => 1,
                'settings' => 1,
                'system_user' => 1,
                'seo_settings' => 1,
                'blog' => 1,
            ],
            'update' => [
                'orders' => 1,
                'subscription' => 1,
                'categories' => 1,
                'sliders' => 1,
                'tax' => 1,
                'services' => 1,
                'promo_code' => 1,
                'featured_section' => 1,
                'partner' => 1,
                'customers' => 1,
                'city' => 1,
                'system_update' => 1,
                'settings' => 1,
                'system_user' => 1,
                'seo_settings' => 1,
                'blog' => 1,
            ],
            'delete' => [
                'orders' => 1,
                'subscription' => 1,
                'categories' => 1,
                'offers' => 1,
                'sliders' => 1,
                'tax' => 1,
                'services' => 1,
                'promo_code' => 1,
                'featured_section' => 1,
                'partner' => 1,
                'customers' => 0, // Note: I added a default value here, adjust as needed
                'city' => 1,
                'faq' => 1,
                'send_notification' => 1,
                'support_tickets' => 1,
                'system_user' => 1,
                'seo_settings' => 1,
                'blog' => 1,
            ],
        ];
    }
    return $permissions;
}
function is_permitted($user_id, $type_of_permission, $permit)
{
    $db = \Config\Database::connect();
    $builder = $db->table('user_permissions');
    $builder->select('role,permissions');
    $builder->where('user_id', $user_id);
    $permissions = $builder->get()->getResultArray();
    $db->close();
    if ($permissions[0]['role'] == "1") {
        return true;
    } else {
        $permissions = json_decode($permissions[0]['permissions'], true);
        foreach ($permissions as $key => $val) {
            if ($key == $type_of_permission) {
                if ($val[$permit] == "yes" || $val[$permit] == "1" || $val[$permit] == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
}
function booked_timings($partner_id, $date_of_service)
{
    $db = \config\Database::connect();
    $table = $db->table('orders o');
    $day = date('l', strtotime($date_of_service));
    $response = $table->select('o.starting_time,o.ending_time')
        ->join('order_services os', 'o.id = os.order_id', 'left')
        ->join('services s', 'os.service_id = s.id', 'left')
        ->join('partner_timings pt', 'pt.partner_id = o.partner_id')
        ->where(['o.partner_id' => $partner_id, 'o.date_of_service' => $date_of_service, 'pt.day' => $day, 'pt.is_open' => '1'])
        ->whereIn('o.status', ['confirmed', 'rescheduled', 'awaiting'])
        ->groupBy('o.id')
        ->orderBy('o.starting_time')
        ->get()->getResultArray();
    $db->close();
    return $response;
}
function check_availability($partner_id, $booking_date, $time)
{
    $today = date('Y-m-d');
    if ($booking_date < $today) {
        $response['error'] = true;
        $response['message'] = "please select upcoming date!";
        return $response;
    }
    $db = \config\Database::connect();
    $table = $db->table('orders a');
    $day = date('l', strtotime($booking_date));
    $timings = getTimingOfDay($partner_id, $day);
    if (isset($timings) && !empty($timings)) {
        $opening_time = $timings['opening_time'];
        $closing_time = $timings['closing_time'];
        $booked_slots = $table->select('a.starting_time AS free_before, (a.starting_time + INTERVAL a.duration HOUR_MINUTE) AS free_after')
            ->where("NOT EXISTS (
            SELECT 1
            FROM orders b
            WHERE b.starting_time BETWEEN (a.starting_time + INTERVAL a.duration HOUR_MINUTE)
                AND (a.starting_time + INTERVAL a.duration HOUR_MINUTE) + INTERVAL 15 SECOND - INTERVAL 1 MICROSECOND
        )")
            ->where("(a.starting_time + INTERVAL a.duration HOUR_MINUTE) BETWEEN '$booking_date $opening_time' AND '$booking_date $closing_time'")
            ->where('date_of_service', $booking_date)
            ->whereIn('status', ['awaiting', 'pending', 'confirmed', 'rescheduled'])
            ->where('partner_id', '50')
            ->groupBy('id')
            ->orderBy('starting_time', 'ASC')
            ->get()
            ->getResultArray();
        $db->close();
        if (isset($booked_slots) && !empty($booked_slots)) {
            if ($time >= $opening_time && $time < $closing_time) {
                foreach ($booked_slots as $key => $val) {
                    $from = strtotime($val['free_before']);
                    $till = strtotime($val['free_after']);
                    $t = isBetween($from, $till, strtotime($time));
                    if (isset($t) && $t == true) {
                        $response['error'] = true;
                        $response['message'] = "provider is busy at this time select another slot";
                    } else {
                        if ($time >= $closing_time) {
                            $response['error'] = true;
                            $response['message'] = "Provider is closed at this time";
                        } else {
                            $response['error'] = false;
                            $response['message'] = "slot is available at this time";
                        }
                    }
                }
                return $response;
            } else {
                $response['error'] = true;
                $response['message'] = "Provider is closed at this time";
                return $response;
            }
        } else {
            $response['error'] = true;
            $response['message'] = "Provider is closed at this time";
            return $response;
        }
    } else {
        $response['error'] = true;
        $response['message'] = "provider is closed on this day";
        return $response;
    }
}
function isBetween($from, $till, $input)
{
    if ($input >= $from && $input <= $till) {
        return true;
    } else {
        return false;
    }
}
function getTimingOfDay($partner_id, $day)
{
    $timings = fetch_details('partner_timings', ['partner_id' => $partner_id, 'day' => $day], ['opening_time', 'closing_time', 'is_open']);
    if (!empty($timings) && isset($timings[0]) && $timings[0]['is_open'] == '1') {
        return $timings[0];
    } else {
        return false;
    }
}
function get_available_slots($partner_id, $booking_date, $required_duration = null, $next_day_order = null)
{
    $timezone = get_settings('general_settings', true);
    date_default_timezone_set($timezone['system_timezone']); // Added user timezone

    if (!empty($next_day_order)) {
        $today = date('Y-m-d');
        if ($booking_date < $today) {
            $response['error'] = true;
            $response['message'] = "please select upcoming date!";
            return $response;
        }
        $db = \config\Database::connect();
        $day = date('l', strtotime($booking_date));
        $timings = getTimingOfDay($partner_id, $day);
        if (isset($timings) && !empty($timings)) {
            $opening_time = $timings['opening_time'];
            $closing_time = $timings['closing_time'];
            $booked_slots = booked_timings($partner_id, $booking_date);
            $interval = 30 * 60;
            $start_time = strtotime($next_day_order);
            $current_time = time();
            $end_time = strtotime($closing_time);
            $count = count($booked_slots);
            $current_date = date('Y-m-d');
            $available_slots = [];
            $busy_slots = [];
            //if booked slot is not empty means that day no odrer no found
            while ($start_time < $end_time) {
                $array_of_time[] = date("H:i:s", $start_time);
                $start_time += $interval;
            }
            if (isset($booked_slots) && !empty($booked_slots)) {
                //here suggested time is created in gap of 30 minutes
                $count_suggestion_slots = count($array_of_time);
                //loop on total booked slots
                for ($i = 0; $i < $count; $i++) {
                    //loop on suggested time slots
                    for ($j = 0; $j < $count_suggestion_slots; $j++) {
                        //if suggested time slot is less than booked slot starting time or suggested time slot is greater than booked time slot starting time
                        if (strtotime($array_of_time[$j]) < strtotime($booked_slots[$i]['starting_time']) || strtotime($array_of_time[$j]) >= strtotime($booked_slots[$i]['ending_time'])) {
                            //check if suggested time slot is not  in array of avaialble slot
                            if (!in_array($array_of_time[$j], $available_slots)) {
                                //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                                if (strtotime($array_of_time[$j]) > $current_time || strtotime($booking_date) != strtotime($current_date)) {
                                    // echo $array_of_time[$j]." added to available time slot <br/>";
                                    $available_slots[] = $array_of_time[$j];
                                } else {
                                    // echo $array_of_time[$j]." added to busy time slot11<br/>";
                                    if (!in_array($array_of_time[$j], $busy_slots)) {
                                        $busy_slots[] = $array_of_time[$j];
                                    }
                                }
                                // die;
                            } else {
                            }
                        } else {
                            //  echo $array_of_time[$j]." added to busy time slot22<br/>";
                            if (!in_array($array_of_time[$j], $busy_slots)) {
                                $busy_slots[] = $array_of_time[$j];
                            }
                        }
                    }
                    $count_busy_slots = count($busy_slots);
                    for ($k = 0; $k < $count_busy_slots; $k++) {
                        if (($key = array_search($busy_slots[$k], $available_slots)) !== false) {
                            unset($available_slots[$key]);
                        }
                    }
                }
                $available_slots = array_values($available_slots);
                $ignore_last_slot = false;
                $all_continous_slot = calculate_continuous_slots($available_slots);
                $next_day_slots = get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date);
                // if(!empty($next_day_available_slots)){
                $next_day_available_slots = $next_day_slots['continous_available_slots'];
                $required_slots = ceil($required_duration / 30);
                if (isset($next_day_available_slots[0][0]) && $next_day_available_slots[0][0] === $opening_time) {
                    // echo "if1";
                    $next_day_fullfilled_slots = count($next_day_available_slots[0]);
                    if ($next_day_fullfilled_slots >= $required_slots) {
                        // echo "if2";
                        $ignore_last_slot = true;
                        $required_duration_for_last_slot = $next_day_fullfilled_slots * 30;
                    } else {
                        // echo "else";
                        $expected_remaining_duration_for_today = $required_duration - ($next_day_fullfilled_slots * 30);
                        // echo $expected_remaining_duration_for_today."<br>";
                        $last_contious_slot_of_current_day = $all_continous_slot[count($all_continous_slot) - 1];
                        // print_R($last_contious_slot_of_current_day);
                        $last_element_of_current_day = $last_contious_slot_of_current_day[count($last_contious_slot_of_current_day) - 1];
                        $last_element_of_current_day = date("H:i:s", strtotime('+30 minutes', strtotime($last_element_of_current_day)));
                        if ($last_element_of_current_day == $closing_time) {
                            // echo "if3";
                            $required_duration_for_last_slot = count($last_contious_slot_of_current_day) * 30;
                            if ($expected_remaining_duration_for_today < $required_duration_for_last_slot) {
                                // echo "if5";
                                $ignore_last_slot = true;
                            }
                        } else {
                            // echo "else2";
                            //Don't do anything here
                        }
                    }
                } else {
                    // echo "else3";
                    //Don't do anything here as the next function will handle the last available slot and all
                }
                //Disable all the chunks that are not required enough
                $continous_slot_doration = 0; // Initialize the variable before the loop
                foreach ($all_continous_slot as $index => $row) {
                    $ignore_last_slot_local = false;
                    if ($index === (count($all_continous_slot) - 1)) {
                        $ignore_last_slot_local = ($ignore_last_slot == false) ? false : true;
                    }
                    if ($ignore_last_slot_local) {
                        $continous_slot_doration = sizeof($row) * 30;
                        if ($continous_slot_doration < $required_duration) {
                            foreach ($row as $child_slots) {
                                if (($key = array_search($child_slots, $available_slots)) !== false) {
                                    unset($available_slots[$key]);
                                    $busy_slots[] = $child_slots;
                                }
                            }
                        }
                    }
                }
                $available_slots = array_values($available_slots);
                $all_continous_slot = calculate_continuous_slots($available_slots);
                $required_slots = ceil($required_duration / 30);
                foreach ($all_continous_slot as $index => $row) {
                    if ($index == count($all_continous_slot) - 1 && $ignore_last_slot == true) {
                        $required_slots = $required_slots - $next_day_fullfilled_slots + 1;
                    }
                    $last_available_slot  = (count($row) - $required_slots) + 1;
                    for ($i = count($row) - 1; $i > $last_available_slot; $i--) {
                        if ($i >= 0 && (($key = array_search($row[$i], $available_slots)) !== false)) {
                            unset($available_slots[$key]);
                            $busy_slots[] = $row[$i];
                        }
                    }
                }
                //---------------------------------  START ----------------------------------------------------------
                // Fetch order data from the database for the requested partner
                $builder = $db->table('orders');
                $builder->select('starting_time, ending_time, date_of_service');
                $builder->where('partner_id', $partner_id);
                $builder->where('date_of_service', $booking_date);
                $builder->whereIn('status', ['awaiting', 'pending', 'confirmed', 'rescheduled']);
                $booked_slots = $builder->get()->getResultArray();
                $duration = $required_duration; // Duration of each service in minutes
                foreach ($available_slots as $slot) {
                    $slot_time = strtotime($slot);
                    $slot_end_time = strtotime("+$duration minutes", $slot_time);
                    $is_booked = false;
                    foreach ($booked_slots as $booked_slot) {
                        $booked_start_time = strtotime($booked_slot['starting_time']);
                        $booked_end_time = strtotime($booked_slot['ending_time']);
                        if (($slot_time >= $booked_start_time && $slot_time < $booked_end_time) ||
                            ($slot_end_time > $booked_start_time && $slot_end_time <= $booked_end_time)
                        ) {
                            $is_booked = true;
                            break;
                        }
                    }
                    if ($is_booked) {
                        $busy_slots[] = $slot;
                        $index = array_search($slot, $available_slots);
                        if ($index !== false) {
                            unset($available_slots[$index]);
                        }
                    }
                }
                // //------------------------------------------------------- END------------------------------------------------------------------
                $response['error'] = false;
                $response['available_slots'] = $available_slots;
                $response['busy_slots'] = $busy_slots;
                return $response;
            } else {
                if (strtotime($booking_date) == strtotime($current_date)) {
                    foreach ($array_of_time as $row) {
                        if (strtotime($row) < $current_time) {
                            if (($key = array_search($row, $array_of_time)) !== false) {
                                unset($array_of_time[$key]);
                                $busy_slots[] = $row;
                            }
                        }
                    }
                }
                //here to continue the index of available_slots
                $array_of_time = array_values($array_of_time);
                $ignore_last_slot = false;
                $all_continous_slot = calculate_continuous_slots($array_of_time);
                $next_day_slots = get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date);
                // if(!empty($next_day_available_slots)){
                $next_day_available_slots = $next_day_slots['continous_available_slots'];
                $required_slots = ceil($required_duration / 30);
                if (isset($next_day_available_slots[0][0]) && $next_day_available_slots[0][0] === $opening_time) {
                    // echo "if1";
                    $next_day_fullfilled_slots = count($next_day_available_slots[0]);
                    if ($next_day_fullfilled_slots >= $required_slots) {
                        // echo "if2";
                        $ignore_last_slot = true;
                        $required_duration_for_last_slot = $next_day_fullfilled_slots * 30;
                    } else {
                        // echo "else";
                        $expected_remaining_duration_for_today = $required_duration - ($next_day_fullfilled_slots * 30);
                        // echo $expected_remaining_duration_for_today."<br>";
                        $last_contious_slot_of_current_day = $all_continous_slot[count($all_continous_slot) - 1];
                        // print_R($last_contious_slot_of_current_day);
                        $last_element_of_current_day = $last_contious_slot_of_current_day[count($last_contious_slot_of_current_day) - 1];
                        $last_element_of_current_day = date("H:i:s", strtotime('+30 minutes', strtotime($last_element_of_current_day)));
                        if ($last_element_of_current_day == $closing_time) {
                            // echo "if3";
                            $required_duration_for_last_slot = count($last_contious_slot_of_current_day) * 30;
                            if ($expected_remaining_duration_for_today < $required_duration_for_last_slot) {
                                // echo "if5";
                                $ignore_last_slot = true;
                            }
                        } else {
                            // echo "else2";
                            //Don't do anything here
                        }
                    }
                } else {
                    // echo "else3";
                    //Don't do anything here as the next function will handle the last available slot and all
                }
                //Disable all the chunks that are not required enough
                $continous_slot_doration = 0; // Initialize the variable before the loop
                foreach ($all_continous_slot as $index => $row) {
                    $ignore_last_slot_local = false;
                    if ($index === (count($all_continous_slot) - 1)) {
                        $ignore_last_slot_local = ($ignore_last_slot == false) ? false : true;
                    }
                    if ($ignore_last_slot_local) {
                        $continous_slot_doration = sizeof($row) * 30;
                        if ($continous_slot_doration < $required_duration) {
                            foreach ($row as $child_slots) {
                                if (($key = array_search($child_slots, $array_of_time)) !== false) {
                                    unset($array_of_time[$key]);
                                    $busy_slots[] = $child_slots;
                                }
                            }
                        }
                    }
                }
                $array_of_time = array_values($array_of_time);
                $all_continous_slot = calculate_continuous_slots($array_of_time);
                $required_slots = ceil($required_duration / 30);
                foreach ($all_continous_slot as $index => $row) {
                    if ($index == count($all_continous_slot) - 1 && $ignore_last_slot == true) {
                        $required_slots = $required_slots - $next_day_fullfilled_slots + 1;
                    }
                    $last_available_slot  = (count($row) - $required_slots) + 1;
                    for ($i = count($row) - 1; $i > $last_available_slot; $i--) {
                        if ($i >= 0 && (($key = array_search($row[$i], $array_of_time)) !== false)) {
                            unset($array_of_time[$key]);
                            $busy_slots[] = $row[$i];
                        }
                    }
                }
            }
            $db->close();
            $response['error'] = false;
            $response['available_slots'] = $array_of_time;
            $response['busy_slots'] = $busy_slots;
            return $response;
        } else {
            $response['error'] = true;
            $response['message'] = "provider is closed on this day";
            return $response;
        }
    }
    //=====================================================================================================
    //=====================================================================================================
    //=====================================================================================================
    $today = date('Y-m-d');
    if ($booking_date < $today) {
        $response['error'] = true;
        $response['message'] = "please select upcoming date!";
        return $response;
    }
    $db = \config\Database::connect();
    $day = date('l', strtotime($booking_date));
    $timings = getTimingOfDay($partner_id, $day);

    if (isset($timings) && !empty($timings)) {
        $opening_time = $timings['opening_time'];
        $closing_time = $timings['closing_time'];
        $booked_slots = booked_timings($partner_id, $booking_date);
        $interval = 30 * 60;
        $start_time = strtotime($opening_time);
        $current_time = time();
        $end_time = strtotime($closing_time);
        $count = count($booked_slots);
        $current_date = date('Y-m-d');
        $available_slots = [];
        $busy_slots = [];
        //if booked slot is not empty means that day no odrer no found
        while ($start_time < $end_time) {
            $array_of_time[] = date("H:i:s", $start_time);
            $start_time += $interval;
        }

        if (isset($booked_slots) && !empty($booked_slots)) {
            //here suggested time is created in gap of 30 minutes
            $count_suggestion_slots = count($array_of_time);
            //loop on total booked slots
            for ($i = 0; $i < $count; $i++) {
                //loop on suggested time slots
                for ($j = 0; $j < $count_suggestion_slots; $j++) {
                    //if suggested time slot is less than booked slot starting time or suggested time slot is greater than booked time slot starting time
                    if (strtotime($array_of_time[$j]) < strtotime($booked_slots[$i]['starting_time']) || strtotime($array_of_time[$j]) >= strtotime($booked_slots[$i]['ending_time'])) {
                        //check if suggested time slot is not  in array of avaialble slot
                        if (!in_array($array_of_time[$j], $available_slots)) {
                            //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                            if (strtotime($array_of_time[$j]) > $current_time || strtotime($booking_date) != strtotime($current_date)) {
                                // echo $array_of_time[$j]." added to available time slot <br/>";
                                $available_slots[] = $array_of_time[$j];
                            } else {
                                // echo $array_of_time[$j]." added to busy time slot11<br/>";
                                if (!in_array($array_of_time[$j], $busy_slots)) {
                                    $busy_slots[] = $array_of_time[$j];
                                }
                            }
                            // die;
                        } else {
                        }
                    } else {
                        //  echo $array_of_time[$j]." added to busy time slot22<br/>";
                        if (!in_array($array_of_time[$j], $busy_slots)) {
                            $busy_slots[] = $array_of_time[$j];
                        }
                    }
                }
                $count_busy_slots = count($busy_slots);
                for ($k = 0; $k < $count_busy_slots; $k++) {
                    if (($key = array_search($busy_slots[$k], $available_slots)) !== false) {
                        unset($available_slots[$key]);
                    }
                }
            }
            //here to continue the index of available_slots
            $available_slots = array_values($available_slots);
            $ignore_last_slot = false;
            $all_continous_slot = calculate_continuous_slots($available_slots);
            $next_day_slots = get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date);
            // if(!empty($next_day_available_slots)){
            $next_day_available_slots = $next_day_slots['continous_available_slots'];
            $required_slots = ceil($required_duration / 30);
            if (isset($next_day_available_slots[0][0]) && $next_day_available_slots[0][0] === $opening_time) {
                // echo "if1";
                $next_day_fullfilled_slots = count($next_day_available_slots[0]);
                if ($next_day_fullfilled_slots >= $required_slots) {
                    // echo "if2";
                    $ignore_last_slot = true;
                    $required_duration_for_last_slot = $next_day_fullfilled_slots * 30;
                } else {
                    // echo "else";
                    $expected_remaining_duration_for_today = $required_duration - ($next_day_fullfilled_slots * 30);
                    // echo $expected_remaining_duration_for_today."<br>";
                    $last_contious_slot_of_current_day = !empty($all_continous_slot[count($all_continous_slot) - 1]) ? $all_continous_slot[count($all_continous_slot) - 1] : [];
                    $last_element_of_current_day = !empty($last_contious_slot_of_current_day) ? $last_contious_slot_of_current_day[count($last_contious_slot_of_current_day) - 1] : "";
                    $last_element_of_current_day = date("H:i:s", strtotime('+30 minutes', strtotime($last_element_of_current_day)));
                    if (!empty($last_element_of_current_day)) {
                    } else {
                        $last_element_of_current_day = $opening_time;
                    }
                    if ($last_element_of_current_day == $closing_time) {
                        // echo "if3";
                        $required_duration_for_last_slot = count($last_contious_slot_of_current_day) * 30;
                        if ($expected_remaining_duration_for_today < $required_duration_for_last_slot) {
                            // echo "if5";
                            $ignore_last_slot = true;
                        }
                    } else {
                        // echo "else2";
                        //Don't do anything here
                    }
                }
            } else {
                // echo "else3";
                //Don't do anything here as the next function will handle the last available slot and all
            }
            //Disable all the chunks that are not required enough
            $continous_slot_doration = 0; // Initialize the variable before the loop
            foreach ($all_continous_slot as $index => $row) {
                $ignore_last_slot_local = false;
                if ($index === (count($all_continous_slot) - 1)) {
                    $ignore_last_slot_local = ($ignore_last_slot == false) ? false : true;
                }
                if ($ignore_last_slot_local) {
                    $continous_slot_doration = sizeof($row) * 30;
                    if ($continous_slot_doration < $required_duration) {
                        foreach ($row as $child_slots) {
                            if (($key = array_search($child_slots, $available_slots)) !== false) {
                                unset($available_slots[$key]);
                                $busy_slots[] = $child_slots;
                            }
                        }
                    }
                }
            }
            $available_slots = array_values($available_slots);
            $all_continous_slot = calculate_continuous_slots($available_slots);
            $required_slots = ceil($required_duration / 30);
            foreach ($all_continous_slot as $index => $row) {
                if ($index == count($all_continous_slot) - 1 && $ignore_last_slot == true) {
                    $required_slots = $required_slots - $next_day_fullfilled_slots + 1;
                }
                $last_available_slot  = (count($row) - $required_slots) + 1;
                for ($i = count($row) - 1; $i > $last_available_slot; $i--) {
                    if ($i >= 0 && (($key = array_search($row[$i], $available_slots)) !== false)) {
                        unset($available_slots[$key]);
                        $busy_slots[] = $row[$i];
                    }
                }
            }
            //---------------------------------  START ----------------------------------------------------------
            // Fetch order data from the database for the requested partner
            $builder = $db->table('orders');
            $builder->select('starting_time, ending_time, date_of_service');
            $builder->where('partner_id', $partner_id);
            $builder->where('date_of_service', $booking_date);
            $builder->whereIn('status', ['awaiting', 'pending', 'confirmed', 'rescheduled']);
            $booked_slots = $builder->get()->getResultArray();
            $duration = $required_duration; // Duration of each service in minutes
            foreach ($available_slots as $slot) {
                $slot_time = strtotime($slot);
                $slot_end_time = strtotime("+$duration minutes", $slot_time);
                $is_booked = false;
                foreach ($booked_slots as $booked_slot) {
                    $booked_start_time = strtotime($booked_slot['starting_time']);
                    $booked_end_time = strtotime($booked_slot['ending_time']);
                    if (($slot_time >= $booked_start_time && $slot_time < $booked_end_time) ||
                        ($slot_end_time > $booked_start_time && $slot_end_time <= $booked_end_time)
                    ) {
                        $is_booked = true;
                        break;
                    }
                }
                if ($is_booked) {
                    $busy_slots[] = $slot;
                    $index = array_search($slot, $available_slots);
                    if ($index !== false) {
                        unset($available_slots[$index]);
                    }
                }
            }
            // //------------------------------------------------------- END------------------------------------------------------------------
            $response['error'] = false;
            $response['available_slots'] = $available_slots;
            $response['busy_slots'] = $busy_slots;
            return $response;
        } else {
            // print_r($array_of_time);
            if (!isset($array_of_time) || empty($array_of_time)) {
                $array_of_time = [];
            }

            if (strtotime($booking_date) == strtotime($current_date)) {
                foreach ($array_of_time as $row) {
                    if (strtotime($row) < $current_time) {
                        if (($key = array_search($row, $array_of_time)) !== false) {
                            unset($array_of_time[$key]);
                            $busy_slots[] = $row;
                        }
                    }
                }
            }

            //here to continue the index of available_slots
            $array_of_time = array_values($array_of_time);
            $ignore_last_slot = false;
            $all_continous_slot = calculate_continuous_slots($array_of_time);

            if (!empty($array_of_time)) {
                $next_day_slots = get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date);
                $next_day_available_slots = $next_day_slots['continous_available_slots'];
                $required_slots = ceil($required_duration / 30);

                if (isset($next_day_available_slots[0][0]) && $next_day_available_slots[0][0] === $opening_time) {
                    // echo "if1";
                    $next_day_fullfilled_slots = count($next_day_available_slots[0]);
                    if ($next_day_fullfilled_slots >= $required_slots) {
                        // echo "if2";
                        $ignore_last_slot = true;
                        $required_duration_for_last_slot = $next_day_fullfilled_slots * 30;
                    } else {
                        // echo "else";
                        $expected_remaining_duration_for_today = $required_duration - ($next_day_fullfilled_slots * 30);
                        // echo $expected_remaining_duration_for_today."<br>";
                        $last_contious_slot_of_current_day = $all_continous_slot[count($all_continous_slot) - 1];
                        // print_R($last_contious_slot_of_current_day);
                        $last_element_of_current_day = $last_contious_slot_of_current_day[count($last_contious_slot_of_current_day) - 1];
                        $last_element_of_current_day = date("H:i:s", strtotime('+30 minutes', strtotime($last_element_of_current_day)));
                        if ($last_element_of_current_day == $closing_time) {
                            // echo "if3";
                            $required_duration_for_last_slot = count($last_contious_slot_of_current_day) * 30;
                            if ($expected_remaining_duration_for_today < $required_duration_for_last_slot) {
                                // echo "if5";
                                $ignore_last_slot = true;
                            }
                        } else {
                            // echo "else2";
                            //Don't do anything here
                        }
                    }
                } else {
                    // echo "else3";
                    //Don't do anything here as the next function will handle the last available slot and all
                }
            }
            //Disable all the chunks that are not required enough
            $continous_slot_doration = 0; // Initialize the variable before the loop
            foreach ($all_continous_slot as $index => $row) {
                $ignore_last_slot_local = false;
                if ($index === (count($all_continous_slot) - 1)) {
                    $ignore_last_slot_local = ($ignore_last_slot == false) ? false : true;
                }
                if ($ignore_last_slot_local) {
                    $continous_slot_doration = sizeof($row) * 30;
                    if ($continous_slot_doration < $required_duration) {
                        foreach ($row as $child_slots) {
                            if (($key = array_search($child_slots, $array_of_time)) !== false) {
                                unset($array_of_time[$key]);
                                $busy_slots[] = $child_slots;
                            }
                        }
                    }
                }
            }

            $array_of_time = array_values($array_of_time);
            $all_continous_slot = calculate_continuous_slots($array_of_time);
            $required_slots = ceil($required_duration / 30);

            foreach ($all_continous_slot as $index => $row) {
                if ($index == count($all_continous_slot) - 1 && $ignore_last_slot == true) {
                    $required_slots = $required_slots - $next_day_fullfilled_slots + 1;
                }
                $last_available_slot  = ((count($row)) - $required_slots) + 1;
                $next_day_slots1 = get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date);
                if (empty($next_day_slots1['available_slots'])) {
                    for ($i = count($row) - 1; $i >= $last_available_slot; $i--) {
                        if ($i >= 0 && (($key = array_search($row[$i], $array_of_time)) !== false)) {
                            unset($array_of_time[$key]);
                            $busy_slots[] = $row[$i];
                        }
                    }
                } else {
                    for ($i = count($row) - 1; $i > $last_available_slot; $i--) {
                        if ($i >= 0 && (($key = array_search($row[$i], $array_of_time)) !== false)) {
                            unset($array_of_time[$key]);
                            $busy_slots[] = $row[$i];
                        }
                    }
                }
            }
        }
        // die;
        $db->close();
        $response['error'] = false;
        $response['available_slots'] = $array_of_time;
        $response['busy_slots'] = $busy_slots;
        return $response;
    } else {
        $db->close();
        $response['error'] = true;
        $response['message'] = "provider is closed on this day";
        return $response;
    }
}
function get_available_slots_without_processing($partner_id, $booking_date, $required_duration = null, $next_day_order = null)
{
    $today = date('Y-m-d');
    if ($booking_date < $today) {
        $response['error'] = true;
        $response['message'] = "please select upcoming date!";
        return $response;
    }
    // $db = \config\Database::connect();
    $day = date('l', strtotime($booking_date));
    $busy_slots = [];
    $timings = getTimingOfDay($partner_id, $day);
    if (isset($timings) && !empty($timings)) {
        $opening_time = $timings['opening_time'];
        $closing_time = $timings['closing_time'];
        $booked_slots = booked_timings($partner_id, $booking_date);
        $interval = 30 * 60;
        $start_time = strtotime($next_day_order);
        $current_time = time();
        $end_time = strtotime($closing_time);
        $count = count($booked_slots);
        $current_date = date('Y-m-d');
        $available_slots = [];
        $array_of_time = [];
        //here suggested time is created in gap of 30 minutes
        while ($start_time <= $end_time) {
            $array_of_time[] = date("H:i:s", $start_time);
            $start_time += $interval;
        }
        // addedd  start
        if (strtotime($booking_date) == strtotime($current_date)) {
            foreach ($array_of_time as $row) {
                if (strtotime($row) < $current_time) {
                    if (($key = array_search($row, $array_of_time)) !== false) {
                        unset($array_of_time[$key]);
                        $busy_slots[] = $row;
                    }
                }
            }
        }
        //addedd end
        //here to continue the index of available_slots
        $array_of_time = array_values($array_of_time);
        if (isset($booked_slots) && !empty($booked_slots)) {
            //here suggested time is created in gap of 30 minutes
            $count_suggestion_slots = count($array_of_time);
            //loop on total booked slots
            for ($i = 0; $i < $count; $i++) {
                //loop on suggested time slots
                for ($j = 0; $j < $count_suggestion_slots; $j++) {
                    //if suggested time slot is less than booked slot starting time or suggested time slot is greater than booked time slot starting time
                    if (strtotime($array_of_time[$j]) < strtotime($booked_slots[$i]['starting_time']) || strtotime($array_of_time[$j]) >= strtotime($booked_slots[$i]['ending_time'])) {
                        if (!in_array($array_of_time[$j], $available_slots)) {
                            //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                            if (strtotime($array_of_time[$j]) > $current_time || strtotime($booking_date) != strtotime($current_date)) {
                                // echo $array_of_time[$j]." added to available time slot <br/>";
                                $available_slots[] = $array_of_time[$j];
                            } else {
                                // echo $array_of_time[$j]." added to busy time slot11<br/>";
                                if (!in_array($array_of_time[$j], $busy_slots)) {
                                    $busy_slots[] = $array_of_time[$j];
                                }
                            }
                            // die;
                        } else {
                        }
                    } else {
                        //  echo $array_of_time[$j]." added to busy time slot22<br/>";
                        if (!in_array($array_of_time[$j], $busy_slots)) {
                            $busy_slots[] = $array_of_time[$j];
                        }
                    }
                }
                $count_busy_slots = count($busy_slots);
                for ($k = 0; $k < $count_busy_slots; $k++) {
                    if (($key = array_search($busy_slots[$k], $available_slots)) !== false) {
                        unset($available_slots[$key]);
                    }
                }
            }
        }

        $all_continous_slot = calculate_continuous_slots($array_of_time);
        $response['error'] = false;
        $response['available_slots'] = $all_continous_slot;
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "provider is closed on this day";
        return $response;
    }
}
function get_service($service_id)
{
    if ($service_id != null) {
        return false;
    }
    $service = fetch_details('services', ['id' => $service_id]);
    if ($service != null && !empty($service)) {
        return response_helper('Found data', false, $service);
    } else {
        return response_helper('No Data Found', false, []);
    }
}
function has_ordered($user_id, $service_id, $custom_job_id = null)
{
    $db = \config\Database::connect();
    if ($custom_job_id) {
        $custom_job = fetch_details('custom_job_requests', ['id' => $custom_job_id]);
        if (empty($custom_job)) {
            $response['error'] = true;
            $response['message'] = "No Custom Service Found";
            return $response;
        }
        $builder = $db
            ->table('orders o')
            ->select(' o.id,o.user_id,os.service_id')
            ->join('order_services os', 'os.order_id = o.id')
            ->where('user_id', $user_id)
            ->where('o.status', 'completed')
            ->where('os.custom_job_request_id', $custom_job_id)->get()->getResultArray();
    } else {
        $services = fetch_details('services', ['id' => $service_id]);
        if (empty($services)) {
            $response['error'] = true;
            $response['message'] = "No Service Found";
            return $response;
        }
        $builder = $db
            ->table('orders o')
            ->select(' o.id,o.user_id,os.service_id')
            ->join('order_services os', 'os.order_id = o.id')
            ->where('user_id', $user_id)
            ->where('o.status', 'completed')
            ->where('os.service_id', $service_id)->get()->getResultArray();
    }
    $db->close();
    if (!empty($builder)) {
        $response['error'] = false;
        $response['message'] = "Has ordered";
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "Can not rate service  without Placing orders";
        return $response;
    }
}
function has_rated($user_id, $rate_id)
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('services_ratings sr')
        ->select('sr.*')
        ->where('sr.id', $rate_id)
        ->where('user_id', $user_id);
    $old_data = $builder->get()->getResultArray();
    $db->close();
    if (!empty($old_data)) {
        $response['error'] = false;
        $response['message'] = "Found Rating";
        $response['data'] = $old_data;
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "No Rating Found";
        return $response;
    }
}
// function get_ratings($user_id)
// {
//     $db = \config\Database::connect();
//     $builder = $db
//         ->table('services s')
//         ->select("
//                 COUNT(sr.rating) as total_ratings,
//                 SUM( CASE WHEN sr.rating = ceil(5) THEN 1 ELSE 0 END) as rating_5,
//                 SUM( CASE WHEN sr.rating = ceil(4) THEN 1 ELSE 0 END) as rating_4,
//                 SUM( CASE WHEN sr.rating = ceil(3) THEN 1 ELSE 0 END) as rating_3,
//                 SUM( CASE WHEN sr.rating = ceil(2) THEN 1 ELSE 0 END) as rating_2,
//                 SUM( CASE WHEN sr.rating = ceil(1) THEN 1 ELSE 0 END) as rating_1
//             ")
//         ->join('services_ratings sr', 'sr.service_id = s.id')
//         ->where('s.user_id', $user_id)
//         ->join('users u', 'u.id = sr.user_id')
//         ->get()->getResultArray();
//     return $builder;
// }
function get_ratings($user_id)
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('services_ratings sr')
        ->select("
            COUNT(sr.rating) as total_ratings,
            SUM(CASE WHEN sr.rating = ceil(5) THEN 1 ELSE 0 END) as rating_5,
            SUM(CASE WHEN sr.rating = ceil(4) THEN 1 ELSE 0 END) as rating_4,
            SUM(CASE WHEN sr.rating = ceil(3) THEN 1 ELSE 0 END) as rating_3,
            SUM(CASE WHEN sr.rating = ceil(2) THEN 1 ELSE 0 END) as rating_2,
            SUM(CASE WHEN sr.rating = ceil(1) THEN 1 ELSE 0 END) as rating_1
        ")
        ->join('services s', 'sr.service_id = s.id', 'left')
        ->join('custom_job_requests cj', 'sr.custom_job_request_id = cj.id', 'left')
        ->join('partner_bids pb', 'pb.custom_job_request_id = cj.id', 'left')
        ->join('users u', 'u.id = sr.user_id')
        ->where("(s.user_id = {$user_id}) OR (pb.partner_id = {$user_id} AND sr.custom_job_request_id IS NOT NULL)")
        ->get()->getResultArray();
    $db->close();
    return $builder;
}
// function update_ratings($service_id, $rate)
// {
//     $db = \config\Database::connect();
//     $service_data = fetch_details('services', ['id' => $service_id]);
//     if (!empty($service_data)) {
//         $user_id = $service_data[0]['user_id'];
//     }
//     $partner_data = fetch_details('partner_details', ['partner_id' => $user_id]);
//     if (!empty($partner_data)) {
//         $partner_id = $partner_data[0]['partner_id'];
//     }
//     $service_ids = fetch_details('services', ['user_id' => $user_id], ['id']);
//     $ids = [];
//     foreach ($service_ids as $si) {
//         array_push($ids, $si['id']);
//     }
//     $data = $db
//         ->table('services_ratings sr')
//         ->select(
//             'count(sr.rating) as number_of_ratings,
//                 sum(sr.rating) as total_rating,
//                 (sum(sr.rating) /count(sr.rating)) as avg_rating'
//         )
//         ->whereIn('service_id', $ids)
//         ->get()->getResultArray();
//     if (!empty($data)) {
//         $data[0]['number_of_ratings'] = $data[0]['number_of_ratings'];
//         $data[0]['total_rating'] = $data[0]['total_rating'];
//         $data[0]['avg_rating'] = $data[0]['total_rating'] / $data[0]['number_of_ratings'];
//         $updated_data = update_details(['ratings' => $data[0]['avg_rating'], 'number_of_ratings' => $data[0]['number_of_ratings']], ['partner_id' => $partner_id], 'partner_details');
//         $updated_data = update_details(['rating' => $data[0]['avg_rating'], 'number_of_ratings' => $data[0]['number_of_ratings']], ['id' => $service_id], 'services');
//     } else {
//         $updated_data = update_details(
//             ['ratings' => $rate, 'number_of_ratings' => 1],
//             ['partner_id' => $partner_id],
//             'partner_details'
//         );
//         $updated_data = update_details(['rating' => $rate, 'number_of_ratings' => 1], ['id' => $service_id], 'services');
//     }
//     if ($updated_data != "") {
//         return $response['error'] = false;
//     } else {
//         return $response['error'] = true;
//     }
// }
function update_ratings($service_id, $rate)
{
    $db = \config\Database::connect();
    // Get service data
    $service_data = fetch_details('services', ['id' => $service_id]);
    if (empty($service_data)) {
        return ['error' => true];
    }
    $user_id = $service_data[0]['user_id'];
    // Get all ratings for this user's services and custom job requests in one query
    $ratings = $db->table('services_ratings sr')
        ->select('COUNT(sr.rating) as number_of_ratings, SUM(sr.rating) as total_rating')
        ->join('services s', 's.id = sr.service_id', 'left')
        ->join('custom_job_requests cj', 'sr.custom_job_request_id = cj.id', 'left')
        ->join('partner_bids pb', 'pb.custom_job_request_id = cj.id', 'left')
        ->where("(s.user_id = {$user_id}) OR (pb.partner_id = {$user_id} AND sr.custom_job_request_id IS NOT NULL)")
        ->get()
        ->getRowArray();

    $db->close();
    // Prepare update data
    if (!empty($ratings) && $ratings['number_of_ratings'] > 0) {
        $avg_rating = $ratings['total_rating'] / $ratings['number_of_ratings'];
        $num_ratings = $ratings['number_of_ratings'];
    } else {
        $avg_rating = $rate;
        $num_ratings = 1;
    }
    // Update partner details
    $updated = update_details(
        ['ratings' => $avg_rating, 'number_of_ratings' => $num_ratings],
        ['partner_id' => $user_id],
        'partner_details',
        false
    );
    // Update service
    $updated = update_details(
        ['rating' => $avg_rating, 'number_of_ratings' => $num_ratings],
        ['id' => $service_id],
        'services',
        false
    );
    return ['error' => ($updated === "") ? true : false];
}
function rating_images($rating_id, $from_app = false)
{
    $rating_data = fetch_details('services_ratings', ['id' => $rating_id]);
    $disk = fetch_current_file_manager();
    $d = ($from_app == false) ? 'for web' : 'for app';
    if (!empty($rating_data)) {
        $rating_images = json_decode($rating_data[0]['images'], true);
        $images_restored = [];
        foreach ($rating_images as $ri) {
            if ($from_app == false) {
                if ($disk == "local_server") {
                    $image_url =  base_url($ri);
                } else if ($disk == "aws_s3") {
                    $image_url =  fetch_cloud_front_url('ratings', $ri);
                }
                $image = '<a  href="' . base_url($ri) . '" data-lightbox="image-1"><img height="80px" class="rounded" src="' . $image_url . '" alt=""></a>';
                array_push($images_restored, $image);
            } else {
                if ($disk == "local_server") {
                    array_push($images_restored, base_url($ri));
                } else if ($disk == "aws_s3") {
                    array_push($images_restored, fetch_cloud_front_url('ratings', $ri));
                }
            }
        }
    }
    return $images_restored;
}
function is_favorite($user_id, $partner_id)
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('bookmarks b')
        ->select('b.*')
        ->where('b.user_id', $user_id)
        ->where('b.partner_id', $partner_id);
    $data = $builder->get()->getResultArray();
    $db->close();
    if (!empty($data)) {
        return true;
    } else {
        return false;
    }
}
function favorite_list($user_id)
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('bookmarks b')
        ->select('b.partner_id')
        ->where('b.user_id', $user_id);
    $data = $builder->get()->getResultArray();
    $db->close();
    $partner_ids = [];
    if (!empty($data)) {
        foreach ($data as $dt) {
            array_push($partner_ids, $dt['partner_id']);
        }
        return $partner_ids;
    } else {
        return false;
    }
}
function in_cart_qty($service_id, $user_id)
{
    $data = fetch_details('cart', ['user_id' => $user_id, 'service_id' => $service_id], ['qty']);
    $quantity = (!empty($data)) ? $data[0]['qty'] : '0';
    return $quantity;
}
function resize_image($image, $new_image, $thumbnail, $width = 300, $height = 300)
{
    if (file_exists(FCPATH . $image)) {
        if (!is_dir(base_url($thumbnail))) {
            mkdir(base_url($thumbnail), 0775, true);
        }
        \Config\Services::image('gd')
            ->withFile(FCPATH . $image)
            ->resize($width, $height, true, 'auto')
            ->save(FCPATH . $new_image);
        $response['error'] = false;
        $response['message'] = "File resizes successfully";
        return $response;
    } else {
        $response['error'] = true;
        $response['message'] = "File does not exist";
        return $response;
    }
}
function provider_total_earning_chart($partner_id = '')
{
    $amount = fetch_details('orders', ['partner_id' => $partner_id, 'is_commission_settled' => '0'], ['sum(final_total) as total']);
    $db = \config\Database::connect();
    $builder = $db
        ->table('orders')
        ->select('SUM(final_total) AS total, DATE_FORMAT(created_at,"%b") AS month_name')
        ->where('partner_id', $partner_id)
        ->where('status', 'completed')
        ->groupBy('created_at');
    $data = $builder->get()->getResultArray();
    $admin_commission_percentage = get_admin_commision($partner_id);
    $admin_commission_amount = intval($admin_commission_percentage) / 100;
    $month_wise_sales = ['total_sale' => [], 'month_name' => []];
    foreach ($data as $row) {
        $tempRow = $row['total'];
        $commission = intval($tempRow) * $admin_commission_amount;
        $total_after_commission = $tempRow - $commission;
        $month_wise_sales['total_sale'][] = $total_after_commission;
        $month_wise_sales['month_name'][] = $row['month_name'];
    }
    $db->close();
    return $month_wise_sales;
}
function provider_already_withdraw_chart($partner_id = '')
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('payment_request')
        ->select('sum(amount) as total')
        ->select('SUM(amount) AS total_withdraw,DATE_FORMAT(created_at,"%b") AS month_name')
        ->where('status', '1')
        ->where('user_id', $partner_id);
    $data = $builder->groupBy('created_at')->get()->getResultArray();
    $tempRow = array();
    $row1 = array();
    foreach ($data as $key => $row) {
        $tempRow = $row['total'];
        $row1[] = $tempRow;
    }
    $month_wise_sales['total_withdraw'] = array_map('intval', array_column($data, 'total_withdraw'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $total_withdraw = $month_wise_sales;
    $db->close();
    return $total_withdraw;
}
function provider_pending_withdraw_chart($partner_id = '')
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('payment_request')
        ->select('sum(amount) as total')
        ->select('SUM(amount) AS pending_withdraw,DATE_FORMAT(created_at,"%b") AS month_name')
        ->where('status', '0')
        ->where('user_id', $partner_id);
    $data = $builder->groupBy('created_at')->get()->getResultArray();
    $month_wise_sales['pending_withdraw'] = array_map('floatval', array_column($data, 'pending_withdraw'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $pending_withdraw = $month_wise_sales;
    $db->close();
    return $pending_withdraw;
    // return $row1;
}
function provider_withdraw_chart($partner_id = '')
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('payment_request')
        ->select('sum(amount) as total')
        ->select('SUM(amount) AS withdraw_request,DATE_FORMAT(created_at,"%b") AS month_name')
        ->where('user_id', $partner_id);
    $data = $builder->groupBy('created_at')->get()->getResultArray();
    $month_wise_sales['withdraw_request'] = array_map('intval', array_column($data, 'withdraw_request'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $withdraw_request = $month_wise_sales;
    $db->close();
    return $withdraw_request;
}
function income_revenue($partner_id = '')
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('payment_request')
        ->select('sum(amount) as total')
        ->select('SUM(amount) AS income_revenue,DATE_FORMAT(date_of_service,"%b") AS month_name')
        ->where('status', '0');
    $data = $builder->groupBy('MONTH(created_at), YEAR(created_at)')->get()->getResultArray();
    $month_wise_sales['income_revenue'] = array_map('intval', array_column($data, 'income_revenue'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $income_revenue = $month_wise_sales;
    $db->close();
    return $income_revenue;
}
function admin_income_revenue($partner_id = '')
{
    $db = \config\Database::connect();
    $builder =  $db
        ->table('orders o')
        ->select('
            o.final_total, pd.admin_commission,pd.*,
            SUM(( o.final_total * pd.admin_commission)/100) as total_admin_earning,DATE_FORMAT(o.date_of_service,"%b") AS month_name
        ')
        ->where('o.status', 'completed')
        ->join('partner_details pd', 'pd.partner_id = o.partner_id', 'left')
        ->groupBy('month_name');
    $data = $builder->get()->getResultArray();
    $month_wise_sales['income_revenue'] = array_map('intval', array_column($data, 'total_admin_earning'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $admin_income_revenue = $month_wise_sales;
    $db->close();
    return $admin_income_revenue;
}
function provider_income_revenue($partner_id = '')
{
    $db = \config\Database::connect();
    $builder =  $db
        ->table('orders o')
        ->select('
        o.final_total, pd.admin_commission,pd.*,
        SUM(o.final_total - (( o.final_total * pd.admin_commission)/100)) as total_partner_earning,DATE_FORMAT(o.date_of_service,"%b") AS month_name
        ')
        ->where('o.status', 'completed')
        ->join('partner_details pd', 'pd.partner_id = o.partner_id', 'left')
        ->groupBy('month_name');
    $data = $builder->get()->getResultArray();
    $translated_month_names = [];
    foreach ($data as $row) {
        $month_key = strtolower($row['month_name']); // Convert to lowercase for consistency
        $translated_month_names[] = labels($month_key); // Use labels function with fallback
    }
    $month_wise_sales['income_revenue'] = array_map('intval', array_column($data, 'total_partner_earning'));
    $month_wise_sales['month_name'] = $translated_month_names;
    $provider_income_revenue = $month_wise_sales;
    $db->close();
    return $provider_income_revenue;
}
function total_income_revenue($partner_id = '')
{
    $db = \config\Database::connect();
    $builder = $db
        ->table('orders o')
        ->select('SUM(o.final_total) AS total_earning, DATE_FORMAT(o.date_of_service, "%b") AS month_name')
        ->where('o.status', 'completed')
        ->join('partner_details pd', 'pd.partner_id = o.partner_id', 'left')
        ->groupBy('month_name');
    $data = $builder->get()->getResultArray();
    $month_wise_sales['income_revenue'] = array_map('intval', array_column($data, 'total_earning'));
    $month_wise_sales['month_name'] = array_column($data, 'month_name');
    $db->close();
    return $month_wise_sales;
}
function fetch_top_trending_services($category_id = 'null')
{
    $db = \config\Database::connect();
    $builder = $db->table('order_services');
    $builder->select('service_id, COUNT(*) as count');
    $builder->where('status', 'completed');
    $builder->groupBy('service_id');
    $builder->orderBy('count', 'desc');
    $builder->limit(10);
    $trending_services = $builder->get()->getResultArray();
    $top_trending_services = array();
    $total_service_orders = array();
    foreach ($trending_services as $key => $trending_service) {
        if ($category_id != "null") {
            $where = ['id' => $trending_service['service_id'], 'category_id' => $category_id];
        } else {
            $where = ['id' => $trending_service['service_id']];
        }
        $services = fetch_details("services", $where, ['id', 'title', 'image', 'price', 'discounted_price', 'category_id'], '10');
        foreach ($services as $key => $row) {
            $total_service_orders = $db->table('order_services o')->select('count(o.id) as `total`')->where('status', 'completed')->where('o.service_id', $row['id'])->get()->getResultArray();
            $services[$key]['order_data'] = $total_service_orders[0]['total'];
        }
        $top_trending_services[] = (!empty($services[0])) ? $services[0] : "";
    }
    $db->close();
    return (array_filter($top_trending_services));
}
function order_encrypt($user_id, $amount, $order_id)
{
    $simple_string = $user_id . "-" . $amount . "-" . $order_id;
    // Store the cipher method
    $ciphering = "AES-128-CTR";
    // Use OpenSSl Encryption method
    $iv_length = openssl_cipher_iv_length($ciphering);
    $options = 0;
    // Non-NULL Initialization Vector for encryption
    $encryption_iv = '1234567891011121';
    // Store the encryption key
    $encryption_key = getenv('decryption_key');
    // Use openssl_encrypt() function to encrypt the data
    $encryption = openssl_encrypt(
        $simple_string,
        $ciphering,
        $encryption_key,
        $options,
        $encryption_iv
    );
    return $encryption;
}
function order_decrypt($order_id)
{
    $ciphering = "AES-128-CTR";
    $options = 0;
    // Use openssl_encrypt() function to encrypt the data
    $encryption = $order_id;
    // Non-NULL Initialization Vector for decryption
    $decryption_iv = '1234567891011121';
    // Store the decryption key
    $decryption_key = getenv('decryption_key');
    // Use openssl_decrypt() function to decrypt the data
    $decryption = openssl_decrypt(
        $encryption,
        $ciphering,
        $decryption_key,
        $options,
        $decryption_iv
    );
    $order_id = (explode("-", $decryption));
    return $order_id;
}
function is_file_uploaded($result = null)
{
    if ($result == true) {
        return true;
    } else {
        return false;
    }
}
function checkPartnerAvailability($partnerId, $requestedStartTime, $requestedDuration, $date_of_service, $starting_time)
{
    helper('date');
    $db = \Config\Database::connect();
    $builder = $db->table('orders');
    $builder->select('starting_time, ending_time, date_of_service');
    $builder->where('date_of_service', $date_of_service);
    $builder->where('partner_id', $partnerId);
    $builder->whereIn('status', ['awaiting', 'pending', 'confirmed', 'rescheduled']);
    $query = $builder->get()->getResultArray();
    $db->close();
    $day = date('l', strtotime($requestedStartTime));
    $timings = getTimingOfDay($partnerId, $day);
    $date_of_service_timestamp = strtotime($date_of_service);
    $current_date_timestamp = time(); // Current date timestamp
    $date_of_service_date = date("Y-m-d", $date_of_service_timestamp);
    $current_date = date("Y-m-d", $current_date_timestamp);
    if ($date_of_service_date != $current_date && $date_of_service_timestamp < $current_date_timestamp) {
        $response['error'] = true;
        $response['message'] = labels(PLEASE_SELECT_UPCOMING_DATE, 'Please Select Upcoming date');
        return $response;
    }
    if (sizeof($query) > 0) {
        $orderTable = $query;
        $partnerClosingTime = $timings['closing_time']; // Replace with the actual closing time
        $requestedEndTime = date('Y-m-d H:i:s', strtotime($requestedStartTime) + $requestedDuration * 60);
        $provider_starting_time = date('H:i:s', strtotime($timings['opening_time']));
        $provider_closing_time = date('H:i:s', strtotime($partnerClosingTime));
        foreach ($orderTable as $order) {
            $orderStartTime = $order['date_of_service'] . ' ' . $order['starting_time'];
            $orderEndTime = $order['date_of_service'] . ' ' . $order['ending_time'];
            if ($requestedStartTime >= $orderStartTime && $requestedStartTime < $orderEndTime) {
                $response['error'] = true;
                $response['message'] = labels(THE_PROVIDER_IS_CURRENTLY_UNAVAILABLE_DURING_THE_REQUESTED_TIME_SLOT_KINDLY_PROPOSE_AN_ALTERNATIVE_TIME, "The provider is currently unavailable during the requested time slot. Kindly propose an alternative time.");
                return $response;
            } elseif ($requestedEndTime > $orderStartTime && $requestedEndTime <= $orderEndTime) {
                $response['error'] = true;
                $response['message'] = labels(THE_PROVIDER_IS_CURRENTLY_UNAVAILABLE_DURING_THE_REQUESTED_TIME_SLOT_KINDLY_PROPOSE_AN_ALTERNATIVE_TIME, "The provider is currently unavailable during the requested time slot. Kindly propose an alternative time.");
                return $response;
            } elseif ($requestedStartTime < $orderStartTime && $requestedEndTime > $orderEndTime) {
                $response['error'] = true;
                $response['message'] = labels(THE_PROVIDER_IS_CURRENTLY_UNAVAILABLE_DURING_THE_REQUESTED_TIME_SLOT_KINDLY_PROPOSE_AN_ALTERNATIVE_TIME, "The provider is currently unavailable during the requested time slot. Kindly propose an alternative time.");
                return $response;
            }
        }
    }
    $time_slots = get_slot_for_place_order($partnerId, $date_of_service, $requestedDuration, $starting_time);
    if (isset($time_slots['closed']) && $time_slots['closed'] == "true") {
        $response['error'] = true;
        $response['message'] = labels(PROVIDER_IS_CLOSED_AT_THIS_TIME, "Provider is closed at this time");
        return $response;
    }
    $partnerClosingTime = $timings['closing_time'];
    $requestedEndTime = date('Y-m-d H:i:s', strtotime($requestedStartTime) + $requestedDuration * 60);
    $provider_starting_time = date('H:i:s', strtotime($timings['opening_time']));
    $provider_closing_time = date('H:i:s', strtotime($partnerClosingTime));
    if ($starting_time < $provider_starting_time || $starting_time >= $provider_closing_time) {
        $response['error'] = true;
        $response['message'] = labels(PROVIDER_IS_CLOSED_AT_THIS_TIME, "Provider is closed at this time");
    } elseif (!$time_slots['slot_avaialble'] && !$time_slots['suborder']) {
        $response['error'] = true;
        $response['message'] = labels(SLOT_IS_NOT_AVAILABLE_AT_THIS_TIME, "Slot is not available at this time ");
    } else {
        $response['error'] = false;
        $response['message'] = labels(SLOT_IS_AVAILABLE_AT_THIS_TIME, "Slot is available at this time");
    }
    return $response;
}
function next_day_available_slots($closing_time, $requestedDuration, $booking_date, $partner_id, $available_slots, $required_duration, $current_date, $busy_slots)
{
    // //-------------------------------------for next day order start--------------------------------------------------
    $before_end_time = date('H:i:s', strtotime($closing_time) - (30 * 60));
    $remaining_duration = $required_duration - 30;
    $next_day_date = date('Y-m-d', strtotime($booking_date . ' +1 day'));
    $next_day = date('l', strtotime($next_day_date));
    $next_day_timings = getTimingOfDay($partner_id, $next_day);
    $next_day_booked_slots = booked_timings($partner_id, $next_day_date);
    $interval = 30 * 60;
    $next_day_opening_time = $next_day_timings['opening_time'];
    $next_day_ending_time = $next_day_timings['closing_time'];
    $next_start_time = strtotime($next_day_opening_time);
    $time = $next_day_opening_time;
    $ending_time_for_next_day_slot = date('H:i:s', strtotime($time . ' +' . $remaining_duration . ' minutes'));
    $next_start_time = strtotime($next_day_opening_time);
    $next_day_available_slots = [];
    $next_day_busy_slots = [];
    $next_day_array_of_time = [];
    if (!empty($next_day_booked_slots)) {
        while ($next_start_time < strtotime($ending_time_for_next_day_slot)) {
            $next_day_array_of_time[] = date("H:i:s", $next_start_time);
            $next_start_time += $interval;
        }
        //check that main order date's last slot is available or not and remaining duration is grater than 30 min
        if (in_array($before_end_time, $available_slots) && $required_duration > 30) {
            //creating time slot for next day   
            //check that next day suggested slots are available or not
            //if next day has  orders
            if (count($next_day_booked_slots) > 0) {
                for ($i = 0; $i < count($next_day_booked_slots); $i++) {
                    //loop on suggested time slots
                    for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                        //if suggested time slot is less than booked slot starting time or suggested time slot is greater than booked time slot starting time
                        if (strtotime($next_day_array_of_time[$j]) < strtotime($next_day_booked_slots[$i]['starting_time']) || strtotime($next_day_array_of_time[$j]) >= strtotime($next_day_booked_slots[$i]['ending_time'])) {
                            //check if suggested time slot is not  in array of avaialble slot
                            if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                                // echo "suggested slot is not in avaiable slot<br/>";
                                $next_day_available_slots[] = $next_day_array_of_time[$j];
                            } else {
                                if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                    $next_day_busy_slots[] = $next_day_array_of_time[$j];
                                }
                            }
                        } else {
                            if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                $next_day_busy_slots[] = $next_day_array_of_time[$j];
                            }
                        }
                    }
                    $count_next_busy_slots = count($next_day_busy_slots);
                    for ($k = 0; $k < $count_next_busy_slots; $k++) {
                        if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                            unset($next_day_available_slots[$key]);
                        }
                    }
                }
            } else {
                //loop on suggested time slots
                for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                    //check if suggested time slot is not  in array of avaialble slot
                    if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                        //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                        if (strtotime($next_day_date) != strtotime($current_date)) {
                            $next_day_available_slots[] = $next_day_array_of_time[$j];
                        } else {
                            if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                $next_day_busy_slots[] = $next_day_array_of_time[$j];
                            }
                        }
                    }
                }
                $count_next_busy_slots = count($next_day_busy_slots);
                for ($k = 0; $k < $count_next_busy_slots; $k++) {
                    if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                        unset($next_day_available_slots[$key]);
                    }
                }
            }
            $available_slots = array_values($available_slots);
            $all_continous_slot = calculate_continuous_slots($available_slots);
            $all_continous_slot_last_slots = $all_continous_slot[count($all_continous_slot) - 1];
            $continous_slot_last_slots = ($all_continous_slot_last_slots[count($all_continous_slot_last_slots) - 1]);
            // die;
            if ($before_end_time == $continous_slot_last_slots);
            // print_R('endind slot is avaialble </br>');
            // die;
            $next_day_all_continue_slot = calculate_continuous_slots($next_day_available_slots);
            // print_r( $next_day_all_continue_slot);
            // die;
            $next_day_available_duration = (count($next_day_all_continue_slot) * 30);
            $past_day_available_slot = count($all_continous_slot_last_slots) * 30;
            //  print_r( $next_day_all_continue_slot );
            $past_day_expected_available_duration = $required_duration - $next_day_available_duration;
            // print_R('past_day_expected_available_duration--' .$past_day_expected_available_duration."</br>");
            // print_R('past_day_available_slot--' .$past_day_available_slot."</br>");
            if ($past_day_expected_available_duration < 0 ||  $past_day_expected_available_duration < $past_day_available_slot) {
                if (count($next_day_available_slots) < count($next_day_array_of_time)) {
                    for ($k = 0; $k < count($available_slots); $k++) {
                        if (($key = array_search($before_end_time, $available_slots)) !== false) {
                            if (count($next_day_available_slots) < count($next_day_array_of_time)) {
                                // unset($available_slots[$key]);
                                // $busy_slots[] = $before_end_time;
                            }
                        }
                    }
                }
            }
        } else {
            for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                //check if suggested time slot is not  in array of avaialble slot
                if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                    //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                    if (strtotime($next_day_date) != strtotime($booking_date)) {
                        $next_day_available_slots[] = $next_day_array_of_time[$j];
                    } else {
                        if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                            $next_day_busy_slots[] = $next_day_array_of_time[$j];
                        }
                    }
                }
            }
            $count_next_busy_slots = count($next_day_busy_slots);
            for ($k = 0; $k < $count_next_busy_slots; $k++) {
                if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                    unset($next_day_available_slots[$key]);
                }
            }
            $available_slots = array_values($available_slots);
            // if (count($next_day_available_slots) < count($next_day_array_of_time)) {
            //     for ($k = 0; $k < count($available_slots); $k++) {
            //         if (($key = array_search($before_end_time, $available_slots)) !== false) {
            //             if (count($next_day_available_slots) < count($next_day_array_of_time)) {
            //                 unset($available_slots[$key]);
            //                 $busy_slots[] = $before_end_time;
            //             }
            //         }
            //     }
            // }
            $all_continous_slot = calculate_continuous_slots($available_slots);
            $all_continous_slot_last_slots = $all_continous_slot[count($all_continous_slot) - 1];
            $continous_slot_last_slots = ($all_continous_slot_last_slots[count($all_continous_slot_last_slots) - 1]);
            // die;
            if ($before_end_time == $continous_slot_last_slots);
            $next_day_all_continue_slot = calculate_continuous_slots($next_day_available_slots);
            $next_day_available_duration = (count($next_day_all_continue_slot) * 30);
            $past_day_available_slot = count($all_continous_slot_last_slots) * 30;
            $past_day_expected_available_duration = $required_duration - $next_day_available_duration;
            if ($past_day_expected_available_duration < 0 || $past_day_available_slot < $past_day_expected_available_duration) {
                if (count($next_day_available_slots) < count($next_day_array_of_time)) {
                    for ($k = 0; $k < count($available_slots); $k++) {
                        if (($key = array_search($before_end_time, $available_slots)) !== false) {
                            if (count($next_day_available_slots) < count($next_day_array_of_time)) {
                                // unset($available_slots[$key]);
                                // $busy_slots[] = $before_end_time;
                            }
                        }
                    }
                }
            }
        }
        $response['error'] = false;
        $response['available_slots'] = $available_slots;
        $response['busy_slots'] = $busy_slots;
        return $response;
    }
}
function getTimingArray($start_time, $end_time, $interval)
{
    $timing_array = [];
    $current_time = strtotime($start_time);
    $end_time = strtotime($end_time);
    while ($current_time < $end_time) {
        $timing_array[] = date('H:i:s', $current_time);
        $current_time += $interval * 60;
    }
    return $timing_array;
}
function get_next_days_slots($closing_time, $booking_date, $partner_id, $required_duration, $current_date)
{
    $remaining_duration = $required_duration - 30;
    $next_day_date = date('Y-m-d', strtotime($booking_date . ' +1 day'));
    $next_day = date('l', strtotime($next_day_date));
    $next_day_timings = getTimingOfDay($partner_id, $next_day);
    $next_day_booked_slots = booked_timings($partner_id, $next_day_date);
    $interval = 30 * 60;
    if (!empty($next_day_timings)) {
        $next_day_opening_time = $next_day_timings['opening_time'];
        $next_day_ending_time = $next_day_timings['closing_time'];
        $next_start_time = strtotime($next_day_opening_time);
        $time = $next_day_opening_time;
        $ending_time_for_next_day_slot = date('H:i:s', strtotime($time . ' +' . $remaining_duration . ' minutes'));
        $next_start_time = strtotime($next_day_opening_time);
        $next_day_available_slots = [];
        $next_day_busy_slots = [];
        $next_day_array_of_time = [];
        while ($next_start_time < strtotime($ending_time_for_next_day_slot)) {
            $next_day_array_of_time[] = date("H:i:s", $next_start_time);
            $next_start_time += $interval;
        }
        if (!empty($next_day_booked_slots)) {
            //check that main order date's last slot is available or not and remaining duration is grater than 30 min
            //creating time slot for next day   
            //check that next day suggested slots are available or not
            //if next day has  orders
            if (count($next_day_booked_slots) > 0) {
                for ($i = 0; $i < count($next_day_booked_slots); $i++) {
                    // echo "-------------------------</br>";
                    //loop on suggested time slots
                    for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                        //if suggested time slot is less than booked slot starting time or suggested time slot is greater than booked time slot starting time
                        if (strtotime($next_day_array_of_time[$j]) < strtotime($next_day_booked_slots[$i]['starting_time']) || strtotime($next_day_array_of_time[$j]) >= strtotime($next_day_booked_slots[$i]['ending_time'])) {
                            //check if suggested time slot is not  in array of avaialble slot
                            if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                                // echo $next_day_array_of_time[$j]."--suggested slot is adding in avaiable slot<br/>";
                                $next_day_available_slots[] = $next_day_array_of_time[$j];
                            } else {
                                // echo $next_day_array_of_time[$j]."--suggested slot is adding in busy slot 1<br/>";
                                // if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                //     $next_day_busy_slots[] = $next_day_array_of_time[$j];
                                // }
                            }
                        } else {
                            // echo $next_day_array_of_time[$j]."--suggested slot is adding in busy slot 2<br/>";
                            if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                $next_day_busy_slots[] = $next_day_array_of_time[$j];
                            }
                        }
                    }
                    $count_next_busy_slots = count($next_day_busy_slots);
                    for ($k = 0; $k < $count_next_busy_slots; $k++) {
                        if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                            unset($next_day_available_slots[$key]);
                        }
                    }
                }
            } else {
                //loop on suggested time slots
                for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                    //check if suggested time slot is not  in array of avaialble slot
                    if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                        //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                        if (strtotime($next_day_date) != strtotime($current_date)) {
                            $next_day_available_slots[] = $next_day_array_of_time[$j];
                        } else {
                            if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                                $next_day_busy_slots[] = $next_day_array_of_time[$j];
                            }
                        }
                    }
                }
                $count_next_busy_slots = count($next_day_busy_slots);
                for ($k = 0; $k < $count_next_busy_slots; $k++) {
                    if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                        unset($next_day_available_slots[$key]);
                    }
                }
            }
            $next_day_available_slots = array_values($next_day_available_slots);
            $all_continuos_slot = calculate_continuous_slots($next_day_available_slots);
            $response['error'] = false;
            $response['available_slots'] = $next_day_available_slots;
            $response['busy_slots'] = $next_day_busy_slots;
            $response['continous_available_slots'] = $all_continuos_slot;
            return $response;
        } else {
            //loop on suggested time slots
            for ($j = 0; $j < count($next_day_array_of_time); $j++) {
                //check if suggested time slot is not  in array of avaialble slot
                if (!in_array($next_day_array_of_time[$j], $next_day_available_slots)) {
                    //if suggested time slot is grater than current time and current date and booked date are not same then to available slot array otherwise busy slot array
                    if (strtotime($next_day_date) != strtotime($current_date)) {
                        $next_day_available_slots[] = $next_day_array_of_time[$j];
                    } else {
                        if (!in_array($next_day_array_of_time[$j], $next_day_busy_slots)) {
                            $next_day_busy_slots[] = $next_day_array_of_time[$j];
                        }
                    }
                }
            }
            $count_next_busy_slots = count($next_day_busy_slots);
            for ($k = 0; $k < $count_next_busy_slots; $k++) {
                if (($key = array_search($next_day_busy_slots[$k], $next_day_available_slots)) !== false) {
                    unset($next_day_available_slots[$key]);
                }
            }
            $next_day_available_slots = array_values($next_day_available_slots);
            $all_continuos_slot = calculate_continuous_slots($next_day_available_slots);
            $response['error'] = false;
            $response['available_slots'] = $next_day_available_slots;
            $response['busy_slots'] = $next_day_busy_slots;
            $response['continous_available_slots'] = $all_continuos_slot;
            return $response;
        }
    } else {
        $response['error'] = false;
        $response['available_slots'] = [];
        $response['busy_slots'] = [];
        $response['continous_available_slots'] = [];
        return $response;
    }
}
function calculate_continuous_slots($array_of_time)
{
    $available_slots = array_values($array_of_time);
    // creating chunks of countinuos time slots from available time slots
    $all_continous_slot = [];
    $continous_slot_number = 0;
    for ($i = 0; $i <= count($available_slots) - 1; $i++) {
        //here we add 30 minutes to  available time slot 
        $next_expected_time_slot = date("H:i:s", strtotime('+30 minutes', strtotime($available_slots[$i])));
        //here we check avaialable slot + 1  means if avaialbe slot is 9:00 then available slot +1 is 9:30 is same as expected time slot if yes then add to continue slot 
        // if (($available_slots[$i + 1] == $next_expected_time_slot)) {
        if (isset($available_slots[$i + 1]) && ($available_slots[$i + 1] == $next_expected_time_slot)) {
            $all_continous_slot[$continous_slot_number][] = $available_slots[$i];
            if (count($available_slots) == $i) {
                $all_continous_slot[$continous_slot_number][] = $available_slots[$i];
            }
        } else {
            $all_continous_slot[$continous_slot_number][] = $available_slots[$i];
            $continous_slot_number++;
        }
    }
    return $all_continous_slot;
}
function get_slot_for_place_order($partnerId, $date_of_service, $required_duration, $starting_time)
{
    // $day = date('l', strtotime($starting_time));
    $day = date('l', strtotime($date_of_service));
    $current_date = date('Y-m-d');
    $timings = getTimingOfDay($partnerId, $day);
    $response = [];
    if (isset($timings) && !empty($timings)) {
        $provider_closing_time = date('H:i:s', strtotime($timings['closing_time']));
        $expoloed_start_time = explode(':', $starting_time);
        $remaining_duration = $required_duration;
        $extra_minutes = '';
        if (($expoloed_start_time[1] > 15 && $expoloed_start_time[1] <= 30) || ($expoloed_start_time[1] > 45 && $expoloed_start_time[1] > 30)) {
            $rounded = date('H:i:s', ceil(strtotime($starting_time) / 1800) * 1800);
            $differenceBetweenRoundedTime = round(abs(strtotime($rounded) - strtotime($starting_time)) / 60, 2);
            $extra_minutes = 'deduct';
        } else {
            $rounded = date('H:i:s', floor(strtotime($starting_time) / 1800) * 1800);
            $differenceBetweenRoundedTime = round(abs(strtotime($starting_time) -  strtotime($rounded)) / 60, 2);
            $extra_minutes = 'add';
        }
        $time_slots = get_available_slots_without_processing($partnerId, $date_of_service, $required_duration, $rounded); //working
        if (!isset($time_slots['available_slots'][0])) {
            $response['suborder'] = false;
            $response['slot_avaialble'] = false;
            return $response;
        }
        $array_of_time = $time_slots['available_slots'][0];
        $array_of_time = array_values($array_of_time);
        if ($array_of_time[0] == $rounded) {
            $next_expected_time_slot = $rounded;
            foreach ($array_of_time as $row) {
                if ($row == $next_expected_time_slot && ($row < $provider_closing_time)) {
                    // print_R("row-- ".$row."</br>");
                    $next_expected_time_slot = date("H:i:s", strtotime('+30 minutes', strtotime($row)));
                    //  print_R("next slot -- ".$next_expected_time_slot."</br>");
                    $remaining_duration = $remaining_duration - 30;
                    // print_R("remaining duration -- ".$remaining_duration."</br>");
                }
            }
            if ($extra_minutes == "add") {
                $remaining_duration += $differenceBetweenRoundedTime;
            } else if ($extra_minutes == "deduct") {
                $remaining_duration -= $differenceBetweenRoundedTime;
            }
            // die;
            if ($remaining_duration <= 0) {
                $response['suborder'] = false;
                $response['slot_avaialble'] = true;
                $response['order_data'] =  $time_slots['available_slots'][0];
            } else {
                $next_day_slots = get_next_days_slots($provider_closing_time, $date_of_service, $partnerId, $required_duration, $current_date);
                $next_day_available_slots = $next_day_slots['available_slots'];
                if ((sizeof($next_day_available_slots) * 30) >= $remaining_duration) {
                    $response['suborder'] = true;
                    $response['suborder_data'] = $next_day_available_slots;
                    $response['order_data'] =  $time_slots['available_slots'][0];
                    $response['slot_avaialble'] = true;
                } else {
                    $response['suborder'] = false;
                    $response['slot_avaialble'] = false;
                }
            }
        } else {
            $response['suborder'] = false;
            $response['slot_avaialble'] = false;
        }
    } else {
        $response['closed'] = "true";
        $response['suborder'] = false;
        $response['slot_avaialble'] = false;
    }
    return $response;
}
function get_service_ratings($service_id)
{
    $db = \config\Database::connect();

    // Get the partner_id (user_id) for this service first
    $serviceData = $db->query("SELECT user_id FROM services WHERE id = {$service_id}")->getRowArray();
    $partnerId = $serviceData['user_id'] ?? null;

    if (!$partnerId) {
        // Return default values if service not found
        $db->close();
        return [['total_ratings' => 0, 'total_rating' => null, 'average_rating' => null, 'rating_5' => 0, 'rating_4' => 0, 'rating_3' => 0, 'rating_2' => 0, 'rating_1' => 0]];
    }

    // Use the SAME logic as Service_ratings_model to ensure consistency
    // This query calculates rating statistics for ALL ratings of the partner who owns this service
    $query = "
        SELECT 
            COUNT(sr.rating) AS total_ratings,
            SUM(sr.rating) AS total_rating,
            (SUM(sr.rating) / COUNT(sr.rating)) AS average_rating,
            SUM(CASE WHEN sr.rating = 5 THEN 1 ELSE 0 END) AS rating_5,
            SUM(CASE WHEN sr.rating = 4 THEN 1 ELSE 0 END) AS rating_4,
            SUM(CASE WHEN sr.rating = 3 THEN 1 ELSE 0 END) AS rating_3,
            SUM(CASE WHEN sr.rating = 2 THEN 1 ELSE 0 END) AS rating_2,
            SUM(CASE WHEN sr.rating = 1 THEN 1 ELSE 0 END) AS rating_1
        FROM services_ratings sr
        LEFT JOIN services s ON sr.service_id = s.id
        WHERE (s.user_id = {$partnerId} OR (sr.custom_job_request_id IS NOT NULL AND EXISTS (SELECT 1 FROM partner_bids pbid WHERE pbid.custom_job_request_id = sr.custom_job_request_id AND pbid.partner_id = {$partnerId})))
    ";

    $rating_data = $db->query($query)->getResultArray();


    $db->close();
    return $rating_data;
}
function calculate_subscription_price($subcription_id)
{
    $subscription_details = fetch_details('subscriptions', ['id' => $subcription_id]);
    $taxPercentageData = fetch_details('taxes', ['id' => $subscription_details[0]['tax_id']], ['percentage']);
    if (!empty($taxPercentageData)) {
        $taxPercentage = $taxPercentageData[0]['percentage'];
    } else {
        $taxPercentage = 0;
    }
    $subscription_details[0]['tax_percentage'] = $taxPercentage;
    if (!empty($subscription_details[0]['discount_price']) && $subscription_details[0]['discount_price'] == "0") {
        if (!empty($subscription_details[0]['tax_type']) && isset($subscription_details[0]['tax_type']) && $subscription_details[0]['tax_type'] == "excluded") {
            $subscription_details[0]['tax_value'] = number_format((intval(($subscription_details[0]['price'] * ($taxPercentage) / 100))), 2);
            $subscription_details[0]['price_with_tax']  = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price'] + ($subscription_details[0]['price'] * ($taxPercentage) / 100)) : 0;
            $subscription_details[0]['original_price_with_tax'] = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price'] + ($subscription_details[0]['price'] * ($taxPercentage) / 100)) : 0;
        } else {
            $subscription_details[0]['tax_value'] = 0;
            $subscription_details[0]['price_with_tax']  = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price']) : 0;
            $subscription_details[0]['original_price_with_tax'] = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price']) : 0;
        }
    } else {
        if (!empty($subscription_details[0]['tax_type']) && isset($subscription_details[0]['tax_type']) && $subscription_details[0]['tax_type'] == "excluded") {
            $subscription_details[0]['tax_value'] = number_format((intval(($subscription_details[0]['discount_price'] * ($taxPercentage) / 100))), 2);
            $subscription_details[0]['price_with_tax']  = !empty($subscription_details[0]['discount_price']) && isset($subscription_details[0]['discount_price']) ? strval($subscription_details[0]['discount_price'] + ($subscription_details[0]['discount_price'] * ($taxPercentage) / 100)) : 0;
            $subscription_details[0]['original_price_with_tax'] = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price'] + ($subscription_details[0]['discount_price'] * ($taxPercentage) / 100)) : 0;
        } else {
            $subscription_details[0]['tax_value'] = 0;
            $subscription_details[0]['price_with_tax']  = !empty($subscription_details[0]['discount_price']) && isset($subscription_details[0]['discount_price']) ? strval($subscription_details[0]['discount_price']) : 0;
            $subscription_details[0]['original_price_with_tax'] = !empty($subscription_details[0]['price']) && isset($subscription_details[0]['price']) ? strval($subscription_details[0]['price']) : 0;
        }
    }
    return $subscription_details;
}
function calculate_partner_subscription_price($partner_id, $subscription_id, $id)
{
    $partner_subscriptions = fetch_details('partner_subscriptions', [
        'partner_id'      => $partner_id,
        'subscription_id' => $subscription_id,
        'id'              => $id
    ]);

    // log_message('debug', 'partner id is: ' . $partner_id);
    // log_message('debug', 'subscription id is: ' . $subscription_id);
    // log_message('debug', 'id is: ' . $id);

    // log_message('debug', 'partner_subscription is: ' . json_encode($partner_subscriptions));
    $sub = &$partner_subscriptions[0]; // keep [0] dependency
    $sub['tax_percentage'] = !empty($sub['tax_percentage']) ? $sub['tax_percentage'] : 0;
    $price = (!empty($sub['discount_price']) && $sub['discount_price'] != "0") ? $sub['discount_price'] : $sub['price'];

    if (!empty($sub['tax_type']) && $sub['tax_type'] === "excluded") {
        $sub['tax_value'] = number_format(($price * $sub['tax_percentage'] / 100), 2, '.', '');
        $sub['price_with_tax'] = strval($price + ($price * $sub['tax_percentage'] / 100));
        $sub['original_price_with_tax'] = strval($sub['price'] + ($sub['price'] * $sub['tax_percentage'] / 100));
    } else {
        $sub['tax_value'] = 0;
        $sub['price_with_tax'] = strval($price);
        $sub['original_price_with_tax'] = strval($sub['price']);
    }

    return $partner_subscriptions;
}

function add_subscription($subscription_id, $partner_id, $insert_id = null)
{
    $settings = get_settings('general_settings', true);
    date_default_timezone_set($settings['system_timezone']); // Added user timezone
    $subscription_details = fetch_details('subscriptions', ['id' => $subscription_id]);
    if ($subscription_details[0]['price'] == "0") {
        $price = calculate_subscription_price($subscription_details[0]['id']);;
        $purchaseDate = date('Y-m-d');
        $subscriptionDuration = $subscription_details[0]['duration'];
        if ($subscriptionDuration == "unlimited") {
            $subscriptionDuration = 0;
        }
        $expiryDate = date('Y-m-d', strtotime($purchaseDate . ' + ' . $subscriptionDuration . ' days'));
        $partner_subscriptions = [
            'partner_id' =>  $partner_id,
            'subscription_id' => $subscription_id,
            'is_payment' => "1",
            'status' => "active",
            'purchase_date' => date('Y-m-d'),
            'expiry_date' =>  $expiryDate,
            'name' => $subscription_details[0]['name'],
            'description' => $subscription_details[0]['description'],
            'duration' => $subscription_details[0]['duration'],
            'price' => $subscription_details[0]['price'],
            'discount_price' => $subscription_details[0]['discount_price'],
            'publish' => $subscription_details[0]['publish'],
            'order_type' => $subscription_details[0]['order_type'],
            'max_order_limit' => $subscription_details[0]['max_order_limit'],
            'service_type' => $subscription_details[0]['service_type'],
            'max_service_limit' => $subscription_details[0]['max_service_limit'],
            'tax_type' => $subscription_details[0]['tax_type'],
            'tax_id' => $subscription_details[0]['tax_id'],
            'is_commision' => $subscription_details[0]['is_commision'],
            'commission_threshold' => $subscription_details[0]['commission_threshold'],
            'commission_percentage' => $subscription_details[0]['commission_percentage'],
            'transaction_id' => '0',
            'tax_percentage' => $price[0]['tax_percentage'],
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        $data = insert_details($partner_subscriptions, 'partner_subscriptions');
        $inserted_subscription = fetch_details('partner_subscriptions', ['id' => $data['id']]);
        if ($inserted_subscription[0]['is_commision'] == "yes") {
            $commission = $inserted_subscription[0]['commission_percentage'];
        } else {
            $commission = 0;
        }
        update_details(['admin_commission' => $commission], ['partner_id' => $partner_id], 'partner_details');
        return true;
    } else {
        if ($subscription_details[0]['is_commision'] == "yes") {
            $commission = $subscription_details[0]['commission_percentage'];
        } else {
            $commission = 0;
        }
        update_details(['admin_commission' => $commission], ['partner_id' => $partner_id], 'partner_details');
        $details_for_subscription = fetch_details('subscriptions', ['id' => $subscription_id]);
        $subscriptionDuration = $details_for_subscription[0]['duration'];
        // Calculate the expiry date based on the current date and subscription duration
        $purchaseDate = date('Y-m-d'); // Get the current date
        if ($subscriptionDuration == "unlimited") {
            $subscriptionDuration = 0;
        }
        $expiryDate = date('Y-m-d', strtotime($purchaseDate . ' + ' . $subscriptionDuration . ' days')); // Add the duration to the purchase date
        $taxPercentageData = fetch_details('taxes', ['id' => $details_for_subscription[0]['tax_id']], ['percentage']);
        if (!empty($taxPercentageData)) {
            $taxPercentage = $taxPercentageData[0]['percentage'];
        } else {
            $taxPercentage = 0;
        }
        $partner_subscriptions = [
            'partner_id' =>  $partner_id,
            'subscription_id' => $subscription_id,
            'is_payment' => "0",
            'status' => "pending",
            'purchase_date' => $purchaseDate,
            'expiry_date' => $expiryDate,
            'name' => $details_for_subscription[0]['name'],
            'description' => $details_for_subscription[0]['description'],
            'duration' => $details_for_subscription[0]['duration'],
            'price' => $details_for_subscription[0]['price'],
            'discount_price' => $details_for_subscription[0]['discount_price'],
            'publish' => $details_for_subscription[0]['publish'],
            'order_type' => $details_for_subscription[0]['order_type'],
            'max_order_limit' => $details_for_subscription[0]['max_order_limit'],
            'service_type' => $details_for_subscription[0]['service_type'],
            'max_service_limit' => $details_for_subscription[0]['max_service_limit'],
            'tax_type' => $details_for_subscription[0]['tax_type'],
            'tax_id' => $details_for_subscription[0]['tax_id'],
            'is_commision' => $details_for_subscription[0]['is_commision'],
            'commission_threshold' => $details_for_subscription[0]['commission_threshold'],
            'commission_percentage' => $details_for_subscription[0]['commission_percentage'],
            'transaction_id' => $insert_id,
            'tax_percentage' => $taxPercentage,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        ];
        insert_details($partner_subscriptions, 'partner_subscriptions');
        return true;
    }
}
if (!function_exists('format_date')) {
    function format_date($dateString, $format = 'Y-m-d H:i:s')
    {
        $date = date_create($dateString);
        return date_format($date, $format);
    }
}
function uploadFile($request, $fieldName, $uploadPath, &$updatedData, $data)
{
    $file = $request->getFile($fieldName);
    if ($file->isValid()) {
        $newName = $file->getRandomName();
        $file->move($uploadPath, $newName);
        $updatedData[$fieldName] = $newName;
    } else {
        $updatedData[$fieldName] = isset($data[$fieldName]) ? $data[$fieldName] : "";
    }
}
function verify_transaction($order_id)
{
    $transaction = fetch_details('transactions', ['order_id' => $order_id]);
    if (!empty($transaction)) {
        if ($transaction[0]['type'] == "razorpay") {
            $razorpay = new Razorpay;
            $credentials = $razorpay->get_credentials();
            $secret = $credentials['secret'];
            $api = new Api($credentials['key'], $secret);
            $payment = $api->payment->fetch($transaction[0]['txn_id']);
            $status = $payment->status;
            if ($status != "captured") {
                update_details(['payment_status' => '1'], ['id' => $order_id], 'orders');
                $response['error'] = false;
                $response['message'] = 'Verified Successfully';
            } else if ($status != "captured") {
                update_details(['status' => 'cancelled'], ['id' => $order_id], 'orders');
                $response['error'] = true;
                $response['message'] = 'Booking is cancelled due to pending payment .';
            }
        } elseif ($transaction[0]['type'] == "stripe") {
            $settings = get_settings('payment_gateways_settings', true);
            $secret_key = isset($settings['stripe_secret_key']) ? $settings['stripe_secret_key'] : "sk_test_51LERZeSCiHzi4IW1hODcT6ngl88bSZzN4SHqH58CFKJ7eEQKSzniJTXgVNXFQPXuKfu9pAOYVMOe6UeE2q7hY5J400qllsvrye";
            $http = service('curlrequest');
            $http->setHeader('Authorization', 'Bearer ' . $secret_key);
            $http->setHeader('Content-Type', 'application/x-www-form-urlencoded');
            $response = $http->get("https://api.stripe.com/v1/payment_intents/{$transaction[0]['txn_id']}");
            $responseData = json_decode($response->getBody(), true);
            $statusOfTransaction = $responseData['status'];
            if ($statusOfTransaction == "succeeded") {
                update_details(['payment_status' => '1'], ['id' => $order_id], 'orders');
                $response['error'] = false;
                $response['message'] = 'Verified Successfully';
            } else if ($statusOfTransaction != "succeeded") {
                update_details(['status' => 'cancelled'], ['id' => $order_id], 'orders');
                $response['error'] = true;
                $response['message'] = 'Booking is cancelled due to pending payment .';
            }
        } else if ($transaction[0]['type'] = "paystack") {
            $paystack = new Paystack();
            $payment = $paystack->verify_transation($transaction[0]['reference']);
            $message = json_decode($payment, true);
            if ($message['status'] == "1" || $message['status'] == "success") {
                update_details(['payment_status' => '1'], ['id' => $order_id], 'orders');
                $response['error'] = false;
                $response['message'] = 'Verified Successfully';
            } else if ($message['status'] != "1" || $message['status'] != "success") {
                update_details(['status' => 'cancelled'], ['id' => $order_id], 'orders');
                $response['error'] = true;
                $response['message'] = 'Booking is cancelled due to pending payment .';
            }
        }
        return $response;
    }
}
function create_stripe_payment_intent()
{
    $settings = get_settings('payment_gateways_settings', true);
    $secret_key = $settings['stripe_secret_key'] ?? "sk_test_51LERZeSCiHzi4IW1hODcT6ngl88bSZzN4SHqH58CFKJ7eEQKSzniJTXgVNXFQPXuKfu9pAOYVMOe6UeE2q7hY5J400qllsvrye";
    $data = [
        'amount' => 100,
        'currency' => 'usd',
        'description' => 'Test',
        'payment_method_types' => ['card'],
        'metadata' => [
            'user_id' => 1,
            'competition_id' => 1,
        ],
        'shipping' => [
            'name' => 'TEST',
            'address' => [
                'country' => "in",
            ],
        ],
    ];
    $body = http_build_query($data);
    $response = \Config\Services::curlrequest()
        ->setHeader('Authorization', 'Bearer ' . $secret_key)
        ->setHeader('Content-Type', 'application/x-www-form-urlencoded')
        ->setBody($body)
        ->post('https://api.stripe.com/v1/payment_intents');
    $responseData = json_decode($response->getBody(), true);
    return $responseData;
}
function razorpay_create_order_for_place_order($order_id)
{
    $order_id = $order_id;
    if ($order_id && !empty($order_id)) {
        $where['o.id'] = $order_id;
    }
    $orders = new Orders_model();
    $order_detail = $orders->list(true, "", null, null, "", "", $where);
    $settings = get_settings('payment_gateways_settings', true);
    if (!empty($order_detail) && !empty($settings)) {
        $currency = $settings['razorpay_currency'];
        $price = $order_detail['data'][0]['final_total'];
        $amount = intval($price * 100);
        $razorpay = new Razorpay();
        $create_order = $razorpay->create_order($amount, $order_id, $currency);
        if (!empty($create_order)) {
            $response = [
                'error' => false,
                'message' => 'razorpay order created',
                'data' => $create_order,
            ];
        } else {
            $response = [
                'error' => true,
                'message' => 'razorpay order not created',
                'data' => [],
            ];
        }
    } else {
        $response = [
            'error' => true,
            'message' => 'details not found"',
            'data' => [],
        ];
    }
    return $response;
}
function create_order_paypal_for_place_order()
{
    $clientId = '123';
    $secret = '123';
    // Step 1: Generate a new access token
    $clientId = '123';
    $secret = '123';
    $client = new Client();
    try {
        $tokenResponse = $client->request('POST', 'https://api-m.sandbox.paypal.com/v1/oauth2/token', [
            'form_params' => [
                'grant_type' => 'client_credentials',
            ],
            'auth' => [$clientId, $secret],
        ]);
        $tokenData = json_decode($tokenResponse->getBody(), true);
        $accessToken = $tokenData['access_token'];
        // Step 2: Make the API request with the new access token
        $uri = 'https://api-m.sandbox.paypal.com/v2/checkout/orders';
        $payload = [
            'intent' => 'CAPTURE',
            'purchase_units' => [
                [
                    'amount' => [
                        'currency_code' => 'USD',
                        'value' => '100.00',
                    ]
                ]
            ],
        ];
        $response = $client->request('POST', $uri, [
            'json' => $payload,
            'headers' => [
                'Accept' => 'application/json',
                'Accept-Language' => 'en_US',
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $accessToken,
            ],
        ]);
        $data = json_decode($response->getBody(), true);
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    } catch (ClientException $e) {
        // Handle 401 Unauthorized error
        echo 'Error Code: ' . $e->getCode() . "\n";
        echo 'Error Message: ' . $e->getMessage() . "\n";
        // You can also get detailed error response from $e->getResponse()
    }
}
function add_settlement_cashcollection_history($message, $type, $date, $time, $amount, $provider_id = null, $order_id = null, $payment_request_id = null, $commission_percentage = null, $total_amount = null, $commision_amount = null)
{
    $settlement_cashcollection_history = [
        'provider_id' => $provider_id,
        'order_id' => $order_id,
        'payment_request_id' => $payment_request_id,
        'commission_percentage' => $commission_percentage,
        'message' => $message,
        'type' => $type,
        'date' => $date,
        'time' => $time,
        'amount' => $amount,
        'total_amount' => $total_amount,
        'commission_amount' => $commision_amount,
    ];
    insert_details($settlement_cashcollection_history, 'settlement_cashcollection_history');
}
function partner_settlement_and_cash_collection_history_status($status, $panel_type)
{
    $value = '';
    if ($panel_type == "admin") {
        if ($status == "cash_collection_by_provider") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('debit', 'Debit') . "
            </div>";
        } else if ($status == "cash_collection_by_admin") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('credit', 'Credit') . "
            </div>";
        } else if ($status == "received_by_admin") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('credit', 'Credit') . "
            </div>";
        } else if ($status == "settled_by_settlement") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('debit', 'Debit') . "
        </div>";
        } else if ($status == "settled_by_payment_request") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('debit', 'Debit') . "
        </div>";
        }
    } else if ($panel_type == "provider") {
        if ($status == "cash_collection_by_provider") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('credit', 'Credit') . "
            </div>";
        } else if ($status == "cash_collection_by_admin") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('debit', 'Debit') . "
            </div>";
        } else if ($status == "received_by_admin") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('debit', 'Debit') . "
        </div>";
        } else if ($status == "settled_by_settlement") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('credit', 'Credit') . "
            </div>";
        } else if ($status == "settled_by_payment_request") {
            $value = "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('credit', 'Credit') . "
            </div>";
        }
    }
    return $value;
}
function partner_settlement_and_cash_collection_history_type($type)
{
    if ($type == "cash_collection_by_provider") {
        $value = labels("cash_collection_by_provider", "Cash Collection By Provider");
    } else if ($type == "cash_collection_by_admin") {
        $value = labels("cash_collection_by_admin", "Cash Collection By Admin");
    } else if ($type == "received_by_admin") {
        $value = labels("received_by_admin", "Received By Admin");
    } else if ($type == "settled_by_settlement") {
        $value = labels("settled_by_settlement", "Settled By settlement");
    } else if ($type == "settled_by_payment_request") {
        $value = labels("settled_by_payment_request", "Settled By Payment Request");
    }
    return $value;
}
function fetch_chat_ids($table, $type, $where = [], $fields = [], $limit = "", $offset = '0', $sort = 'id', $order = 'DESC', $or_like = [],)
{
    $db = \Config\Database::connect();
    $builder = $db->table($table);
    if (!empty($fields)) {
        $builder->select($fields);
    }
    if (!empty($where)) {
        $builder->where($where);
    }
    if (!empty($or_like)) {
        $builder->groupStart();
        foreach ($or_like as $field => $values) {
            $builder->whereIn($field, $values);
        }
        $builder->groupEnd();
    }
    $builder->orderBy($sort, $order);
    if (!empty($limit)) {
        $builder->limit($limit, $offset);
    }
    $query = $builder->get();
    if ($type == "customer") {
        $ids = [];
        foreach ($query->getResultArray() as $row) {
            $ids[] = $row['customer_id'];
        }
    } else if ($type == "provider") {
        $ids = [];
        foreach ($query->getResultArray() as $row) {
            $ids[] = $row['provider_id'];
        }
    }
    $db->close();
    return $ids;
}
function add_enquiry_for_chat($user_type, $enquiry_user_id, $for_booking = false, $booking_id = null)
{
    $user_type = $user_type;
    if ($user_type == "provider") {
        $enquiry_field = 'provider_id';
    } else if ($user_type == "customer") {
        $enquiry_field = 'customer_id';
    }
    if ($for_booking && $user_type == "customer") {
        $is_already_exist_query = fetch_details('enquiries', [$enquiry_field => $enquiry_user_id, 'booking_id' => $booking_id]);
    } else {
        $is_already_exist_query = fetch_details('enquiries', [$enquiry_field => $enquiry_user_id, 'booking_id' => $booking_id]);
    }
    if (empty($is_already_exist_query)) {
        $user = fetch_details('users', ['id' => $enquiry_user_id])[0];
        $data['title'] =  $user['username'] . '_query';
        $data['status'] =  1;
        if ($user_type == "provider") {
            $data['userType'] =  1;
            $data['provider_id'] = $enquiry_user_id;
        } else if ($user_type == "customer") {
            $data['userType'] =  2;
            $data['customer_id'] = $enquiry_user_id;
        }
        if ($for_booking && $user_type == "customer") {
            $data['booking_id'] = $booking_id;
        }
        $data['date'] =  now();
        $store = insert_details($data, 'enquiries');
        $e_id = $store['id'];
    } else {
        $e_id = $is_already_exist_query[0]['id'];
    }
    return $e_id;
}
function insert_chat_message_for_chat($sender_id, $receiver_id, $message, $e_id, $sender_type, $receiver_type, $created_at, $upload_attachment = false, array $file = null, $booking_id = null)
{
    $data = [
        'sender_id' => $sender_id,
        'receiver_id' => $receiver_id,
        'message' => $message,
        'e_id' => $e_id,
        'sender_type' => $sender_type,
        'receiver_type' => $receiver_type,
        'created_at' => $created_at,
        'booking_id' => $booking_id
    ];

    $path = './public/uploads/chat_attachment/';
    $uploaded_files = [];
    if ($upload_attachment && !empty($file)) {
        if (!is_dir($path)) {
            mkdir($path, 0775, true);
        }
        foreach ($file['tmp_name'] as $key => $tmp_name) {
            $file_type = $file['type'][$key];
            $file_size = $file['size'][$key];
            $file_name = $file['name'][$key];
            $uploadedFile = new UploadedFile(
                $file['tmp_name'][$key],
                $file['name'][$key],
                $file['type'][$key],
                $file['size'][$key],
                $file['error'][$key]
            );
            $result = upload_file($uploadedFile, 'public/uploads/chat_attachment', "Error creating chat attachements", 'chat_attachment');
            if ($result['disk'] == "local_server") {
                $file_name = $path . $result['file_name'];
            } else if ($result['disk'] == "aws_s3") {
                $file_name = $result['file_name'];
            }
            $uploaded_files[] = ['file' => $file_name, 'file_type' => $file_type, 'file_size' => $file_size, 'file_name' => $result['file_name']];
        }
    }

    $disk = fetch_current_file_manager();
    $data['file'] = json_encode($uploaded_files);
    $chat_message = insert_details($data, 'chats');
    $db = \Config\Database::connect();
    $builder = $db->table('chats c');
    $builder->select('c.*,u.username,u.image,u.id as user_id')
        ->join('users u', 'u.id = c.sender_id')
        ->where(['c.id' =>  $chat_message['id']]);
    $chat = $builder->get()->getResultArray();
    if (!empty($chat)) {
        if (!empty($chat[0]['file'])) {
            $decodedFiles = json_decode($chat[0]['file'], true); // Decode the JSON string to an array
            $chat[0]['file'] = []; // Initialize the array to store the transformed data
            foreach ($decodedFiles as $data_file) {
                if ($disk == "local_server") {
                    $file = base_url($data_file['file']);
                } else if ($disk == "aws_s3") {
                    $file = fetch_cloud_front_url('chat_attachment', $data_file['file']);
                } else {
                    $file = base_url($data_file['file']);
                }
                $chat[0]['file'][] = [
                    'file' => $file,
                    'file_type' => $data_file['file_type'],
                    'file_size' => $data_file['file_size'],
                    'file_name' => $data_file['file_name']
                ];
            }
        } else {
            $chat[0]['file'] = is_array($chat[0]['file']) ? [] : "";
        }
        if (isset($chat[0]['image'])) {
            $imagePath = $chat[0]['image'];
            if ($disk == "local_server") {
                $chat[0]['profile_image'] = fix_provider_path($imagePath);
            } else if ($disk == "aws_s3") {
                $chat[0]['profile_image'] = fetch_cloud_front_url('profile', $chat[0]['image']);
            } else {
                $chat[0]['profile_image'] = fix_provider_path($imagePath);
            }
        }
        $chat_last_message_date = fetch_details('chats', ['e_id' => $chat[0]['e_id']], ['id', 'created_at'], 1, 0, 'created_at', 'DESC');
        if (!empty($chat_last_message_date)) {
            $last_date = $chat_last_message_date[0]['created_at'];
        } else {
            $last_date = now();
        }
        $chat[0]['last_message_date'] = $last_date;
    }
    $db->close();
    return $chat[0];
}
function fix_provider_path($imagePath)
{
    $image = "";
    if (empty($imagePath) || $imagePath == NULL) {
        return $image;
    }
    if (strpos($imagePath, '/public/backend/assets/profiles/') === 0) {
        $image = $imagePath;
    } elseif (file_exists(FCPATH . 'public/backend/assets/profiles/' . $imagePath)) {
        $image = base_url('public/backend/assets/profiles/' . $imagePath);
    } else {
        $image = base_url($imagePath);
    }
    if (empty($image)) {
        $image  = base_url('public/backend/assets/profiles/default.png');
    }
    return $image;
}
function getSenderReceiverDataForChatNotification($sender_id, $receiver_id, $chat_id, $last_chat_date, $view_user_type, $when_customer_is_receiver = null)
{
    $db = \Config\Database::connect();
    $disk = fetch_current_file_manager();
    if ($view_user_type == "admin") {
        $receiver_details = $db->table('users u')->select('u.id,u.image,u.username')->where('u.id', $receiver_id)->get()->getResultArray();
        $receiver_details = !empty($receiver_details) ? $receiver_details[0] : [];

        if (isset($receiver_details['image'])) {
            if ($disk == "local_server") {
                $imagePath = $receiver_details['image'];
                $receiver_details['image'] = fix_provider_path($imagePath) ?? "";
            } else if ($disk == 'aws_s3') {
                $receiver_details['image'] = fetch_cloud_front_url('profile', $receiver_details['image']);
            } else {
                $imagePath = $receiver_details['image'];
                $receiver_details['image'] = fix_provider_path($imagePath) ?? "";
            }
        } else {
            $receiver_details['image'] = base_url("/public/backend/assets/profiles/default.png");
        }
    } else if ($view_user_type == "provider" || $view_user_type == "provider_booking") {
        if ($when_customer_is_receiver == "yes") {
            $receiver_details = $db->table('users u')->select('u.id,u.image,u.username')->where('u.id', $receiver_id)->get()->getResultArray();
            $receiver_details = !empty($receiver_details) ? $receiver_details[0] : [];
        } else {
            $receiver_details = $db->table('users u')->select('u.id,u.image,pd.company_name as username')->where('u.id', $receiver_id)->join('partner_details pd', 'pd.partner_id = u.id')->get()->getResultArray();
            $receiver_details = !empty($receiver_details) ? $receiver_details[0] : [];
        }
        if (isset($receiver_details['image'])) {
            if ($disk == "local_server") {
                $imagePath = $receiver_details['image'];
                $receiver_details['image'] = fix_provider_path($imagePath) ?? "";
            } else if ($disk == 'aws_s3') {
                $receiver_details['image'] = fetch_cloud_front_url('profile', $receiver_details['image']);
            } else {
                $imagePath = $receiver_details['image'];
                $receiver_details['image'] = fix_provider_path($imagePath) ?? "";
            }
        } else {
            $receiver_details['image'] = base_url("/public/backend/assets/profiles/default.png");
        }
    }
    $sender_details = fetch_details('users', ['id' => $sender_id], ['id', 'username', 'image']);

    if (isset($sender_details['image'])) {
        if ($disk == "local_server") {
            $imagePath = $sender_details['image'];
            $sender_details['image'] = fix_provider_path($imagePath) ?? "";
        } else if ($disk == 'aws_s3') {
            $sender_details['image'] = fetch_cloud_front_url('profile', $sender_details['image']);
        } else {
            $sender_details['image'] = fix_provider_path($sender_details['image']) ?? "";
        }
    } else {
        $sender_details['image'] = base_url("/public/backend/assets/profiles/default.png");
    }
    $builder = $db->table('chats c');
    $builder->select('c.*,u.username,u.image,u.id as user_id')
        ->join('users u', 'u.id = c.sender_id')
        ->where(['c.id' =>  $chat_id]);
    $chat = $builder->get()->getResultArray();
    $db->close();

    if (!empty($chat)) {
        if (!empty($chat[0]['file'])) {
            $decodedFiles = json_decode($chat[0]['file'], true); // Decode the JSON string into an array
            $chat[0]['file'] = []; // Initialize the array to store the formatted data
            foreach ($decodedFiles as $data) {
                if ($disk == "local_server") {
                    $file = base_url($data['file']);
                } else if ($disk == "aws_s3") {
                    $file = fetch_cloud_front_url('chat_attachment', $data['file']);
                } else {
                    $file = base_url($data['file']);
                }
                $chat[0]['file'][] = [
                    'file' => $file,
                    'file_type' => $data['file_type'],
                    'file_name' => $data['file_name'],
                    'file_size' => $data['file_size'],
                ];
            }
        } else {
            $chat[0]['file'] = is_array($chat[0]['file']) ? [] : "";
        }
        if (isset($chat[0]['image'])) {
            if ($disk == "local_server") {
                $imagePath = $chat[0]['image'];
                $chat[0]['profile_image'] = fix_provider_path($imagePath) ?? "";
            } else if ($disk == "aws_s3") {
                $chat[0]['profile_image'] = fetch_cloud_front_url('profile', $chat[0]['image']);
            } else {
                $imagePath = $chat[0]['image'];
                $chat[0]['profile_image'] = fix_provider_path($imagePath) ?? "";
            }
        } else {
            $chat[0]['profile_image'] = base_url("/public/backend/assets/profiles/default.png");
        }
        $chat[0]['last_message_date'] = $last_chat_date;
        $data = $chat[0];
    }
    $data['sender_details'] = $sender_details;
    $data['receiver_details'] = $receiver_details;
    $data['last_message_date'] = $last_chat_date;
    $data['viewer_type'] = $view_user_type;

    return $data;
}
function getLastMessageDateFromChat($e_id)
{
    $chat_last_message_date = fetch_details('chats', ['e_id' => $e_id], ['id', 'created_at'], 1, 0, 'created_at', 'DESC');
    if (!empty($chat_last_message_date)) {
        $last_date = $chat_last_message_date[0]['created_at'];
    } else {
        $last_date1 = new DateTime();
        $last_date = $last_date1->format('Y-m-d H:i:s');
    }
    return $last_date;
}
function checkModificationInDemoMode($superadminEmail)
{
    if ($superadminEmail == "superadmin@gmail.com") {
        return true;
    } else {
        if (defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 1) {
            return true;
        } else {
            $response['error'] = true;
            $response['message'] = labels(DEMO_MODE_ERROR, 'Modification in demo version is not allowed.');
            $response['csrfName'] = csrf_token();
            $response['csrfHash'] = csrf_hash();
            return $response;
        }
    }
}
function setPageInfo(&$data, $title, $mainPage)
{
    $data['title'] = $title;
    $data['main_page'] = $mainPage;
}
function getAccessToken()
{
    $filePath = (FCPATH . '/public/firebase_config.json');
    if (!file_exists($filePath)) {
        log_message('error', 'Firebase service account file not found at: ' . $filePath);
        return false;
    }
    $client = new Client();
    $client->setAuthConfig($filePath);
    $client->setScopes(['https://www.googleapis.com/auth/firebase.messaging']);
    $accessToken = $client->fetchAccessTokenWithAssertion()['access_token'];
    return $accessToken;
}
function sendNotificationToFCM($url, $access_token, $Data)
{
    $headers = [
        'Authorization: Bearer ' . $access_token,
        'Content-Type: application/json',
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $Data);
    $result = curl_exec($ch);

    // log_message('error', 'The notification send reponse is ' . json_encode($result));
    if (!empty($result['error']['code']) && $result['error']['code'] == "404") {
        return false;
        // die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    return true;
}
function send_web_notification1($fcmMsg, $registrationIDs_chunks)
{
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = $settings['value'];
    $settings = json_decode($settings, true);
    $message1 = [];
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';
    foreach ($registrationIDs_chunks[0] as $registrationIDs) {
        $message1 = [
            "message" => [
                "token" => $registrationIDs['fcm_id'],
                "data" => $fcmMsg,
                // Android notification
                "android" => [
                    "notification" => [
                        "title" => $fcmMsg["title"],
                        "body" => $fcmMsg["body"],
                        "sound" => $fcmMsg["type"] == "order" || $fcmMsg["type"] == "new_order" ? "order_sound" : "default",
                        "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                    ]
                ],
                // iOS notification
                "apns" => [
                    "payload" => [
                        "aps" => [
                            "alert" => [
                                "title" => $fcmMsg["title"],
                                "body" => $fcmMsg["body"]
                            ],
                            "sound" => $fcmMsg["type"] == "order" || $fcmMsg["type"] == "new_order" ? "order_sound.aiff" : "default",
                            "mutable-content" => 1
                        ]
                    ],
                    "fcm_options" => [
                        "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                    ]
                ],
                "notification" => [
                    "title" => $fcmMsg["title"],
                    "body" => $fcmMsg["body"],
                    "image" => isset($fcmMsg["image"]) ? $fcmMsg["image"] : ""
                ]
            ]
        ];
        $data1 = json_encode($message1);
        sendNotificationToFCM($url, $access_token, $data1);
    }
}
function send_web_notification($title, $message, $partner_id = null, $click_action = null)
{
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = $settings['value'];
    $message1 = [];
    $fcm_tokens = [];
    $settings = json_decode($settings, true);
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';
    $db      = \Config\Database::connect();
    $builder = $db->table('users u');
    $users = $builder->Select("u.id,u.web_fcm_id")
        ->join('users_groups ug', 'ug.user_id=u.id')
        ->join('users_fcm_ids uf', 'uf.user_id=u.id')
        ->where('ug.group_id', '1')
        ->where('uf.platform', 'web')
        ->where('uf.status', '1')
        ->get()->getResultArray();

    $db->close();
    if (!empty($partner_id)) {
        $partner = fetch_details('users', ['id' => $partner_id], ['web_fcm_id']);
    }
    $settings = get_settings('general_settings', true);
    $icon = $settings['logo'];


    foreach ($users as $key => $users) {
        $fcm_tokens[] = $users['fcm_id'];
    }
    $fcm_tokens = array_filter(($fcm_tokens));

    // array_push($fcm_tokens,$partner[0]['fcm_id']);
    if (!empty($partner_id)) {
        array_push($fcm_tokens, $partner[0]['fcm_id']);
    }
    $fcm_tokens = (array_values($fcm_tokens));
    foreach ($fcm_tokens as $token) {
        $message1 = [
            "message" => [
                "token" => $token,
                'data' => ['type' => "new_order"],
                'notification' => [
                    'title' => $title,
                    'body' => $message,
                ],
            ]
        ];
    }
    $data1 = json_encode($message1);
    sendNotificationToFCM($url, $access_token, $data1);
    return false;
}
// function send_panel_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
// {
//     // Prepare data for the queue
//     $notificationData = [
//         'notification_type' => 'panel_chat',
//         'title' => $title,
//         'message' => $message,
//         'user_id' => $user_id,
//         'click_action' => $click_action,
//         'type' => $type,
//         'payload' => $payload
//     ];

//     // Queue the notification instead of sending immediately
//     try {
//         $jobId = service('queue')->push('chat_notifications', 'chatNotification', $notificationData);
//         log_message('info', 'Panel chat notification queued successfully with job ID: ' . $jobId);
//         return true; // Return true to indicate the notification was queued successfully
//     } catch (\Exception $e) {
//         log_message('error', 'Failed to queue panel chat notification: ' . $e->getMessage());
//         return false;
//     }
// }

function send_panel_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
{
    $db = \Config\Database::connect();
    $builder = $db->table('users u');
    $settings = get_settings('general_settings', true);
    $icon = $settings['logo'];
    $user_data = $builder->select("u.id,u.panel_fcm_id,uf.platform,uf.fcm_id")
        ->join('users_groups ug', 'ug.user_id=u.id')
        ->join('users_fcm_ids uf', 'uf.user_id=u.id')
        ->whereIn('uf.platform', ['admin_panel', 'provider_panel'])
        ->where('uf.status', '1')
        // ->where('ug.group_id', '3')
        ->where('u.id', $user_id)
        ->get()->getResultArray();

    //select u.fcm_id from users_fcm_ids u where u.platform in ('admin_panel', 'provider_panel') and u.status = 1 and u.user_id = {$user_id}

    // if (!empty($user_id)) {
    //     $user_data = fetch_details('users', ['id' => $user_id], ['panel_fcm_id', 'id', 'username', 'image']);
    // }

    $settings = get_settings('general_settings', true);
    $fcm_tokens = [];
    foreach ($user_data as $key => $users) {
        $fcm_tokens[] = $users['fcm_id']; // fcm_id
    }
    $fcm_tokens = array_filter($fcm_tokens);
    $payload = [
        "id" => (string) $payload['id'],
        "sender_id" => (string)$payload['sender_id'],
        "receiver_id" => (string)$payload['receiver_id'],
        "booking_id" => (string)$payload['booking_id'],
        "message" => (string)$payload['message'],
        // "file" => (string)$payload['file'],
        "file" => json_encode([
            $payload['file']
        ]),
        "file_type" => (string)$payload['file_type'],
        "created_at" => (string)$payload['created_at'],
        "updated_at" => (string)$payload['updated_at'],
        "e_id" => (string)$payload['e_id'],
        "sender_type" => (string)$payload['sender_type'],
        "receiver_type" => (string)$payload['receiver_type'],
        "username" => (string)$payload['username'],
        "image" => (string)$payload['image'],
        "user_id" => (string)$payload['user_id'],
        "profile_image" => (string)$payload['profile_image'] ?? "",
        "last_message_date" => (string)$payload['last_message_date'],
        "viewer_type" => (string)$payload['viewer_type'],
        "sender_details" => json_encode([
            $payload['sender_details']
        ]),
        "receiver_details" => json_encode([
            $payload['receiver_details']
        ]),
    ];
    // if (!empty($fcm_tokens)) {
    //     $fcm_tokens1 = $fcm_tokens[0];
    // } else {
    //     $fcm_tokens1 = [];
    // }
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = $settings['value'];
    $settings = json_decode($settings, true);
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';

    foreach ($fcm_tokens as $key => $fcm_token) {

        if (!empty($fcm_token)) {
            $message1 = [
                "message" => [
                    "token" => $fcm_token,
                    "data" => $payload,
                    'notification' => [
                        'title' => $title,
                        'body' => $message,
                    ],
                ]
            ];

            $data1 = json_encode($message1);
            sendNotificationToFCM($url, $access_token, $data1);
        } else {
            return "No fcm found";
        }
    }
}

function send_app_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
{
    $db = \Config\Database::connect();
    $builder = $db->table('users u');
    $settings = get_settings('general_settings', true);
    $icon = $settings['logo'];
    // $user_data = $builder->select("u.id,u.fcm_id,u.platform")
    //     ->join('users_groups ug', 'ug.user_id=u.id')
    //     ->where('ug.group_id', '3')
    //     ->get()->getResultArray();
    // if (!empty($user_id)) {
    //     $user_data = fetch_details('users', ['id' => $user_id], ['fcm_id', 'id', 'username', 'image', 'platform']);
    // }

    if ($payload['receiver_type'] == 1) {

        $user_data = $builder->select("u.id,uf.platform,uf.fcm_id")
            ->join('users_groups ug', 'ug.user_id=u.id')
            ->join('users_fcm_ids uf', 'uf.user_id=u.id')
            ->whereIn('uf.platform', ['android', 'ios'])
            ->where('u.id', $user_id)
            ->where('ug.group_id', '3')
            ->get()->getResultArray();
    } else if ($payload['receiver_type'] == 2) {

        $user_data = $builder->select("u.id,uf.fcm_id,uf.platform,u.username,u.image")
            ->join('users_groups ug', 'ug.user_id  =u.id')
            ->join('users_fcm_ids uf', 'uf.user_id=u.id')
            ->whereIn('uf.platform', ['android', 'ios'])
            ->where('u.id', $user_id)
            ->where('ug.group_id', '2')
            ->get()->getResultArray();
    } else if ($payload['receiver_type'] == 0) { // for admin
        $user_data = $builder->select("u.id,uf.fcm_id,uf.platform,u.username,u.image")
            ->join('users_groups ug', 'ug.user_id  =u.id')
            ->join('users_fcm_ids uf', 'uf.user_id=u.id')
            ->whereIn('uf.platform', ['admin_panel'])
            ->where('u.id', $user_id)
            ->where('ug.group_id', '1')
            ->get()->getResultArray();
    }

    // Build array of FCM tokens
    $fcm_tokens = [];
    foreach ($user_data as $users) {
        if (!empty($users['fcm_id'])) {
            $fcm_tokens[] = [
                'fcm_id' => $users['fcm_id'],
                'platform' => $users['platform']
            ];
        }
    }

    // If message is empty, fallback to "received X files"
    if (empty($message)) {
        $fileArray = isset($payload['file']) ? $payload['file'] : [];
        $fileCount = count($fileArray);
        $message = "Received " . $fileCount . " files";
    }
    $payload = [
        'title' => (string) $title,
        'body' => (string)  $message,
        "id" => (string) $payload['id'],
        "sender_id" => (string)$payload['sender_id'],
        "receiver_id" => (string)$payload['receiver_id'],
        "booking_id" => isset($payload['booking_id']) ? (string)$payload['booking_id'] : '0',
        "message" => (string)$payload['message'],
        "file" => json_encode([
            $payload['file']
        ]),
        "file_type" => (string)$payload['file_type'],
        "created_at" => (string)$payload['created_at'],
        "updated_at" => (string)$payload['updated_at'],
        "e_id" => (string)$payload['e_id'],
        "sender_type" => (string)$payload['sender_type'],
        // "receiver_type" => isset($payload['viewer_type']) && $payload['viewer_type'] == "admin" ? "0" : (string)$payload['receiver_type'], // 0 = admin
        "receiver_type" => (string)$payload['receiver_type'],
        "username" => (string)$payload['username'],
        "image" => (string)$payload['image'],
        "user_id" => (string)$payload['user_id'],
        "profile_image" => (string)$payload['profile_image'] ?? "",
        "last_message_date" => (string)$payload['last_message_date'],
        "viewer_type" => (string)$payload['viewer_type'],
        "sender_details" => json_encode([
            $payload['sender_details']
        ]),
        "receiver_details" => json_encode([
            $payload['receiver_details']
        ]),
        'type' => 'chat',
        'booking_status' => isset($payload['booking_status']) ? (string) $payload['booking_status'] : "",
        'provider_id' => isset($payload['provider_id']) ? (string) $payload['provider_id'] : "",
    ];
    if ($payload['sender_type'] == 1  && $payload['receiver_type'] == 2) {
        $payload['provider_id'] = $payload['sender_id'];
    } else if ($payload['sender_type'] == 2 && $payload['receiver_type'] == 1) {
        $payload['provider_id'] = $payload['receiver_id'];
    } else {
        $payload['provider_id'] = "";
    }
    if ($payload['booking_id'] != 0 || $payload['booking_id'] != "") {
        $booking_status = fetch_details('orders', ['id' => $payload['booking_id']], ['status']);
        $payload['booking_status'] = isset($booking_status[0]) ? $booking_status[0]['status'] : "";
    }

    // Fetch Firebase settings and access token
    $access_token = getAccessToken();
    $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
    $settings = json_decode($settings['value'], true);
    $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';

    // Send notification to each device token
    foreach ($fcm_tokens as $tokenData) {
        log_message('error', 'Sending notification to FCM: ' . json_encode($tokenData));
        $message1 = [
            "message" => [
                "data" => $payload,
                "token" => $tokenData['fcm_id'],
            ]
        ];

        // If platform is iOS → add notification section
        if ($tokenData['platform'] === 'ios') {
            $message1["message"]["notification"] = [
                'title' => $title,
                'body' => $message,
            ];
        }

        $data1 = json_encode($message1);
        sendNotificationToFCM($url, $access_token, $data1);
    }

    // // Send notification to each device token
    // foreach ($fcm_tokens as $tokenData) {
    //     $message1 = [
    //         "message" => [
    //             "data" => $payload,
    //             "token" => $tokenData['fcm_id'],
    //         ]
    //     ];

    //     // If platform is iOS → add notification section
    //     if ($tokenData['platform'] === 'ios') {
    //         $message1["message"]["notification"] = [
    //             'title' => $title,
    //             'body' => $message,
    //         ];
    //     }

    //     $data1 = json_encode($message1);
    //     $headers = [
    //         'Authorization: Bearer ' . $access_token,
    //         'Content-Type: application/json',
    //     ];

    //     // Send request using CURL
    //     $ch = curl_init();
    //     curl_setopt($ch, CURLOPT_URL, $url);
    //     curl_setopt($ch, CURLOPT_POST, true);
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    //     curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    //     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, $data1);
    //     $result = curl_exec($ch);
    //     if ($result == FALSE) {
    //         die('Curl failed: ' . curl_error($ch));
    //     }
    //     curl_close($ch);
    // }
}

// function send_app_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
// {
//     // Prepare data for the queue
//     $notificationData = [
//         'notification_type' => 'app_chat',
//         'title' => $title,
//         'message' => $message,
//         'user_id' => $user_id,
//         'click_action' => $click_action,
//         'type' => $type,
//         'payload' => $payload
//     ];

//     // Queue the notification instead of sending immediately
//     try {
//         $jobId = service('queue')->push('chat_notifications', 'chatNotification', $notificationData);
//         log_message('info', 'App chat notification queued successfully with job ID: ' . $jobId);
//         return true; // Return true to indicate the notification was queued successfully
//     } catch (\Exception $e) {
//         log_message('error', 'Failed to queue app chat notification: ' . $e->getMessage());
//         return false;
//     }
// }
// function send_customer_web_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
// {
//     // Prepare data for the queue
//     $notificationData = [
//         'notification_type' => 'customer_web_chat',
//         'title' => $title,
//         'message' => $message,
//         'user_id' => $user_id,
//         'click_action' => $click_action,
//         'type' => $type,
//         'payload' => $payload
//     ];

//     // Queue the notification instead of sending immediately
//     try {
//         $jobId = service('queue')->push('chat_notifications', 'chatNotification', $notificationData);
//         log_message('info', 'Customer web chat notification queued successfully with job ID: ' . $jobId);
//         return true; // Return true to indicate the notification was queued successfully
//     } catch (\Exception $e) {
//         log_message('error', 'Failed to queue customer web chat notification: ' . $e->getMessage());
//         return false;
//     }
// }

function send_customer_web_chat_notification($title, $message, $user_id = null, $click_action = null, $type = null, $payload = null)
{
    $db = \Config\Database::connect();
    $builder = $db->table('users u');
    $settings = get_settings('general_settings', true);
    $icon = $settings['logo'];
    $user_data = $builder->select("u.id,uf.fcm_id")
        ->join('users_groups ug', 'ug.user_id=u.id')
        ->join('users_fcm_ids uf', 'uf.user_id=u.id')
        ->whereIn('uf.platform', ['web'])
        ->where('uf.status', '1')
        ->where('ug.group_id', '2')
        ->where('u.id', $user_id)
        ->get()->getResultArray();

    $settings = get_settings('general_settings', true);
    $fcm_tokens = [];

    foreach ($user_data as $key => $users) {
        $fcm_tokens[] = $users['fcm_id']; // fcm_id
    }
    $fcm_tokens = array_filter($fcm_tokens);

    $payload = [
        "id" => (string) $payload['id'],
        "sender_id" => (string)$payload['sender_id'],
        "receiver_id" => (string)$payload['receiver_id'],
        "booking_id" => (string)$payload['booking_id'],
        "message" => (string)$payload['message'],
        // "file" => (string)$payload['file'],
        "file" => json_encode([
            $payload['file']
        ]),
        "file_type" => (string)$payload['file_type'],
        "created_at" => (string)$payload['created_at'],
        "updated_at" => (string)$payload['updated_at'],
        "e_id" => (string)$payload['e_id'],
        "sender_type" => (string)$payload['sender_type'],
        "receiver_type" => (string)$payload['receiver_type'],
        "username" => (string)$payload['username'],
        "image" => (string)$payload['image'],
        "user_id" => (string)$payload['user_id'],
        "profile_image" => (string)$payload['profile_image'] ?? "",
        "last_message_date" => (string)$payload['last_message_date'],
        "viewer_type" => (string)$payload['viewer_type'],
        "sender_details" => json_encode([
            $payload['sender_details']
        ]),
        "receiver_details" => json_encode([
            $payload['receiver_details']
        ]),
    ];
    if (!empty($fcm_tokens)) {
        $fcm_tokens1 = $fcm_tokens[0];
    } else {
        $fcm_tokens1 = [];
    }
    if (!empty($fcm_tokens1)) {
        $message1 = [
            "message" => [
                "token" => $fcm_tokens1,
                "data" => $payload,
                'notification' => [
                    'title' => $title,
                    'body' => $message,
                ],
            ]
        ];
        $access_token = getAccessToken();
        $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0];
        $settings = $settings['value'];
        $settings = json_decode($settings, true);
        $url = 'https://fcm.googleapis.com/v1/projects/' . $settings['projectId'] . '/messages:send';
        $data1 = json_encode($message1);
        sendNotificationToFCM($url, $access_token, $data1);
    } else {
        return "No fcm found";
    }
}
function extractVariables($content)
{
    preg_match_all('/\[\[(.*?)\]\]/', $content, $matches);
    return array_map('trim', $matches[1]);
}
function custom_email_sender($to, $subject, $message, $from_email, $from_name, $bcc = null, $cc = null, $logo_attachment = null, $cid = null)
{
    // Prepare data for the queue
    $emailData = [
        'to' => $to,
        'subject' => $subject,
        'message' => $message,
        'from_email' => $from_email,
        'from_name' => $from_name,
        'bcc' => $bcc,
        'cc' => $cc,
        'logo_attachment' => $logo_attachment,
        'cid' => $cid
    ];

    // Queue the email instead of sending immediately
    // try {
    //     $jobId = service('queue')->push('emails', 'email', $emailData);
    //     log_message('info', 'Email queued successfully with job ID: ' . $jobId);
    //     return true; // Return true to indicate the email was queued successfully
    // } catch (\Exception $e) {
    //     log_message('error', 'Failed to queue email: ' . $e->getMessage());
    //     return false;
    // }
    $email = \Config\Services::email();
    $email->setTo($to);
    $email->setFrom($from_email, $from_name);
    $email->setSubject($subject);
    $email->setMailType('html');
    if (!empty($bcc)) {
        $email->setBCC($bcc);
    }
    if (!empty($cc)) {
        $email->setCC($cc);
    }
    $email->setMessage($message);
    return $email->send();
    // if (!$email->send()) {
    //     log_message('error', '$email header ' . var_export($email->printDebugger(['headers']), true));
    // } else {
    //     return true;
    //     echo "Email sent successfully.";
    // }
}
/**
 * Send custom email with template replacement
 * 
 * This function has been updated to prevent null values from being passed to str_replace()
 * which was causing deprecated warnings in newer PHP versions. All template variables
 * are now safely validated before replacement.
 * 
 * @param string $type Email template type
 * @param int|null $provider_id Provider ID
 * @param string|null $email_to Recipient email
 * @param float|null $amount Amount
 * @param int|null $user_id User ID
 * @param int|null $booking_id Booking ID
 * @param string|null $booking_date Booking date
 * @param string|null $booking_time Booking time
 * @param string|null $booking_service_names Service names
 * @param string|null $booking_address Booking address
 * @return bool|array Success status or error details
 */
function send_custom_email($type, $provider_id = null, $email_to = null, $amount = null, $user_id = null, $booking_id = null, $booking_date = null, $booking_time = null, $booking_service_names = null, $booking_address = null, $language = null)
{
    // Fetch settings
    $email_settings = \get_settings('email_settings', true);
    $company_settings = \get_settings('general_settings', true);
    $smtpUsername = $email_settings['smtpUsername'];
    $company_name = get_company_title_with_fallback($company_settings);

    // Fetch email template with translation support
    $template_data = get_translated_email_template($type, $language);
    if (!$template_data) {
        // echo "Email template not found.";
        return false;
    }

    // Get template and subject (already translated by helper function)
    $template = $template_data['template'];
    $subject = $template_data['subject'];
    // Check if template includes provider name placeholder
    if (strpos($template, '[[provider_name]]') !== false && $provider_id !== null) {
        $partner_data = fetch_details('partner_details', ['partner_id' => $provider_id]);
        if (!$partner_data) {
            // echo "Partner data not found.";
            // return "Partner data not found.";
            return false;
        }

        $provider_name = $partner_data[0]['company_name'];
        $defaultLanguageCode = get_default_language();
        $translationModel = new App\Models\TranslatedPartnerDetails_model();
        $translatedPartnerDetails = $translationModel->getTranslatedDetails($provider_id, $defaultLanguageCode);
        if (!empty($translatedPartnerDetails)) {
            $provider_name = $translatedPartnerDetails['company_name'];
        } else {
            $provider_name = $partner_data[0]['company_name'];
        }

        $template = str_replace("[[provider_name]]", $provider_name, $template);
    }
    if (strpos($template, '[[company_name]]') !== false  && $company_name !== null) {
        $template = str_replace("[[company_name]]", $company_name, $template);
    }
    if (strpos($template, '[[provider_id]]') !== false  && $provider_id !== null) {
        $template = str_replace("[[provider_id]]", $provider_id, $template);
    }
    if (strpos($template, '[[site_url]]') !== false) {
        $template = str_replace("[[site_url]]", base_url(), $template);
    }
    if (strpos($template, '[[company_contact_info]]') !== false) {
        $contact_us = getTranslatedSetting('contact_us', 'contact_us');
        $contact_info = isset($contact_us) && !empty($contact_us) ? $contact_us : 'Contact us for more information';
        $template = str_replace("[[company_contact_info]]", $contact_info, $template);
    }
    if (strpos($template, '[[amount]]') !== false && $amount !== null) {
        $template = str_replace("[[amount]]", $amount, $template);
    }
    $logo_attachment = "";
    $cid = "";
    if (strpos($template, '[[company_logo]]') !== false) {
        $settings = get_settings('general_settings', true);
        $logo = isset($settings['logo']) && !empty($settings['logo']) ? $settings['logo'] : '';
        if (!empty($logo)) {
            $logoPath = "public/uploads/site/" . $logo;
            if (file_exists($logoPath)) {
                $logo_attachment = $logoPath;
                $cid = basename($logoPath);
                $logo_img_tag = '<img src="cid:' . $cid . '" alt="Company Logo">';
                $template = str_replace("[[company_logo]]", $logo_img_tag, $template);
            } else {
                // If logo file doesn't exist, remove the placeholder from the template
                $template = str_replace("[[company_logo]]", '', $template);
            }
        } else {
            // If no logo setting, remove the placeholder from the template
            $template = str_replace("[[company_logo]]", '', $template);
        }
        preg_match_all('/<img[^>]+src=["\'](.*?)["\'][^>]*>/i', $template, $matches);
        $imagePaths = $matches[1];
        foreach ($imagePaths as $imagePath) {
            if (file_exists($imagePath)) {
                $template = str_replace($imagePath, "cid:$cid", $template);
            }
        }
    }
    if (strpos($template, '[[currency]]') !== false) {
        $currency = get_settings('general_settings', true);
        $currency_value = isset($currency['currency']) && !empty($currency['currency']) ? $currency['currency'] : 'USD';
        $template = str_replace("[[currency]]", $currency_value, $template);
    }
    if (strpos($template, '[[user_name]]') !== false && $user_id !== null) {
        $users = fetch_details('users', ['id' => $user_id]);
        if (!$users) {
            return false;
            // echo "User data not found.";
            // return "User data not found.";
        }
        $user_name = $users[0]['username'];
        $template = str_replace("[[user_name]]", $user_name, $template);
    }
    if (strpos($template, '[[user_id]]') !== false && $user_id !== null) {
        $template = str_replace("[[user_id]]", $user_id, $template);
    }
    if (strpos($template, '[[user_id]]') !== false && $user_id !== null) {
        $template = str_replace("[[user_id]]", $user_id, $template);
    }
    if ($booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]);
        if (empty($booking[0])) {
            return false;
        }
        $booking = $booking[0];
        $template = str_replace("[[booking_id]]", $booking['id'], $template);
        if (strpos($template, '[[booking_date]]') !== false && $booking_id !== null) {
            $template = str_replace("[[booking_date]]", $booking['date_of_service'], $template);
        }
        if (strpos($template, '[[booking_time]]') !== false && $booking_id !== null) {
            $template = str_replace("[[booking_time]]", $booking['starting_time'], $template);
        }
        if (strpos($template, '[[booking_status]]') !== false && $booking_id !== null) {
            $template = str_replace("[[booking_status]]", $booking['status'], $template);
        }
        if (strpos($template, '[[booking_service_names]]') !== false  && $booking_id !== null) {
            $services = fetch_details('order_services', ['order_id' => $booking_id]);
            $service_names = '';
            foreach ($services as $row) {
                $service_names .= $row['service_title'] . ', ';
            }
            $service_names = rtrim($service_names, ', ');
            $template = str_replace("[[booking_service_names]]", $service_names, $template);
        }
        if (strpos($template, '[[booking_address]]') !== false &&  $booking_id !== null) {
            $template = str_replace("[[booking_address]]", $booking['address'], $template);
        }
    }
    if (strpos($template, '[[booking_id]]') !== false && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['id'])[0];
        $template = str_replace("[[booking_id]]", $booking['id'], $template);
    }
    if (strpos($template, '[[booking_date]]') !== false && $booking_date !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['booking_date'])[0];
        $template = str_replace("[[booking_date]]", $booking['date_of_service'], $template);
    }
    if (strpos($template, '[[booking_time]]') !== false && $booking_time !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['booking_time'])[0];
        $template = str_replace("[[booking_time]]", $booking['starting_time'], $template);
    }
    if (strpos($template, '[[booking_time]]') !== false && $booking_time !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['booking_time'])[0];
        $template = str_replace("[[booking_time]]", $booking['starting_time'], $template);
    }
    if (strpos($template, '[[booking_service_names]]') !== false && $booking_service_names !== null && $booking_id !== null) {
        $services = fetch_details('orders_services', ['order_id' => $booking_id]);
        $service_names = '';
        foreach ($services as $row) {
            $service_names .= $row['service_title'] . ', ';
        }
        $service_names = rtrim($service_names, ', ');
        $template = str_replace("[[booking_service_names]]", $service_names, $template);
    }
    if (strpos($template, '[[booking_address]]') !== false && $booking_address !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['address'])[0];
        $template = str_replace("[[booking_address]]", $booking['address'], $template);
    }
    $bcc = [];
    $cc = [];
    if ($template_data[0]['bcc']) {
        $base_tags = $template_data[0]['bcc'];
        $val = explode(',', $base_tags);
        $bcc = [];
        foreach ($val as $s) {
            $bcc[] = $s;
        }
    }
    if ($template_data[0]['cc']) {
        $base_tags = $template_data[0]['cc'];
        $val = explode(',', $base_tags);
        $cc = [];
        foreach ($val as $s) {
            $cc[] = $s;
        }
    }
    // Prepare email details
    $from_email = $smtpUsername;
    $from_name = $company_name;
    $message = htmlspecialchars_decode($template);
    // Send email
    if (custom_email_sender($email_to, $subject, $message, $from_email, $from_name, $bcc, $cc, $logo_attachment, $cid)) {
        // if (custom_email_sender($email_to, $subject, $message, $from_email, $from_name, $bcc, $cc, $logo_attachment, $cid)) {
        return true;
    } else {
        return "email not send";
    }
}
function unsubscribe_link_user_encrypt($user_id, $email)
{
    $simple_string = $user_id . "-" . $email;
    // Store the cipher method
    $ciphering = "AES-128-CTR";
    // Use OpenSSl Encryption method
    $iv_length = openssl_cipher_iv_length($ciphering);
    $options = 0;
    // Non-NULL Initialization Vector for encryption
    $encryption_iv = '1234567891011121';
    // Store the encryption key
    $encryption_key = getenv('decryption_key');
    // Use openssl_encrypt() function to encrypt the data
    $encryption = openssl_encrypt(
        $simple_string,
        $ciphering,
        $encryption_key,
        $options,
        $encryption_iv
    );
    return $encryption;
}
function unsubscribe_link_user_decrypt($user_id)
{
    $ciphering = "AES-128-CTR";
    $options = 0;
    // Use openssl_encrypt() function to encrypt the data
    $encryption = $user_id;
    // Non-NULL Initialization Vector for decryption
    $decryption_iv = '1234567891011121';
    // Store the decryption key
    $decryption_key = getenv('decryption_key');
    // Use openssl_decrypt() function to decrypt the data
    $decryption = openssl_decrypt(
        $encryption,
        $ciphering,
        $decryption_key,
        $options,
        $decryption_iv
    );
    $data = (explode("-", $decryption));
    return $data;
}
function is_unsubscribe_enabled($user_id)
{
    $user = fetch_details('users', ['id' => $user_id], ['id', 'unsubscribe_email'])[0];
    return $user['unsubscribe_email'];
}
// function compressImage($source, $destination, $quality)
// {
//     $settings = get_settings('general_settings', true);
//     // Check if image compression is enabled
//     if ($settings['image_compression_preference'] == 0) {
//         // If compression is not enabled, simply copy the file to the destination
//         // if (!copy($source, $destination)) {
//         //     die('Failed to copy the image.');
//         // }
//         // return;
//     }
//     $finfo = finfo_open(FILEINFO_MIME_TYPE);
//     $mime = finfo_file($finfo, $source);
//     finfo_close($finfo);
//     if ($mime === 'image/svg+xml') {
//         $svgContent = file_get_contents($source);
//         if (file_put_contents($destination, $svgContent) === false) {
//             die('Failed to save the SVG image.');
//         }
//         return;
//     }
//     switch ($mime) {
//         case 'image/jpeg':
//             $image = imagecreatefromjpeg($source);
//             break;
//         case 'image/png':
//             $image = imagecreatefrompng($source);
//             break;
//         case 'image/gif':
//             $image = imagecreatefromgif($source);
//             break;
//         default:
//             $image = null;
//     }
//     if ($image === null) {
//         $image=$source;
//         // die('Unsupported image type.');
//     }
//     // If a custom quality setting exists, use it
//     if (!empty($settings['image_compression_quality'])) {
//         $quality = $settings['image_compression_quality'];
//     }
//     if (!imagejpeg($image, $destination, $quality)) {
//         die('Failed to save the image.');
//     }
//     imagedestroy($image);
// }
function compressImage($source, $destination, $quality)
{
    $settings = get_settings('general_settings', true);
    // Check if image compression is disabled
    if ($settings['image_compression_preference'] == 0) {
        copy($source, $destination); // Directly copy the file if compression is disabled
        return;
    }
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime = finfo_file($finfo, $source);
    finfo_close($finfo);
    // Handle SVG images separately
    if ($mime === 'image/svg+xml') {
        $svgContent = file_get_contents($source);
        file_put_contents($destination, $svgContent); // Save the SVG without compression
        return;
    }
    $image = null;
    // Check for supported image types
    switch ($mime) {
        case 'image/jpeg':
            $image = imagecreatefromjpeg($source);
            break;
        case 'image/png':
            $image = imagecreatefrompng($source);
            break;
        case 'image/gif':
            $image = imagecreatefromgif($source);
            break;
        default:
            // If image type is unsupported, simply copy it to the destination
            copy($source, $destination);
            return;
    }
    // Use custom quality setting if available
    if (!empty($settings['image_compression_quality'])) {
        $quality = $settings['image_compression_quality'];
    }
    // Compress and save the image
    if (!imagejpeg($image, $destination, $quality)) {
        copy($source, $destination); // If compression fails, copy the original file
    }
    imagedestroy($image);
}
function copy_image($number, $og_path)
{
    $sourceFilePath = FCPATH . $number;
    if (file_exists($sourceFilePath)) {
        $destinationDirectory = FCPATH . $og_path;
        $og_path = rtrim($og_path, '/');
        $fileName = basename($sourceFilePath);
        $destinationFilePath = $destinationDirectory . '/' . $fileName;
        if (copy($sourceFilePath, $destinationFilePath)) {
            $image = $og_path . '/' . $fileName;
        } else {
            $image = $og_path . '/' . $fileName;
        }
    } else {
        $image = "";
    }
    return $image;
}
function set_user_otp($mobile, $otp, $only_mobile_number = null, $country_code = null)
{
    $dateString = date('Y-m-d H:i:s');
    $time = strtotime($dateString);
    $data['otp'] = $otp;
    $data['created_at'] = $dateString;
    if (!empty($country_code)) {
        $mobile_for_sms = $country_code . $only_mobile_number;
    } else {
        $mobile_for_sms = $only_mobile_number;
    }
    $otps = fetch_details('otps', ['mobile' => $mobile_for_sms]);
    foreach ($otps as $user) {
        if (isset($user['mobile']) && !empty($user['mobile'])) {
            $message = send_sms($mobile_for_sms, "please don't share with anyone $otp", $country_code);
            if ($message['http_code'] != 201) {
                return [
                    "error" => true,
                    "message" => "OTP Can not send.",
                    "data" => $data
                ];
            } else {
                update_details($data, ['id' => $user['id']], 'otps');
                return [
                    "error" => false,
                    "message" => "OTP send successfully.",
                    "data" => $data
                ];
            }
        }
        return [
            "error" => true,
            "message" => "No OTP Stored for this number."
        ];
    }
}
function send_sms($phone, $msg, $country_code = "+91")
{
    $data = get_settings('sms_gateway_setting', true);
    $current_sms_gateway = $data['current_sms_gateway'] ?? "twilio";
    if ($current_sms_gateway == "vonage") {
    } else if ($current_sms_gateway == "twilio") {
        $account_sid = $data['twilio']['twilio_account_sid'] ?? '';
        $auth_token = $data['twilio']['twilio_auth_token'] ?? "";
        $from = $data['twilio']['twilio_from'] ?? "";

        $body = [
            'To' => $phone,
            'From' => $from,
            'Body' => $msg
        ];
        // return curl_sms(
        //     "https://api.twilio.com/2010-04-01/Accounts/{$account_sid}/Messages.json",
        //     'POST',
        //     $body,
        //     [
        //         "Authorization: Basic " . base64_encode("{$account_sid}:{$auth_token}")
        //     ]
        // );
        return curl_sms(
            "https://api.twilio.com/2010-04-01/Accounts/{$account_sid}/Messages.json",
            'POST',
            http_build_query($body), // <-- Add this
            [
                "Authorization: Basic " . base64_encode("{$account_sid}:{$auth_token}"),
                "Content-Type: application/x-www-form-urlencoded"
            ]
        );
    }
}
function parse_sms(string $string = "", string $mobile = "", string $sms = "", string $country_code = "")
{
    $parsedString = str_replace("{only_mobile_number}", $mobile, $string);
    $parsedString = str_replace("{message}", $sms, $parsedString); // Use $parsedString as the third argument
    return $parsedString;
}
function curl_sms($url, $method = 'GET', $data = [], $headers = [])
{
    $ch = curl_init();
    $curl_options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_HEADER => 0,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
        )
    );
    if (count($headers) != 0) {
        $curl_options[CURLOPT_HTTPHEADER] = $headers;
    }
    if (strtolower($method) == 'post') {
        $curl_options[CURLOPT_POST] = 1;
        $curl_options[CURLOPT_POSTFIELDS] = $data;
    } else {
        $curl_options[CURLOPT_CUSTOMREQUEST] = 'GET';
    }
    curl_setopt_array($ch, $curl_options);
    $result = array(
        'body' => json_decode(curl_exec($ch), true),
        'http_code' => curl_getinfo($ch, CURLINFO_HTTP_CODE),
    );
    return $result;
}
function check_notification_setting($setting, $type)
{
    $data = get_settings('notification_settings', true);
    if (isset($data[$setting . '_' . $type])) {
        return $data[$setting . '_' . $type];
    }
    return false;
}
/**
 * Send custom SMS with template replacement and multilanguage support
 * 
 * This function has been updated to support multilanguage SMS templates similar to send_custom_email.
 * It uses the get_translated_sms_template helper function to fetch translated templates with fallback mechanism.
 * 
 * @param string $type SMS template type
 * @param int|null $provider_id Provider ID
 * @param string|null $email_to Recipient email
 * @param float|null $amount Amount
 * @param int|null $user_id User ID
 * @param int|null $booking_id Booking ID
 * @param string|null $booking_date Booking date
 * @param string|null $booking_time Booking time
 * @param string|null $booking_service_names Service names
 * @param string|null $booking_address Booking address
 * @param string|null $language Language code for template translation
 * @return bool|array Success status or error details
 */
function send_custom_sms($type, $provider_id = null, $email_to = null, $amount = null, $user_id = null, $booking_id = null, $booking_date = null, $booking_time = null, $booking_service_names = null, $booking_address = null, $language = null)
{
    // Fetch settings
    $company_settings = get_settings('general_settings', true);
    $company_name = get_company_title_with_fallback($company_settings);

    // Fetch SMS template with translation support
    $template_data = get_translated_sms_template($type, $language);
    if (!$template_data) {
        // echo "SMS template not found.";
        return false;
    }

    // Get template (already translated by helper function)
    $template = $template_data['template'];
    // Check if template includes provider name placeholder
    if (strpos($template, '[[provider_name]]') !== false && $provider_id !== null) {
        $partner_data = fetch_details('partner_details', ['partner_id' => $provider_id]);
        if (!$partner_data) {
            // echo "Partner data not found.";
            // return "Partner data not found.";
            return false;
        }

        $provider_name = $partner_data[0]['company_name'];
        $defaultLanguageCode = get_default_language();
        $translationModel = new App\Models\TranslatedPartnerDetails_model();
        $translatedPartnerDetails = $translationModel->getTranslatedDetails($provider_id, $defaultLanguageCode);
        if (!empty($translatedPartnerDetails)) {
            $provider_name = $translatedPartnerDetails['company_name'];
        } else {
            $provider_name = $partner_data[0]['company_name'];
        }

        $template = str_replace("[[provider_name]]", $provider_name, $template);
    }
    if (strpos($template, '[[company_name]]') !== false  && $company_name !== null) {
        $template = str_replace("[[company_name]]", $company_name, $template);
    }
    if (strpos($template, '[[provider_id]]') !== false  && $provider_id !== null) {
        $template = str_replace("[[provider_id]]", $provider_id, $template);
    }
    if (strpos($template, '[[site_url]]') !== false) {
        $template = str_replace("[[site_url]]", base_url(), $template);
    }
    if (strpos($template, '[[company_contact_info]]') !== false) {
        $contact_us = getTranslatedSetting('contact_us', 'contact_us');
        $contact_us = isset($contact_us) && !empty($contact_us) ? $contact_us : 'Contact us for more information';
        $contact_us = htmlspecialchars_decode($contact_us);
        $contact_us = strip_tags($contact_us);
        $contact_us = html_entity_decode($contact_us);
        $template = str_replace("[[company_contact_info]]", $contact_us, $template);
    }
    if (strpos($template, '[[amount]]') !== false && $amount !== null) {
        $template = str_replace("[[amount]]", $amount, $template);
    }
    if (strpos($template, '[[currency]]') !== false) {
        $currency = get_settings('general_settings', true);
        $currency = $currency['currency'];
        $template = str_replace("[[currency]]", $currency, $template);
    }
    if (strpos($template, '[[user_name]]') !== false && $user_id !== null) {
        $users = fetch_details('users', ['id' => $user_id]);
        if (!$users) {
            return false;
        }
        $user_name = $users[0]['username'];
        $template = str_replace("[[user_name]]", $user_name, $template);
    }
    if (strpos($template, '[[user_id]]') !== false && $user_id !== null) {
        $template = str_replace("[[user_id]]", $user_id, $template);
    }
    if (strpos($template, '[[user_id]]') !== false && $user_id !== null) {
        $template = str_replace("[[user_id]]", $user_id, $template);
    }
    if ($booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]);
        if (empty($booking[0])) {
            return false;
        }
        $booking = $booking[0];
        $template = str_replace("[[booking_id]]", $booking['id'], $template);
        if (strpos($template, '[[booking_date]]') !== false && $booking_id !== null) {
            $template = str_replace("[[booking_date]]", $booking['date_of_service'], $template);
        }
        if (strpos($template, '[[booking_time]]') !== false && $booking_id !== null) {
            $template = str_replace("[[booking_time]]", $booking['starting_time'], $template);
        }
        if (strpos($template, '[[booking_service_names]]') !== false  && $booking_id !== null) {
            $services = fetch_details('order_services', ['order_id' => $booking_id]);
            $service_names = '';
            foreach ($services as $row) {
                $service_names .= $row['service_title'] . ', ';
            }
            $service_names = rtrim($service_names, ', ');
            $template = str_replace("[[booking_service_names]]", $service_names, $template);
        }
        if (strpos($template, '[[booking_address]]') !== false &&  $booking_id !== null) {
            $template = str_replace("[[booking_address]]", $booking['address'], $template);
        }
    }
    if (strpos($template, '[[booking_id]]') !== false && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['id'])[0];
        $template = str_replace("[[booking_id]]", $booking['id'], $template);
    }
    if (strpos($template, '[[booking_date]]') !== false && $booking_date !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['booking_date'])[0];
        $template = str_replace("[[booking_date]]", $booking['date_of_service'], $template);
    }
    if (strpos($template, '[[booking_time]]') !== false && $booking_time !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['booking_time'])[0];
        $template = str_replace("[[booking_time]]", $booking['starting_time'], $template);
    }
    if (strpos($template, '[[booking_service_names]]') !== false && $booking_service_names !== null && $booking_id !== null) {
        $services = fetch_details('orders_services', ['order_id' => $booking_id]);
        $service_names = '';
        foreach ($services as $row) {
            $service_names .= $row['service_title'] . ', ';
        }
        $service_names = rtrim($service_names, ', ');
        $template = str_replace("[[booking_service_names]]", $service_names, $template);
    }
    if (strpos($template, '[[booking_address]]') !== false && $booking_address !== null && $booking_id !== null) {
        $booking = fetch_details('orders', ['id' => $booking_id]['address'])[0];
        $template = str_replace("[[booking_address]]", $booking['address'], $template);
    }
    $json_message_body = stripslashes($template);
    $json_message_body = str_replace(['rn', '\r', '\n', '\\'], '', $json_message_body);
    $mobile = fetch_details('users', ['email' => $email_to], ['phone']);
    if (empty($mobile)) {
        return [
            "error" => true,
            "message" => "OTP Can not send.",
        ];
    }
    $message = send_sms($mobile[0]['phone'], htmlspecialchars_decode($json_message_body));
    $statusCode = $message['http_code'] ?? null;
    return [
        "error" => $statusCode != 201,
        "message" => $statusCode != 201 ? "OTP Can not send." : "OTP send successfully.",
    ];
}
function encrypt_data($key, $text)
{
    $iv = openssl_random_pseudo_bytes(16);
    $key .= "0000";
    $encrypted_data = openssl_encrypt($text, 'aes-256-cbc', $key, 0, $iv);
    $data = array("ciphertext" => $encrypted_data, "iv" => bin2hex($iv));
    return $data;
}
function checkOTPExpiration($otpTime)
{
    $currentTime = time();
    $otpTimestamp = strtotime($otpTime);
    if ($otpTimestamp === false) {
        return [
            "error" => true,
            "message" => "Invalid OTP time format."
        ];
    }
    $timeDifference = $currentTime - $otpTimestamp;
    if ($timeDifference <= 600) { // 10 minutes = 300 seconds
        return [
            "error" => false,
            "message" => "Success: OTP is valid."
        ];
    } else {
        return [
            "error" => true,
            "message" => "OTP has expired."
        ];
    }
}
function feature_section_type($type)
{
    $value = "";
    if ($type == "categories") {
        $value = labels("categories", "Categories");
    } else if ($type == "partners") {
        $value = labels("partners", "Partners");
    } else if ($type == "top_rated_partner") {
        $value = labels("top_rated_provider", "Top Rated Provider");
    } else if ($type == "previous_order") {
        $value = labels("previous_order", "Previos Order");
    } else if ($type == "ongoing_order") {
        $value = labels("ongoing_order", "Ongoing Order");
    } else if ($type == "near_by_provider") {
        $value = labels("near_by_providers", "Near By Providers");
    } else if ($type == "banner") {
        $value = labels("banner", "Banner");
    } else {
        $value = labels("no_section_type_found", "No Section Type Found");
    }
    return $value;
}
function banner_type($type)
{
    $value = "";
    if ($type == "banner_default") {
        $value = labels("default", "Default");
    } else if ($type == "banner_category") {
        $value = labels("category", "Category");
    } else if ($type == "banner_provider") {
        $value = labels("provider", "Provider");
    } else if ($type == "banner_url") {
        $value = labels("url", "URL");
    } else {
        $value = "-";
    }
    return $value;
}
function create_folder($path)
{
    $fullPath = FCPATH . $path;
    if (is_dir($fullPath)) {
        return true;
    }
    if (mkdir($fullPath, 0775, true)) {
        return true;
    } else {
        return false;
    }
}
function sanitizeInput($data)
{
    if (is_array($data)) {
        return array_map('sanitizeInput', $data);
    }
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}
function updateEnv($key, $value)
{
    $envPath = ROOTPATH . '.env';
    if (file_exists($envPath)) {
        $envContent = file_get_contents($envPath);
        $pattern = "/^{$key}=.*/m";
        if (preg_match($pattern, $envContent)) {
            $envContent = preg_replace($pattern, "{$key}={$value}", $envContent);
        } else {
            $envContent .= "\n{$key}={$value}";
        }
        file_put_contents($envPath, $envContent);
    }
}
function diffForHumans($datetime)
{
    $time = strtotime($datetime);
    $current_time = time();
    $diff = $current_time - $time;
    // Define time intervals
    $intervals = [
        'year'   => 31536000,  // 365 days * 24 hours * 60 minutes * 60 seconds
        'month'  => 2592000,   // 30 days * 24 hours * 60 minutes * 60 seconds
        'week'   => 604800,    // 7 days * 24 hours * 60 minutes * 60 seconds
        'day'    => 86400,     // 24 hours * 60 minutes * 60 seconds
        'hour'   => 3600,      // 60 minutes * 60 seconds
        'minute' => 60,        // 60 seconds
        'second' => 1
    ];
    foreach ($intervals as $key => $value) {
        if ($diff >= $value) {
            $time_diff = floor($diff / $value);
            return $time_diff == 1 ? "1" . labels($key, $key) . ' ' . labels('ago', 'ago') : "$time_diff " . labels($key, $key) . ' ' . labels('ago', 'ago');
        }
    }
    return labels('just_now', 'Just now');
}
function send_notification_to_related_providers($category_id, $custom_job_request_id, $latitude, $longitude)
{
    $partners = fetch_details('partner_details', ['is_accepting_custom_jobs' => 1], ['partner_id', 'custom_job_categories']);
    $category_name = fetch_details('categories', ['id' => $category_id], ['name']);
    // Prepare partner IDs for the specific category
    $partners_ids = [];
    foreach ($partners as $partner) {
        // Ensure custom_job_categories is a valid JSON string
        $category_ids = !empty($partner['custom_job_categories'])
            ? json_decode($partner['custom_job_categories'], true)
            : [];
        if (is_array($category_ids) && in_array($category_id, $category_ids)) {
            $partners_ids[] = $partner['partner_id'];
        }
    }
    if (!empty($partners_ids)) {
        $settings = get_settings('general_settings', true);
        $db = \Config\Database::connect();
        $builder = $db->table('partner_details pd');
        $builder->select("
        pd.*,
        u.username as partner_name, u.balance, u.longitude, u.latitude, 
        u.payable_commision,
        ps.id as partner_subscription_id, ps.status, ps.max_order_limit,
        st_distance_sphere(POINT('$longitude','$latitude'), POINT(u.longitude, u.latitude))/1000 as distance
    ")
            ->join('users u', 'pd.partner_id = u.id')
            ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id', 'left')
            ->whereIn('pd.partner_id', $partners_ids)
            ->having('distance < ' . (float)$settings['max_serviceable_distance'])
            ->groupBy('pd.partner_id');
        $partners_for_notifiy = $builder->get()->getResultArray();
        foreach ($partners_for_notifiy as $key => $id) {
            $partner_subscription = fetch_details('partner_subscriptions', ['partner_id' => $id['partner_id'], 'status' => 'active']);
            if ($partner_subscription) {
                $subscription_purchase_date = $partner_subscription[0]['updated_at'];
                $partner_order_limit = fetch_details('orders', ['partner_id' => $id['partner_id'], 'parent_id' => null, 'created_at >' => $subscription_purchase_date]);
                $partners_subscription = $db->table('partner_subscriptions ps');
                $partners_subscription_data = $partners_subscription->select('ps.*')->where('ps.status', 'active')
                    ->get()
                    ->getResultArray();
                $subscription_order_limit = $partners_subscription_data[0]['max_order_limit'];
                if ($partners_subscription_data[0]['order_type'] == "limited") {
                    if (count($partner_order_limit) >= $subscription_order_limit) {
                        unset($ids[$key]);
                    }
                }
            } else {
                unset($partners_for_notifiy[$key]);
            }
        }
    }
    // Proceed only if there are matching partners
    if (!empty($partners_ids)) {
        $settings = get_settings('general_settings', true);
        $db = \Config\Database::connect();
        $builder = $db->table('partner_details pd');
        $builder->select("
        pd.*,
        u.username as partner_name, u.balance, u.longitude, u.latitude, 
        u.payable_commision,
        ps.id as partner_subscription_id, ps.status, ps.max_order_limit,
        st_distance_sphere(POINT('$longitude','$latitude'), POINT(u.longitude, u.latitude))/1000 as distance
    ")
            ->join('users u', 'pd.partner_id = u.id')
            ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id', 'left')
            ->whereIn('pd.partner_id', $partners_ids) // Filter by partner IDs matching the category
            ->having('distance < ' . (float)$settings['max_serviceable_distance']) // Radius check
            ->groupBy('pd.partner_id');
        $partners_for_notifiy = $builder->get()->getResultArray();
        $access_token = getAccessToken();
        $settings = fetch_details('settings', ['variable' => 'firebase_settings'])[0]['value'];
        $firebase_settings = json_decode($settings, true);
        $url = 'https://fcm.googleapis.com/v1/projects/' . $firebase_settings['projectId'] . '/messages:send';
        $fcmMsg = [
            "title" => "New Custom Job Available",
            "body" => "A new job in " . $category_name[0]['name'] . " is available.",
            "type" => "job_notification",
        ];


        // Send notifications to partners and their panels
        foreach ($partners_for_notifiy as $partner_id) {
            insert_details(['custom_job_request_id' => $custom_job_request_id['id'], 'partner_id' => $partner_id['partner_id']], 'custom_job_provider');
            // $user = fetch_details('users', ['id' => $partner_id['partner_id']], ['fcm_id', 'panel_fcm_id', 'platform']);
            $user = $db->table('users_fcm_ids')
                ->select('fcm_id,platform')
                ->where('user_id', $partner_id['partner_id'])
                ->whereIn('platform', ['android', 'ios', 'web', 'provider_panel'])
                ->where('status', '1')
                ->get()
                ->getResultArray();

            if (!empty($user)) {
                $fcm_ids = [];
                foreach ($user as $row) {
                    if (!empty($row['fcm_id'])) {
                        $fcm_ids[] = $row; // Add the full user data (you need fcm_id + platform)
                    }
                }

                if (!empty($fcm_ids)) {
                    $fcm_ids_chunks = array_chunk($fcm_ids, 1000);
                    // Use queued notifications for better performance
                    queue_notification($fcmMsg, $fcm_ids_chunks, [], 'default');
                }
            }
        }
    }
}
// Functions for handling transactions
function handleAdditionalCharge($status, $transaction, $order, $order_id, $user_id)
{
    $data1['status'] = $status == "success" ? 'success' : 'failed';
    if (!empty($transaction)) {
        update_details($data1, [
            'order_id' => $order_id,
            'id' => $transaction['id'],
            'user_id' => $user_id
        ], 'transactions');
    } else {
        createTransaction($order, $order_id, 'failed', 'payment cancelled by customer', $user_id);
    }
}
function handleSuccessfulTransaction($transaction, $order, $order_id, $user_id, $is_redorder = false)
{
    if (!empty($transaction)) {
        $data1['status'] = 'success';
        update_details($data1, [
            'order_id' => $order_id,
            'user_id' => $user_id
        ], 'transactions');
    }
    $cart_data = fetch_cart(true, $user_id);
    if ($is_redorder == false && !empty($cart_data)) {
        foreach ($cart_data['data'] as $row) {
            delete_details(['id' => $row['id']], 'cart');
        }
    }
}
function handleFailedTransaction($transaction, $order, $order_id, $user_id)
{
    $data1['status'] = 'failed';
    if (!empty($transaction)) {
        update_details($data1, [
            'order_id' => $order_id,
            'user_id' => $user_id
        ], 'transactions');
        update_details(['status' => "cancelled"], [
            'id' => $order_id,
            'status' => 'awaiting',
            'user_id' => $user_id
        ], 'orders');
    } else {
        createTransaction($order, $order_id, 'failed', 'payment cancelled by customer', $user_id);
        update_details(['status' => "cancelled"], [
            'id' => $order_id,
            'status' => 'awaiting',
            'user_id' => $user_id
        ], 'orders');
    }
}
function createTransaction($order, $order_id, $status, $message, $user_id)
{
    $data = [
        'transaction_type' => 'transaction',
        'user_id' => $user_id,
        'partner_id' => "",
        'order_id' => $order_id,
        'type' => $order[0]['payment_method'],
        'txn_id' => "",
        'amount' => $order[0]['final_total'],
        'status' => $status,
        'currency_code' => "",
        'message' => $message,
    ];
    add_transaction($data);
}
function priceFormat($currencyCode, $price, $decimalDigits)
{
    $r =  number_to_currency($price, $currencyCode, locale_get_default(), $decimalDigits);
    // Check if price is empty or "null" (as string)
    if (empty($price) || $price === "null") {
        return $price;
    }
    // Convert price string to a float after removing commas
    $newPrice = (float)str_replace(",", "", $price);
    // Define the locale
    $locale = locale_get_default(); // or specify a default locale, e.g., "en_US"
    // Initialize formatter
    $formatter = new NumberFormatter($locale, NumberFormatter::CURRENCY);
    $formatter->setTextAttribute(NumberFormatter::CURRENCY_CODE, $currencyCode);
    $formatter->setAttribute(NumberFormatter::FRACTION_DIGITS, $decimalDigits);
    // Format and return the price
    return $formatter->formatCurrency($newPrice, $currencyCode);
}
function update_custom_job_status($order_id, $status)
{
    $get_custom_job_data = fetch_details('orders', ['id' => $order_id]);
    if (!empty($get_custom_job_data)) {
        if ($get_custom_job_data[0]['custom_job_request_id'] != "" || $get_custom_job_data[0]['custom_job_request_id'] != NULL) {
            $update = update_details(['status' => $status], ['id' => $get_custom_job_data[0]['custom_job_request_id']], 'custom_job_requests');
        }
    }
}
function truncateWords($str, $limit = 20)
{
    $str = strip_tags($str); // Remove HTML tags
    if (mb_strlen($str) <= $limit) {
        return $str;
    }
    return mb_substr($str, 0, $limit) . '...';
}
if (!function_exists('image_url')) {
    function image_url($image_path)
    {
        $settings = get_settings('general_settings', true);
        $file_manager = $settings['file_manager'] ?? "local_server";
        if ($file_manager == "aws_s3") {
            return $image_path;
        } else if ($file_manager == "local_server") {
            return $image_path;
            // Trim the image path to remove any whitespace
            $image_path = trim($image_path);
            // Get settings for default logo
            $settings = get_settings('general_settings', true);
            $default_logo = base_url("public/uploads/site/" . $settings['logo']);
            // If empty path, return default logo
            if (empty($image_path)) {
                return $default_logo;
            }
            // Handle URLs
            if (filter_var($image_path, FILTER_VALIDATE_URL)) {
                // Parse the URL to get the path
                $parsed_url = parse_url($image_path);
                $url_path = isset($parsed_url['path']) ? urldecode($parsed_url['path']) : ''; // Check if 'path' exists
                // Extract the path after 'public/'
                if (strpos($url_path, '/public/') !== false) {
                    $relative_path = substr($url_path, strpos($url_path, '/public/') + 8);
                } else {
                    $relative_path = ltrim($url_path, '/');
                }
                // Define possible paths to check
                $possible_paths = [
                    FCPATH . $relative_path,
                    FCPATH . 'public/' . $relative_path
                ];
                foreach ($possible_paths as $path) {
                    if (is_file($path)) { // Use is_file instead of file_exists
                        return $image_path;
                    }
                }
                // Additional check for direct path
                $direct_path = FCPATH . str_replace('/public/', '', $url_path);
                if (is_file($direct_path)) {
                    return $image_path;
                }
                // If file not found, return default logo
                return $default_logo;
            }
            // Handle local paths
            // Remove 'public/' prefix if exists
            $clean_path = str_replace('public/', '', $image_path);
            $clean_path = urldecode($clean_path); // Decode URL-encoded characters
            // Define possible local paths to check
            $possible_paths = [
                FCPATH . $clean_path,
                FCPATH . 'public/' . $clean_path,
                FCPATH . 'backend/' . $clean_path
            ];
            foreach ($possible_paths as $path) {
                if (is_file($path)) {
                    $final_url = base_url(str_replace(FCPATH, '', $path));
                    return $final_url;
                }
            }
            // If no file found, return default logo
            return $default_logo;
        } else {
            return $image_path;
        }
    }
}
function upload_to_aws_s3($file_name, $file_tmp_name, $folder_name)
{
    try {
        $S3_settings = get_settings('general_settings', true);
        $aws_key = $S3_settings['aws_access_key_id'] ?? '';
        $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
        $bucket = $S3_settings['aws_bucket'] ?? '';
        $region = $S3_settings['aws_region'] ?? 'us-east-1';
        $directory = $folder_name ?? ''; // Add custom directory here
        if (!$aws_key || !$aws_secret || !$bucket || !$region) {
            return [
                "error" => true,
                "message" => "AWS configuration missing. Please check configuration variables."
            ];
        }
        $config = [
            'region' => $region,
            'version' => 'latest',
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ],
        ];
        $s3 = new S3Client($config);
        $file_open = fopen($file_tmp_name, 'r');
        // Construct the full file path with the directory
        $key = $directory ? rtrim($directory, '/') . '/' . $file_name : $file_name;
        $result = $s3->putObject([
            'Bucket' => $bucket,
            'Key'    => $key,
            'Body'   => $file_open,
            'ContentType' => mime_content_type($file_tmp_name) // Ensure the file has the correct MIME type
            // 'ACL'    => 'public-read'
        ]);
        fclose($file_open);
        if ($result && isset($result['ObjectURL'])) {
            $file_url = $result['ObjectURL'];
            return [
                "error" => false,
                "data" => $file_url,
                "message" => "File uploaded successfully"
            ];
        } else {
            return [
                "error" => true,
                "data" => "",
                "message" => "File upload failed"
            ];
        }
    } catch (Exception $e) {
        return [
            "error" => true,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}
function get_aws_s3_folder_info($folder_name = null)
{
    try {
        $S3_settings = get_settings('general_settings', true);
        $aws_key = $S3_settings['aws_access_key_id'] ?? '';
        $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
        $bucket = $S3_settings['aws_bucket'] ?? '';
        $region = $S3_settings['aws_default_region'] ?? 'us-east-1';
        if (!$aws_key || !$aws_secret || !$bucket || !$region) {
            return [
                "error" => true,
                "message" => "AWS configuration missing. Please check configuration variables."
            ];
        }
        $config = [
            'region' => $region,
            'version' => 'latest',
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ],
        ];
        $s3 = new S3Client($config);
        $params = [
            'Bucket' => $bucket,
            'Delimiter' => '/',
        ];
        if ($folder_name) {
            // If a specific folder name is provided, set it as the Prefix
            $params['Prefix'] = rtrim($folder_name, '/') . '/';
        }
        $result = $s3->listObjectsV2($params);
        $folderInfo = [];
        if (isset($result['CommonPrefixes']) || $folder_name) {
            $folders = $folder_name ? [['Prefix' => $params['Prefix']]] : $result['CommonPrefixes'];
            foreach ($folders as $prefix) {
                $folderPath = $prefix['Prefix'];
                $folderName = rtrim(basename($folderPath), '/');
                // Count files in folder
                $fileParams = [
                    'Bucket' => $bucket,
                    'Prefix' => $folderPath,
                ];
                $fileResult = $s3->listObjectsV2($fileParams);
                $fileCount = isset($fileResult['Contents']) ? count($fileResult['Contents']) : 0;
                $folderInfo[] = [
                    'name' => $folderName,
                    'path' => $folderPath,
                    'fileCount' => $fileCount
                ];
            }
        }
        return [
            "error" => false,
            "data" => $folderInfo,
            "message" => "Folder information retrieved successfully"
        ];
    } catch (AwsException $e) {
        return [
            "error" => true,
            "message" => "AWS Error: " . $e->getMessage()
        ];
    } catch (Exception $e) {
        return [
            "error" => true,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}
function get_provider_files_from_aws_s3_folder($segments)
{
    $S3_settings = get_settings('general_settings', true);
    $aws_key = $S3_settings['aws_access_key_id'] ?? '';
    $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
    $region = $S3_settings['aws_region'] ?? 'us-east-1';
    $aws_url = $S3_settings['aws_url'] ?? '';
    $bucket_name = $S3_settings['aws_bucket'] ?? '';
    // Validate AWS configuration
    if (!$aws_key || !$aws_secret || !$bucket_name || !$region) {
        return [
            "error" => true,
            "message" => "AWS configuration missing. Please check configuration variables."
        ];
    }
    $config = [
        'region' => $region,
        'version' => 'latest',
        'credentials' => [
            'key'    => $aws_key,
            'secret' => $aws_secret,
        ],
    ];
    $s3 = new S3Client($config);
    $new_path = implode('/', array_slice($segments, array_search('get-gallery-files', $segments) + 1));
    $result = $s3->listObjects([
        'Bucket' => $bucket_name,
        'Prefix' => $new_path,
    ]);
    $files = array_map(function ($object) use ($bucket_name, $s3, $new_path, $aws_url) {
        $fileName = basename($object['Key']);
        return [
            'name' => $fileName,
            'type' => $s3->headObject([
                'Bucket' => $bucket_name,
                'Key'    => $object['Key'],
            ])['ContentType'],
            'size' => $object['Size'],
            'full_path' => $aws_url . '/' .  $object['Key'],
            // 'full_path' => $s3->getObjectUrl($bucket_name, $object['Key']),
            'path' => $object['Key'],
            'disk' => 'aws_s3'
        ];
    }, $result['Contents']);
    return $files;
}
function get_aws_s3_file($file_path)
{
    try {
        $S3_settings = get_settings('general_settings', true);
        $aws_key = $S3_settings['aws_access_key_id'] ?? '';
        $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
        $aws_url = $S3_settings['aws_url'] ?? '';
        $region = $S3_settings['aws_region'] ?? 'us-east-1';
        $bucket_name = $S3_settings['aws_bucket'] ?? '';
        // Validate AWS configuration
        if (!$aws_key || !$aws_secret || !$bucket_name || !$region) {
            return [
                "error" => true,
                "message" => "AWS configuration missing. Please check configuration variables."
            ];
        }
        $config = [
            'region' => $region,
            'version' => 'latest',
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ],
        ];
        $s3 = new S3Client($config);
        // Check if file exists
        if (!$s3->doesObjectExist($bucket_name, $file_path)) {
            return [
                "error" => true,
                "message" => "File does not exist in S3"
            ];
        }
        // Get file metadata
        $result = $s3->headObject([
            'Bucket' => $bucket_name,
            'Key'    => $file_path
        ]);
        $fileName = basename($file_path);
        $fileData = [
            'name' => $fileName,
            'type' => getFileType($fileName),
            'size' => formatFileSize($result['ContentLength']),
            'full_path' => $aws_url . '/' . $file_path,
            'path' => $file_path,
            'lastModified' => $result['LastModified']->format('Y-m-d H:i:s'),
            'contentType' => $result['ContentType']
        ];
        return [
            "error" => false,
            "data" => $fileData,
            "message" => "File retrieved successfully"
        ];
    } catch (AwsException $e) {
        return [
            "error" => true,
            "message" => "AWS Error: " . $e->getMessage()
        ];
    } catch (Exception $e) {
        return [
            "error" => true,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}
function get_aws_s3_folder_files($folder_path)
{
    try {
        $S3_settings = get_settings('general_settings', true);
        $aws_key = $S3_settings['aws_access_key_id'] ?? '';
        $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
        $aws_url = $S3_settings['aws_url'] ?? '';
        $region = $S3_settings['aws_region'] ?? 'us-east-1';
        $bucket_name = $S3_settings['aws_bucket'] ?? '';
        if (!$aws_key || !$aws_secret || !$bucket_name || !$region) {
            return [
                "error" => true,
                "message" => "AWS configuration missing. Please check configuration variables."
            ];
        }
        $config = [
            'region' => $region,
            'version' => 'latest',
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ],
        ];
        $s3 = new S3Client($config);
        // Ensure folder path ends with '/'
        $folder_path = rtrim($folder_path, '/') . '/';
        $params = [
            'Bucket' => $bucket_name,
            'Prefix' => $folder_path,
        ];
        $result = $s3->listObjectsV2($params);
        $files = [];
        if (isset($result['Contents'])) {
            foreach ($result['Contents'] as $file) {
                // Skip the folder itself
                if ($file['Key'] !== $folder_path) {
                    $fileName = basename($file['Key']);
                    $files[] = [
                        'name' => $fileName,
                        'type' => getFileType($fileName),
                        'size' => formatFileSize($file['Size']),
                        'full_path' => $aws_url . '/' . $file['Key'],
                        'path' => $file['Key'],
                        'lastModified' => $file['LastModified']->format('Y-m-d H:i:s')
                    ];
                }
            }
        }
        return [
            "error" => false,
            "data" => $files,
            "message" => "Files retrieved successfully"
        ];
    } catch (AwsException $e) {
        return [
            "error" => true,
            "message" => "AWS Error: " . $e->getMessage()
        ];
    } catch (Exception $e) {
        return [
            "error" => true,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}
function download_aws_s3_file($file_path, $download_name = null)
{
    try {
        $S3_settings = get_settings('general_settings', true);
        $aws_key = $S3_settings['aws_access_key_id'] ?? '';
        $aws_secret = $S3_settings['aws_secret_access_key'] ?? '';
        $region = $S3_settings['aws_region'] ?? 'us-east-1';
        $bucket_name = $S3_settings['aws_bucket'] ?? '';
        if (!$aws_key || !$aws_secret || !$bucket_name || !$region) {
            return [
                "error" => true,
                "message" => "AWS configuration missing. Please check configuration variables."
            ];
        }
        $s3 = new S3Client([
            'version' => 'latest',
            'region'  => $region,
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ]
        ]);
        // Get file metadata
        $result = $s3->headObject([
            'Bucket' => $bucket_name,
            'Key'    => $file_path
        ]);
        // Set download name if not provided
        if (!$download_name) {
            $download_name = basename($file_path);
        }
        // Get the file content type
        $contentType = $result['ContentType'];
        // Get the file
        $file = $s3->getObject([
            'Bucket' => $bucket_name,
            'Key'    => $file_path
        ]);
        // Set headers for download
        header('Content-Type: ' . $contentType);
        header('Content-Disposition: attachment; filename="' . $download_name . '"');
        header('Content-Length: ' . $file['ContentLength']);
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');
        // Output the file content
        echo $file['Body'];
        exit;
    } catch (S3Exception $e) {
        return [
            "error" => true,
            "message" => "S3 Error: " . $e->getMessage()
        ];
    } catch (Exception $e) {
        return [
            "error" => true,
            "message" => "An error occurred: " . $e->getMessage()
        ];
    }
}
function formatFileSize($bytes)
{
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' bytes';
    }
}
function getFileType($filename)
{
    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    $fileTypes = [
        // Images
        'jpg' => 'image',
        'jpeg' => 'image',
        'png' => 'image',
        'gif' => 'image',
        'svg' => 'image',
        'webp' => 'image',
        // Documents
        'pdf' => 'document',
        'doc' => 'document',
        'docx' => 'document',
        'xls' => 'document',
        'xlsx' => 'document',
        'ppt' => 'document',
        'pptx' => 'document',
        'txt' => 'document',
        // Audio
        'mp3' => 'audio',
        'wav' => 'audio',
        'ogg' => 'audio',
        // Video
        'mp4' => 'video',
        'avi' => 'video',
        'mov' => 'video',
        'wmv' => 'video',
        // Archives
        'zip' => 'archive',
        'rar' => 'archive',
        '7z' => 'archive',
        'tar' => 'archive',
        'gz' => 'archive'
    ];
    return $fileTypes[$extension] ?? 'other';
}
function upload_file($file, $upload_path, $error_message, $folder_name, $is_login_image = null)
{
    $settings = get_settings('general_settings', true);
    $file_manager = $settings['file_manager'];
    if ($file_manager == "aws_s3") {
        $file_name = $file->getRandomName();
        $file_tmp_name = $file->getTempName();
        $result = upload_to_aws_s3($file_name, $file_tmp_name, $folder_name);
        if ($result['error']) {
            return ['error' => true, 'message' => "file not uploded"];
        } else {
            return ['error' => false, 'file_path' => $result, 'disk' => 'aws_s3', 'file_name' => $file_name];
        }
    } else if ($file_manager == "local_server") {
        if (!is_dir($upload_path)) {
            if (!mkdir($upload_path, 0755, true)) {
                return ['error' => false, 'message' => $error_message];
            }
        }
        if ($file->isValid() && !$file->hasMoved()) {
            if ($is_login_image == 'yes' && $upload_path == "public/frontend/retro/") {
                $file_name = "Login_BG.jpg";
            } else {
                $file_name = $file->getRandomName();
            }
            if ($file->isValid() && !$file->hasMoved()) {
                $tempPath = $file->getTempName();
                $full_path = $upload_path . '/' . $file_name;
                compressImage($tempPath, $full_path, 70);
                return ['error' => false, 'file_path' => $full_path, 'disk' => 'local_server', 'file_name' => $file_name];
            }
        }
    }
    return ['error' => true, 'message' => 'Failed to upload the file.'];
}
function get_top_rated_providers($latitude = null, $longitude = null)
{
    $db = \Config\Database::connect();
    $disk = fetch_current_file_manager();
    $rating_data = $db->table('partner_details pd')
        ->select('p.id, p.username, p.company, p.image, pd.banner, pd.company_name, pd.at_store, pd.at_doorstep,
                  COUNT(sr.rating) as number_of_rating, 
                  COALESCE(SUM(sr.rating), 0) as total_rating,
                  CASE 
                      WHEN COUNT(sr.rating) > 0 THEN SUM(sr.rating) / COUNT(sr.rating)
                      ELSE 0 
                  END as average_rating,
                  ps.status as subscription_status')
        ->join('users p', 'p.id = pd.partner_id')
        ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id')
        ->join('services s', 's.user_id = pd.partner_id', 'left')
        ->join('services_ratings sr', 'sr.service_id = s.id', 'left')
        ->join('custom_job_requests cj', 'sr.custom_job_request_id = cj.id', 'left')
        ->join('partner_bids pb', 'pb.custom_job_request_id = cj.id', 'left')
        ->where('ps.status', 'active')
        ->where("(s.user_id = pd.partner_id) OR (pb.partner_id = pd.partner_id AND sr.custom_job_request_id IS NOT NULL)")
        ->groupBy('p.id')
        ->orderBy('average_rating', 'desc')
        ->get()
        ->getResultArray();
    // Filter out providers with exceeded order limits or inactive subscriptions
    foreach ($rating_data as $key => $row) {
        $partner_subscription = fetch_details('partner_subscriptions', ['partner_id' => $row['id'], 'status' => 'active']);
        if ($partner_subscription) {
            $subscription_purchase_date = $partner_subscription[0]['updated_at'];
            $partner_order_limit = fetch_details('orders', ['partner_id' => $row['id'], 'parent_id' => null, 'created_at >' => $subscription_purchase_date]);
            $subscription_data = fetch_details('partner_subscriptions', ['partner_id' => $row['id'], 'status' => 'active']);
            $subscription_order_limit = $subscription_data[0]['max_order_limit'];
            if ($subscription_data[0]['order_type'] == 'limited' && count($partner_order_limit) >= $subscription_order_limit) {
                unset($rating_data[$key]);
            }
        } else {
            unset($rating_data[$key]);
        }
    }
    $rating_data = array_values($rating_data);
    if (!empty($rating_data)) {
        foreach ($rating_data as &$provider) {
            if ($provider['image'] != null || $provider['banner'] != null) {
                if ($disk == 'local_server') {
                    $provider['image'] = get_image_url($provider['image']);
                } else if ($disk) {
                    $provider['image'] = fetch_cloud_front_url('profile', $provider['image']);
                } else {
                    $provider['image'] = get_image_url($provider['banner']);
                }
                if ($disk == 'local_server') {
                    $provider['banner_image'] = base_url($provider['banner'])  ?? '';
                } else if ($disk) {
                    $provider['banner_image'] = fetch_cloud_front_url('banner', $provider['banner']);
                } else {
                    $provider['banner_image'] = base_url($provider['banner'])  ?? '';
                }
            } else {
                $provider['image'] = '';
                $provider['banner_image'] = '';
            }
            unset($provider['minimum_order_amount'], $provider['banner']);
            $total_services_of_providers = fetch_details(
                'services',
                [
                    'user_id' => $provider['id'],
                    'at_store' => $provider['at_store'],
                    'at_doorstep' => $provider['at_doorstep']
                ],
                ['id']
            );
            $provider['total_services'] = count($total_services_of_providers);
            // Safely calculate average rating
            $provider['average_rating'] = $provider['number_of_rating'] > 0
                ? ($provider['total_rating'] / $provider['number_of_rating'])
                : 0;
            $provider_services = fetch_details(
                'services',
                ['user_id' => $provider['id']],
                ['title']
            );
            $provider['services'] = $provider_services;
        }
    }
    return $rating_data;
}
function get_image_url($image_path)
{
    if (file_exists(FCPATH . 'public/backend/assets/profiles/' . $image_path)) {
        return base_url('public/backend/assets/profiles/' . $image_path);
    }
    if (file_exists(FCPATH . $image_path)) {
        return base_url($image_path);
    }
    if (file_exists(FCPATH . "public/uploads/users/partners/" . $image_path)) {
        return base_url("public/uploads/users/partners/" . $image_path);
    }
    return base_url("public/backend/assets/profiles/default.png");
}
function generate_unique_slug(string $slug, string $table, int|null $excludeID = null, int $count = 0): string
{
    // Check if the input contains non-English characters
    $isNonEnglish = !preg_match('/^[a-zA-Z0-9\s\-_.,!@#$%^&*()+=]+$/', $slug);

    // If non-English characters are detected, auto-assign slug with number suffix
    if ($isNonEnglish) {
        // Generate a base slug using the table name and current timestamp for non-English inputs
        $baseSlug = 'slug';
        $newSlug = $count ? $baseSlug . '-' . $count : $baseSlug;

        // Get the CI4 database connection
        $db = \Config\Database::connect();
        $builder = $db->table($table);

        // Build query to check for existing slug
        $builder->where('slug', $newSlug);
        if ($excludeID !== null) {
            $builder->where('id !=', $excludeID);
        }

        // Check if there are any results
        $query = $builder->get();
        if ($query->getNumRows() > 0) {
            // If the slug exists, call the function recursively with incremented count
            return generate_unique_slug($slug, $table, $excludeID, $count + 1);
        }
        return $newSlug;
    }

    // For English text, proceed with normal slug generation
    // Create a URL-safe slug
    $slug = url_title($slug, '-', true);
    $newSlug = $count ? $slug . '-' . $count : $slug;

    // Get the CI4 database connection
    $db = \Config\Database::connect();
    $builder = $db->table($table); // Use the provided table name

    // Build query to check for existing slug
    $builder->where('slug', $newSlug);
    if ($excludeID !== null) {
        $builder->where('id !=', $excludeID);
    }

    // Check if there are any results
    $query = $builder->get();
    if ($query->getNumRows() > 0) {
        // If the slug exists, call the function recursively
        return generate_unique_slug($slug, $table, $excludeID, $count + 1);
    }
    return $newSlug;
}
function delete_file_based_on_server($folder_name, $file_name, $disk)
{
    $settings = get_settings('general_settings', true);
    if ($disk == "aws_s3") {
        $aws_key = $settings['aws_access_key_id'] ?? '';
        $aws_secret = $settings['aws_secret_access_key'] ?? '';
        $bucket = $settings['aws_bucket'] ?? '';
        $region = $settings['aws_region'] ?? 'us-east-1';
        if (!$aws_key || !$aws_secret || !$bucket || !$region) {
            return ['error' => true, 'message' => "AWS configuration missing. Please check configuration variables."];
        }
        $config = [
            'region' => $region,
            'version' => 'latest',
            'credentials' => [
                'key'    => $aws_key,
                'secret' => $aws_secret,
            ],
        ];
        $s3 = new S3Client($config);
        // The file key to delete on S3
        $file_key = $folder_name . '/' . $file_name; // Construct the full path
        try {
            $s3->deleteObject(['Bucket' => $bucket, 'Key'    => $file_key]);
            return ['error' => false, 'message' => "File deleted successfully from S3."];
        } catch (Aws\S3\Exception\S3Exception $e) {
            return ['error' => false, 'message' => "Failed to delete file from S3: " . $e->getMessage()];
        }
    } else {
        if ($folder_name == "categories") {
            $path = "public/uploads/categories";
        }
        if ($folder_name == "site") {
            $path = "public/uploads/site";
        }
        if ($folder_name == "profile") {
            $path = "public/backend/assets/profile/";
        }
        if ($folder_name == "banner") {
            $path = "public/backend/assets/banner/";
        }
        if ($folder_name == "national_id") {
            $path = "public/backend/assets/national_id/";
        }
        if ($folder_name == "address_id") {
            $path = "public/backend/assets/address_id//";
        }
        if ($folder_name == "passport") {
            $path = "public/backend/assets/passport/";
        }
        if ($folder_name == "partner") {
            $path = "public/uploads/partner";
        }
        if ($folder_name == "sliders") {
            $path = "public/uploads/sliders";
        }
        if ($folder_name == "services") {
            $path = "public/uploads/services";
        }
        if ($folder_name == "feature_section") {
            $path = "public/uploads/feature_section";
        }
        if ($folder_name == "ratings") {
            $path = "public/uploads/ratings";
        }
        if ($folder_name == "promocodes") {
            $path = "public/uploads/promocodes/";
        }
        if ($folder_name == "become_provider") {
            $path = "public/uploads/become_provider/";
        }
        if ($folder_name == "seo_settings") {
            $path = "public/uploads/seo_settings/general_seo_settings/";
        }
        if ($folder_name == "service_seo_settings") {
            $path = "public/uploads/seo_settings/service_seo_settings/";
        }
        if ($folder_name == "category_seo_settings") {
            $path = "public/uploads/seo_settings/category_seo_settings/";
        }
        if ($folder_name == "provider_seo_settings") {
            $path = "public/uploads/seo_settings/provider_seo_settings/";
        }
        if ($folder_name == "blog_seo_settings") {
            $path = "public/uploads/seo_settings/blog_seo_settings/";
        }
        if ($folder_name == "blogs") {
            $path = "public/uploads/blogs/";
        }
        if ($folder_name == "blogs/images") {
            $path = "public/uploads/blogs/images/";
        }


        if (!empty($file_name)) {
            $file_path = $path . '/' . $file_name;
            if (file_exists($file_path)) {
                if (unlink($file_path)) {
                    return [
                        "error" => false,
                        "message" => "File deleted successfully from the local server"
                    ];
                } else {
                    return [
                        "error" => true,
                        "message" => "Failed to delete file from the local server"
                    ];
                }
            } else {
                return [
                    "error" => true,
                    "message" => "File not found on the local server"
                ];
            }
        }
    }
}

// function fetch_cloud_front_url_old($folder_name, $file_name)
// {
//     $settings = get_settings('general_settings', true);
//     if (empty($settings['aws_url'])) {
//         return $file_name ?? ''; // Return empty string if file_name is null
//     }
//     $aws_url = rtrim($settings['aws_url'] ?? '', '/'); // Ensure no trailing slash
//     $folder_name = trim($folder_name ?? '', '/');     // Remove leading/trailing slashes
//     $file_name = ltrim($file_name ?? '', '/');        // Ensure file_name is not null
//     // Remove "public/uploads/", "backend/", or "assets/" from the file_name if present
//     $file_name = preg_replace('#^(public|uploads|backend|assets|services|chat_attachment|provider_work_evidence|national_id|banner|address_id|passport|promocodes|ratings|profile|profiles|seo_settings|general_seo_settings)(/.*)?/#', '', $file_name);
//     return $aws_url . '/' . $folder_name . '/' . $file_name;
// }

function fetch_cloud_front_url($folder_name, $file_name)
{
    $settings = get_settings('general_settings', true);
    $aws_url = rtrim($settings['aws_url'] ?? '', '/');

    if (empty($aws_url) || empty($file_name)) {
        return $file_name ?? '';
    }

    $folder_name = trim($folder_name ?? '', '/');
    $file_name = ltrim($file_name ?? '', '/');

    $folder_config = get_s3_folder_config();

    foreach ($folder_config as $folder => $behavior) {
        if (str_starts_with($file_name, $folder . '/')) {
            if ($behavior === 'preserve') {
                $file_name = preg_replace('#^' . preg_quote($folder) . '/#', '', $file_name);
            } else {
                $file_name = basename($file_name); // Simple, fast cut
            }
            break;
        }
    }

    return $aws_url . '/' . $folder_name . '/' . $file_name;
}

function get_file_url($disk, $file_key, $default_path = 'public/backend/assets/default.png', $cloud_front_type = '')
{
    // If it's already a full URL, just return it (no further processing needed)
    if (is_full_url($file_key)) {
        return $file_key;
    }

    if (empty($file_key)) {
        return base_url($default_path);
    }

    switch ($disk) {
        case 'local_server':
            $local_path = FCPATH . $file_key;
            return is_file($local_path)
                ? base_url($file_key)
                : base_url($default_path);

        case 'aws_s3':
            $url = fetch_cloud_front_url($cloud_front_type, $file_key);
            return remote_file_exists($url)
                ? $url
                : base_url($default_path);

        default:
            $fallback_path = FCPATH . $file_key;
            return is_file($fallback_path)
                ? base_url($file_key)
                : base_url($default_path);
    }
}

function is_full_url($path)
{
    return is_string($path) && preg_match('#^https?://#i', $path);
}



function remote_file_exists($url)
{
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_NOBODY => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 2,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return $http_code === 200;
}

function get_s3_folder_config()
{
    return [
        'seo_settings' => 'preserve',
        'user_documents' => 'preserve',
        'category_images' => 'preserve',

        'public' => 'remove',
        'uploads' => 'remove',
        'backend' => 'remove',
        'assets' => 'remove',
        'services' => 'remove',
        'chat_attachment' => 'remove',
        'provider_work_evidence' => 'remove',
        'national_id' => 'remove',
        'banner' => 'remove',
        'address_id' => 'remove',
        'passport' => 'remove',
        'promocodes' => 'remove',
        'ratings' => 'remove',
        'profile' => 'remove',
        'profiles' => 'remove'
    ];
}

function fetch_current_file_manager()
{
    $setting = get_settings('storage_disk');
    if (empty($setting) || !isset($setting)) {
        $setting = 'local_server';
    }
    return $setting;
}
function fetch_partner_formatted_data($user_id)
{
    $userdata = fetch_details('users', ['id' => $user_id], [
        'id',
        'username',
        'email',
        'balance',
        'active',
        'first_name',
        'last_name',
        'company',
        'phone',
        'country_code',
        'fcm_id',
        'image',
        'city_id',
        'city',
        'latitude',
        'longitude'
    ])[0];
    $partnerData = fetch_details('partner_details', ['partner_id' => $user_id])[0];
    $subscription = fetch_details('partner_subscriptions', ['partner_id' => $user_id], [], 1, 0, 'id', 'DESC');
    $disk = fetch_current_file_manager();
    // if ($disk == 'local_server') {
    //     $userdata['image'] = (file_exists($userdata['image'])) ? base_url($userdata['image']) : "";
    // } else if ($disk == 'aws_s3') {
    //     $userdata['image'] = fetch_cloud_front_url('profile', $userdata['image']);
    // } else {
    //     $userdata['image'] = "";
    // }

    // if ($disk == 'local_server') {
    //     $partnerData['banner'] = (file_exists($partnerData['banner'])) ? base_url($partnerData['banner']) : "";
    // } else if ($disk == 'aws_s3') {
    //     $partnerData['banner'] = fetch_cloud_front_url('banner', $partnerData['banner']);
    // } else {
    //     $partnerData['banner'] = "";
    // }
    // if ($disk == 'local_server') {
    //     if (!empty($partnerData['address_id']) && is_string($partnerData['address_id'])) {
    //         $partnerData['address_id'] = base_url($partnerData['address_id']);
    //     } else {
    //         $partnerData['address_id'] = null;
    //     }
    // } else if ($disk == 'aws_s3') {
    //     $partnerData['address_id'] = fetch_cloud_front_url('address_id', $partnerData['address_id']);
    // } else {
    //     $partnerData['address_id'] = null;
    // }
    // if ($disk == 'local_server') {
    //     if (!empty($partnerData['passport']) && is_string($partnerData['passport'])) {
    //         $partnerData['passport'] = base_url($partnerData['passport']);
    //     } else {
    //         $partnerData['passport'] = null;
    //     }
    // } else if ($disk == 'aws_s3') {
    //     $partnerData['passport'] = fetch_cloud_front_url('passport', $partnerData['passport']);
    // } else {
    //     $partnerData['passport'] = "";
    // }
    // if ($disk == 'local_server') {
    //     $partnerData['national_id'] = base_url($partnerData['national_id']);
    // } else if ($disk == 'aws_s3') {
    //     $partnerData['national_id'] = fetch_cloud_front_url('national_id', $partnerData['national_id']);
    // } else {
    //     $partnerData['national_id'] = "";
    // }

    $imageFields = [
        'userdata' => [
            'image' => 'profile'
        ],
        'partnerData' => [
            'banner' => 'banner',
            'passport' => 'passport',
            'national_id' => 'national_id',
            'address_id' => 'address_id'
        ]
    ];

    foreach ($imageFields as $varName => $fields) {
        foreach ($fields as $key => $type) {
            $value = ${$varName}[$key] ?? '';

            switch ($disk) {
                case 'local_server':
                    $fullPath = FCPATH . ltrim($value, '/');
                    ${$varName}[$key] = (!empty($value) && is_file($fullPath))
                        ? base_url($value)
                        : ($type === 'address_id' ? null : '');
                    break;

                case 'aws_s3':
                    ${$varName}[$key] = !empty($value)
                        ? fetch_cloud_front_url($type, $value)
                        : ($type === 'address_id' ? null : '');
                    break;

                default:
                    ${$varName}[$key] = ($type === 'address_id' ? null : '');
            }
        }
    }

    $get_settings = get_settings('general_settings', true);
    $partnerData['pre_booking_chat'] = ($get_settings['allow_pre_booking_chat'] == 1) ? ($partnerData['pre_chat'] ?? "") : 0;
    $partnerData['post_booking_chat'] = ($get_settings['allow_post_booking_chat'] == 1) ? ($partnerData['chat'] ?? "") : 0;
    if (!empty($partnerData['other_images'])) {
        if (isset($partnerData['other_images'])) {
            $decodedImages = json_decode($partnerData['other_images'], true);
            $otherImages = [];
            if (is_array($decodedImages)) {
                foreach ($decodedImages as $image) {
                    if ($disk == "local_server") {
                        $otherImages[] = base_url($image);
                    } else if ($disk == "aws_s3") {
                        $otherImages[] = fetch_cloud_front_url('partner', $image);
                    } else {
                        $otherImages[] = base_url($image);
                    }
                }
            }
            $partnerData['other_images'] = $otherImages;
        }
    } else {
        $partnerData['other_images'] = [];
    }
    if (!empty($partnerData['custom_job_categories'])) {
        $partnerData['custom_job_categories'] =
            json_decode($partnerData['custom_job_categories'], true);
    } else {
        $partnerData['custom_job_categories'] = [];
    }
    $location_information = [
        'city' => $userdata['city'],
        'latitude' => $userdata['latitude'],
        'longitude' => $userdata['longitude'],
        'address' => $partnerData['address']
    ];
    $bank_information = [
        'tax_name' => $partnerData['tax_name'] == "null" ? "" : $partnerData['tax_name'],
        'tax_number' => $partnerData['tax_number'] == "null" ? "" : $partnerData['tax_number'],
        'account_number' => $partnerData['account_number'] == "null" ? "" : $partnerData['account_number'],
        'account_name' => $partnerData['account_name'] == "null" ? "" : $partnerData['account_name'],
        'bank_code' => $partnerData['bank_code'] == "null" ? "" : $partnerData['bank_code'],
        'swift_code' => $partnerData['swift_code'] == null ? "" : $partnerData['swift_code'],
        'bank_name' => $partnerData['bank_name'] == "null" ? "" : $partnerData['bank_name']
    ];
    // Get subscription translations if subscription exists
    $subscriptionTranslations = [];
    if (!empty($subscription[0]['subscription_id'])) {
        try {
            $subscriptionTranslationModel = new \App\Models\TranslatedSubscriptionModel();
            $currentLanguage = get_current_language_from_request();
            $defaultLanguage = get_default_language();

            // Get current language translation
            $currentTranslation = $subscriptionTranslationModel->getTranslation($subscription[0]['subscription_id'], $currentLanguage);

            // Get default language translation
            $defaultTranslation = $subscriptionTranslationModel->getTranslation($subscription[0]['subscription_id'], $defaultLanguage);

            // Set subscription translations
            if ($currentTranslation && $currentLanguage !== $defaultLanguage) {
                $subscriptionTranslations['translated_name'] = $currentTranslation['name'];
                $subscriptionTranslations['translated_description'] = $currentTranslation['description'];
            } else {
                // Fallback to default language or main table
                $subscriptionTranslations['translated_name'] = $defaultTranslation['name'] ?? $subscription[0]['name'] ?? '';
                $subscriptionTranslations['translated_description'] = $defaultTranslation['description'] ?? $subscription[0]['description'] ?? '';
            }
        } catch (\Exception $e) {
            // Log error but don't break the function
            log_message('error', 'Error getting subscription translations: ' . $e->getMessage());

            // Fallback to main table data
            $subscriptionTranslations['translated_name'] = $subscription[0]['name'] ?? '';
            $subscriptionTranslations['translated_description'] = $subscription[0]['description'] ?? '';
        }
    } else {
        // No subscription, set empty translated fields
        $subscriptionTranslations['translated_name'] = '';
        $subscriptionTranslations['translated_description'] = '';
    }

    $subscription_information = [
        'subscription_id' => $subscription[0]['subscription_id'] ?? "",
        'isSubscriptionActive' => $subscription[0]['status'] ?? "deactive",
        'created_at' => $subscription[0]['created_at'] ?? "",
        'updated_at' => $subscription[0]['updated_at'] ?? "",
        'is_payment' => $subscription[0]['is_payment'] ?? "",
        'id' => $subscription[0]['id'] ?? "",
        'partner_id' => $subscription[0]['partner_id'] ?? "",
        'purchase_date' => $subscription[0]['purchase_date'] ?? "",
        'expiry_date' => $subscription[0]['expiry_date'] ?? "",
        'name' => $subscription[0]['name'] ?? "",
        'description' => $subscription[0]['description'] ?? "",
        'duration' => $subscription[0]['duration'] ?? "",
        'price' => $subscription[0]['price'] ?? "",
        'discount_price' => $subscription[0]['discount_price'] ?? "",
        'order_type' => $subscription[0]['order_type'] ?? "",
        'max_order_limit' => $subscription[0]['max_order_limit'] ?? "",
        'is_commision' => $subscription[0]['is_commision'] ?? "",
        'commission_threshold' => $subscription[0]['commission_threshold'] ?? "",
        'commission_percentage' => $subscription[0]['commission_percentage'] ?? "",
        'publish' => $subscription[0]['publish'] ?? "",
        'tax_id' => $subscription[0]['tax_id'] ?? "",
        'tax_type' => $subscription[0]['tax_type'] ?? "",
        // Add translated subscription fields
        'translated_name' => $subscriptionTranslations['translated_name'],
        'translated_description' => $subscriptionTranslations['translated_description']
    ];
    if (!empty($subscription[0])) {
        $price = calculate_partner_subscription_price($subscription[0]['partner_id'], $subscription[0]['subscription_id'], $subscription[0]['id']);
    }
    $subscription_information['tax_value'] = $price[0]['tax_value'] ?? "";
    $subscription_information['price_with_tax'] = $price[0]['price_with_tax'] ?? "";
    $subscription_information['original_price_with_tax'] = $price[0]['original_price_with_tax'] ?? "";
    $subscription_information['tax_percentage'] = $price[0]['tax_percentage'] ?? "";

    // Use the new SEO model for formatted data
    $seoModel = new \App\Models\Seo_model();
    $seoModel->setTableContext('providers');

    $seoData = $seoModel->getSeoSettingsByReferenceId($user_id, 'meta');

    $formatted_seo_settings = [];
    if ($seoData) {
        $formatted_seo_settings['seo_title'] = $seoData['title'];
        $formatted_seo_settings['seo_description'] = $seoData['description'];
        $formatted_seo_settings['seo_keywords'] = $seoData['keywords'];
        $formatted_seo_settings['seo_og_image'] = $seoData['image']; // Already formatted with proper URL
        $formatted_seo_settings['seo_schema_markup'] = $seoData['schema_markup'] ?? '';
    } else {
        $formatted_seo_settings['seo_title'] = "";
        $formatted_seo_settings['seo_description'] = "";
        $formatted_seo_settings['seo_keywords'] = "";
        $formatted_seo_settings['seo_og_image'] = "";
        $formatted_seo_settings['seo_schema_markup'] = "";
    }

    // Process translations for partner data
    $translatedData = [];
    try {
        // Initialize translation model
        $translationModel = new \App\Models\TranslatedPartnerDetails_model();

        // Get all available translations for this partner
        $allTranslations = $translationModel->getAllTranslationsForPartner($user_id);

        // Get all available languages from the database dynamically
        // This ensures the structure supports all languages configured in the system
        $languageModel = new \App\Models\Language_model();
        $availableLanguages = $languageModel->select('code')->findAll();

        // Initialize translated_fields structure dynamically with all available languages
        // This replaces the hardcoded 'en' and 'hi' structure to support any number of languages
        $translatableFields = ['username', 'company_name', 'about', 'long_description'];
        $translatedData['translated_fields'] = [];

        foreach ($translatableFields as $field) {
            $translatedData['translated_fields'][$field] = [];
            foreach ($availableLanguages as $language) {
                $translatedData['translated_fields'][$field][$language['code']] = '';
            }
        }

        // Process each translation record
        foreach ($allTranslations as $translation) {
            $languageCode = $translation['language_code'];

            // Map the translatable fields
            if (isset($translation['username'])) {
                $translatedData['translated_fields']['username'][$languageCode] = $translation['username'];
            }
            if (isset($translation['company_name'])) {
                $translatedData['translated_fields']['company_name'][$languageCode] = $translation['company_name'];
            }
            if (isset($translation['about'])) {
                $translatedData['translated_fields']['about'][$languageCode] = $translation['about'];
            }
            if (isset($translation['long_description'])) {
                $translatedData['translated_fields']['long_description'][$languageCode] = $translation['long_description'];
            }
        }

        // Fill in fallback values from main table for empty translations
        // Only set English fallback values if they are empty
        if (empty($translatedData['translated_fields']['username']['en'])) {
            $translatedData['translated_fields']['username']['en'] = $userdata['username'] ?? '';
        }
        if (empty($translatedData['translated_fields']['company_name']['en'])) {
            $translatedData['translated_fields']['company_name']['en'] = $partnerData['company_name'] ?? '';
        }
        if (empty($translatedData['translated_fields']['about']['en'])) {
            $translatedData['translated_fields']['about']['en'] = $partnerData['about'] ?? '';
        }
        if (empty($translatedData['translated_fields']['long_description']['en'])) {
            $translatedData['translated_fields']['long_description']['en'] = $partnerData['long_description'] ?? '';
        }
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in fetch_partner_formatted_data: ' . $e->getMessage());

        // Set default structure even if translation fails - use dynamic language structure
        $languageModel = new \App\Models\Language_model();
        $availableLanguages = $languageModel->select('code')->findAll();

        $translatableFields = ['username', 'company_name', 'about', 'long_description'];
        $translatedData['translated_fields'] = [];

        foreach ($translatableFields as $field) {
            $translatedData['translated_fields'][$field] = [];
            foreach ($availableLanguages as $language) {
                // Set English as default for main values, others as empty
                if ($language['code'] === 'en') {
                    $translatedData['translated_fields'][$field][$language['code']] =
                        ($field === 'username' ? ($userdata['username'] ?? '') : ($partnerData[$field] ?? ''));
                } else {
                    $translatedData['translated_fields'][$field][$language['code']] = '';
                }
            }
        }
    }


    $data1 = [
        'subscription_information' => $subscription_information,
        'location_information' => $location_information,
        'user' => array_diff_key($userdata, array_flip(['city', 'latitude', 'longitude'])),
        'provder_information' => array_merge(
            array_diff_key($partnerData, array_flip([
                'tax_name',
                'tax_number',
                'account_number',
                'account_name',
                'bank_code',
                'swift_code',
                'bank_name',
                'address',
                'chat',
                'pre_chat'
            ])),
            $formatted_seo_settings,
            $translatedData // Add translated data to the response
        ),
        'bank_information' => $bank_information,
        'working_days' => array_map(function ($val) {
            return [
                'day' => $val['day'],
                'isOpen' => $val['is_open'],
                'start_time' => $val['opening_time'],
                'end_time' => $val['closing_time']
            ];
        }, fetch_details('partner_timings', ['partner_id' => $userdata['id']])),
    ];

    return $data1;
}

function get_cart_formatted_data($user_id, $search, $limit, $offset, $sort, $order, $where, $message, $error)
{
    $cart_details = fetch_cart(true, $user_id, $search, $limit, $offset, $sort, $order, $where);
    if (!empty($cart_details['data'])) {
        return response_helper(
            $message,
            $error,
            remove_null_values($cart_details['data']),
            200,
            remove_null_values(
                [
                    'provider_id' => $cart_details['provider_id'],
                    'provider_names' => $cart_details['provider_names'],
                    'service_ids' => $cart_details['service_ids'],
                    'qtys' => $cart_details['qtys'],
                    'visiting_charges' => $cart_details['visiting_charges'],
                    'advance_booking_days' => $cart_details['advance_booking_days'],
                    'company_name' => $cart_details['company_name'],
                    'total_duration' => $cart_details['total_duration'],
                    'is_pay_later_allowed' => $cart_details['is_pay_later_allowed'],
                    'total_quantity' => $cart_details['total_quantity'],
                    'sub_total' => $cart_details['sub_total'],
                    'overall_amount' => $cart_details['overall_amount'],
                    'total' => $cart_details['total'],
                    "at_store" => (!empty($cart_details) && isset($cart_details)) ? $cart_details['at_store'] : "0",
                    "at_doorstep" => (!empty($cart_details) && isset($cart_details)) ? $cart_details['at_doorstep'] : "0",
                    "is_online_payment_allowed" => (!empty($cart_details) && isset($cart_details)) ? $cart_details['is_online_payment_allowed'] : "0",
                ]
            )
        );
    } else {
        return response_helper('service not found');
    }
}
function store_notifications($title, $message, $type, $user_id, $is_readed, $notification_type, $date_sent, $target, $image = null, $order_id = null, $type_id = null, $order_status = null, $custom_job_request_id = null, $bidder_id = null, $bid_status = null)
{
    $data['title'] = $title;
    $data['message'] = $message;
    $data['type'] = $type;
    $data['type_id'] = $type_id;
    $data['image'] = $image;
    $data['order_id'] = $order_id;
    $data['user_id'] = $user_id;
    $data['is_readed'] = $is_readed;
    $data['notification_type'] = $notification_type;
    $data['target'] = $target;
    $data['order_status'] = $order_status;
    $data['custom_job_request_id'] = $custom_job_request_id;
    $data['bidder_id'] = $bidder_id;
    $data['bid_status'] = $bid_status;
    insert_details($data, 'notifications');
}
function store_users_fcm_id($user_id, $fcm_id, $platform, $web_fcm_id = null)
{
    if (!empty($fcm_id) || !empty($web_fcm_id)) {
        $fcmData['fcm_id'] = $fcm_id;
        if ($web_fcm_id != '') {
            $fcmData['fcm_id'] = $web_fcm_id;
        } else if ($fcm_id != '') {
            $fcmData['fcm_id'] = $fcm_id;
        }
        $data['user_id'] = $user_id;
        $data['fcm_id'] = $fcm_id ?? $web_fcm_id;
        $data['platform'] = $platform;

        $checkDataExist = fetch_details('users_fcm_ids', ['user_id' => $user_id, 'fcm_id' => $fcm_id ?? $web_fcm_id, 'platform' => $platform]);
        if (!empty($checkDataExist)) {
            update_details($data, ['id' => $checkDataExist[0]['id']], 'users_fcm_ids');
        } else {
            insert_details($data, 'users_fcm_ids');
        }
    }
    return true;
}

/**
 * Prepare country code data for forms
 * This function handles the logic for selecting the appropriate country code
 * 
 * @param string $user_country_code The user's existing country code from database
 * @return array Returns array with 'country_codes' and 'selected_country_code'
 */
function prepare_country_code_data($user_country_code = '')
{
    // Fetch all country codes
    $country_codes = fetch_details('country_codes', []);

    // Find default country code from the already-fetched country codes
    $default_country_code = '';
    foreach ($country_codes as $code) {
        if (!empty($code['is_default'])) {
            $default_country_code = $code['calling_code'];
            break;
        }
    }

    // Use user's country code if available, otherwise use default
    $selected_country_code = !empty($user_country_code) ? $user_country_code : $default_country_code;

    return [
        'country_codes' => $country_codes,
        'selected_country_code' => $selected_country_code
    ];
}

/**
 * Get default language code from database
 * 
 * @return string Default language code (defaults to 'en' if none set)
 */
function get_default_language(): string
{
    $defaultLanguage = fetch_details('languages', ['is_default' => '1']);
    if (!empty($defaultLanguage)) {
        return $defaultLanguage[0]['code'];
    }

    // Fallback to 'en' only if no default language is set in database
    return 'en';
}

/**
 * Get current language code from session
 * 
 * @return string Current language code (defaults to database default language)
 */
function get_current_language(): string
{
    $session = session();
    $currentLang = $session->get('lang');

    // Return current language or default to database default language
    if (!empty($currentLang)) {
        return $currentLang;
    }

    // Get default language from database
    return get_default_language();
}

/**
 * Get translated email template with fallback mechanism
 * 
 * Fetches email template with multi-language support:
 * 1. First tries to get translation for current language
 * 2. If not found, tries default language translation
 * 3. If no translations exist, uses original template from main table
 * 
 * @param string $type Email template type
 * @param string|null $languageCode Specific language code (optional, uses current language if not provided)
 * @return array|false Template data with translated content or false if template not found
 */
function get_translated_email_template(string $type, ?string $languageCode = null): array|false
{
    // Get language codes for fallback mechanism
    $currentLanguage = $languageCode ?? get_current_language();
    $defaultLanguage = get_default_language();

    // Fetch base email template
    $template_data = fetch_details('email_templates', ['type' => $type]);
    if (!$template_data) {
        return false;
    }

    // Initialize with original template data
    $result = $template_data[0];

    // Try to get translated template for requested language
    $translationModel = new \App\Models\Translated_email_template_model();
    $translatedTemplate = $translationModel->getTranslatedTemplate($template_data[0]['id'], $currentLanguage);

    // If translation exists for current language, use it
    if (!empty($translatedTemplate)) {
        $result['template'] = !empty($translatedTemplate['template']) ? $translatedTemplate['template'] : $result['template'];
        $result['subject'] = !empty($translatedTemplate['subject']) ? $translatedTemplate['subject'] : $result['subject'];
    }
    // If no translation for current language, try default language (if different from current)
    else if ($currentLanguage !== $defaultLanguage) {
        $defaultTranslatedTemplate = $translationModel->getTranslatedTemplate($template_data[0]['id'], $defaultLanguage);
        if (!empty($defaultTranslatedTemplate)) {
            $result['template'] = !empty($defaultTranslatedTemplate['template']) ? $defaultTranslatedTemplate['template'] : $result['template'];
            $result['subject'] = !empty($defaultTranslatedTemplate['subject']) ? $defaultTranslatedTemplate['subject'] : $result['subject'];
        }
    }
    // If no translations available, use original template from main table (already set in $result)

    return $result;
}

/**
 * Get translated SMS template with fallback mechanism
 * 
 * Fetches SMS template with multi-language support:
 * 1. First tries to get translation for current language
 * 2. If not found, tries default language translation
 * 3. If no translations exist, uses original template from main table
 * 
 * @param string $type SMS template type
 * @param string|null $languageCode Specific language code (optional, uses current language if not provided)
 * @return array|false Template data with translated content or false if template not found
 */
function get_translated_sms_template(string $type, ?string $languageCode = null): array|false
{
    // Get language codes for fallback mechanism
    $currentLanguage = $languageCode ?? get_current_language();
    $defaultLanguage = get_default_language();

    // Fetch base SMS template
    $template_data = fetch_details('sms_templates', ['type' => $type]);
    if (!$template_data) {
        return false;
    }

    // Initialize with original template data
    $result = $template_data[0];

    // Try to get translated template for requested language
    $translationModel = new \App\Models\Translated_sms_template_model();
    $translatedTemplate = $translationModel->getTranslatedTemplate($template_data[0]['id'], $currentLanguage);

    // If translation exists for current language, use it
    if (!empty($translatedTemplate)) {
        $result['template'] = !empty($translatedTemplate['template']) ? $translatedTemplate['template'] : $result['template'];
        $result['title'] = !empty($translatedTemplate['title']) ? $translatedTemplate['title'] : $result['title'];
    }
    // If no translation for current language, try default language (if different from current)
    else if ($currentLanguage !== $defaultLanguage) {
        $defaultTranslatedTemplate = $translationModel->getTranslatedTemplate($template_data[0]['id'], $defaultLanguage);
        if (!empty($defaultTranslatedTemplate)) {
            $result['template'] = !empty($defaultTranslatedTemplate['template']) ? $defaultTranslatedTemplate['template'] : $result['template'];
            $result['title'] = !empty($defaultTranslatedTemplate['title']) ? $defaultTranslatedTemplate['title'] : $result['title'];
        }
    }
    // If no translations available, use original template from main table (already set in $result)

    return $result;
}


/**
 * Get translated partner data based on current language
 * 
 * @param array $partnerData Original partner data
 * @param int $partnerId Partner ID
 * @return array Partner data with translated fields
 */
function get_translated_partner_data(array $partnerData, int $partnerId): array
{
    $currentLang = get_current_language();
    $defaultLangCode = get_default_language();

    // If current language is the default language, return original data
    if ($currentLang === $defaultLangCode) {
        return $partnerData;
    }

    try {
        // Get translated data for current language
        $translationModel = new \App\Models\TranslatedPartnerDetails_model();
        $translatedData = $translationModel->getTranslatedDetails($partnerId, $currentLang);

        // log_message('debug', 'translatedData: ' . json_encode($translatedData));
        if ($translatedData) {
            // Replace translatable fields with translated versions
            $partnerData['company_name'] = !empty($translatedData['company_name']) ? $translatedData['company_name'] : $partnerData['company_name'];
            $partnerData['about'] = !empty($translatedData['about']) ? $translatedData['about'] : $partnerData['about'];
            $partnerData['long_description'] = !empty($translatedData['long_description']) ? $translatedData['long_description'] : $partnerData['long_description'];
        }
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_partner_data: ' . $e->getMessage());
    }

    return $partnerData;
}

/**
 * Get translated category data based on current language
 * 
 * @param array $categoryData Original category data
 * @param int $categoryId Category ID
 * @return array Category data with translated fields
 */
function get_translated_category_data(array $categoryData, int $categoryId): array
{
    $currentLang = get_current_language();
    $defaultLangCode = get_default_language();

    try {
        // Get translated data for current language
        $translationModel = new \App\Models\TranslatedCategoryDetails_model();
        $translatedData = $translationModel->getTranslatedDetails($categoryId, $currentLang);

        if ($translatedData) {
            // Replace translatable fields with translated versions
            $categoryData['name'] = !empty($translatedData['name']) ? $translatedData['name'] : $categoryData['name'];
        }
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_category_data: ' . $e->getMessage());
    }

    return $categoryData;
}

/**
 * Get categories with translated names
 * 
 * This helper function fetches categories and applies translated names
 * based on the current language with fallback to main table
 * 
 * @param array $whereConditions Optional where conditions for filtering
 * @return array Array of categories with translated names
 */
function get_categories_with_translated_names(array $whereConditions = []): array
{
    try {
        $categoryModel = new \App\Models\Category_model();

        // Get categories from main table
        $query = $categoryModel->select('id, name, parent_id, image');

        if (!empty($whereConditions)) {
            $query = $query->where($whereConditions);
        }

        $categories = $query->findAll();

        if (empty($categories)) {
            return [];
        }

        // Get category IDs for batch translation lookup
        $categoryIds = array_column($categories, 'id');
        $translatedNames = $categoryModel->getTranslatedCategoryNames($categoryIds);

        // Update category names with translations
        foreach ($categories as &$category) {
            if (isset($translatedNames[$category['id']])) {
                $category['name'] = $translatedNames[$category['id']];
                $category['image'] = !empty($category['image']) ? $category['image'] : '';
            }
        }

        return $categories;
    } catch (\Exception $e) {
        log_message('error', 'Error fetching categories with translated names: ' . $e->getMessage());

        // Fallback to main table only
        $categoryModel = new \App\Models\Category_model();
        $query = $categoryModel->select('id, name, image');
        if (!empty($whereConditions)) {
            $query = $query->where($whereConditions);
        }
        return $query->findAll();
    }
}

/**
 * Sort languages array so that default language appears first
 * This function ensures better UI by always showing the default language tab first
 * 
 * @param array $languages Array of language data from database
 * @return array Sorted languages array with default language first
 */
function sort_languages_with_default_first(array $languages): array
{
    // Separate default and non-default languages
    $default_languages = [];
    $non_default_languages = [];

    foreach ($languages as $language) {
        if (isset($language['is_default']) && $language['is_default'] == 1) {
            $default_languages[] = $language;
        } else {
            $non_default_languages[] = $language;
        }
    }

    // Return default languages first, then non-default languages
    return array_merge($default_languages, $non_default_languages);
}

/**
 * Get translated service data based on current language
 * 
 * @param array $serviceData Original service data
 * @param int $serviceId Service ID
 * @return array Service data with translated fields
 */
function get_translated_service_data(array $serviceData, int $serviceId): array
{
    $currentLang = get_current_language();
    $defaultLangCode = get_default_language();

    // If current language is the default language, return original data
    if ($currentLang === $defaultLangCode) {
        return $serviceData;
    }

    try {
        // Get translated data for current language
        $translationModel = new \App\Models\TranslatedServiceDetails_model();
        $translatedData = $translationModel->getTranslatedDetails($serviceId, $currentLang);

        if ($translatedData) {
            // Replace translatable fields with translated versions
            $serviceData['title'] = !empty($translatedData['title']) ? $translatedData['title'] : $serviceData['title'];
            $serviceData['description'] = !empty($translatedData['description']) ? $translatedData['description'] : $serviceData['description'];
            $serviceData['long_description'] = !empty($translatedData['long_description']) ? $translatedData['long_description'] : $serviceData['long_description'];
            $serviceData['tags'] = !empty($translatedData['tags']) ? $translatedData['tags'] : $serviceData['tags'];
            $serviceData['faqs'] = !empty($translatedData['faqs']) ? $translatedData['faqs'] : $serviceData['faqs'];
        }
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_service_data: ' . $e->getMessage());
    }

    return $serviceData;
}

/**
 * Transform form data to translated_fields structure for services
 * 
 * @param array $postData POST data from form
 * @param string $defaultLanguage Default language code
 * @return array Translated fields structure
 */
function transform_service_form_data_to_translated_fields(array $postData, string $defaultLanguage): array
{
    // Get languages from database
    $languages = fetch_details('languages', [], ['id', 'language', 'code', 'is_default'], "", '0', 'id', 'ASC');

    if (empty($languages)) {
        return [];
    }

    // Define translatable fields for services
    $translatableFields = [
        'title',
        'description',
        'long_description',
        'tags',
        'faqs'
    ];

    // Build the translated_fields structure
    $translatedFields = [];
    foreach ($translatableFields as $fieldName) {
        $translatedFields[$fieldName] = [];
    }

    // Process each language
    foreach ($languages as $language) {
        $languageCode = $language['code'];

        foreach ($translatableFields as $fieldName) {
            // Get the field value for this language from POST data
            // Form sends data as: title[en], description[en], etc.
            $fieldKey = $fieldName . '[' . $languageCode . ']';
            $fieldValue = $postData[$fieldKey] ?? null;

            // For default language, also check if there's a direct field value (fallback)
            if ($languageCode === $defaultLanguage && empty($fieldValue)) {
                $fieldValue = $postData[$fieldName] ?? null;
            }

            // Handle special cases for tags and faqs
            if ($fieldName === 'tags' && is_array($fieldValue)) {
                // Extract tag values from objects with 'value' property or use strings directly
                $tagValues = [];
                foreach ($fieldValue as $tag) {
                    if (is_string($tag)) {
                        $tagValues[] = trim($tag);
                    } elseif (is_array($tag) && isset($tag['value'])) {
                        $tagValues[] = trim($tag['value']);
                    }
                }
                $fieldValue = implode(', ', array_filter($tagValues));
            } elseif ($fieldName === 'faqs' && is_array($fieldValue)) {
                // Convert faqs array to JSON string
                $fieldValue = json_encode($fieldValue);
            }

            // Only add non-empty values
            if (!empty($fieldValue)) {
                $translatedFields[$fieldName][$languageCode] = trim($fieldValue);
            }
        }
    }

    return $translatedFields;
}

/**
 * Get partner translations for a specific language
 * 
 * @param int $partnerId The partner ID
 * @param string $languageCode Language code
 * @return array|null Translated details or null if not found
 */
function get_partner_translations(int $partnerId, string $languageCode): ?array
{
    try {
        $translationModel = new \App\Models\TranslatedPartnerDetails_model();
        return $translationModel->getTranslatedDetails($partnerId, $languageCode);
    } catch (\Exception $e) {
        log_message('error', 'Error getting partner translations: ' . $e->getMessage());
        return null;
    }
}

/**
 * Get all translations for a partner
 * 
 * @param int $partnerId The partner ID
 * @return array All translations for the partner
 */
function get_all_partner_translations(int $partnerId): array
{
    try {
        $translationModel = new \App\Models\TranslatedPartnerDetails_model();
        return $translationModel->getAllTranslationsForPartner($partnerId);
    } catch (\Exception $e) {
        log_message('error', 'Error getting all partner translations: ' . $e->getMessage());
        return [];
    }
}

/**
 * Get service translations for a specific language
 * 
 * @param int $serviceId Service ID
 * @param string $languageCode Language code
 * @return array|null Translated details or null if not found
 */
function get_service_translations(int $serviceId, string $languageCode): ?array
{
    try {
        $translationModel = new \App\Models\TranslatedServiceDetails_model();
        return $translationModel->getTranslatedDetails($serviceId, $languageCode);
    } catch (\Exception $e) {
        log_message('error', 'Error getting service translations: ' . $e->getMessage());
        return null;
    }
}

/**
 * Get all translations for a service
 * 
 * @param int $serviceId Service ID
 * @return array All translations for the service
 */
function get_all_service_translations(int $serviceId): array
{
    try {
        $translationModel = new \App\Models\TranslatedServiceDetails_model();
        return $translationModel->getAllTranslationsForService($serviceId);
    } catch (\Exception $e) {
        log_message('error', 'Error getting all service translations: ' . $e->getMessage());
        return [];
    }
}

/**
 * Get all translations for multiple sections in one query
 * 
 * @param array $sectionIds Array of section IDs
 * @return array All translations organized by section_id and language_code
 */
function get_all_section_translations(array $sectionIds): array
{
    try {
        if (empty($sectionIds)) {
            return [];
        }

        $translationModel = new \App\Models\TranslatedFeaturedSections_model();
        $db = \Config\Database::connect();

        // Get all translations for the sections
        $builder = $db->table('translated_featured_sections');
        $translations = $builder->select('section_id, language_code, title, description')
            ->whereIn('section_id', $sectionIds)
            ->get()
            ->getResultArray();

        $db->close();

        // Organize translations by section_id and language_code
        $organizedTranslations = [];
        foreach ($translations as $translation) {
            $sectionId = $translation['section_id'];
            $languageCode = $translation['language_code'];

            if (!isset($organizedTranslations[$sectionId])) {
                $organizedTranslations[$sectionId] = [];
            }

            $organizedTranslations[$sectionId][$languageCode] = [
                'title' => $translation['title'],
                'description' => $translation['description']
            ];
        }

        return $organizedTranslations;
    } catch (\Exception $e) {
        log_message('error', 'Error getting all section translations: ' . $e->getMessage());
        return [];
    }
}

/**
 * Apply translation logic to section data
 * 
 * This function implements the translation logic for sections:
 * - Main fields (title, description): Use default language translation, fallback to main table
 * - Translated fields (translated_title, translated_description): Use requested language, fallback to default language, then first available, then main table
 * 
 * @param array $sectionData Original section data from main table
 * @param array $allTranslations All translations organized by section_id and language_code
 * @param int $sectionId Section ID
 * @param string $requestedLanguage Language from request header
 * @param string $defaultLanguage Default language from database
 * @return array Section data with main and translated fields
 */
function apply_section_translation_logic(array $sectionData, array $allTranslations, int $sectionId, string $requestedLanguage, string $defaultLanguage): array
{
    try {
        // Get translations for this specific section
        $sectionTranslations = $allTranslations[$sectionId] ?? [];

        // Initialize result with original data
        $result = $sectionData;

        // Get main fields (title, description) - use default language translation, fallback to main table
        $defaultTranslation = $sectionTranslations[$defaultLanguage] ?? null;
        $result['title'] = $defaultTranslation['title'] ?? $sectionData['title'] ?? '';
        $result['description'] = $defaultTranslation['description'] ?? $sectionData['description'] ?? '';

        // Get translated fields (translated_title, translated_description) - use requested language with fallbacks
        $translatedTitle = '';
        $translatedDescription = '';

        // Try requested language first
        if (isset($sectionTranslations[$requestedLanguage])) {
            $requestedTranslation = $sectionTranslations[$requestedLanguage];
            $translatedTitle = $requestedTranslation['title'] ?? '';
            $translatedDescription = $requestedTranslation['description'] ?? '';
        }

        // If requested language not available or empty, try default language
        if (empty($translatedTitle) && isset($sectionTranslations[$defaultLanguage])) {
            $defaultTranslation = $sectionTranslations[$defaultLanguage];
            $translatedTitle = $defaultTranslation['title'] ?? '';
            $translatedDescription = $defaultTranslation['description'] ?? '';
        }

        // If still empty, use first available translation
        if (empty($translatedTitle) && !empty($sectionTranslations)) {
            $firstTranslation = reset($sectionTranslations);
            $translatedTitle = $firstTranslation['title'] ?? '';
            $translatedDescription = $firstTranslation['description'] ?? '';
        }

        // Final fallback to main table data
        if (empty($translatedTitle)) {
            $translatedTitle = $sectionData['title'] ?? '';
            $translatedDescription = $sectionData['description'] ?? '';
        }

        // Add translated fields to result
        $result['translated_title'] = $translatedTitle;
        $result['translated_description'] = $translatedDescription;

        return $result;
    } catch (\Exception $e) {
        log_message('error', 'Error applying section translation logic: ' . $e->getMessage());

        // Return original data with empty translated fields as fallback
        $result = $sectionData;
        $result['translated_title'] = $sectionData['title'] ?? '';
        $result['translated_description'] = $sectionData['description'] ?? '';

        return $result;
    }
}

/**
 * Apply translation logic to multiple sections at once
 * 
 * This is the main function to use for section translation in APIs.
 * It handles fetching all translations and applying the logic to multiple sections efficiently.
 * 
 * @param array $sections Array of section data from main table
 * @param string $requestedLanguage Language from request header (optional, will be auto-detected)
 * @param string $defaultLanguage Default language (optional, will be auto-detected)
 * @return array Array of sections with main and translated fields
 */
function apply_section_translations_to_multiple(array $sections, string $requestedLanguage = null, string $defaultLanguage = null): array
{
    try {
        // Auto-detect languages if not provided
        if ($requestedLanguage === null) {
            $requestedLanguage = get_current_language_from_request();
        }
        if ($defaultLanguage === null) {
            $defaultLanguage = get_default_language();
        }

        // Extract section IDs
        $sectionIds = array_column($sections, 'id');
        if (empty($sectionIds)) {
            return $sections;
        }

        // Get all translations in one query
        $allTranslations = get_all_section_translations($sectionIds);

        // Apply translation logic to each section
        $translatedSections = [];
        foreach ($sections as $section) {
            $translatedSections[] = apply_section_translation_logic(
                $section,
                $allTranslations,
                $section['id'],
                $requestedLanguage,
                $defaultLanguage
            );
        }

        return $translatedSections;
    } catch (\Exception $e) {
        log_message('error', 'Error applying section translations to multiple sections: ' . $e->getMessage());

        // Return original sections with empty translated fields as fallback
        $fallbackSections = [];
        foreach ($sections as $section) {
            $fallbackSection = $section;
            $fallbackSection['translated_title'] = $section['title'] ?? '';
            $fallbackSection['translated_description'] = $section['description'] ?? '';
            $fallbackSections[] = $fallbackSection;
        }

        return $fallbackSections;
    }
}

/**
 * Apply translation logic to a single section
 * 
 * This is a convenience function for single section translation.
 * 
 * @param array $section Section data from main table
 * @param string $requestedLanguage Language from request header (optional, will be auto-detected)
 * @param string $defaultLanguage Default language (optional, will be auto-detected)
 * @return array Section with main and translated fields
 */
function apply_section_translations_to_single(array $section, string $requestedLanguage = null, string $defaultLanguage = null): array
{
    return apply_section_translations_to_multiple([$section], $requestedLanguage, $defaultLanguage)[0];
}

/**
 * Decode JSON fields to arrays if they are JSON strings
 * This helper function ensures that JSON fields like FAQs and tags are returned as proper arrays
 * 
 * @param mixed $value The value to decode
 * @param string $fieldName The name of the field being processed
 * @return mixed Decoded value (array if JSON string, original value otherwise)
 */
function decode_json_field($value, string $fieldName)
{
    // Only process JSON fields
    if (!in_array($fieldName, ['faqs', 'tags'])) {
        return $value;
    }

    // If value is empty or null, return empty array
    if (empty($value)) {
        return [];
    }

    // If value is already an array, return as-is
    if (is_array($value)) {
        return $value;
    }

    // If value is a string, try to decode JSON
    if (is_string($value)) {
        $decoded = json_decode($value, true);

        // If JSON decode was successful and returned an array, return it
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            return $decoded;
        }

        // If JSON decode failed, log the error and return empty array
        log_message('warning', "Failed to decode JSON for field '$fieldName': " . json_last_error_msg());
        return [];
    }

    // For any other type, return empty array
    return [];
}

/**
 * Get translated service data with fallback logic based on Content-Language header
 * This function provides both default language and translated values for API responses
 * 
 * @param int $serviceId Service ID
 * @param array $fallbackData Fallback data from main table
 * @param string|null $requestedLanguage Optional specific language code (if not provided, will use Content-Language header)
 * @return array Translated data with both default and translated values
 */
function get_translated_service_data_for_api(int $serviceId, array $fallbackData = [], ?string $requestedLanguage = null): array
{
    try {
        // 1️⃣ Get default language
        $defaultLanguage = get_default_language();

        // 2️⃣ Determine requested language
        $requestedLanguage = $requestedLanguage
            ?? get_current_language_from_request()
            ?? $defaultLanguage;

        // 3️⃣ Fetch all translations for the service
        $allTranslationsRaw = get_all_service_translations($serviceId);

        // Organize translations by language code
        $allTranslations = [];
        foreach ($allTranslationsRaw as $translation) {
            $langCode = $translation['language_code'];
            $allTranslations[$langCode] = [
                'title' => $translation['title'] ?? '',
                'description' => $translation['description'] ?? '',
                'long_description' => $translation['long_description'] ?? '',
                'tags' => $translation['tags'] ?? '',
                'faqs' => $translation['faqs'] ?? ''
            ];
        }


        // 4️⃣ Pick default and requested translations
        $defaultTranslations   = $allTranslations[$defaultLanguage] ?? [];
        $requestedTranslations = $allTranslations[$requestedLanguage] ?? [];

        // 5️⃣ Define fields and fallback values
        $translatableFields = [
            'title' => $fallbackData['title'] ?? '',
            'description' => $fallbackData['description'] ?? '',
            'long_description' => $fallbackData['long_description'] ?? '',
            'tags' => $fallbackData['tags'] ?? '',
            'faqs' => $fallbackData['faqs'] ?? ''
        ];

        $translatedData = [];

        // 6️⃣ Process each field
        foreach ($translatableFields as $field => $fallbackValue) {

            // Helper function to get the first non-empty value from translations
            $getFirstAvailableTranslation = function ($field) use ($allTranslations, $fallbackValue) {
                foreach ($allTranslations as $langData) {
                    if (!empty($langData[$field])) {
                        return $langData[$field];
                    }
                }
                return $fallbackValue; // fallback to main record
            };

            // Default value: default language or fallback
            $defaultValue = $defaultTranslations[$field] ?? null;
            if ($defaultValue === null) {
                // Default language doesn't exist, try first available
                $defaultValue = $getFirstAvailableTranslation($field);
            } elseif (empty($defaultValue)) {
                // Default language exists but is empty, try first available
                $defaultValue = $getFirstAvailableTranslation($field);
            }

            // Requested value: Use requested language if it exists (even if empty), otherwise fallback
            if (isset($requestedTranslations[$field])) {
                // Requested language has this field (even if empty), use it
                $requestedValue = $requestedTranslations[$field];
            } else {
                // Requested language doesn't have this field, use default or first available
                $requestedValue = $defaultValue;
                if (empty($requestedValue)) {
                    $requestedValue = $getFirstAvailableTranslation($field);
                }
            }

            // Decode JSON fields if needed
            $defaultValue   = decode_json_field($defaultValue, $field);
            $requestedValue = decode_json_field($requestedValue, $field);

            // Assign to API response
            $translatedData[$field] = $defaultValue;
            $translatedData["translated_$field"] = $requestedValue;
        }

        return $translatedData;
    } catch (\Exception $e) {
        log_message('error', 'Translation processing failed in get_translated_service_data_for_api: ' . $e->getMessage());
        return [];
    }
}


/**
 * Get translated partner data with proper fallback logic based on Content-Language header
 * 
 * Fallback logic:
 * 1. If data for the language passed in header exists → use that data as translated_fieldName
 * 2. If header language data not present → use default language data from translations table
 * 3. If neither header nor default language available → use main table data as fallback
 * 
 * @param int $partnerId Partner ID
 * @param array $fallbackData Fallback data from main table
 * @param string|null $requestedLanguage Optional specific language code (if not provided, will use Content-Language header)
 * @return array Partner data with translations following fallback logic
 */
function get_translated_partner_data_for_api(int $partnerId, array $fallbackData = [], ?string $requestedLanguage = null): array
{
    try {
        // Validate partner ID to prevent errors
        if (empty($partnerId) || $partnerId <= 0) {
            log_message('error', 'Invalid partner ID provided to get_translated_partner_data_for_api: ' . $partnerId);
            return $fallbackData; // Return fallback data if partner ID is invalid
        }

        // 1️⃣ Get default language
        $defaultLanguage = get_default_language();

        // 2️⃣ Determine requested language
        $requestedLanguage = $requestedLanguage
            ?? get_current_language_from_request()
            ?? $defaultLanguage;

        // 3️⃣ Fetch all translations for the partner
        $allTranslationsRaw = get_all_partner_translations($partnerId);

        // Organize translations by language code
        $allTranslations = [];
        foreach ($allTranslationsRaw as $translation) {
            $langCode = $translation['language_code'];
            $allTranslations[$langCode] = [
                'company_name' => $translation['company_name'] ?? '',
                'about' => $translation['about'] ?? '',
                'long_description' => $translation['long_description'] ?? '',
                'username' => $translation['username'] ?? ''
            ];
        }

        // log_message('debug', 'Partner allTranslations organized: ' . json_encode($allTranslations));

        // 4️⃣ Pick default and requested translations
        $defaultTranslations   = $allTranslations[$defaultLanguage] ?? [];
        $requestedTranslations = $allTranslations[$requestedLanguage] ?? [];

        // 5️⃣ Define fields and fallback values
        $translatableFields = [
            'company_name' => $fallbackData['company_name'] ?? $fallbackData['company'] ?? '',
            'about' => $fallbackData['about'] ?? '',
            'long_description' => $fallbackData['long_description'] ?? $fallbackData['description'] ?? '',
            'username' => $fallbackData['username'] ?? $fallbackData['partner_name'] ?? $fallbackData['username'] ?? ''
        ];

        $translatedData = [];

        // 6️⃣ Process each field with same logic as service translations
        foreach ($translatableFields as $field => $fallbackValue) {

            // Helper function to get the first non-empty value from translations
            $getFirstAvailableTranslation = function ($field) use ($allTranslations, $fallbackValue) {
                foreach ($allTranslations as $langData) {
                    if (!empty($langData[$field])) {
                        return $langData[$field];
                    }
                }
                return $fallbackValue; // fallback to main record
            };

            // Default value: default language or fallback
            $defaultValue = $defaultTranslations[$field] ?? null;
            if ($defaultValue === null) {
                // Default language doesn't exist, try first available
                $defaultValue = $getFirstAvailableTranslation($field);
            } elseif (empty($defaultValue)) {
                // Default language exists but is empty, try first available
                $defaultValue = $getFirstAvailableTranslation($field);
            }

            // Requested value: Use requested language if it exists (even if empty), otherwise fallback
            if (isset($requestedTranslations[$field])) {
                // Requested language has this field (even if empty), use it
                $requestedValue = $requestedTranslations[$field];
            } else {
                // Requested language doesn't have this field, use default or first available
                $requestedValue = $defaultValue;
                if (empty($requestedValue)) {
                    $requestedValue = $getFirstAvailableTranslation($field);
                }
            }

            // Decode JSON fields if needed
            $defaultValue   = decode_json_field($defaultValue, $field);
            $requestedValue = decode_json_field($requestedValue, $field);

            // Assign to API response following the same pattern as services
            $translatedData[$field] = $defaultValue;
            $translatedData["translated_$field"] = $requestedValue;
        }

        return $translatedData;
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_partner_data_for_api: ' . $e->getMessage());
        return [];
    }
}

/**
 * Apply translations to multiple services for API responses
 * 
 * @param array $services Array of services with their IDs
 * @return array Services with applied translations
 */
function apply_translations_to_services_for_api(array $services): array
{
    try {
        foreach ($services as &$service) {
            if (isset($service['id'])) {
                $translatedData = get_translated_service_data_for_api($service['id'], $service);

                // Merge translated data with original service data
                $service = array_merge($service, $translatedData);
                $service['translated_status'] = getTranslatedValue($service['status'], 'panel');
            }
        }

        return $services;
    } catch (\Exception $e) {
        log_message('error', 'Error applying translations to services: ' . $e->getMessage());
        return $services; // Return original data if translation fails
    }
}

/**
 * Apply translations to multiple partners for API responses
 * 
 * @param array $partners Array of partners with their IDs
 * @return array Partners with applied translations
 */
function apply_translations_to_partners_for_api(array $partners): array
{
    try {
        foreach ($partners as &$partner) {
            if (isset($partner['id'])) {
                $translatedData = get_translated_partner_data_for_api($partner['id'], $partner);

                // Merge translated data with original partner data
                $partner = array_merge($partner, $translatedData);
            }
        }

        return $partners;
    } catch (\Exception $e) {
        log_message('error', 'Error applying translations to partners: ' . $e->getMessage());
        return $partners; // Return original data if translation fails
    }
}

/**
 * Get translated category data for API responses
 * 
 * This function follows the same pattern as partner and service translations:
 * - Main field contains default language value (from translations table or main table as fallback)
 * - Translated field contains requested language value (empty if no translation exists)
 * 
 * @param int $categoryId Category ID
 * @param array $categoryData Original category data
 * @return array Category data with translated fields
 */
function get_translated_category_data_for_api(int $categoryId, array $categoryData, array $fields = ['name']): array
{
    try {
        $defaultLanguage = get_default_language();
        $requestedLanguage = get_current_language_from_request();

        // Load translation model
        $translationModel = new \App\Models\TranslatedCategoryDetails_model();

        // Get all available translations for this category
        $allTranslations = $translationModel->getAllTranslationsForCategory($categoryId);

        $translatedData = [];

        foreach ($fields as $field) {
            // 1. NAME field: Always contains default language data
            // Priority: Default language translation -> Main table data as fallback
            $defaultValue = '';
            if (!empty($allTranslations[$defaultLanguage][$field])) {
                $defaultValue = $allTranslations[$defaultLanguage][$field];
            } else {
                // Fallback to main table data
                $defaultValue = $categoryData[$field] ?? '';
            }
            $translatedData[$field] = $defaultValue;

            // 2. TRANSLATED_NAME field: Contains requested language data with proper fallback
            // Priority: Requested language -> Default language -> First available -> Main table
            $translatedValue = '';

            if ($requestedLanguage === $defaultLanguage) {
                // If requested language is default, use the same value as name
                $translatedValue = $defaultValue;
            } else {
                // Check if requested language translation exists
                if (!empty($allTranslations[$requestedLanguage][$field])) {
                    $translatedValue = $allTranslations[$requestedLanguage][$field];
                } else {
                    // Fallback to default language translation
                    if (!empty($allTranslations[$defaultLanguage][$field])) {
                        $translatedValue = $allTranslations[$defaultLanguage][$field];
                    } else {
                        // Fallback to first available translation
                        $firstAvailableTranslation = '';
                        foreach ($allTranslations as $langCode => $translation) {
                            if (!empty($translation[$field])) {
                                $firstAvailableTranslation = $translation[$field];
                                break;
                            }
                        }

                        if (!empty($firstAvailableTranslation)) {
                            $translatedValue = $firstAvailableTranslation;
                        } else {
                            // Final fallback to main table data
                            $translatedValue = $categoryData[$field] ?? '';
                        }
                    }
                }
            }

            $translatedData['translated_' . $field] = $translatedValue;
        }

        return $translatedData;
    } catch (\Exception $e) {
        log_message('error', 'Translation processing failed in get_translated_category_data_for_api: ' . $e->getMessage());

        // Fallback: return defaults only
        $fallbackData = [];
        foreach ($fields as $field) {
            $fallbackValue = $categoryData[$field] ?? '';
            $fallbackData[$field] = $fallbackValue;
            $fallbackData['translated_' . $field] = $fallbackValue;
        }

        return $fallbackData;
    }
}


/**
 * Apply translations to multiple categories for API responses
 * 
 * @param array $categories Array of categories with their IDs
 * @return array Categories with applied translations
 */
function apply_translations_to_categories_for_api(array $categories, array $fields = ['name']): array
{
    try {
        foreach ($categories as &$category) {
            if (isset($category['id'])) {
                $translatedData = get_translated_category_data_for_api($category['id'], $category, $fields);

                // Merge translated data with original category data
                $category = array_merge($category, $translatedData);
            }
        }

        return $categories;
    } catch (\Exception $e) {
        log_message('error', 'Error applying translations to categories: ' . $e->getMessage());
        return $categories; // Return original data if translation fails
    }
}

/**
 * Update category names in database query results with translations
 * 
 * This function is used for database queries that fetch category names directly
 * and need to be updated with translations based on Content-Language header
 * 
 * @param array $data Array of data containing category information
 * @return array Updated data with translated category names
 */
function update_category_names_in_query_results(array $data): array
{
    try {
        // Update category names in the data using the helper function
        foreach ($data as &$item) {
            if (isset($item['category_id']) && !empty($item['category_id'])) {
                $categoryData = ['name' => $item['category_name'] ?? ''];
                $translatedCategoryData = get_translated_category_data_for_api($item['category_id'], $categoryData);
                $item['category_name'] = $translatedCategoryData['name'];
                $item['translated_category_name'] = $translatedCategoryData['translated_name'];
            }
        }

        return $data;
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Error updating category names in query results: ' . $e->getMessage());
        return $data; // Return original data if translation fails
    }
}

/**
 * Get current language from request headers or default to 'en'
 * 
 * @return string Language code
 */
function get_current_language_from_request(): string
{
    try {
        $request = \Config\Services::request();
        $contentLanguage = $request->getHeaderLine('Content-Language');

        if (!empty($contentLanguage)) {
            // Extract language code (e.g., "en-US" -> "en")
            $languageCode = explode('-', $contentLanguage)[0];
            $result = strtolower($languageCode);

            return $result;
        }

        return 'en'; // Default fallback
    } catch (\Exception $e) {
        log_message('error', 'Error getting current language from request: ' . $e->getMessage());
        return 'en'; // Default fallback
    }
}

/**
 * Get translated featured section data based on current language
 * 
 * @param array $sectionData Original section data
 * @param int $sectionId Section ID
 * @return array Section data with translated fields
 */
function get_translated_featured_section_data(array $sectionData, int $sectionId): array
{
    $currentLang = get_current_language();
    $defaultLangCode = get_default_language();

    // If current language is the default language, return original data
    if ($currentLang === $defaultLangCode) {
        return $sectionData;
    }

    try {
        // Get translated data for current language
        $translationModel = new \App\Models\TranslatedFeaturedSections_model();
        $translatedData = $translationModel->getTranslatedDetails($sectionId, $currentLang);

        if ($translatedData) {
            // Replace translatable fields with translated versions
            $sectionData['title'] = !empty($translatedData['title']) ? $translatedData['title'] : $sectionData['title'];
            $sectionData['description'] = !empty($translatedData['description']) ? $translatedData['description'] : $sectionData['description'];
        }
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_featured_section_data: ' . $e->getMessage());
    }

    return $sectionData;
}

/**
 * Get featured sections with translated names
 * 
 * This helper function fetches featured sections and applies translated names
 * based on the current language with fallback to main table
 * 
 * @param array $whereConditions Optional where conditions for filtering
 * @return array Array of featured sections with translated names
 */
function get_featured_sections_with_translated_names(array $whereConditions = []): array
{
    try {
        $sectionModel = new \App\Models\Featured_sections_model();

        // Get sections from main table
        $query = $sectionModel->select('id, title, description');

        if (!empty($whereConditions)) {
            $query = $query->where($whereConditions);
        }

        $sections = $query->findAll();

        if (empty($sections)) {
            return [];
        }

        // Get section IDs for batch translation lookup
        $sectionIds = array_column($sections, 'id');
        $translatedTitles = $sectionModel->getTranslatedSectionTitles($sectionIds);
        $translatedDescriptions = $sectionModel->getTranslatedSectionDescriptions($sectionIds);

        // Update section titles and descriptions with translations
        foreach ($sections as &$section) {
            if (isset($translatedTitles[$section['id']])) {
                $section['title'] = $translatedTitles[$section['id']];
            }
            if (isset($translatedDescriptions[$section['id']])) {
                $section['description'] = $translatedDescriptions[$section['id']];
            }
        }

        return $sections;
    } catch (\Exception $e) {
        log_message('error', 'Error fetching featured sections with translated names: ' . $e->getMessage());

        // Fallback to main table only
        $sectionModel = new \App\Models\Featured_sections_model();
        $query = $sectionModel->select('id, title, description');
        if (!empty($whereConditions)) {
            $query = $query->where($whereConditions);
        }
        return $query->findAll();
    }
}

/**
 * Get translated featured section data for API responses
 * 
 * This function processes featured section data for API responses,
 * applying translations based on the Content-Language header
 * 
 * @param int $sectionId Section ID
 * @param array $sectionData Original section data
 * @return array Processed section data with translations
 */
function get_translated_featured_section_data_for_api(int $sectionId, array $sectionData): array
{
    try {
        $defaultLanguage = get_default_language();
        $requestedLanguage = get_current_language_from_request();

        // Get default language translation
        $translationModel = new \App\Models\TranslatedFeaturedSections_model();
        $defaultTranslation = $translationModel->getTranslatedDetails($sectionId, $defaultLanguage);

        // Get requested language translation
        $requestedTranslation = null;
        if ($requestedLanguage !== $defaultLanguage) {
            $translationModel = new \App\Models\TranslatedFeaturedSections_model();
            $requestedTranslation = $translationModel->getTranslatedDetails($sectionId, $requestedLanguage);
        }

        // Initialize translated data
        $translatedData = [];
        $defaultTitle = '';
        $defaultDescription = '';
        $requestedTitle = '';
        $requestedDescription = '';

        // Get default language title and description
        if ($defaultTranslation) {
            if (!empty($defaultTranslation['title'])) {
                $defaultTitle = $defaultTranslation['title'];
            }
            if (!empty($defaultTranslation['description'])) {
                $defaultDescription = $defaultTranslation['description'];
            }
        } else {
            // Fallback to main table title and description
            $defaultTitle = $sectionData['title'] ?? '';
            $defaultDescription = $sectionData['description'] ?? '';
        }

        // Get requested language title and description
        if ($requestedTranslation) {
            if (!empty($requestedTranslation['title'])) {
                $requestedTitle = $requestedTranslation['title'];
            }
            if (!empty($requestedTranslation['description'])) {
                $requestedDescription = $requestedTranslation['description'];
            }
        }

        // Set the fields based on your requirement:
        // Main fields should always contain default language values
        // Translated fields should contain the requested language values
        $translatedData['title'] = $defaultTitle; // Always default language
        $translatedData['description'] = $defaultDescription; // Always default language

        // Set translated fields based on requested language
        if ($requestedLanguage === $defaultLanguage) {
            // If requested language is the same as default language
            $translatedData['translated_title'] = $defaultTitle; // Same as default language
            $translatedData['translated_description'] = $defaultDescription; // Same as default language
        } else {
            // If requested language is different from default language
            $translatedData['translated_title'] = $requestedTitle; // Requested language value (empty if no translation)
            $translatedData['translated_description'] = $requestedDescription; // Requested language value (empty if no translation)
        }

        return $translatedData;
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Translation processing failed in get_translated_featured_section_data_for_api: ' . $e->getMessage());

        // Return fallback data
        $defaultLanguage = get_default_language();
        $requestedLanguage = get_current_language_from_request();
        $fallbackTitle = $sectionData['title'] ?? '';
        $fallbackDescription = $sectionData['description'] ?? '';

        return [
            'title' => $fallbackTitle, // Always default language (from main table)
            'description' => $fallbackDescription, // Always default language (from main table)
            'translated_title' => ($requestedLanguage === $defaultLanguage) ? $fallbackTitle : '', // Requested language or empty
            'translated_description' => ($requestedLanguage === $defaultLanguage) ? $fallbackDescription : '' // Requested language or empty
        ];
    }
}

/**
 * Apply translations to multiple featured sections for API responses
 * 
 * @param array $sections Array of sections with their IDs
 * @return array Sections with applied translations
 */
function apply_translations_to_featured_sections_for_api(array $sections): array
{
    try {
        foreach ($sections as &$section) {
            if (isset($section['id'])) {
                $translatedData = get_translated_featured_section_data_for_api($section['id'], $section);

                // Merge translated data with original section data
                $section = array_merge($section, $translatedData);
            }
        }

        return $sections;
    } catch (\Exception $e) {
        log_message('error', 'Error applying translations to featured sections: ' . $e->getMessage());
        return $sections; // Return original data if translation fails
    }
}
/**
 * Get translated value for any key based on current language
 * 
 * @param string $key The key to translate
 * @param string $category Language file category (default: 'customer_app')
 * @return string Translated value
 */
function getTranslatedValue($key, $category = 'customer_app')
{
    try {
        helper('language');
        // Get current language from request header
        $languageCode = get_current_language_from_request();

        // Load language file for the specified category
        $languageData = load_language_file($languageCode, $category);

        // Return translated value if found
        if ($languageData && isset($languageData[$key])) {
            return $languageData[$key];
        }

        // Fallback to default English translations if not found
        $defaultLanguageData = load_language_file('en', $category);
        if ($defaultLanguageData && isset($defaultLanguageData[$key])) {
            return $defaultLanguageData[$key];
        }

        // Final fallback to original key with proper capitalization
        return ucfirst($key);
    } catch (\Exception $e) {
        log_message('error', 'Failed to get translated value for key "' . $key . '": ' . $e->getMessage());
        return ucfirst($key);
    }
}

/**
 * Queue booking status update notification
 * 
 * This function queues a booking status update notification job instead of
 * sending notifications directly. This improves performance by processing
 * notifications in the background.
 * 
 * @param string $order_id The order ID
 * @param string $to_send_id The user ID to send notification to
 * @param array $users_fcm Array of FCM tokens and platforms
 * @param string $translated_status The translated status message
 * @param string|null $partner_id The partner ID (optional)
 * @param array $usersEmail Array of user email data
 * @param array $details Order details array
 * @param string|null $status The booking status (optional)
 * @param array|null $additional_charges Additional charges data (optional)
 */
function queueBookingNotification($order_id, $to_send_id, $users_fcm, $translated_status, $partner_id = null, $usersEmail = [], $details = [], $status = null, $additional_charges = null)
{
    try {
        // Prepare job data
        $jobData = [
            'notification_type' => 'booking_status_update',
            'order_id' => $order_id,
            'to_send_id' => $to_send_id,
            'users_fcm' => $users_fcm,
            'translated_status' => $translated_status,
            'partner_id' => $partner_id,
            'usersEmail' => $usersEmail,
            'details' => $details,
            'status' => $status,
            'additional_charges' => $additional_charges
        ];

        // Get queue service and dispatch the job
        $queue = service('queue');
        $queue->push('booking_notifications', 'bookingNotification', $jobData, 'high');

        log_message('info', 'Queued booking notification for order: ' . $order_id);
    } catch (\Exception $e) {
        log_message('error', 'Failed to queue booking notification for order ' . $order_id . ': ' . $e->getMessage());

        // Fallback: send notification directly if queue fails
        log_message('warning', 'Falling back to direct notification sending for order: ' . $order_id);

        // Send notification directly as fallback
        $trans = new \Config\ApiResponseAndNotificationStrings();
        $title = $trans->bookingStatusChange;
        $body = $trans->bookingStatusUpdateMessage . $translated_status;
        $type = 'order';

        $fcmMsg = array(
            'content_available' => "true",
            'title' => $title,
            'body' => $body,
            'type' => $type,
            'type_id' => "$to_send_id",
            'order_id' => "$order_id",
            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
        );

        if (!empty($users_fcm)) {
            $registrationIDs_chunks = array_chunk($users_fcm, 1000);
            // Use queued notifications for better performance
            queue_notification($fcmMsg, $registrationIDs_chunks, [], 'default');
            store_notifications($title, $body, $type, $to_send_id, 0, 'general', now(), 'specific_user', '', $order_id, $to_send_id, '', '', '', '');
        }

        // Send email if enabled
        if (!empty($usersEmail[0]['email']) && check_notification_setting('booking_status_updated', 'email') && is_unsubscribe_enabled($to_send_id) == 1) {
            $date_of_service = isset($details[0]['date_of_service']) ? $details[0]['date_of_service'] : '';
            send_custom_email('booking_status_updated', null, $usersEmail[0]['email'], null, $to_send_id, $order_id, $date_of_service, null, null, null, get_default_language());
        }
    }
}

/**
 * Get taxes with translated names based on current language
 * Fetches taxes from main table and joins with translations table to get localized tax titles
 * 
 * @param array $whereConditions Optional where conditions to filter taxes (e.g., ['status' => 1])
 * @param array $fields Optional specific fields to select (defaults to id, title, percentage)
 * @return array Array of taxes with translated titles for current language
 */
if (!function_exists('get_taxes_with_translated_names')) {
    function get_taxes_with_translated_names(array $whereConditions = ['status' => 1], array $fields = ['id', 'title', 'percentage']): array
    {
        try {
            $db = \Config\Database::connect();
            $currentLanguage = get_current_language();
            $defaultLanguage = get_default_language();

            // Build select statement for requested fields
            $selectFields = [];
            foreach ($fields as $field) {
                $selectFields[] = 't.' . $field;
            }

            // Add translated title to select if title is requested
            if (in_array('title', $fields)) {
                // Build COALESCE statement based on whether we need default language join
                if ($currentLanguage !== $defaultLanguage) {
                    // Try current language first, then default language, then original title
                    $selectFields[] = 'COALESCE(ttd_current.title, ttd_default.title, t.title) as title';
                } else {
                    // Only current language (which is same as default), then original title
                    $selectFields[] = 'COALESCE(ttd_current.title, t.title) as title';
                }
                // Remove duplicate title from array
                $selectFields = array_filter($selectFields, function ($field) {
                    return $field !== 't.title';
                });
            }

            $builder = $db->table('taxes t');
            $builder->select(implode(', ', $selectFields));

            // Left join with translations table for current language
            $builder->join(
                'translated_tax_details ttd_current',
                "ttd_current.tax_id = t.id AND ttd_current.language_code = " . $db->escape($currentLanguage),
                'left'
            );

            // Left join with translations table for default language (only if different from current)
            if ($currentLanguage !== $defaultLanguage) {
                $builder->join(
                    'translated_tax_details ttd_default',
                    "ttd_default.tax_id = t.id AND ttd_default.language_code = " . $db->escape($defaultLanguage),
                    'left'
                );
            }

            // Apply where conditions if provided
            if (!empty($whereConditions)) {
                foreach ($whereConditions as $key => $value) {
                    $builder->where('t.' . $key, $value);
                }
            }

            $taxes = $builder->get()->getResultArray();

            return $taxes;
        } catch (\Exception $e) {
            log_message('error', 'Error in get_taxes_with_translated_names: ' . $e->getMessage());

            // Fallback to simple fetch_details without translations
            return fetch_details('taxes', $whereConditions, $fields);
        }
    }
}

/**
 * Check if a user is blocked by another user
 * 
 * @param int $sender_id The ID of the user trying to send a message
 * @param int $receiver_id The ID of the user receiving the message
 * @return bool True if the sender is blocked by the receiver, false otherwise
 */
function is_user_blocked($sender_id, $receiver_id)
{
    try {
        // Check if the receiver has blocked the sender
        $blocked_by_receiver = fetch_details('user_reports', [
            'reporter_id' => $receiver_id,
            'reported_user_id' => $sender_id
        ], ['id']);

        // If there's a record, the sender is blocked by the receiver
        return !empty($blocked_by_receiver);
    } catch (\Exception $e) {
        log_message('error', 'Error in is_user_blocked: ' . $e->getMessage());
        // Return false on error to allow message sending (fail-safe approach)
        return false;
    }
}

/**
 * Get company title with proper language fallback
 * 
 * This function handles company title retrieval with the following priority:
 * 1. Current language translation (if available and not empty)
 * 2. Default language translation (if available and not empty)
 * 3. First available translation (if any translations exist)
 * 4. Old single language format (if company_title is a string)
 * 5. Final fallback to "eDemand"
 * 
 * @param array $settings General settings array
 * @param string|null $currentLanguage Optional current language code (if not provided, will get from session)
 * @return string Company title with proper fallback
 */
function get_company_title_with_fallback($settings, $currentLanguage = null)
{
    try {
        // Get current language from session if not provided
        if ($currentLanguage === null) {
            $session = \Config\Services::session();
            $currentLanguage = $session->get('language_code');
        }

        // If no current language, get default language
        if (!$currentLanguage) {
            $default_lang = fetch_details('languages', ['is_default' => 1], ['code']);
            $currentLanguage = !empty($default_lang) ? $default_lang[0]['code'] : 'en';
        }

        // Check if company_title is multilingual (array format)
        if (isset($settings['company_title']) && is_array($settings['company_title'])) {
            // New multilingual format - try current language first
            if (isset($settings['company_title'][$currentLanguage]) && !empty($settings['company_title'][$currentLanguage])) {
                return $settings['company_title'][$currentLanguage];
            }

            // Try default language as fallback
            $default_lang = fetch_details('languages', ['is_default' => 1], ['code']);
            $defaultLanguageCode = !empty($default_lang) ? $default_lang[0]['code'] : 'en';

            if (isset($settings['company_title'][$defaultLanguageCode]) && !empty($settings['company_title'][$defaultLanguageCode])) {
                return $settings['company_title'][$defaultLanguageCode];
            }

            // Fallback to first available translation
            foreach ($settings['company_title'] as $lang => $title) {
                if (!empty($title)) {
                    return $title;
                }
            }
        }
        // Check if company_title is old single string format
        else if (isset($settings['company_title']) && is_string($settings['company_title']) && !empty($settings['company_title'])) {
            return $settings['company_title'];
        }

        // Final fallback
        return "eDemand";
    } catch (\Exception $e) {
        // Log error but don't break the function
        log_message('error', 'Error in get_company_title_with_fallback: ' . $e->getMessage());

        // Return fallback on error
        return "eDemand";
    }
}

/**
 * Get translated names for services and partners in batch - OPTIMIZED
 * 
 * This function efficiently fetches translated service titles and partner company names
 * for multiple records in just 2 database queries, preventing N+1 query problems.
 * 
 * Translation fallback logic:
 * 1. Try current language translation
 * 2. Fallback to default language translation  
 * 3. Fallback to original data from main table
 * 
 * @param array $serviceIds Array of service IDs to get translations for
 * @param array $partnerIds Array of partner IDs to get translations for
 * @param string $currentLang Current language code (e.g., 'en', 'ar', 'tr')
 * @param string $defaultLang Default language code from database settings
 * @return array Array with 'services' and 'partners' keys containing translated names
 *               Format: ['services' => [service_id => translated_title], 'partners' => [partner_id => translated_name]]
 */
function get_batch_translated_names(array $serviceIds, array $partnerIds, string $currentLang, string $defaultLang): array
{
    $result = [
        'services' => [],
        'partners' => []
    ];

    try {
        // Get service translations in batch - OPTIMIZED single query
        if (!empty($serviceIds)) {
            $serviceModel = new \App\Models\TranslatedServiceDetails_model();
            $serviceTranslations = $serviceModel->getAllTranslationsForMultipleServices($serviceIds);

            // Process each service ID to get translated title
            foreach ($serviceIds as $serviceId) {
                $translatedTitle = null;

                // Try current language first
                if (
                    isset($serviceTranslations[$serviceId][$currentLang]['title']) &&
                    !empty(trim($serviceTranslations[$serviceId][$currentLang]['title']))
                ) {
                    $translatedTitle = trim($serviceTranslations[$serviceId][$currentLang]['title']);
                }
                // Fallback to default language
                elseif (
                    isset($serviceTranslations[$serviceId][$defaultLang]['title']) &&
                    !empty(trim($serviceTranslations[$serviceId][$defaultLang]['title']))
                ) {
                    $translatedTitle = trim($serviceTranslations[$serviceId][$defaultLang]['title']);
                }

                // Only set translation if we found a valid non-empty value
                // If null, the calling code will use the original data as fallback
                $result['services'][$serviceId] = $translatedTitle;
            }
        }

        // Get partner translations in batch - OPTIMIZED single query
        if (!empty($partnerIds)) {
            $partnerModel = new \App\Models\TranslatedPartnerDetails_model();
            $partnerTranslations = $partnerModel->getAllTranslationsForPartners($partnerIds);

            // Process each partner ID to get translated company name
            foreach ($partnerIds as $partnerId) {
                $translatedName = null;

                // Try current language first - check both username and company_name fields
                if (
                    isset($partnerTranslations[$partnerId][$currentLang]['company_name']) &&
                    !empty(trim($partnerTranslations[$partnerId][$currentLang]['company_name']))
                ) {
                    $translatedName = trim($partnerTranslations[$partnerId][$currentLang]['company_name']);
                } elseif (
                    isset($partnerTranslations[$partnerId][$currentLang]['username']) &&
                    !empty(trim($partnerTranslations[$partnerId][$currentLang]['username']))
                ) {
                    $translatedName = trim($partnerTranslations[$partnerId][$currentLang]['username']);
                }
                // Fallback to default language - check both username and company_name fields
                elseif (
                    isset($partnerTranslations[$partnerId][$defaultLang]['company_name']) &&
                    !empty(trim($partnerTranslations[$partnerId][$defaultLang]['company_name']))
                ) {
                    $translatedName = trim($partnerTranslations[$partnerId][$defaultLang]['company_name']);
                } elseif (
                    isset($partnerTranslations[$partnerId][$defaultLang]['username']) &&
                    !empty(trim($partnerTranslations[$partnerId][$defaultLang]['username']))
                ) {
                    $translatedName = trim($partnerTranslations[$partnerId][$defaultLang]['username']);
                }

                // Only set translation if we found a valid non-empty value
                // If null, the calling code will use the original data as fallback
                $result['partners'][$partnerId] = $translatedName;
            }
        }
    } catch (\Exception $e) {
        // Log error but don't break the function - graceful degradation
        log_message('error', 'Error in get_batch_translated_names: ' . $e->getMessage());
    }

    return $result;
}

function get_translated_partner_field($partnerId, $fieldName, $defaultValue = null)
{
    $currentLang = get_current_language();
    $defaultLang = get_default_language();

    if (empty($partnerId) || empty($fieldName)) {
        return $defaultValue;
    }

    $translationModel = new \App\Models\TranslatedPartnerDetails_model();
    $translations = $translationModel->getAllTranslationsForPartner($partnerId);

    if (!empty($translations)) {
        // Try current language first
        foreach ($translations as $item) {
            if ($item['language_code'] === $currentLang && isset($item[$fieldName])) {
                return $item[$fieldName];
            }
        }

        // Fallback to default language
        foreach ($translations as $item) {
            if ($item['language_code'] === $defaultLang && isset($item[$fieldName])) {
                return $item[$fieldName];
            }
        }
    }

    // Final fallback
    return $defaultValue;
}
function getTranslatedSetting(string $key, string $field = ""): string
{
    $session     = session();
    $currentLang = $session->get('lang') ?? 'en';

    // Pull the setting (with optional nested field if needed)
    $settings = get_settings($key, true);
    $value    = $field ? ($settings[$field] ?? '') : ($settings[$key] ?? '');

    // Case 1: Old clients → plain HTML (last fallback for old single language data)
    if (is_string($value)) {
        return $value;
    }

    // Case 2: New clients → translations array with 4-tier fallback logic
    if (is_array($value)) {
        $defaultLang = fetch_details('languages', ['is_default' => 1], ['code'])[0]['code'] ?? 'en';

        // Tier 1: Current language translation (if available)
        if (!empty($value[$currentLang])) {
            return $value[$currentLang];
        }

        // Tier 2: Default language translation (if current language fails)
        if (!empty($value[$defaultLang])) {
            return $value[$defaultLang];
        }

        // Tier 3: First available translation (if default language fails)
        if (!empty($value)) {
            return reset($value);
        }
    }

    // Tier 4: If all above fail, try to get old single language data as last fallback
    // This handles cases where the new structure exists but is empty
    $oldValue = get_settings($key, true);
    if (is_string($oldValue)) {
        return $oldValue;
    }

    return '';
}
