<?php

namespace App\Models;

use CodeIgniter\Model;

class Partners_model extends Model
{
    protected $table = 'partner_details';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'partner_id',
        'company_name',
        'about',
        'national_id',
        'address',
        'passport',
        'address_id',
        'banner',
        'tax_name',
        'tax_number',
        'bank_name',
        'account_number',
        'account_name',
        'bank_code',
        'swift_code',
        'advance_booking_days',
        'type',
        'number_of_members',
        'admin_commission',
        'visiting_charges',
        'is_approved',
        'service_range',
        'ratings',
        'number_of_ratings',
        'payable_commision',
        'other_images',
        'long_description',
        'at_store',
        'at_doorstep',
        'chat',
        'need_approval_for_the_service',
        'pre_chat',
        'custom_job_categories',
        'slug',

    ];

    /**
     * Private helper function to handle translation logic for partner data
     * 
     * @param array $partnerData Raw partner data from database
     * @param array $translations All translations for partners (indexed by partner_id then language_code)
     * @param string $requestedLang Language code requested by user
     * @param string $defaultLang Default language of the system
     * @return array Partner data with proper translation fields applied
     */
    private function applyTranslations($partnerData, $translations, $requestedLang, $defaultLang)
    {
        $partnerId = $partnerData['partner_id'];

        // Get translations for this specific partner
        $partnerTranslations = $translations[$partnerId] ?? [];

        // Determine the best translation for requested language
        $requestedTranslation = $this->getBestTranslation($partnerTranslations, $requestedLang, $defaultLang);

        // Determine the best translation for default language (for original fields)
        $defaultTranslation = $this->getBestTranslation($partnerTranslations, $defaultLang, $defaultLang);

        // Apply original fields (use default language translation, fallback to main table)
        $partnerData['company_name'] = trim($defaultTranslation['company_name'] ?? $partnerData['company_name']);
        $partnerData['about'] = $defaultTranslation['about'] ?? $partnerData['about'];
        $partnerData['long_description'] = $defaultTranslation['long_description'] ?? $partnerData['long_description'];

        // Apply username translation with fallback to main table username
        $partnerData['partner_name'] = trim($defaultTranslation['username'] ?? $partnerData['partner_name']);

        // Apply translated fields (use requested language translation with fallback logic)
        // If requested translation is empty, fall back to English or original data
        $partnerData['translated_company_name'] = trim(!empty($requestedTranslation['company_name'])
            ? $requestedTranslation['company_name']
            : ($defaultTranslation['company_name'] ?? $partnerData['company_name']));
        $partnerData['translated_about'] = !empty($requestedTranslation['about'])
            ? $requestedTranslation['about']
            : ($defaultTranslation['about'] ?? $partnerData['about']);
        $partnerData['translated_long_description'] = !empty($requestedTranslation['long_description'])
            ? $requestedTranslation['long_description']
            : ($defaultTranslation['long_description'] ?? $partnerData['long_description']);

        // Apply translated username with fallback logic
        $partnerData['translated_partner_name'] = trim(!empty($requestedTranslation['username'])
            ? $requestedTranslation['username']
            : ($defaultTranslation['username'] ?? $partnerData['partner_name']));

        return $partnerData;
    }

    /**
     * Get the best available translation based on priority
     * 
     * @param array $partnerTranslations All translations for a partner (indexed by language_code)
     * @param string $preferredLang Preferred language code
     * @param string $defaultLang Default language code
     * @return array Best translation data
     */
    private function getBestTranslation($partnerTranslations, $preferredLang, $defaultLang)
    {
        if (isset($partnerTranslations[$preferredLang])) {
            return $partnerTranslations[$preferredLang];
        } elseif (isset($partnerTranslations[$defaultLang])) {
            return $partnerTranslations[$defaultLang];
        } elseif (!empty($partnerTranslations)) {
            return reset($partnerTranslations);
        }
        return [];
    }

    /**
     * Get the requested language with proper priority
     * 
     * @param string|null $languageCode Explicit language code from parameter
     * @return string Language code to use
     */
    private function getRequestedLanguage($languageCode = null)
    {
        // Priority 1: Explicit parameter
        if ($languageCode) {

            return $languageCode;
        }

        // Priority 2: Header language (for API requests)
        if (function_exists('get_current_language_from_request')) {
            $headerLang = get_current_language_from_request();
            if ($headerLang) {
                return $headerLang;
            }
        }

        // Priority 3: Session language
        return get_current_language();
    }

    public function list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [], $additional_data = [], $limit_for_subscription = null, $languageCode = null)
    {
        $disk = fetch_current_file_manager();

        // Get current language for translation with priority: header > session > default
        $currentLang = $this->getRequestedLanguage($languageCode);
        $defaultLang = get_default_language();

        $multipleWhere = '';
        $db      = \Config\Database::connect();
        $builder = $db->table('partner_details pd');
        $values = ['7'];
        // Add translated fields join for search if not English
        if ($search and $search != '' && $currentLang !== 'en') {
            $builder->join('translated_partner_details tpd_search', "tpd_search.partner_id = pd.partner_id AND tpd_search.language_code = '$currentLang'", 'left');
        }

        if ($search and $search != '') {

            $searchWhere = [
                '`pd.id`' => $search,
                '`pd.company_name`' => $search,
                '`pd.tax_name`' => $search,
                '`pd.tax_number`' => $search,
                '`pd.bank_name`' => $search,
                '`pd.account_number`' => $search,
                '`pd.account_name`' => $search,
                '`pd.bank_code`' => $search,
                '`pd.swift_code`' => $search,
                '`pd.created_at`' => $search,
                '`pd.updated_at`' => $search,
                '`username`' => $search,
                '`ps.status`' => $search,
            ];

            // Add translated fields to search if not English
            if ($currentLang !== 'en') {
                $searchWhere['`tpd_search.company_name`'] = $search;
                $searchWhere['`tpd_search.about`'] = $search;
                $searchWhere['`tpd_search.long_description`'] = $search;
            }


            if (isset($searchWhere) && !empty($searchWhere)) {
                $builder->groupStart();
                $builder->orLike($searchWhere);
                $builder->groupEnd();
            }
        }

        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        $builder->select(' COUNT( DISTINCT pd.id) as `total`')
            ->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id', 'left')
            ->where('ug.group_id', 3)->whereNotIn('pd.is_approved', $values);
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        if (isset($_GET['partner_filter']) && $_GET['partner_filter'] != '') {
            $builder->where('pd.is_approved', $_GET['partner_filter']);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->where('ps.status', 'active')->whereIn($column_name, $whereIn);
            // print_r($builder->get()->getResultArray()); die;
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $latitude = $additional_data['latitude'];
            $longitude = $additional_data['longitude'];
        }

        $partner_count = $builder->get()->getResultArray();
        $defaultLanguage = get_default_language();
        // print_r($db->getLastQuery());
        // die;
        $total = $partner_count[0]['total'];
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude']) &&  !empty($limit_for_subscription)  && isset($limit_for_subscription)) {
            if (isset($where) && !empty($where)) {
                $builder->where($where);
            }
            if (isset($searchWhere) && !empty($searchWhere)) {
                $builder->groupStart();
                $builder->orLike($searchWhere);
                $builder->groupEnd();
            }

            // Add translated fields join for search if not English
            if ($search and $search != '' && $currentLang !== 'en') {
                $builder->join('translated_partner_details tpd_search', "tpd_search.partner_id = pd.partner_id AND tpd_search.language_code = '$currentLang'", 'left');
            }

            $builder->select("
                pd.*,
                u.username as partner_name, 
                u.balance, u.image, u.active, u.email, u.phone, u.city, 
                u.longitude, u.latitude, u.payable_commision,
                ug.user_id, ug.group_id,
                ps.id as partner_subscription_id, 
                ps.status as partner_subscription_status, 
                ps.max_order_limit,

                COUNT(DISTINCT CASE WHEN pd.partner_id AND o.status = 'completed' THEN o.id END) as number_of_orders,

                st_distance_sphere(POINT('$longitude','$latitude'), POINT(u.longitude, u.latitude))/1000 as distance,

                MAX(DISTINCT CASE WHEN pd.partner_id THEN pc.discount END) as maximum_discount_percentage,
                MAX(DISTINCT CASE WHEN pd.partner_id THEN pc.max_discount_amount END) as maximum_discount_up_to,

                (st_distance_sphere(POINT('$longitude','$latitude'), POINT(u.longitude, u.latitude))/1000) < " .
                $additional_data['max_serviceable_distance'] . " as is_Available_at_location
            ");
            $builder
                ->join('users u', 'pd.partner_id = u.id')
                ->join('users_groups ug', 'ug.user_id = u.id')
                ->join('orders o', 'o.partner_id = pd.partner_id AND o.parent_id IS NULL', 'left')
                ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id')
                ->join('promo_codes pc', 'pc.partner_id = pd.partner_id', 'left')
                ->where('ug.group_id', 3)
                ->where('pd.is_approved', '1')
                ->groupBy('pd.partner_id');

            // for web :: web ma scroll ma issue ave ena mate aa karel che  jyare partner id pass thay tyare distance vadi condition n check thavi joiye
            if (!array_key_exists('pd.partner_id', $where)) {
                $builder->having('distance < ' . $additional_data['max_serviceable_distance']);
            }
            $builder->where('ps.status', 'active')
                ->groupBy('pd.partner_id');
        } else if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            // Add translated fields join for search if not English
            if ($search and $search != '' && $currentLang !== 'en') {
                $builder->join('translated_partner_details tpd_search', "tpd_search.partner_id = pd.partner_id AND tpd_search.language_code = '$currentLang'", 'left');
            }

            $builder->select("
                pd.*,
                u.username as partner_name,
                u.balance, u.image, u.active, u.email, u.phone, u.city,
                u.longitude, u.latitude, u.payable_commision,
                ug.user_id, ug.group_id,
                ps.id as partner_subscription_id, 
                ps.status as partner_subscription_status, 
                ps.max_order_limit,

                COUNT(DISTINCT CASE WHEN pd.partner_id AND o.status = 'completed' THEN o.id END) as number_of_orders,

                st_distance_sphere(POINT('$longitude','$latitude'), POINT(u.longitude, u.latitude))/1000 as distance,

                MAX(DISTINCT CASE WHEN pd.partner_id THEN pc.discount END) as maximum_discount_percentage,
                MAX(DISTINCT CASE WHEN pd.partner_id THEN pc.max_discount_amount END) as maximum_discount_up_to
            ");

            $builder
                ->join('users u', 'pd.partner_id = u.id')
                ->join('users_groups ug', 'ug.user_id = u.id')
                ->join('orders o', 'o.partner_id = pd.partner_id AND o.parent_id IS NULL', 'left')
                ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id', 'left')
                ->join('promo_codes pc', 'pc.partner_id = pd.partner_id', 'left')
                ->where('ug.group_id', 3)
                ->where('pd.is_approved', '1')
                ->groupBy('pd.partner_id')
                ->having('distance < ' . $additional_data['max_serviceable_distance']);
        } else {
            // Add translated fields join for search if not English
            if ($search and $search != '' && $currentLang !== 'en') {
                $builder->join('translated_partner_details tpd_search', "tpd_search.partner_id = pd.partner_id AND tpd_search.language_code = '$currentLang'", 'left');
            }

            $subQueryOrders = "(SELECT o.partner_id, COUNT(o.id) AS number_of_orders
                    FROM orders o
                    WHERE o.status = 'completed' AND o.parent_id IS NULL
                    GROUP BY o.partner_id)";

            $subQueryDiscounts = "(SELECT pc.partner_id, 
                              MAX(pc.discount) AS maximum_discount_percentage, 
                              MAX(pc.max_discount_amount) AS maximum_discount_up_to
                       FROM promo_codes pc
                       GROUP BY pc.partner_id)";

            $builder->select("
                pd.*,
                u.username as partner_name,
                u.balance, u.image, u.active, u.email, u.phone, 
                u.city, u.longitude, u.latitude, u.payable_commision,
                ug.user_id, ug.group_id,
                ps.id as partner_subscription_id, 
                ps.status as partner_subscription_status,

                pt.day, pt.opening_time, pt.closing_time, pt.is_open,

                COALESCE(OrdersSummary.number_of_orders, 0) AS number_of_orders,
                COALESCE(DiscountSummary.maximum_discount_percentage, 0) AS maximum_discount_percentage,
                COALESCE(DiscountSummary.maximum_discount_up_to, 0) AS maximum_discount_up_to
            ");

            $builder
                ->join('users u', 'pd.partner_id = u.id')
                ->join('users_groups ug', 'ug.user_id = u.id')
                ->join("($subQueryOrders) AS OrdersSummary", 'OrdersSummary.partner_id = pd.partner_id', 'left')
                ->join("($subQueryDiscounts) AS DiscountSummary", 'DiscountSummary.partner_id = pd.partner_id', 'left')
                ->join('partner_subscriptions ps', 'ps.partner_id = pd.partner_id', 'left')
                ->join('partner_timings pt', 'pt.partner_id = pd.partner_id', 'left')
                ->where('ug.group_id', 3)
                ->groupBy('pd.partner_id');
        }
        if (isset($_GET['partner_filter']) && $_GET['partner_filter'] != '') {
            $builder->where('pd.is_approved', $_GET['partner_filter']);
        }
        if (isset($searchWhere) && !empty($searchWhere)) {
            $builder->groupStart();
            $builder->orLike($searchWhere);
            $builder->groupEnd();
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->where('ps.status', 'active')->whereIn($column_name, $whereIn);
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        $partner_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        // Batch fetch all translations for all partners in a single query
        $allTranslations = [];
        if (!empty($partner_record)) {
            $partnerIds = array_column($partner_record, 'partner_id');

            $translatedPartnerDetailsModel = new \App\Models\TranslatedPartnerDetails_model();

            // Get all translations for all partners (not just current language)
            $allTranslations = $translatedPartnerDetailsModel->getAllTranslationsForPartners($partnerIds);
        }

        $bulkData = array();
        $bulkData['total'] = $total;
        if ($from_app == false) {
            $db      = \Config\Database::connect();
            $builder = $db->table('users u');
            $builder->select('u.*,ug.group_id')
                ->join('users_groups ug', 'ug.user_id = u.id')
                ->where('ug.group_id', 1)
                ->where(['phone' => $_SESSION['identity']]);
            $user1 = $builder->get()->getResultArray();
            $permissions = get_permission($user1[0]['id']);
        }
        $rows = array();
        $tempRow = array();
        foreach ($partner_record as $row) {
            // Apply translations using our helper function
            $row = $this->applyTranslations($row, $allTranslations, $currentLang, $defaultLang);

            $profile = "";
            $defaultImage = base_url('public/backend/assets/default.png');
            $disk = fetch_current_file_manager();

            // Handle profile image with consistent fallback logic
            $imageSrc = get_file_url($disk, $row['image'], 'public/backend/assets/default.png', 'profile');

            $profile = '<div class="o-media o-media--middle">
                        <a href="' . $imageSrc . '" data-lightbox="image-1">
                            <img class="o-media__img images_in_card" src="' . $imageSrc . '" alt="' . $row['partner_name'] . '">
                        </a>';

            if ($row['email'] != '' && $row['phone'] != "") {
                $contact_detail =
                    '<span>
                    ' .  ((defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0)  ? 'wrteam.' . substr($row['email'], 6) : $row['email']) . '
                </span>';
            } elseif ($row['email'] != '') {
                $contact_detail =  ((defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0)) ?  'wrteam.' . substr($row['email'], 6) : $row['email'];
            } else {
                $contact_detail = ((defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0)) ? 'XXX-' . substr($row['phone'], 6) :   $row['phone'];
            }
            $profile .= '<a href="' . base_url('/admin/partners/general_outlook/' . $row['partner_id']) . '"><div class="o-media__body">
                <div class="provider_name_table">' .     $row['partner_name'] . '</div>
                <div class="provider_email_table">' . $contact_detail . '</div>
                </div>
                </div></a>';
            $status = '';
            $status = '<div class="dropdown ">
            <a class="" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <button class="btn btn-secondary   btn-sm px-3"><i class="fas fa-ellipsis-v "></i></button>
          </a>
            <div class="dropdown-menu dropdown-scrollbar custom_dropdown" aria-labelledby="dropdownMenuButton">';
            if ($from_app == false) {
                if ($permissions['update']['partner'] == 1) {
                    $status .= '<a class="dropdown-item" href="' . base_url('/admin/partners/edit_partner/' . $row['partner_id']) . '"><i class="fa fa-pen mr-1 text-primary"></i>' . labels('edit_provider', 'Edit Provider') . '</a>';
                }
                if ($permissions['delete']['partner'] == 1) {
                    $status .= '<a class="dropdown-item delete_partner" href="#" id="delete_partner"> <i class="fa fa-trash mr-1 text-danger"></i>' . labels('delete_provider', 'Delete Provider') . '</a>';
                }
                if ($permissions['read']['partner'] == 1) {
                    $status .= '</i><a class="dropdown-item" href="' . base_url('/admin/partners/general_outlook/' . $row['partner_id']) . '"> <i class="fa fa-eye mr-1 text-success"></i>' . labels('view_provider', 'View Provider') . '</a>';
                }
                $status .= '<a class="dropdown-item" href="' . base_url('/admin/partners/duplicate/' . $row['partner_id']) . '"><i class="fa fa-copy mr-1 text-primary"></i>' . labels('duplicate_provider', 'Duplicate Provider') . '</a>';
            }
            $status .= ($row['is_approved'] == 1) ?
                '<a class="dropdown-item disapprove_partner" href="#" id="disapprove_partner"> <i class="fas fa-times text-danger mr-1"></i>' . labels('disapprove_provider', 'Disapprove Provider') . '</a>' :
                '<a class="dropdown-item approve_partner" href="#" id="approve_partner" ><i class="fas fa-check text-success mr-1"></i>' . labels('approve_provider', 'Approve Provider') . '</a>';
            $status .= '</div></div>';
            if ($from_app) {
                // Handle app-specific image logic with consistent fallback
                if (isset($additional_data['customer_id']) && !empty($additional_data['customer_id'])) {
                    $is_bookmarked = is_bookmarked($additional_data['customer_id'], $row['partner_id'])[0]['total'];
                    if (isset($is_bookmarked) && $is_bookmarked == 1) {
                        $tempRow['is_bookmarked'] = '1';
                    } else if (isset($is_bookmarked) && $is_bookmarked == 0) {
                        $tempRow['is_bookmarked'] = '0';
                    } else {
                        $tempRow['is_bookmarked'] = '0';
                    }
                }

                // Use get_file_url for consistent image handling
                $tempRow['image'] = get_file_url($disk, $row['image'], 'public/backend/assets/default.png', 'profile');
            }
            $tempRow['address'] = (!empty($row['address']) && isset($row['address'])) ? $row['address'] : '';
            if (($row['type'] == 0)) {
                $type = ucfirst(labels('individual', 'Individual'));
            } else {
                $type = ucfirst(labels('organization', 'Organization'));
            }
            $label = ($row['is_approved'] == 1) ?
                "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-success text-emerald-success dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 mx-5'>" . labels('approved', 'Approved') . "
                    </div>" :
                "<div class='tag border-0 rounded-md ltr:ml-2 rtl:mr-2 bg-emerald-danger text-emerald-danger dark:bg-emerald-500/20 dark:text-emerald-100 ml-3 mr-3 '>" . labels('disapproved', 'Disapproved') . "
                    </div>";

            // Convert to raw SQL query for better performance and clarity
            // This query calculates rating statistics for a partner from both services and custom job requests
            $rating_data = $db->query("
                SELECT 
                    COUNT(sr.rating) AS number_of_rating,
                    SUM(sr.rating) AS total_rating,
                    (SUM(sr.rating) / COUNT(sr.rating)) AS average_rating
                FROM services_ratings sr
                LEFT JOIN services s ON sr.service_id = s.id
                WHERE s.user_id = {$row['partner_id']}
                   OR (
                       sr.custom_job_request_id IS NOT NULL
                       AND EXISTS (
                           SELECT 1
                           FROM partner_bids pb
                           WHERE pb.custom_job_request_id = sr.custom_job_request_id
                             AND pb.partner_id = {$row['partner_id']}
                       )
                   )
            ")->getResultArray();

            // print_r($db->getLastQuery());
            // die;

            // Handle banner image with consistent fallback
            $tempRow['banner_edit'] = get_file_url($disk, $row['banner'], 'public/backend/assets/default.png', 'banner');

            if (!empty($row['banner'])) {
                $tempRow['banner_image'] = get_file_url($disk, $row['banner'], 'public/backend/assets/default.png', 'banner');
            } else {
                $tempRow['banner_image'] = '';
            }

            // Handle other_images with consistent fallback
            if (!empty($row['other_images'])) {
                $other_images_array = json_decode($row['other_images'], true);
                if (is_array($other_images_array)) {
                    $row['other_images'] = array_map(function ($data) use ($disk) {
                        if ($data !== '') {
                            return get_file_url($disk, $data, 'public/backend/assets/default.png', 'partner');
                        }
                        return get_file_url($disk, '', 'public/backend/assets/default.png', 'partner');
                    }, $other_images_array);
                } else {
                    $row['other_images'] = [];
                }
            } else {
                $row['other_images'] = [];
            }

            $cash_collection_button = '<button class="btn btn-success btn-sm edit_cash_collection" data-id="' . $row['id'] . '" data-toggle="modal" data-target="#update_modal"><i class="fa fa-pen" aria-hidden="true"></i> </button> ';

            $tempRow['id'] = $row['id'];
            $tempRow['is_Available_at_location'] = isset($row['is_Available_at_location']) ? $row['is_Available_at_location'] : "";
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['city'] = $row['city'];
            $tempRow['partner_profile'] = $profile;
            // Use the translated values from our helper function
            $tempRow['company_name'] = $row['company_name'];
            $tempRow['balance'] = $row['balance'];
            $tempRow['longitude'] = $row['longitude'];
            $tempRow['latitude'] = $row['latitude'];
            $tempRow['mobile'] = ((defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0)) ?  "XXXXX" . substr($row['phone'], 6) : $row['phone'];
            // Use the translated values from our helper function
            $tempRow['about'] = $row['about'];
            // Use the translated values from our helper function
            $tempRow['long_description'] = $row['long_description'];

            // Use the translated fields from our helper function
            $tempRow['translated_company_name'] = $row['translated_company_name'];
            $tempRow['translated_about'] = $row['translated_about'];
            $tempRow['translated_long_description'] = $row['translated_long_description'];
            $tempRow['translated_partner_name'] = $row['translated_partner_name'];
            $tempRow['address'] = (!empty($row['address']) && isset($row['address'])) ? $row['address'] : '';

            // Handle national_id with consistent fallback
            $tempRow['national_id'] = get_file_url($disk, $row['national_id'], 'public/backend/assets/default.png', 'national_id');

            // Handle address_id with consistent fallback
            $tempRow['address_id'] = get_file_url($disk, $row['address_id'], 'public/backend/assets/default.png', 'address_id');

            // Handle passport with consistent fallback
            $tempRow['passport'] = get_file_url($disk, $row['passport'], 'public/backend/assets/default.png', 'passport');

            $tempRow['partner_name'] = $row['partner_name'];
            $tempRow['tax_name'] = $row['tax_name'];
            $tempRow['tax_number'] = $row['tax_number'];
            $tempRow['bank_name'] = $row['bank_name'];
            $tempRow['account_number'] = $row['account_number'];
            $tempRow['account_name'] = $row['account_name'];
            $tempRow['bank_code'] = $row['bank_code'];
            $tempRow['swift_code'] = $row['swift_code'];
            $tempRow['number_of_members'] = $row['number_of_members'];
            $tempRow['admin_commission'] = $row['admin_commission'];
            $tempRow['type'] = $type;
            $tempRow['email'] = ((defined('ALLOW_MODIFICATION') && ALLOW_MODIFICATION == 0)) ? 'wrteam.' . substr($row['email'], 6) :  $row['email'];
            // $tempRow['image'] = $row['image'] ?? "public/backend/assets/default.png"; // Removed: This was overwriting the properly processed image field with base_url
            $tempRow['advance_booking_days'] = $row['advance_booking_days'];
            $tempRow['number_of_members'] = $row['number_of_members'];
            $tempRow['ratings'] = $row['ratings'];
            $tempRow['number_of_ratings'] = $rating_data[0]['number_of_rating'];
            $tempRow['visiting_charges'] = $row['visiting_charges'];
            $tempRow['contact_detail'] = $contact_detail;
            $tempRow['is_approved_edit'] = $row['is_approved'];
            $tempRow['payable_commision'] = intval($row['payable_commision']);
            $tempRow['cash_collection_button'] = $cash_collection_button;
            $tempRow['checkbox'] = "  <input type='checkbox' class='select-item checkbox' name='select-item'";
            $tempRow['other_images'] = $row['other_images'];
            $tempRow['at_doorstep'] = isset($row['at_doorstep']) ? $row['at_doorstep'] : "0";
            $tempRow['at_store'] = isset($row['at_store']) ? $row['at_store'] : "0";
            $tempRow['post_booking_chat'] = isset($row['chat']) ? $row['chat'] : "0";
            $tempRow['pre_booking_chat'] = isset($row['pre_chat']) ? $row['pre_chat'] : "0";
            // $tempRow['address_id'] = $row['address_id']; // Removed: This was overwriting the properly processed address_id field with base_url
            $tempRow['slug'] = $row['slug'];



            if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
                $tempRow['distance'] = $row['distance'];
            }


            // Count only approved and active services for the provider
            $total_services_of_providers = fetch_details('services', [
                'user_id' => $row['partner_id'],
                'at_store' => $row['at_store'],
                'at_doorstep' => $row['at_doorstep'],
                'status' => 1,  // Only active services
                'approved_by_admin' => 1  // Only approved services
            ], ['id']);
            $tempRow['total_services'] = count($total_services_of_providers);


            if (check_partner_availibility($row['partner_id'])) {
                $tempRow['is_available_now'] = true;
            } else {
                $tempRow['is_available_now'] = false;
            }
            $tempRow['status'] = $label;
            if (!empty($rating_data)) {
                $tempRow['ratings'] = '<i class="fa-solid fa-star text-warning"></i>(' . (($rating_data[0]['average_rating'] != "") ? sprintf('%0.1f', $rating_data[0]['average_rating']) : '0.0') . ')';
                if ($from_app == false) {
                    $tempRow['ratings'] = '<i class="fa-solid fa-star text-warning"></i>(' . (($rating_data[0]['average_rating'] != "") ? sprintf('%0.1f', $rating_data[0]['average_rating']) : '0.0') . ')';
                } else {
                    $tempRow['ratings'] =  (($rating_data[0]['average_rating'] != "") ? sprintf('%0.1f', $rating_data[0]['average_rating']) : '0.0');
                }
            }
            $rate_data = get_ratings($row['partner_id']);
            $tempRow['1_star'] = $rate_data[0]['rating_1'];
            $tempRow['2_star'] = $rate_data[0]['rating_2'];
            $tempRow['3_star'] = $rate_data[0]['rating_3'];
            $tempRow['4_star'] = $rate_data[0]['rating_4'];
            $tempRow['5_star'] = $rate_data[0]['rating_5'];
            $partner_timings = (fetch_details('partner_timings', ['partner_id' => $row['partner_id']]));
            foreach ($partner_timings as $pt) {
                $tempRow[$pt['day'] . '_is_open'] = $pt['is_open'];
                $tempRow[$pt['day'] . '_opening_time'] = $pt['opening_time'];
                $tempRow[$pt['day'] . '_closing_time'] = $pt['closing_time'];
            }
            if ($from_app == false) {
                $tempRow['discount'] =  $row['maximum_discount_percentage'];
                $tempRow['discount_up_to'] =  $row['maximum_discount_up_to'];
                $tempRow['is_approved'] = ($from_app == true) ? $row['is_approved'] : $status;
                $tempRow['created_at'] = $row['created_at'];
            } else {
                if (isset($additional_data['customer_id']) && !empty($additional_data['customer_id'])) {
                    $customer_id = $additional_data['customer_id'];
                    $is_favorite = is_favorite($customer_id, $row['partner_id']);
                    $tempRow['is_favorite'] = ($is_favorite) ? '1' : '0';
                }
                $tempRow['discount'] =  $row['maximum_discount_percentage'];
                $tempRow['discount_up_to'] =  $row['maximum_discount_up_to'];
                $tempRow['number_of_orders'] = $row['number_of_orders'];
                $tempRow['status'] = $row['is_approved'];
                unset($tempRow['partner_profile']);
                unset($tempRow['contact_detail']);
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = count($rows);
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        // echo "<pre>";
        // print_r($bulkData);
        // die;
        return $bulkData;
    }
    public function unsettled_commission_list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'pd.id', $whereIn = [], $additional_data = [])
    {
        $multipleWhere = '';
        $db      = \Config\Database::connect();
        $builder = $db->table('partner_details pd');
        $values = ['7'];
        if ($search and $search != '') {
            $multipleWhere = [
                '`pd.id`' => $search,
                '`pd.company_name`' => $search,
                '`pd.tax_name`' => $search,
                '`pd.tax_number`' => $search,
                '`pd.bank_name`' => $search,
                '`pd.account_number`' => $search,
                '`pd.account_name`' => $search,
                '`pd.bank_code`' => $search,
                '`pd.swift_code`' => $search,
                '`pd.created_at`' => $search,
                '`pd.updated_at`' => $search,
            ];
        }
        $builder->select(' COUNT(pd.id) as `total` ')->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', 3)->whereNotIn('pd.is_approved', $values);
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orWhere($multipleWhere);
            $builder->groupEnd();
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['max_serviceable_distance'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $partner_count = $builder->get()->getResultArray();
        $total = $partner_count[0]['total'];

        $currentLang = $this->getRequestedLanguage();
        $defaultLang = get_default_language();
        if (isset($additional_data['latitude']) && !empty($additional_data['latitude'])) {
            $parnter_ids = get_near_partners($additional_data['latitude'], $additional_data['longitude'], $additional_data['city_id'], true);
            if (isset($parnter_ids) && !empty($parnter_ids) && !isset($parnter_ids['error'])) {
                $builder->whereIn('pd.partner_id', $parnter_ids);
            }
        }
        $builder->select("
            pd.*,
            u.username as partner_name,
            u.balance,u.image,u.active,u.email,u.phone,
            ug.user_id,ug.group_id
        ")
            ->join('users u', 'pd.partner_id = u.id')
            ->join('users_groups ug', 'ug.user_id = u.id')
            ->where('ug.group_id', 3);
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($whereIn) && !empty($whereIn)) {
            $builder->whereIn($column_name, $whereIn);
        }
        $builder->whereNotIn('pd.is_approved', $values);
        $partner_record = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();

        // Batch fetch all translations for all partners in a single query
        $allTranslations = [];
        if (!empty($partner_record)) {
            $partnerIds = array_column($partner_record, 'partner_id');

            $translatedPartnerDetailsModel = new \App\Models\TranslatedPartnerDetails_model();

            // Get all translations for all partners (not just current language)
            $allTranslations = $translatedPartnerDetailsModel->getAllTranslationsForPartners($partnerIds);
        }

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();
        foreach ($partner_record as $row) {
            // Apply translations using our helper function
            $row = $this->applyTranslations($row, $allTranslations, $currentLang, $defaultLang);
            $operations =  '<button class="btn btn-success btn-sm pay-out" data-toggle="modal" data-target="#exampleModal"> 
            <i class="fa fa-pencil" aria-hidden="true"></i> 
            </button> ';
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['balance'] = $row['balance'];
            $tempRow['company_name'] = $row['company_name'];
            $tempRow['operations'] = $operations;
            $tempRow['partner_name'] = $row['partner_name'];

            // Use the translated fields from our helper function
            $tempRow['translated_company_name'] = $row['translated_company_name'];
            $tempRow['translated_partner_name'] = $row['translated_partner_name'];
            if ($from_app == false) {
                $tempRow['created_at'] = $row['created_at'];
            } else {
                $tempRow['status'] = $row['is_approved'];
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return $bulkData;
    }
    public function review()
    {
        $limit = (isset($_GET['limit']) && !empty($_GET['limit'])) ? $_GET['limit'] : 10;
        $offset = (isset($_GET['offset']) && !empty($_GET['offset'])) ? $_GET['offset'] : 0;
        $sort = (isset($_GET['sort']) && !empty($_GET['sort'])) ? $_GET['sort'] : 'id';
        $order = (isset($_GET['order']) && !empty($_GET['order'])) ? $_GET['order'] : 'ASC';
        $search = (isset($_GET['search']) && !empty($_GET['search'])) ? $_GET['search'] : '';
        $ratings = new Service_ratings_model();
        $data = $ratings->ratings_list(true, $search, $limit, $offset, $sort, $order, ['s.user_id' => $this->user_details['id']]);
        $bulkData = array();
        $rows = array();
        $tempRow = array();
        foreach ($data['data'] as $row) {
            $tempRow['id'] = $row['id'];
            $tempRow['user_name'] = $row['user_name'];
            $tempRow['profile_image'] = (!empty($row['profile_image']) && isset($row['profile_image'])) ? $row['profile_image'] : '';
            $tempRow['service_name'] = $row['service_name'];
            $tempRow['rating'] = $row['rating'];
            $tempRow['comment'] = $row['comment'];
            $tempRow['rated_on'] = $row['rated_on'];
            $tempRow['images'] = $row['images'];
            $rate_data = get_ratings($row['partner_id']);
            $tempRow['1_star'] = $rate_data[0]['rating_1'];
            $tempRow['2_star'] = $rate_data[0]['rating_2'];
            $tempRow['3_star'] = $rate_data[0]['rating_3'];
            $tempRow['4_star'] = $rate_data[0]['rating_4'];
            $tempRow['5_star'] = $rate_data[0]['rating_5'];
            $rows[] = $tempRow;
        }
        return $bulkData;
    }
}
