<?php

namespace App\Models;

use CodeIgniter\Model;

class ReasonsForReportAndBlockChat_model extends Model
{
    protected $table = 'reasons_for_report_and_block_chat';
    // Keep 'reason' in allowedFields for backward compatibility during migration
    protected $allowedFields = ['reason', 'needs_additional_info', 'type', 'created_at', 'updated_at'];
    protected $primaryKey = 'id';

    public function list($is_admin_panel, $where, $search = '',$limit = 10, $offset = 0, $sort = 'r.id', $order = 'DESC', $from_app = false)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('reasons_for_report_and_block_chat r');
        $multipleWhere = [];

        $condition = $bulkData = $rows = $tempRow = [];
        if ((isset($search) && !empty($search) && $search != "") || (isset($_GET['search']) && $_GET['search'] != '')) {
            $search = (isset($_GET['search']) && $_GET['search'] != '') ? $_GET['search'] : $search;
            $multipleWhere = [
                'r.id' => $search,
                // Remove reason from search since it's now in translations table
            ];
        }
        if (isset($_GET['offset']))
            $offset = $_GET['offset'];
        if (isset($_GET['limit'])) {
            $limit = $_GET['limit'];
        }
        if (isset($_GET['sort'])) {
            if ($_GET['sort'] == 'pc.id') {
                $sort = "r.id";
            } else {
                $sort = $_GET['sort'];
            }
        }
        if (isset($_GET['order'])) {
            $order = $_GET['order'];
        }
        $count =  $builder->select(' COUNT(r.id) as `total` ');
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        $count = $builder->get()->getResultArray();
        $total = $count[0]['total'];
        $builder->select('r.id, r.reason, r.needs_additional_info, r.type, r.created_at, r.updated_at');
        if (isset($where) && !empty($where)) {
            $builder->where($where);
        }
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $builder->groupStart();
            $builder->orLike($multipleWhere);
            $builder->groupEnd();
        }
        $admin_contact_query = $builder->orderBy($sort, $order)->limit($limit, $offset)->get()->getResultArray();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();
        
        // Get current language for displaying translated reason
        $session = session();
        $currentLanguage = $session->get('lang') ?? 'en';
        
        // If no language set in session, try to get from database
        if ($currentLanguage === 'en') {
            $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code']);
            if (!empty($defaultLanguage)) {
                $currentLanguage = $defaultLanguage[0]['code'];
            }
        }
        
        // Get all reason IDs to fetch translations
        $reasonIds = array_column($admin_contact_query, 'id');
        
        // Fetch translations for all reasons
        $translatedReasonModel = new \App\Models\TranslatedReasonsForReportAndBlockChat_model();
        $translations = [];
        if (!empty($reasonIds)) {
            $translations = $translatedReasonModel->getTranslationsForReasons($reasonIds, $currentLanguage);
        }
        
        // Create a lookup array for translations
        $translationLookup = [];
        foreach ($translations as $translation) {
            $translationLookup[$translation['reason_id']] = $translation['reason'];
        }
        
        foreach ($admin_contact_query as $row) {
            $tempRow['id'] = $row['id'];
            
            // Get default language code
            $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code'])[0]['code'] ?? 'en';
            
            // Get default language translation
            $defaultTranslation = null;
            if (isset($translations)) {
                foreach ($translations as $translation) {
                    if ($translation['reason_id'] == $row['id'] && $translation['language_code'] == $defaultLanguage) {
                        $defaultTranslation = $translation['reason'];
                        break;
                    }
                }
            }
            
            // Set reason field with default language data or main table fallback
            $tempRow['reason'] = $defaultTranslation ?? $row['reason'] ?? '';
            
            // Set translated_reason field with current language translation if available
            $currentTranslation = $translationLookup[$row['id']] ?? null;
            $tempRow['translated_reason'] = $currentTranslation;
            
            $tempRow['needs_additional_info'] = $row['needs_additional_info'];
            $tempRow['created_at'] = $row['created_at'];
            $tempRow['updated_at'] = $row['updated_at'];

            $needs_additional_info_badge = ($row['needs_additional_info'] == 1) ?
                "<div class='  text-emerald-success  ml-3 mr-3 mx-5'>" . labels('yes', 'Yes') . "
            </div>" :
                "<div class=' text-emerald-danger ml-3 mr-3 '>" . labels('no', 'No') . "
            </div>";
            $tempRow['needs_additional_info_badge'] = $needs_additional_info_badge;
            $operations = '<div class="dropdown">
            <a class="" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <button class="btn btn-secondary   btn-sm px-3"> <i class="fas fa-ellipsis-v "></i></button>
            </a><div class="dropdown-menu" aria-labelledby="dropdownMenuLink">';
            $operations .= '<a class="dropdown-item edit_reason " data-id="' . $row['id'] . '"  data-toggle="modal" data-target="#update_modal" onclick="reason_id(this)"><i class="fa fa-pen mr-1 text-primary"></i> ' . labels('edit', 'Edit') . '</a>';
            $operations .= '<a class="dropdown-item remove_reason" data-id="' . $row['id'] . '" onclick="reason_id(this)" data-toggle="modal" data-target="#delete_modal"> <i class="fa fa-trash text-danger mr-1"></i> ' . labels('delete', 'Delete') . '</a>';
            $operations .= '</div></div>';
            $tempRow['operations'] = $operations;
            $tempRow['type'] = $row['type'];


            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        if ($from_app) {
            return $rows;
        } else {
            return json_encode($bulkData);
        }
    }

    /**
     * Get translated reason text with fallback logic
     * 
     * @param int $reasonId Reason ID
     * @param string $languageCode Language code (optional, uses current language if not provided)
     * @return string Reason text in the specified language or fallback
     */
    public function getTranslatedReasonText(int $reasonId, string $languageCode = null): string
    {
        // If no language code provided, get current language
        if (!$languageCode) {
            $session = session();
            $languageCode = $session->get('lang') ?? 'en';
            
            // If no language set in session, try to get from database
            if ($languageCode === 'en') {
                $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code']);
                if (!empty($defaultLanguage)) {
                    $languageCode = $defaultLanguage[0]['code'];
                }
            }
        }
        
        // Get default language code
        $defaultLanguage = fetch_details('languages', ['is_default' => 1], ['code'])[0]['code'] ?? 'en';
        
        $translatedReasonModel = new \App\Models\TranslatedReasonsForReportAndBlockChat_model();
        $translatedText = $translatedReasonModel->getTranslatedReasonText($reasonId, $languageCode, $defaultLanguage);
        
        return $translatedText ?? 'No translation available';
    }
}
