<?php

namespace App\Models;

use CodeIgniter\Model;

class Service_ratings_model extends Model
{
    protected $table = 'services_ratings';
    protected $primaryKey = 'id';
    protected $allowedFields = ['user_id', 'service_id', 'rating', 'comment', 'images', 'custom_job_request_id'];
    public function ratings_list($from_app = false, $search = '', $limit = 10, $offset = 0, $sort = 'id', $order = 'ASC', $where = [], $column_name = 'id', $whereIn = [], $additional_data = [])
    {
        $multipleWhere = '';
        $db      = \Config\Database::connect();
        $builder = $db->table('services_ratings sr');
        if ($search and $search != '') {
            $multipleWhere = [
                '`sr.id`' => $search,
                '`sr.user_id`' => $search,
                '`sr.rating`' => $search,
                '`sr.comment`' => $search,
                '`sr.created_at`' => $search,
                '`u.username`' => $search,
                '`s.title`' => $search,
            ];
        }

        // $builder->select(' COUNT(sr.id) as `total` ')
        //     ->join('users u', 'u.id = sr.user_id')
        //     ->join('services s', 's.id = sr.service_id');

        // Get partner_id first if it exists for count query
        $partner_id = isset($additional_data['partner_id']) ? $additional_data['partner_id'] : null;

        // Build dynamic WHERE conditions for count query
        $count_where_conditions = [];
        $count_where_params = [];

        // Add search conditions if specified
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $search_conditions = [];
            foreach ($multipleWhere as $key => $value) {
                $search_conditions[] = "{$key} LIKE ?";
                $count_where_params[] = "%{$value}%";
            }
            if (!empty($search_conditions)) {
                $count_where_conditions[] = "(" . implode(' OR ', $search_conditions) . ")";
            }
        }

        // Add rating filter if specified
        if (isset($_GET['rating_star_filter']) && $_GET['rating_star_filter'] != '') {
            $count_where_conditions[] = 'sr.rating = ?';
            $count_where_params[] = $_GET['rating_star_filter'];
        }

        // Add partner filter if specified
        if (isset($additional_data['partner_id']) && !empty($additional_data['partner_id'])) {
            $count_where_conditions[] = "(s.user_id = ? OR (sr.custom_job_request_id IS NOT NULL AND EXISTS (SELECT 1 FROM partner_bids pbid WHERE pbid.custom_job_request_id = sr.custom_job_request_id AND pbid.partner_id = ?)))";
            $count_where_params[] = $partner_id;
            $count_where_params[] = $partner_id;
        }

        // Add existing WHERE conditions
        if (isset($where) && !empty($where)) {
            foreach ($where as $key => $value) {
                $count_where_conditions[] = "{$key} = ?";
                $count_where_params[] = $value;
            }
        }

        // Add WHERE IN conditions
        if (isset($whereIn) && !empty($whereIn)) {
            $placeholders = str_repeat('?,', count($whereIn) - 1) . '?';
            $count_where_conditions[] = "{$column_name} IN ({$placeholders})";
            $count_where_params = array_merge($count_where_params, $whereIn);
        }

        // Build the final WHERE clause for count
        $count_where_clause = '';
        if (!empty($count_where_conditions)) {
            $count_where_clause = 'WHERE ' . implode(' AND ', $count_where_conditions);
        }

        // Build the count SQL query
        $count_sql = "
            SELECT COUNT(sr.id) as total
            FROM services_ratings sr
            LEFT JOIN users u ON u.id = sr.user_id
            LEFT JOIN services s ON s.id = sr.service_id
            LEFT JOIN custom_job_requests cj ON cj.id = sr.custom_job_request_id
            {$count_where_clause}
        ";

        $ratings_total_count = $db->query($count_sql, $count_where_params)->getResultArray();
        $total = $ratings_total_count[0]['total'];

        // Get partner_id first if it exists for main query
        $partner_id = isset($additional_data['partner_id']) ? $additional_data['partner_id'] : null;

        // Build dynamic WHERE conditions
        $where_conditions = [];
        $where_params = [];

        // Add rating filter if specified
        if (isset($_GET['rating_star_filter']) && $_GET['rating_star_filter'] != '') {
            $where_conditions[] = 'sr.rating = ?';
            $where_params[] = $_GET['rating_star_filter'];
        }

        // Add partner filter if specified
        if (isset($additional_data['partner_id']) && !empty($additional_data['partner_id'])) {
            $where_conditions[] = "(s.user_id = ? OR (sr.custom_job_request_id IS NOT NULL AND EXISTS (SELECT 1 FROM partner_bids pbid WHERE pbid.custom_job_request_id = sr.custom_job_request_id AND pbid.partner_id = ?)))";
            $where_params[] = $partner_id;
            $where_params[] = $partner_id;
        }

        // Add existing WHERE conditions
        if (isset($where) && !empty($where)) {
            foreach ($where as $key => $value) {
                $where_conditions[] = "{$key} = ?";
                $where_params[] = $value;
            }
        }

        // Add WHERE IN conditions
        if (isset($whereIn) && !empty($whereIn)) {
            $placeholders = str_repeat('?,', count($whereIn) - 1) . '?';
            $where_conditions[] = "{$column_name} IN ({$placeholders})";
            $where_params = array_merge($where_params, $whereIn);
        }

        // Build the final WHERE clause
        $where_clause = '';
        if (!empty($where_conditions)) {
            $where_clause = 'WHERE ' . implode(' AND ', $where_conditions);
        }

        // Get current language and default language for translation fallback
        $currentLang = get_current_language();
        $defaultLang = get_default_language();

        // Build the raw SQL query with translation support
        $sql = "
            SELECT 
                sr.*,
                u.image AS profile_image,
                u.username,
                CASE 
                    WHEN sr.service_id IS NOT NULL THEN " . ($partner_id ?: 's.user_id') . "
                    WHEN sr.custom_job_request_id IS NOT NULL THEN " . ($partner_id ?: 'NULL') . "
                    ELSE NULL
                END AS partner_id,
                COALESCE(s.title, cj.service_title) AS service_name,
                s.title AS original_service_title,
                cj.service_title AS custom_job_title
            FROM services_ratings sr
            LEFT JOIN users u ON u.id = sr.user_id
            LEFT JOIN services s ON s.id = sr.service_id
            LEFT JOIN custom_job_requests cj ON cj.id = sr.custom_job_request_id
            {$where_clause}
            ORDER BY sr.{$sort} {$order}
            LIMIT {$limit} OFFSET {$offset}
        ";

        $rating_records = $db->query($sql, $where_params)->getResultArray();

        // Get service translations for all services in the results
        $serviceIds = array_filter(array_column($rating_records, 'service_id'));

        $serviceTranslations = [];
        if (!empty($serviceIds)) {
            $serviceTranslations = $this->getServiceTranslations($serviceIds);
        }

        // print_r($db->getLastQuery());
        // die;
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();
        $disk = fetch_current_file_manager();

        foreach ($rating_records as $row) {

            $partnerDetails = fetch_details('users', ['id' => $row['partner_id']], ['username']);
            $partner_name = !empty($partnerDetails[0]['username']) ? $partnerDetails[0]['username'] : "";
            $tempRow['id'] = $row['id'];
            $tempRow['partner_id'] = $row['partner_id'];
            $tempRow['partner_name'] = $partner_name;
            $tempRow['user_name'] = $row['username'];

            if ($disk == "aws_s3") {
                $tempRow['profile_image'] = fetch_cloud_front_url('profile', $row['profile_image']);
            } else if ($disk == "local_server") {

                if (!empty($row['profile_image'])) {

                    $imagePath =  'public/backend/assets/profiles/' . $row['profile_image'];
                    if (check_exists(base_url($imagePath)) || check_exists(base_url('/public/uploads/users/partners/' . $row['profile_image'])) || check_exists($imagePath)) {
                        if (filter_var($row['profile_image'], FILTER_VALIDATE_URL)) {
                            $tempRow['profile_image'] = base_url($row['profile_image']);
                        } else {
                            $imagePath = (file_exists($imagePath)) ? $imagePath : 'public/backend/assets/profiles/' . basename($row['profile_image']);
                            $tempRow['profile_image'] = base_url($imagePath);
                        }
                    }
                } else {
                    $tempRow['profile_image'] = base_url("public/backend/assets/profiles/default.png");
                }
            } else {
                $tempRow['profile_image'] = base_url("public/backend/assets/profiles/default.png");
            }

            $tempRow['user_id'] = $row['user_id'];
            $tempRow['service_id'] = $row['service_id'];

            // Keep original service name
            $tempRow['service_name'] = $row['service_name'];

            // Add translated service name with fallback logic
            if (!empty($row['service_id'])) {
                // Get translations for this specific service
                $serviceId = $row['service_id'];
                $serviceTrans = $serviceTranslations[$serviceId] ?? [];

                // Apply fallback chain: current language → default language → main table → first available
                $tempRow['translated_service_name'] = $this->getTranslatedServiceNameWithFallback(
                    $row,
                    $currentLang,
                    $defaultLang,
                    $serviceTrans
                );
            } else {
                // For custom job requests, use the custom job title directly
                $tempRow['translated_service_name'] = $row['custom_job_title'] ?? $row['service_name'];
            }

            $tempRow['rating'] = $row['rating'];
            $tempRow['comment'] = ($row['comment'] != "") ? $row['comment'] : "";
            $tempRow['rated_on'] = $row['created_at'];
            $tempRow['custom_job_request_id'] = $row['custom_job_request_id'];

            $tempRow['rate_updated_on'] = $row['updated_at'];
            if ($from_app == false) {
                $tempRow['stars'] = '<i class="fa-solid fa-star text-warning"></i>' .  $row['rating'];
                if ($row['images'] != "") {
                    $images =  rating_images($row['id'], false);
                    $tempRow['images'] = $images;
                } else {
                    $tempRow['images'] = array();
                }
                if ($row['images'] != "") {
                    $images = rating_images($row['id'], false);
                    $decodedImages = array_map('urldecode', $images);

                    $imageUrls = array_map(function ($htmlString) {
                        preg_match('/src="([^"]+)"/', $htmlString, $matches);
                        return isset($matches[1]) ? $matches[1] : '';
                    }, $decodedImages);
                } else {
                    $imageUrls = array();
                }

                $tempRow['view_images'] = '<button class="btn btn-success view-rating-images" title="View" data-id="' . $row['id'] . '" data-images=\'' . json_encode($imageUrls) . '\' data-toggle="modal" data-target="#viewImages"><i class="fa fa-eye" aria-hidden="true"></i></button>';
            } else {
                if ($row['images'] != "") {
                    $images =  rating_images($row['id'], true);
                    $tempRow['images'] = $images;
                } else {
                    $tempRow['images'] = array();
                }
            }
            $rows[] = $tempRow;
        }
        if ($from_app) {
            $response['total'] = $total;
            $response['data'] = $rows;
            return $response;
        } else {
            $bulkData['rows'] = $rows;
        }
        return $bulkData;
    }


    /**
     * Get service translations for multiple service IDs
     * 
     * @param array $serviceIds Array of service IDs
     * @return array Service translations grouped by service ID and language
     */
    private function getServiceTranslations(array $serviceIds): array
    {
        if (empty($serviceIds)) {
            return [];
        }

        $db = \Config\Database::connect();

        $sql = "
            SELECT 
                service_id,
                language_code,
                title,
                description,
                long_description
            FROM translated_service_details 
            WHERE service_id IN (" . implode(',', $serviceIds) . ")
        ";
        $translations = $db->query($sql)->getResultArray();

        // Group translations by service ID and language
        $groupedTranslations = [];
        foreach ($translations as $translation) {
            $serviceId = $translation['service_id'];
            $languageCode = $translation['language_code'];

            if (!isset($groupedTranslations[$serviceId])) {
                $groupedTranslations[$serviceId] = [];
            }

            $groupedTranslations[$serviceId][$languageCode] = $translation;
        }

        return $groupedTranslations;
    }

    /**
     * Get translated service name with fallback logic
     * Priority: current language → default language → main table → first available translation
     * 
     * @param array $serviceData Service data from database
     * @param string $currentLang Current language code
     * @param string $defaultLang Default language code
     * @param array $serviceTranslations Translations for this service
     * @return string Service name with fallback
     */
    private function getTranslatedServiceNameWithFallback(array $serviceData, string $currentLang, string $defaultLang, array $serviceTranslations): string
    {
        // If no translations available, use main table title
        if (empty($serviceTranslations)) {
            return $serviceData['original_service_title'] ?? $serviceData['service_name'] ?? '';
        }

        $currentTranslation = null;
        $defaultTranslation = null;
        $firstAvailable = null;

        // Loop through all language translations for this service
        foreach ($serviceTranslations as $languageCode => $translation) {
            if ($firstAvailable === null && !empty($translation['title'])) {
                $firstAvailable = $translation['title'];
            }
            if ($languageCode === $currentLang && !empty($translation['title'])) {
                $currentTranslation = $translation['title'];
            }
            if ($languageCode === $defaultLang && !empty($translation['title'])) {
                $defaultTranslation = $translation['title'];
            }
        }

        // Apply fallback chain: current language → default language → main table → first available
        return $currentTranslation
            ?? $defaultTranslation
            ?? ($serviceData['original_service_title'] ?? '')
            ?? $firstAvailable
            ?? '';
    }
}
