<!-- Main Content -->
<?php
$db      = \Config\Database::connect();
$builder = $db->table('users u');
$builder->select('u.*,ug.group_id')
    ->join('users_groups ug', 'ug.user_id = u.id')
    ->where('ug.group_id', 1)
    ->where(['phone' => $_SESSION['identity']]);
$user1 = $builder->get()->getResultArray();
$permissions = get_permission($user1[0]['id']);
?>
<div class="main-content">
    <section class="section">
        <div class="section-header mt-2">
            <h1> <?= labels('api_key_settings', 'API Key Settings') ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item "><a href="<?= base_url('/admin/settings/system-settings') ?>"><?= labels('system_settings', "System Settings") ?></a></div>
                <div class="breadcrumb-item"> <?= labels('api_key_settings', 'API Key Settings') ?></div>
            </div>
        </div>
        <form action="<?= base_url('admin/settings/api_key_settings') ?>" method="post">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
            <div class="container-fluid card ">
                <div class="row">
                    <div class="col " style="border-bottom: solid 1px #e5e6e9;">
                        <div class='toggleButttonPostition '><?= labels('api_key_settings', 'Api Key Settings') ?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col mb-3">
                        <div class='toggleButttonPostition text-new-primary'><?= labels('client_api_key_settings', ' Client API Keys') ?></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="google_map_api"><?= labels('API_link_for_customer_app', 'API link for Customer App') ?> </label>
                            <div class="input-group">
                                <input id="API_link_for_customer_app" class="form-control" type="text" name="API_link_for_customer_app" value="<?= base_url('api/v1/'); ?>" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('API_link_for_customer_app')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            <small class="text-danger">( <?= labels('use_this_link_as_your_API_link_in_apps_code', 'Use this link as your API link in App\'s code') ?> )</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="google_map_api"><?= labels('API_link_for_provider_app', 'API link for Provider App ') ?> </label>
                            <div class="input-group">
                                <input id="API_link_for_provider_app" class="form-control" type="text" name="API_link_for_provider_app" value="<?= base_url('/partner/api/v1/'); ?>" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('API_link_for_provider_app')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            <small class="text-danger">( <?= labels('use_this_link_as_your_API_link_in_providers_app_code', 'Use this link as your API link in Provider\'s App code') ?> )</small>
                        </div>
                    </div>
                </div>
                <?php
                $isSuperAdmin = $_SESSION['email'] == "superadmin@gmail.com";
                $isAdminOrUser1 = ($user1[0]['id'] == 1 || $isSuperAdmin);

                if ($isAdminOrUser1) {
                    $isModifiable = defined('ALLOW_MODIFICATION') && constant('ALLOW_MODIFICATION') == 1;
                } else {
                    $isModifiable = defined('ALLOW_MODIFICATION') && constant('ALLOW_MODIFICATION') == 0;
                }
                ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class='toggleButttonPostition text-new-primary'><?= labels('google_API_key_for_map', 'Google API key for map') ?></div>
                        <div class="form-group">
                            <label for="google_map_api"><?= labels('google_API_key_for_map', 'Google API key for map') ?></label>
                            <div class="input-group">
                                <input id="google_map_api" class="form-control" type="text" name="google_map_api"
                                    value="<?= (isset($google_map_api) && !empty($google_map_api) ? str_repeat('*', strlen($google_map_api)) : 'Enter API key') ?>"
                                    data-original-value="<?= isset($google_map_api) ? htmlspecialchars($google_map_api) : '' ?>"
                                    data-is-masked="<?= (isset($google_map_api) && !empty($google_map_api)) ? 'true' : 'false' ?>"
                                    <?= (!($isAdminOrUser1 && $isModifiable == 1)) ? 'readonly' : '' ?> />
                                <?php if ($isAdminOrUser1 && $isModifiable == 1): ?>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="toggleGoogleApiKeyVisibility('google_map_api', 'google-api-key-toggle-icon')" title="Toggle visibility">
                                            <i class="fas fa-eye" id="google-api-key-toggle-icon"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('google_map_api')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            <small class="form-text text-muted"><?= ($isAdminOrUser1 && $isModifiable == 1) ? labels('click_the_eye_icon_to_toggle_visibility', 'Click the eye icon to toggle visibility') : '' ?></small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class='toggleButttonPostition text-new-primary'><?= labels('google_api_key_for_places', 'Google API key for Places') ?></div>
                        <div class="form-group">
                            <label for="google_places_api"><?= labels('google_api_key_for_places', 'Google API key for Places') ?></label>
                            <div class="input-group">
                                <input id="google_places_api" class="form-control" type="text" name="google_places_api"
                                    value="<?= (isset($google_places_api) && !empty($google_places_api) ? str_repeat('*', strlen($google_places_api)) : 'Enter API key') ?>"
                                    data-original-value="<?= isset($google_places_api) ? htmlspecialchars($google_places_api) : '' ?>"
                                    data-is-masked="<?= (isset($google_places_api) && !empty($google_places_api)) ? 'true' : 'false' ?>"
                                    <?= (!($isAdminOrUser1 && $isModifiable == 1)) ? 'readonly' : '' ?> />
                                <?php if ($isAdminOrUser1 && $isModifiable == 1): ?>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="toggleGoogleApiKeyVisibility('google_places_api', 'google-places-api-key-toggle-icon')" title="Toggle visibility">
                                            <i class="fas fa-eye" id="google-places-api-key-toggle-icon"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('google_places_api')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            <small class="form-text text-muted"><?= ($isAdminOrUser1 && $isModifiable == 1) ? labels('click_the_eye_icon_to_toggle_visibility', 'Click the eye icon to toggle visibility') : '' ?></small>
                        </div>
                    </div>
                </div>

                <div class="row">
                </div>
                <div class="row mt-3">
                    <?php if ($permissions['update']['settings'] == 1) : ?>

                        <div class="col-md d-flex justify-content-end">
                            <div class="form-group">
                                <input type='submit' name='update' id='update' value='<?= labels('save_changes', "Save Changes") ?>' class='btn bg-new-primary' />
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </form>
    </section>
</div>

<script>
    // Google API Key masking functionality - Updated to handle multiple API keys
    function toggleGoogleApiKeyVisibility(inputId, iconId) {
        const apiKeyInput = document.getElementById(inputId);
        const toggleIcon = document.getElementById(iconId);

        if (!apiKeyInput || !toggleIcon) {
            console.error('Required elements not found for Google API key visibility toggle');
            return;
        }

        const originalValue = apiKeyInput.getAttribute('data-original-value');
        const isMasked = apiKeyInput.getAttribute('data-is-masked') === 'true';

        if (!originalValue || originalValue.trim() === '') {
            // No value to toggle
            return;
        }

        if (isMasked) {
            // Show the actual value
            apiKeyInput.value = originalValue;
            apiKeyInput.setAttribute('data-is-masked', 'false');
            toggleIcon.classList.remove('fa-eye');
            toggleIcon.classList.add('fa-eye-slash');
            toggleIcon.parentElement.setAttribute('title', 'Hide API key');
        } else {
            // Mask the value
            apiKeyInput.value = '*'.repeat(originalValue.length);
            apiKeyInput.setAttribute('data-is-masked', 'true');
            toggleIcon.classList.remove('fa-eye-slash');
            toggleIcon.classList.add('fa-eye');
            toggleIcon.parentElement.setAttribute('title', 'Show API key');
        }
    }

    // Initialize Google API key toggle button state for both API keys
    $(document).ready(function() {
        // Initialize Map API key toggle
        const mapApiKeyInput = document.getElementById('google_map_api');
        const mapToggleIcon = document.getElementById('google-api-key-toggle-icon');

        if (mapApiKeyInput && mapToggleIcon) {
            const isMasked = mapApiKeyInput.getAttribute('data-is-masked') === 'true';
            if (isMasked) {
                mapToggleIcon.classList.remove('fa-eye-slash');
                mapToggleIcon.classList.add('fa-eye');
                mapToggleIcon.parentElement.setAttribute('title', 'Show API key');
            } else {
                mapToggleIcon.classList.remove('fa-eye');
                mapToggleIcon.classList.add('fa-eye-slash');
                mapToggleIcon.parentElement.setAttribute('title', 'Hide API key');
            }
        }

        // Initialize Places API key toggle
        const placesApiKeyInput = document.getElementById('google_places_api');
        const placesToggleIcon = document.getElementById('google-places-api-key-toggle-icon');

        if (placesApiKeyInput && placesToggleIcon) {
            const isMasked = placesApiKeyInput.getAttribute('data-is-masked') === 'true';
            if (isMasked) {
                placesToggleIcon.classList.remove('fa-eye-slash');
                placesToggleIcon.classList.add('fa-eye');
                placesToggleIcon.parentElement.setAttribute('title', 'Show API key');
            } else {
                placesToggleIcon.classList.remove('fa-eye');
                placesToggleIcon.classList.add('fa-eye-slash');
                placesToggleIcon.parentElement.setAttribute('title', 'Hide API key');
            }
        }
    });

    // Validate on form submission - Handle both API keys
    $('form').submit(function(event) {
        // Handle Google Map API key masking before form submission
        const mapApiKeyInput = document.getElementById('google_map_api');
        if (mapApiKeyInput) {
            const originalValue = mapApiKeyInput.getAttribute('data-original-value');
            const isMasked = mapApiKeyInput.getAttribute('data-is-masked') === 'true';

            // If the field is masked, use the original value for submission
            if (isMasked && originalValue && originalValue.trim() !== '') {
                mapApiKeyInput.value = originalValue;
            }
        }

        // Handle Google Places API key masking before form submission
        const placesApiKeyInput = document.getElementById('google_places_api');
        if (placesApiKeyInput) {
            const originalValue = placesApiKeyInput.getAttribute('data-original-value');
            const isMasked = placesApiKeyInput.getAttribute('data-is-masked') === 'true';

            // If the field is masked, use the original value for submission
            if (isMasked && originalValue && originalValue.trim() !== '') {
                placesApiKeyInput.value = originalValue;
            }
        }
    });

    function copyToClipboard(elementId) {
        const element = document.getElementById(elementId);
        if (element) {
            element.select();
            element.setSelectionRange(0, 99999); // For mobile devices
            document.execCommand('copy');

            // Show a temporary success message
            const originalValue = element.value;
            element.style.backgroundColor = '#d4edda';
            element.style.borderColor = '#c3e6cb';
            setTimeout(() => {
                element.style.backgroundColor = '';
                element.style.borderColor = '';
            }, 1000);
        }
    }
</script>