<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <div class="section-header mt-2">
            <h1><?= labels('edit_email_template', "Edit Email template") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item "><a href="<?= base_url('/admin/settings/system-settings') ?>"><?= labels('system_settings', "System Settings") ?></a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/admin/settings/email_template_list') ?>"><?= labels('email_configuration', "Email Configuration") ?></a></div>
                <div class="breadcrumb-item"><?= labels('edit_email_configuration', "Edit Email Configuration") ?></div>
            </div>
        </div>
        
        <div class="card">
            <div class="col mb-3" style="border-bottom: solid 1px #e5e6e9;">
                <div class="toggleButttonPostition"><?= labels('email_configuration', "Email Configuration") ?></div>
            </div>
            <div class="card-body">
                <!-- Language Tabs -->
                <?php if (count($languages) > 1): ?>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="d-flex flex-wrap align-items-center gap-4">
                                <?php
                                // Sort languages so default language appears first for better UI
                                $sorted_languages = sort_languages_with_default_first($languages);
                                foreach ($sorted_languages as $index => $language) {
                                    if ($language['is_default'] == 1) {
                                        $current_language = $language['code'];
                                    }
                                ?>
                                    <div class="language-option position-relative <?= $language['is_default'] ? 'selected' : '' ?>"
                                        id="language-<?= $language['code'] ?>"
                                        data-language="<?= $language['code'] ?>"
                                        style="cursor: pointer; padding: 0.5rem 0;">
                                        <span class="language-text px-2 <?= $language['is_default'] ? 'text-primary fw-medium' : 'text-muted' ?>"
                                            style="font-size: 0.875rem; transition: color 0.3s ease; white-space: nowrap;">
                                            <?= $language['language'] ?><?= $language['is_default'] ? ' (Default)' : '' ?>
                                        </span>
                                        <div class="language-underline"
                                            style="position: absolute; bottom: 0; left: 0; width: <?= $language['is_default'] ? '100%' : '0' ?>; height: 2px; background: #0d6efd; transition: width 0.3s ease; border-radius: 1px;"></div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?= form_open_multipart(base_url('admin/settings/edit_email_template_operation'), array('class' => 'form-submit-event', 'id' => 'edit_email_template_form')) ?>
                
                <input type="hidden" name="template_id" value="<?= $template['id'] ?>" />
                
                <!-- Type field outside tabs -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?= labels('type', "Type") ?></label>
                            <select class="form-control select2" name="email_type" id="email_type">
                                <option value="provider_approved" <?= ($template['type'] == "provider_approved") ? 'selected' : '' ?>><?= labels('provider_approved', "Provider Approved") ?></option>
                                <option value="provider_disapproved" <?= ($template['type'] == "provider_disapproved") ? 'selected' : '' ?>><?= labels('provider_disapproved', "Provider Disapproved") ?></option>
                                <option value="withdraw_request_approved" <?= ($template['type'] == "withdraw_request_approved") ? 'selected' : '' ?>><?= labels('approved_withdraw_request', "Approved Withdrawal Request") ?></option>
                                <option value="withdraw_request_disapproved" <?= ($template['type'] == "withdraw_request_disapproved") ? 'selected' : '' ?>><?= labels('disapproved_withdraw_request', "Disapproved Withdrawal Request") ?> </option>
                                <option value="payment_settlement" <?= ($template['type'] == "payment_settlement") ? 'selected' : '' ?>><?= labels('payment_settled', "Payment Settled") ?> </option>
                                <option value="service_approved" <?= ($template['type'] == "service_approved") ? 'selected' : '' ?>> <?= labels('service_approved', "Service Approved") ?></option>
                                <option value="service_disapproved" <?= ($template['type'] == "service_disapproved") ? 'selected' : '' ?>><?= labels('service_disapproved', "Service Disapproved") ?> </option>
                                <option value="user_account_active" <?= ($template['type'] == "user_account_active") ? 'selected' : '' ?>><?= labels('user_account_activated', "User Account Activated") ?> </option>
                                <option value="user_account_deactive" <?= ($template['type'] == "user_account_deactive") ? 'selected' : '' ?>> <?= labels('user_account_deactivated', "User Account Deactivated") ?> </option>
                                <option value="provider_update_information" <?= ($template['type'] == "provider_update_information") ? 'selected' : '' ?>> <?= labels('provider_information_updated', "Provider Information Updated") ?> </option>
                                <option value="new_provider_registerd" <?= ($template['type'] == "new_provider_registerd") ? 'selected' : '' ?>> <?= labels('new_provider_registered', "New Provider Registered") ?> </option>
                                <option value="withdraw_request_received" <?= ($template['type'] == "withdraw_request_received") ? 'selected' : '' ?>> <?= labels('withdrawal_request_received', "Withdrawal Request Received") ?> </option>
                                <option value="booking_status_updated" <?= ($template['type'] == "booking_status_updated") ? 'selected' : '' ?>> <?= labels('booking_status_updated', "Booking Status Updated") ?> </option>
                                <option value="new_booking_confirmation_to_customer" <?= ($template['type'] == "new_booking_confirmation_to_customer") ? 'selected' : '' ?>> <?= labels('new_booking_confirmation_to_customer', "New Booking Confirmation to Customer") ?> </option>
                                <option value="new_booking_received_for_provider" <?= ($template['type'] == "new_booking_received_for_provider") ? 'selected' : '' ?>> <?= labels('new_booking_received_for_provider', "New Booking Received for Provider") ?> </option>
                                <option value="withdraw_request_send" <?= ($template['type'] == "withdraw_request_send") ? 'selected' : '' ?>><?= labels('withdraw_request_by_provider', "Withdraw Request by Provider") ?> </option>
                                <option value="new_rating_given_by_customer" <?= ($template['type'] == "new_rating_given_by_customer") ? 'selected' : '' ?>><?= labels('new_rating_given_by_customer', "New Rating Given by Customer") ?> </option>
                                <option value="rating_request_to_customer" <?= ($template['type'] == "rating_request_to_customer") ? 'selected' : '' ?>><?= labels('rating_request_to_customer', "Rating Request to Customer") ?> </option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Language-specific subject fields -->
                <div class="row mt-3">
                    <?php
                    // Use sorted languages for content divs
                    foreach ($sorted_languages as $index => $language) {
                        // Get translation data for this language
                        $translation_data = isset($translations[$language['code']]) ? $translations[$language['code']] : [];
                        $subject_value = !empty($translation_data['subject']) ? $translation_data['subject'] : ($language['is_default'] == 1 ? $template['subject'] : '');
                    ?>
                        <div class="col-md-6" id="subjectDiv-<?= $language['code'] ?>" <?= $language['code'] == $current_language ? 'style="display: block;"' : 'style="display: none;"' ?>>
                            <div class="form-group">
                                <label for="subject_<?= $language['code'] ?>" class="required"><?= labels('subject', 'Subject') . ($language['is_default'] ? '' : ' (' . $language['code'] . ')') ?></label>
                                <input id="subject_<?= $language['code'] ?>" class="form-control" type="text" name="translations[<?= $language['code'] ?>][subject]" placeholder="<?= labels('enter_subject_here', 'Enter subject here') ?>" value="<?= $subject_value ?>">
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <!-- Parameters section (same for all languages) -->
                <div class="col-md-12 provider_registration_request parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                    </div>
                </div>
                <div class="col-md-12 withdraw_request parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="amount"><?= labels('amount', "Amount") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="currency"><?= labels('currency', "Currency") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                    </div>
                </div>
                <div class="col-md-12 payment_settlement parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="amount"><?= labels('amount', "Amount") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="currency"><?= labels('currency', "Currency") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                    </div>
                </div>
                <div class="col-md-12 service_request parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="amount"><?= labels('amount', "Amount") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="currency"><?= labels('currency', "Currency") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="service_id"><?= labels('service_id', "Service ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="service_name"><?= labels('service_name', "Service Name") ?></button>
                    </div>
                </div>
                <div class="col-md-12 user_account parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_id"><?= labels('user_id', "User ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_name"><?= labels('user_name', "User name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                    </div>
                </div>
                <div class="col-md-12 booking_status parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_id"><?= labels('user_id', "User ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_name"><?= labels('user_name', "User Name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_id"><?= labels('booking_id', "Booking ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_date"><?= labels('booking_date', "Booking Date") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_time"><?= labels('booking_time', "Booking Time") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_service_names"><?= labels('booking_service_names', "Booking Service names") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_address"><?= labels('booking_address', "Booking Address") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="amount"><?= labels('amount', "Amount") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_status"><?= labels('status', "Status") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="currency"><?= labels('currency', "Currency") ?></button>
                    </div>
                </div>
                <div class="col-md-12 new_booking parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_id"><?= labels('user_id', "User ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_name"><?= labels('user_name', "User Name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_id"><?= labels('booking_id', "Booking ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_date"><?= labels('booking_date', "Booking Date") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_time"><?= labels('booking_time', "Booking Time") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_service_names"><?= labels('booking_service_names', "Booking Service names") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="booking_address"><?= labels('booking_address', "Booking Address") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="amount"><?= labels('amount', "Amount") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="currency"><?= labels('currency', "Currency") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                    </div>
                </div>
                <div class="col-md-12 rating_module parameters">
                    <label><?= labels('parameters', "Parameters") ?></label>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_id"><?= labels('user_id', "User ID") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="user_name"><?= labels('user_name', "User Name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_name"><?= labels('company_name', "Company name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="site_url"><?= labels('site_url', "Site URL") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_contact_info"><?= labels('company_contact_info', "Company Contact Info") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="company_logo"><?= labels('company_logo', "Company Logo") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_name"><?= labels('provider_name', "Provider name") ?></button>
                        <button type="button" class="btn btn-primary btn-icon icon-left" data-variable="provider_id"><?= labels('provider_id', "Provider ID") ?></button>
                    </div>
                </div>

                <!-- BCC and CC fields (same for all languages) -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= labels('bcc', "BCC") ?></label>
                            <input id="bcc" style="border-radius: 0.25rem!important" class="w-100" type="text" value="<?= ($template['bcc']) ?>" name="bcc[]" placeholder="<?= labels('press_enter_to_add_bcc', 'Press enter to add BCC') ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= labels('cc', "CC") ?></label>
                            <input id="cc" style="border-radius: 0.25rem" class="w-100" type="text" name="cc[]" value="<?= $template['cc'] ?>" placeholder="<?= labels('press_enter_to_add_cc', 'Press enter to add CC') ?>">
                        </div>
                    </div>
                </div>

                <!-- Language-specific template fields -->
                <div class="row">
                    <?php
                    foreach ($sorted_languages as $index => $language) {
                        // Get translation data for this language
                        $translation_data = isset($translations[$language['code']]) ? $translations[$language['code']] : [];
                        $template_value = !empty($translation_data['template']) ? $translation_data['template'] : ($language['is_default'] == 1 ? $template['template'] : '');
                    ?>
                        <div class="col-md-12" id="templateDiv-<?= $language['code'] ?>" <?= $language['code'] == $current_language ? 'style="display: block;"' : 'style="display: none;"' ?>>
                            <div class="form-group">
                                <label for="template_<?= $language['code'] ?>" class="required"><?= labels('template', 'Template') . ($language['is_default'] ? '' : ' (' . $language['code'] . ')') ?></label>
                                <textarea rows="10" id="template_<?= $language['code'] ?>" class="form-control h-50 summernotes custome_reset template-editor" name="translations[<?= $language['code'] ?>][template]"><?= $template_value ?></textarea>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <!-- Submit button -->
                <div class="row mt-3 mb-3">
                    <div class="col-md d-flex justify-content-end">
                        <button type="submit" class="btn btn-lg bg-new-primary submit_btn"><?= labels('save_changes', 'Save Changes') ?></button>
                    </div>
                </div>
                
                <?= form_close() ?>
            </div>
        </div>
    </section>
</div>

<script>
    $(document).ready(function() {
        // Hide all parameter sections initially
        $('.provider_registration_request,.withdraw_request,.payment_settlement,.service_request,.user_account,.booking_status,.new_booking,.rating_module').hide();
        
        let type = "<?= $template['type'] ?>";
        
        // Apply initial visibility to parameter sections based on type
        if (type == "provider_approved" || type == "provider_disapproved" || type == "provider_update_information" || type == "new_provider_registerd") {
            $('.provider_registration_request').show();
        }
        if (type == "withdraw_request_approved" || type == "withdraw_request_disapproved" || type == "withdraw_request_received" || type == "withdraw_request_send") {
            $('.withdraw_request').show();
        }
        if (type == "payment_settlement") {
            $('.payment_settlement').show();
        }
        if (type == "service_approved" || type == "service_disapproved") {
            $('.service_request').show();
        }
        if (type == "user_account_active" || type == "user_account_deactive") {
            $('.user_account').show();
        }
        if (type == "booking_status_updated") {
            $('.booking_status').show();
        }
        if (type == "new_booking_confirmation_to_customer" || type == "new_booking_received_for_provider") {
            $('.new_booking').show();
        }
        if (type == "new_rating_given_by_customer" || type == "rating_request_to_customer") {
            $('.rating_module').show();
        }
        
        // Initialize Select2 for email type dropdown
        setTimeout(() => {
            $('#email_type').select2();
        });
        
        // Handle email type change to show/hide relevant parameters
        $('#email_type').change(function() {
            let email_type = this.value;
            
            if (email_type == "provider_approved" || email_type == "provider_disapproved" || email_type == "provider_update_information" || email_type == "new_provider_registerd") {
                $('.provider_registration_request').show();
            } else {
                $('.provider_registration_request').hide();
            }
            if (email_type == "withdraw_request_approved" || email_type == "withdraw_request_disapproved" || email_type == "withdraw_request_received" || email_type == "withdraw_request_send") {
                $('.withdraw_request').show();
            } else {
                $('.withdraw_request').hide();
            }
            if (email_type == "payment_settlement") {
                $('.payment_settlement').show();
            } else {
                $('.payment_settlement').hide();
            }
            if (email_type == "service_approved" || email_type == "service_disapproved") {
                $('.service_request').show();
            } else {
                $('.service_request').hide();
            }
            if (email_type == "user_account_active" || email_type == "user_account_deactive") {
                $('.user_account').show();
            } else {
                $('.user_account').hide();
            }
            if (email_type == "booking_status_updated") {
                $('.booking_status').show();
            } else {
                $('.booking_status').hide();
            }
            if (email_type == "new_booking_confirmation_to_customer" || email_type == "new_booking_received_for_provider") {
                $('.new_booking').show();
            } else {
                $('.new_booking').hide();
            }
            if (email_type == "new_rating_given_by_customer" || email_type == "rating_request_to_customer") {
                $('.rating_module').show();
            } else {
                $('.rating_module').hide();
            }
        });
        
        // Initialize BCC field with Tagify
        if (document.getElementById("bcc") != null) {
            var input = document.querySelector('input[id=bcc]');
            new Tagify(input);
        }
        
        // Initialize CC field with Tagify
        if (document.getElementById("cc") != null) {
            var input = document.querySelector('input[id=cc]');
            new Tagify(input);
        }
    });

    // Handle parameter button clicks to insert variables into active template editor
    $('.parameters .btn').click(function() {
        let variableName = $(this).data('variable');
        let formattedText = `[[${variableName}]]`;
        
        // Insert into active TinyMCE editor
        if (typeof tinymce !== 'undefined' && tinymce.activeEditor) {
            tinymce.activeEditor.execCommand('mceInsertContent', false, formattedText);
        }
    });

    // Language switching functionality
    $(document).ready(function() {
        let default_language = '<?= $current_language ?>';

        $(document).on('click', '.language-option', function() {
            const language = $(this).data('language');

            // Update underline animation
            $('.language-underline').css('width', '0%');
            $('#language-' + language).find('.language-underline').css('width', '100%');

            // Update text styling
            $('.language-text').removeClass('text-primary fw-medium');
            $('.language-text').addClass('text-muted');
            $('#language-' + language).find('.language-text').removeClass('text-muted');
            $('#language-' + language).find('.language-text').addClass('text-primary');

            // Show/hide subject and template divs for all languages
            $('div[id^="subjectDiv-"]').hide();
            $('div[id^="templateDiv-"]').hide();
            $('#subjectDiv-' + language).show();
            $('#templateDiv-' + language).show();

            default_language = language;
        });
    });
</script>
