<div class="main-content">
    <section class="section">
        <div class="section-header mt-2">
            <h1><?= labels('reasons_rejection', "Rejection Reasons") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><?= labels('reasons_rejection', 'Rejection Reasons') ?></a></div>
            </div>
        </div>
        <?= helper('form'); ?>
        <div class="row">
            <div class="col-md-5">
                <div class="container-fluid card">
                    <div class="row ">
                        <div class="col mb-12" style="border-bottom: solid 1px #e5e6e9;">
                            <div class="toggleButttonPostition"><?= labels('add_reasons_rejection', 'Add Reasons') ?></div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= form_open('admin/reason_for_report_and_block_chat/add', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add_reasons', 'enctype' => "multipart/form-data"]); ?>
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="d-flex flex-wrap align-items-center gap-4">
                                    <?php
                                    // Sort languages to ensure default language comes first
                                    $sorted_languages = [];
                                    $default_language = null;

                                    // First, find and add default language
                                    foreach ($languages as $language) {
                                        if ($language['is_default'] == 1) {
                                            $sorted_languages[] = $language;
                                            $default_language = $language['code'];
                                            $current_language = $language['code'];
                                            break;
                                        }
                                    }

                                    // Then add all other languages
                                    foreach ($languages as $language) {
                                        if ($language['is_default'] != 1) {
                                            $sorted_languages[] = $language;
                                        }
                                    }

                                    foreach ($sorted_languages as $index => $language) {
                                    ?>
                                        <div class="language-option position-relative <?= $language['is_default'] ? 'selected' : '' ?>"
                                            id="language-<?= $language['code'] ?>"
                                            data-language="<?= $language['code'] ?>"
                                            style="cursor: pointer; padding: 0.5rem 0;">
                                            <span class="language-text px-2 <?= $language['is_default'] ? 'text-primary fw-medium' : 'text-muted' ?>"
                                                style="font-size: 0.875rem; transition: color 0.3s ease; white-space: nowrap;">
                                                <?= $language['language'] ?><?= $language['is_default'] ? '(Default)' : '' ?>
                                            </span>
                                            <div class="language-underline"
                                                style="position: absolute; bottom: 0; left: 0; width: <?= $language['is_default'] ? '100%' : '0' ?>; height: 2px; background: #0d6efd; transition: width 0.3s ease; border-radius: 1px;"></div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <?php
                            foreach ($sorted_languages as $index => $language) {
                            ?>
                                <div class="col-md-12" id="translationDiv-<?= $language['code'] ?>" <?= $language['code'] == $current_language ? 'style="display: block;"' : 'style="display: none;"' ?>>
                                    <div class="form-group">
                                        <label for="reason<?= $language['code'] ?>" class="<?= $language['code'] == $current_language ? 'required' : '' ?>"><?= labels('reason', "Reason") . ($language['is_default'] ? '' : ' (' . $language['code'] . ')') ?></label>
                                        <input id="reason<?= $language['code'] ?>" class="form-control" type="text" name="reason[<?= $language['code'] ?>]" placeholder="<?= labels('enter_the_reason_here', "Enter the reason here") ?>">
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="row">
                            <div class="col-md-12 form-group">
                                <label class=" mt-2" class="required">
                                    <input type="checkbox" id="needs_additional_info" name="needs_additional_info" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?= labels('needs_additional_info', 'Needs Additional Info') ?></span>
                                </label>
                            </div>


                        </div>
                        <div class="row">
                            <div class="col-md d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary submit_btn"><?= labels('add', "Add") ?></button>
                            </div>
                        </div>
                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
            <div class="col-md-7">
                <div class="container-fluid card">
                    <div class="row ">
                        <div class="col mb-12" style="border-bottom: solid 1px #e5e6e9;">
                            <div class="toggleButttonPostition"><?= labels('reasons', "Reasons") ?></div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="row mt-4 mb-3 ">
                                    <div class="col-md-4 col-sm-2 mb-2">
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="customSearch" placeholder="<?= labels('search_here', 'Search here!') ?>" aria-label="Search" aria-describedby="customSearchBtn">
                                            <div class="input-group-append">
                                                <button class="btn btn-primary" type="button">
                                                    <i class="fa fa-search d-inline"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="dropdown d-inline ml-2">
                                        <button class="btn export_download dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            <?= labels('download', 'Download') ?>
                                        </button>
                                        <div class="dropdown-menu" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 28px, 0px); top: 0px; left: 0px; will-change: transform;">
                                            <a class="dropdown-item" onclick="custome_export('pdf','FAQs list','user_list');"><?= labels('pdf', 'PDF') ?></a>
                                            <a class="dropdown-item" onclick="custome_export('excel','FAQs list','user_list');"><?= labels('excel', 'Excel') ?></a>
                                            <a class="dropdown-item" onclick="custome_export('csv','FAQs list','user_list')"><?= labels('csv', 'CSV') ?></a>
                                        </div>
                                    </div>
                                </div>
                                <table class="table " data-fixed-columns="true" id="user_list" data-detail-formatter="user_formater"
                                    data-auto-refresh="true" data-toggle="table"
                                    data-url="<?= base_url("admin/reason_for_report_and_block_chat/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]"
                                    data-search="false" data-show-columns="false" data-show-columns-search="true" data-show-refresh="false" data-sort-name="id" data-sort-order="DESC"
                                    data-query-params="faqs_query_params" data-pagination-successively-size="2">
                                    <thead>
                                        <tr>
                                            <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                            <th data-field="reason" class="text-center" data-formatter="reasonFormatter"><?= labels('reason', 'Reason') ?></th>
                                            <th data-field="needs_additional_info_badge" class="text-center"><?= labels('needs_additional_info', 'Needs Additional Info') ?></th>
                                            <th data-field="created_at" class="text-center" data-visible="false"><?= labels('created_at', 'Created At') ?></th>
                                            <th data-field="operations" class="text-center" data-events="rejection_reasons_events"><?= labels('operations', 'Operations') ?></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?= labels('edit_reason', 'Edit Reason') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?= form_open('admin/reason_for_report_and_block_chat/edit', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'edit_reason_form', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="d-flex flex-wrap align-items-center gap-4">
                                <?php
                                // Use the same sorted languages for modal
                                $current_modal_language = $default_language;

                                foreach ($sorted_languages as $index => $language) {
                                ?>
                                    <div class="language-modal-option position-relative <?= $language['is_default'] ? 'selected' : '' ?>"
                                        id="language-modal-<?= $language['code'] ?>"
                                        data-language="<?= $language['code'] ?>"
                                        style="cursor: pointer; padding: 0.5rem 0;">
                                        <span class="language-modal-text px-2 <?= $language['is_default'] ? 'text-primary fw-medium' : 'text-muted' ?>"
                                            style="font-size: 0.875rem; transition: color 0.3s ease; white-space: nowrap;">
                                            <?= $language['language'] ?><?= $language['is_default'] ? '(Default)' : '' ?>
                                        </span>
                                        <div class="language-modal-underline"
                                            style="position: absolute; bottom: 0; left: 0; width: <?= $language['is_default'] ? '100%' : '0' ?>; height: 2px; background: #0d6efd; transition: width 0.3s ease; border-radius: 1px;"></div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    foreach ($sorted_languages as $index => $language) {
                    ?>
                        <div class="form-group" id="translationModalDiv-<?= $language['code'] ?>" <?= $language['code'] == $current_modal_language ? 'style="display: block;"' : 'style="display: none;"' ?>>
                            <label for="edit_reason<?= $language['code'] ?>" class="<?= $language['code'] == $current_modal_language ? 'required' : '' ?>"><?= labels('reason', "Reason") . ($language['is_default'] ? '' : ' (' . $language['code'] . ')') ?></label>
                            <input id="edit_reason<?= $language['code'] ?>" class="form-control" type="reason" name="reason[<?= $language['code'] ?>]" placeholder="Enter the reason here">
                        </div>
                    <?php } ?>
                    <div class="form-group">
                        <div class="col-md-12 ">
                            <label class=" mt-2" class="required">
                                <input type="checkbox" id="edit_needs_additional_info" name="needs_additional_info" class="custom-switch-input">
                                <span class="custom-switch-indicator"></span>
                                <span class="custom-switch-description"><?= labels('needs_additional_info', 'Needs Additional Info') ?></span>
                            </label>
                        </div>
                    </div>




                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" name="submit"><?= labels('save_changes', "Save changes") ?></button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', "Close") ?></button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $("#customSearch").on('keydown', function() {
        $('#user_list').bootstrapTable('refresh');
    });
</script>

<script>
    // select default language
    $(document).ready(function() {
        let default_language = '<?= $current_language ?>';
        let current_modal_language = '<?= $current_modal_language ?>';

        // Formatter function to display translated reason when available
        window.reasonFormatter = function(value, row, index) {
            // If translated_reason is available, use it; otherwise use the reason field
            if (row.translated_reason && row.translated_reason.trim() !== '') {
                return row.translated_reason;
            }
            return row.reason || 'No translation available';
        };

        // Handle main form language tab switching
        $(document).on('click', '.language-option', function() {
            const language = $(this).data('language');

            // Update underline styling
            $('.language-underline').css('width', '0%');
            $('#language-' + language).find('.language-underline').css('width', '100%');

            // Update text styling
            $('.language-text').removeClass('text-primary fw-medium');
            $('.language-text').addClass('text-muted');
            $('#language-' + language).find('.language-text').removeClass('text-muted');
            $('#language-' + language).find('.language-text').addClass('text-primary fw-medium');

            // Show/hide translation divs and manage required class
            if (language != default_language) {
                // Hide current language div and remove required class
                $('#translationDiv-' + default_language).hide();
                $('#translationDiv-' + default_language + ' label').removeClass('required');

                // Show new language div and add required class
                $('#translationDiv-' + language).show();
                $('#translationDiv-' + language + ' label').addClass('required');
            }

            default_language = language;
        });

        // Handle modal language tab switching
        $(document).on('click', '.language-modal-option', function() {
            const language = $(this).data('language');

            $('.language-modal-underline').css('width', '0%');
            $('#language-modal-' + language).find('.language-modal-underline').css('width', '100%');

            $('.language-modal-text').removeClass('text-primary fw-medium');
            $('.language-modal-text').addClass('text-muted');
            $('#language-modal-' + language).find('.language-modal-text').removeClass('text-muted');
            $('#language-modal-' + language).find('.language-modal-text').addClass('text-primary');

            if (language != current_modal_language) {
                // Hide current language div and remove required class
                $('#translationModalDiv-' + current_modal_language).hide();
                $('#translationModalDiv-' + current_modal_language + ' label').removeClass('required');

                // Show new language div and add required class
                $('#translationModalDiv-' + language).show();
                $('#translationModalDiv-' + language + ' label').addClass('required');
            }

            current_modal_language = language;
        });

        // Handle edit reason functionality
        window.reason_id = function(element) {
            const id = $(element).data('id');

            // Fetch reason data with translations
            $.ajax({
                url: '<?= base_url("admin/reason_for_report_and_block_chat/get_reason_data") ?>',
                type: 'POST',
                data: {
                    id: id,
                    '<?= csrf_token() ?>': '<?= csrf_hash() ?>'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.error) {
                        alert(response.message);
                        return;
                    }

                    const data = response.data;

                    // Set the reason ID
                    $('#id').val(data.id);

                    // Set the needs_additional_info checkbox
                    $('#edit_needs_additional_info').prop('checked', data.needs_additional_info == 1);

                    // Set translations for each language
                    if (data.translations) {
                        Object.keys(data.translations).forEach(function(languageCode) {
                            const reasonText = data.translations[languageCode];
                            $(`#edit_reason${languageCode}`).val(reasonText);
                        });
                    }
                },
                error: function() {
                    alert('Failed to fetch reason data');
                }
            });
        };
    });
</script>