<!-- Main Content -->
<?php

$db      = \Config\Database::connect();
$builder = $db->table('users u');
$builder->select('u.*,ug.group_id')
    ->join('users_groups ug', 'ug.user_id = u.id')
    ->where('ug.group_id', 1)
    ->where(['phone' => $_SESSION['identity']]);
$user1 = $builder->get()->getResultArray();
$permissions = get_permission($user1[0]['id']);
?>
<div class="main-content">
    <section class="section">
        <div class="section-header mt-2">
            <h1><?= labels('seo_settings', "SEO Settings") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item "><a href="<?= base_url('/admin/settings/system-settings') ?>"><?= labels('system_settings', "System Settings") ?></a></div>

                <div class="breadcrumb-item"><?= labels('seo_settings', "SEO Settings") ?></a></div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class=" card">
                    <?= helper('form'); ?>
                    <div class="row border_bottom_for_cards m-0">
                        <div class="col">
                            <div class="toggleButttonPostition"><?= labels('seo_settings', "SEO Settings") ?></div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= form_open('/admin/settings/add-seo-settings', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'add', 'enctype' => "multipart/form-data"]); ?>

                        <div class="form-group">
                            <label for="page" class="required"><?= labels('page', "Page") ?></label>
                            <select name="page" id="page" class="form-control" required>
                                <option value=""><?= labels('select_page', "Select Page") ?></option>
                                <option value="home"><?= labels('home', "Home") ?></option>
                                <option value="become-provider"><?= labels('become_provider', "Become Provider") ?></option>
                                <option value="landing-page"><?= labels('landing_page', "Landing Page") ?></option>
                                <option value="about-us"><?= labels('about_us', "About Us") ?></option>
                                <option value="contact-us"><?= labels('contact_us', "Contact Us") ?></option>
                                <option value="providers-page"><?= labels('providers_page', "Providers Page") ?></option>
                                <option value="services-page"><?= labels('services_page', "Services Page") ?></option>
                                <option value="terms-and-conditions"><?= labels('terms_and_conditions', "Terms and Conditions") ?></option>
                                <option value="privacy-policy"><?= labels('privacy_policy', "Privacy Policy") ?></option>
                                <option value="faqs"><?= labels('faqs', "FAQs") ?></option>
                                <option value="blogs"><?= labels('blogs', "Blogs") ?></option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="title" class="required"><?= labels('title', "Title") ?></label>
                            <i data-content="<?= labels('data_content_meta_title', 'Meta title should not exceed 60 characters for optimal SEO performance.') ?>" class="fa fa-question-circle" data-original-title="" title=""></i>
                            <input id="title" class="form-control" type="text" name="title" placeholder="<?= labels('enter_title_here', 'Enter the title here') ?>" maxlength="255" required>
                            <small class="form-text text-muted"><?= labels('max_255_characters', 'Maximum 255 characters') ?></small>
                        </div>
                        <div class="form-group">
                            <label for="description" class="required"><?= labels('description', 'Description') ?></label>
                            <i data-content="<?= labels('data_content_meta_description', 'Meta description should be between 150-160 characters for optimal SEO ranking.') ?>" class="fa fa-question-circle" data-original-title="" title=""></i>
                            <textarea id="description" style="min-height:60px" class="form-control" required type="text" name="description" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('description', 'Description') ?> <?= labels('here', ' Here ') ?>" maxlength="500"></textarea>
                            <small class="form-text text-muted"><?= labels('max_500_characters', 'Maximum 500 characters') ?></small>
                        </div>
                        <div class="form-group">
                            <label for="schema_markup" class="required"><?= labels('schema_markup', 'Schema Markup') ?></label>
                            <i data-content='<?= labels("data_content_schema_markup", "Schema markup helps search engines understand your content. Generate markup using this") . " <a href=\"https://www.rankranger.com/schema-markup-generator\" target=\"_blank\">" . labels("tool", "tool") . "</a>" ?>'
                                data-toggle="popover"
                                class="fa fa-question-circle"
                                data-original-title=""
                                title=""></i>
                            <textarea id="schema_markup" style="min-height:60px" class="form-control" required type="text" name="schema_markup" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('schema_markup', 'Schema Markup') ?> <?= labels('here', ' Here ') ?>"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="keywords" class="required"><?= labels('keywords', 'Keywords') ?></label>
                            <i data-content="<?= labels('data_content_meta_keywords', 'For optimal SEO performance, it is recommended to use up to 10 well-targeted keywords.') ?>" class="fa fa-question-circle" data-original-title="" title=""></i>
                            <input id="keywords" style="border-radius: 0.25rem" class="w-100" type="text" name="keywords[]" placeholder="<?= labels('press_enter_to_add_keyword', 'Press enter to add keyword') ?>">
                        </div>
                        <div class="form-group">
                            <label for="image" class="required"><?= labels('image', 'Image') ?> </label>
                            <i data-content="<?= labels('data_content_meta_image', 'Upload a high-quality image (1200x630px recommended) for social media sharing.') ?>" class="fa fa-question-circle" data-original-title="" title=""></i><br>
                            <input type="file" class="filepond" name="image" id="image" accept="image/*" required>
                            <small class="form-text text-muted"><?= labels('upload_image_formats', 'Supported formats: JPEG, JPG, PNG, GIF') ?></small>
                        </div>
                        <div class=" d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary submit_btn"><?= labels('submit', "Submit") ?></button>
                        </div>

                        <?= form_close(); ?>
                    </div>
                </div>
            </div>
            <?php if ($permissions['read']['seo_settings'] == 1) : ?>

                <div class="col-md-8">
                    <div class=" card">
                        <div class="row">
                            <div class="col-lg">
                                <div class="row border_bottom_for_cards m-0">
                                    <div class="col">
                                        <div class="toggleButttonPostition"><?= labels('seo_settings', "SEO Settings") ?></div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row mt-2">
                                        <div class="col-md-12">
                                            <div class="row pb-3 ">
                                                <div class="col-12">
                                                    <div class="row mb-3 ">
                                                        <div class="col-md-4 col-sm-2 mb-2">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="customSearch" placeholder="<?= labels('search_here', 'Search here!') ?>" aria-label="Search" aria-describedby="customSearchBtn">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-primary" type="button">
                                                                        <i class="fa fa-search d-inline"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <table class="table" data-pagination-successively-size="2" data-query-params="system_tax_query_params" id="user_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/settings/seo-settings-list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="false" data-show-columns="false" data-show-columns-search="true" data-show-refresh="false" data-sort-name="id" data-sort-order="desc">
                                                <thead>
                                                    <tr>
                                                        <th data-field="id" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                                        <th data-field="image" class="text-center" data-sortable="true"><?= labels('image', 'Image') ?></th>
                                                        <th data-field="page" class="text-center" data-sortable="true"><?= labels('page', 'Page') ?></th>
                                                        <th data-field="title" class="text-center" data-sortable="true"><?= labels('title', 'Title') ?></th>
                                                        <th data-field="description" class="text-center" data-sortable="true"><?= labels('description', 'Description') ?></th>
                                                        <th data-field="keywords" class="text-center" data-sortable="true"><?= labels('keywords', 'Keywords') ?></th>
                                                        <th data-field="operations" class="text-center" data-events="action_events"><?= labels('operations', 'Operations') ?></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- update modal -->
    <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="update_modal_thing" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?= labels('edit', 'Edit') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?= form_open('admin/settings/update-seo-settings', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'edit_seo_settings', 'enctype' => "multipart/form-data"]); ?>
                    <input type="hidden" name="id" id="id">
                    <div class="form-group">
                        <label for="page" class="required"><?= labels('page', "Page") ?></label>
                        <select name="page" id="edit_page" class="form-control" disabled>
                            <option value=""><?= labels('select_page', "Select Page") ?></option>
                            <option value="home"><?= labels('home', "Home") ?></option>
                            <option value="become-provider"><?= labels('become_provider', "Become Provider") ?></option>
                            <option value="landing-page"><?= labels('landing_page', "Landing Page") ?></option>
                            <option value="about-us"><?= labels('about_us', "About Us") ?></option>
                            <option value="contact-us"><?= labels('contact_us', "Contact Us") ?></option>
                            <option value="providers-page"><?= labels('providers_page', "Providers Page") ?></option>
                            <option value="services-page"><?= labels('services_page', "Services Page") ?></option>
                            <option value="terms-and-conditions"><?= labels('terms_and_conditions', "Terms and Conditions") ?></option>
                            <option value="privacy-policy"><?= labels('privacy_policy', "Privacy Policy") ?></option>
                            <option value="faqs"><?= labels('faqs', "FAQs") ?></option>
                            <option value="blogs"><?= labels('blogs', "Blogs") ?></option>
                        </select>
                        <input type="hidden" name="page" id="edit_page_hidden" value="">
                    </div>
                    <div class="form-group">
                        <label for="title" class="required"><?= labels('title', "Title") ?></label>
                        <input id="edit_title" class="form-control" type="text" name="title" placeholder="Enter the title here" maxlength="255">
                        <small class="form-text text-muted"><?= labels('max_255_characters', 'Maximum 255 characters') ?></small>
                    </div>
                    <div class="form-group">
                        <label for="description" class="required"><?= labels('description', "Description") ?></label>
                        <textarea id="edit_description" style="min-height:60px" class="form-control" required type="text" name="description" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('description', 'Description') ?> <?= labels('here', ' Here ') ?>" maxlength="500"></textarea>
                        <small class="form-text text-muted"><?= labels('max_500_characters', 'Maximum 500 characters') ?></small>
                    </div>
                    <div class="form-group">
                        <label for="edit_schema_markup" class="required"><?= labels('schema_markup', 'Schema Markup') ?></label>
                        <textarea id="edit_schema_markup" style="min-height:60px" class="form-control" required type="text" name="schema_markup" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('schema_markup', 'Schema Markup') ?> <?= labels('here', ' Here ') ?>"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="edit_keywords" class="required"><?= labels('keywords', "Keywords") ?></label>
                        <input id="edit_keywords" style="border-radius: 0.25rem" class="w-100" type="text" name="keywords[]" placeholder="<?= labels('press_enter_to_add_keyword', 'Press enter to add keyword') ?>">
                    </div>
                    <div class="form-group">
                        <label for="image"><?= labels('image', 'Image') ?></label><br>
                        <input type="file" class="filepond" name="image" id="edit_image" accept="image/*">
                        <small class="form-text text-muted"><?= labels('upload_image_formats_optional', 'Optional: Upload new image to replace current one. Supported formats: JPEG, JPG, PNG, GIF') ?></small>
                        <!-- Current Image Preview -->
                        <div class="current-image-container mt-3" style="border: 1px solid #ddd; border-radius: 4px; padding: 10px; background-color: #f8f9fa; display: none;">
                            <div class="d-flex align-items-center">
                                <img id="current_image_display" src="" alt="Current SEO Image" style="max-width: 100px; max-height: 100px; object-fit: cover; border-radius: 4px;">
                                <div class="ml-3">
                                    <strong><?= labels('current_image', 'Current Image') ?></strong><br>
                                    <small class="text-muted"><?= labels('current_seo_image', 'Upload a new image above to replace it') ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary submit_btn" name="submit"><?= labels('save_changes', 'Save Changes') ?></button>
                    <?php form_close() ?>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', 'Close') ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include the reusable SEO Counters JavaScript -->
<script src="<?= base_url('public/backend/assets/js/seo-settings.js') ?>"></script>

<script>
    $(function() {
        let popoverTimer;
        let currentPopover = null;
        let isOverPopover = false;
        let isOverTrigger = false;

        $('[data-toggle="popover"]').popover({
            html: true,
            trigger: 'manual',
            container: 'body'
        }).on('mouseenter', function() {
            const $this = $(this);
            isOverTrigger = true;
            clearTimeout(popoverTimer);

            // Hide other popovers
            if (currentPopover && currentPopover[0] !== $this[0]) {
                currentPopover.popover('hide');
            }

            currentPopover = $this;
            $this.popover('show');

        }).on('mouseleave', function() {
            isOverTrigger = false;
            startHideTimer();
        });

        // Handle popover content hover
        $(document).on('mouseenter', '.popover', function() {
            isOverPopover = true;
            clearTimeout(popoverTimer);
        }).on('mouseleave', '.popover', function() {
            isOverPopover = false;
            startHideTimer();
        });

        function startHideTimer() {
            clearTimeout(popoverTimer);
            popoverTimer = setTimeout(function() {
                if (!isOverTrigger && !isOverPopover && currentPopover) {
                    currentPopover.popover('hide');
                    currentPopover = null;
                }
            }, 150);
        }
    });
    /** TAGIFY MANAGEMENT FOR KEYWORDS */

    // Initialize Tagify for keywords fields
    function initializeTagify() {
        // Check if Tagify is available
        if (typeof Tagify === 'undefined') {
            console.error('Tagify library is not loaded!');
            return;
        }

        // Initialize Tagify for main keywords field
        const keywordsInput = document.querySelector('input[id=keywords]');
        if (keywordsInput && !keywordsInput._tagify) {
            try {
                const tagifyInstance = new Tagify(keywordsInput, {
                    placeholder: 'Press enter to add keyword',
                    delimiters: ",| ", // Allow comma and space as delimiters
                    editTags: false, // Disable editing tags after creation
                    originalInputValueFormat: valuesArr => valuesArr.map(item => item.value),
                    dropdown: {
                        enabled: 0 // Disable dropdown suggestions
                    }
                });

                // Ensure the instance is attached to the element
                keywordsInput._tagify = tagifyInstance;

                // Use Tagify's ready event and also setup events immediately
                tagifyInstance.on('ready', function() {
                    window.SEOCounters.updateKeywordCounter('keywords');
                });

                // Setup event listeners for add/remove
                tagifyInstance.on('add', function(e) {
                    setTimeout(() => window.SEOCounters.updateKeywordCounter('keywords'), 10);
                });

                tagifyInstance.on('remove', function(e) {
                    setTimeout(() => window.SEOCounters.updateKeywordCounter('keywords'), 10);
                });

                // Also create initial counter immediately
                setTimeout(() => {
                    window.SEOCounters.updateKeywordCounter('keywords');
                }, 100);

            } catch (error) {
                console.error('Error initializing Tagify for keywords:', error);
            }
        }

        // Initialize Tagify for edit keywords field
        const editKeywordsInput = document.querySelector('input[id=edit_keywords]');
        if (editKeywordsInput && !editKeywordsInput._tagify) {
            try {
                const editTagifyInstance = new Tagify(editKeywordsInput, {
                    placeholder: 'Press enter to add keyword',
                    delimiters: ",| ", // Allow comma and space as delimiters
                    editTags: false, // Disable editing tags after creation
                    originalInputValueFormat: valuesArr => valuesArr.map(item => item.value),
                    dropdown: {
                        enabled: 0 // Disable dropdown suggestions
                    }
                });

                // Ensure the instance is attached to the element
                editKeywordsInput._tagify = editTagifyInstance;

                // Use Tagify's ready event and also setup events immediately
                editTagifyInstance.on('ready', function() {
                    window.SEOCounters.updateKeywordCounter('edit_keywords');
                });

                // Setup event listeners for add/remove
                editTagifyInstance.on('add', function(e) {
                    setTimeout(() => window.SEOCounters.updateKeywordCounter('edit_keywords'), 10);
                });

                editTagifyInstance.on('remove', function(e) {
                    setTimeout(() => window.SEOCounters.updateKeywordCounter('edit_keywords'), 10);
                });

                // Also create initial counter immediately
                setTimeout(() => {
                    window.SEOCounters.updateKeywordCounter('edit_keywords');
                }, 100);

            } catch (error) {
                console.error('Error initializing Tagify for edit_keywords:', error);
            }
        }
    }

    // SEO Settings Page-specific functionality
    $(document).ready(function() {
        // Initialize counters from external file
        window.SEOCounters.init();

        // Page dropdown management - specific to this page
        const BASE_URL = "<?= base_url() ?>";
        let existingPages = new Set();

        /** DROPDOWN MANAGEMENT */

        // Load existing pages from server
        async function loadExistingPages() {
            try {
                const response = await fetch(`${BASE_URL}/admin/settings/get-existing-seo-pages`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                });

                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }

                const data = await response.json();

                if (!data.error && Array.isArray(data.existing_pages)) {
                    existingPages = new Set(data.existing_pages);
                    updateDropdownOptions();
                    // Check if we should hide the form after loading existing pages
                    checkAndHideFormIfNeeded();
                }
            } catch (error) {
                console.error('Error loading existing pages:', error);
            }
        }

        // Get all available page options from the dropdown
        function getAllAvailablePages() {
            const pageSelect = document.getElementById('page');
            if (!pageSelect) return [];

            const availablePages = [];
            const options = pageSelect.querySelectorAll('option');

            options.forEach(option => {
                // Skip the default empty option
                if (option.value && option.value.trim() !== '') {
                    availablePages.push(option.value);
                }
            });

            return availablePages;
        }

        // Check if all pages have entries and hide form if needed
        function checkAndHideFormIfNeeded() {
            const availablePages = getAllAvailablePages();
            const allPagesHaveEntries = availablePages.length > 0 &&
                availablePages.every(page => existingPages.has(page));

            const formColumn = document.querySelector('.col-md-4');
            const tableColumn = document.querySelector('.col-md-8, .col-md-12'); // pick whichever exists

            if (!formColumn || !tableColumn) return; // fail-safe

            if (allPagesHaveEntries) {
                // Hide form column
                formColumn.classList.add('d-none');

                // Reset + set table to full width
                tableColumn.classList.remove('col-md-8', 'col-md-12');
                tableColumn.classList.add('col-md-12');
            } else {
                // Show form column
                formColumn.classList.remove('d-none');

                // Reset + set table back to 8-cols
                tableColumn.classList.remove('col-md-8', 'col-md-12');
                tableColumn.classList.add('col-md-8');
            }
        }


        // Update dropdown options based on existing pages
        function updateDropdownOptions() {
            const pageSelect = document.getElementById('page');
            if (!pageSelect) return;

            const options = pageSelect.querySelectorAll('option');
            options.forEach(option => {
                if (option.value && existingPages.has(option.value)) {
                    option.style.display = 'none';
                } else {
                    option.style.display = '';
                }
            });

            // Reset to default option (empty value)
            pageSelect.value = '';
            pageSelect.selectedIndex = 0;
        }

        /** CRUD OPERATIONS */

        // Edit SEO settings - using standard project pattern
        window.edit_seo_setting = function(id) {
            $.get(BASE_URL + "/admin/settings/get-seo-settings?id=" + id, function(data) {
                if (!data.error) {
                    // console.log(data.data);
                    // Populate the edit modal with data
                    $('#id').val(data.data.id);
                    $('#edit_page').val(data.data.page);
                    $('#edit_page_hidden').val(data.data.page);
                    $('#edit_title').val(data.data.title);
                    $('#edit_description').val(data.data.description);
                    $('#edit_schema_markup').val(data.data.schema_markup);

                    // Handle keywords field with Tagify
                    const editKeywordsInput = document.getElementById('edit_keywords');
                    if (editKeywordsInput && editKeywordsInput._tagify) {
                        // Clear existing tags and add new ones
                        editKeywordsInput._tagify.removeAllTags();
                        if (data.data.keywords && data.data.keywords.trim() !== '') {
                            // Convert comma-separated keywords to array and add them
                            const keywords = data.data.keywords.split(',').map(keyword => keyword.trim()).filter(keyword => keyword !== '');
                            editKeywordsInput._tagify.addTags(keywords);
                        }
                    } else {
                        // Fallback for non-Tagify field
                        editKeywordsInput.value = data.data.keywords;
                    }

                    // Update counters for edit form
                    window.SEOCounters.updateCharacterCounter('edit_title', window.SEOCounters.MAX_LENGTHS.title);
                    window.SEOCounters.updateCharacterCounter('edit_description', window.SEOCounters.MAX_LENGTHS.description);
                    setTimeout(() => {
                        window.SEOCounters.updateKeywordCounter('edit_keywords');
                    }, 100);

                    // Handle current image preview
                    const currentImageDisplay = $('#current_image_display');
                    const currentImageContainer = $('.current-image-container');

                    if (data.data.image_url && data.data.image_url.trim() !== '' && currentImageDisplay.length) {
                        currentImageDisplay.attr('src', data.data.image_url);
                        currentImageContainer.show();
                    } else {
                        currentImageContainer.hide();
                    }

                    // Clear FilePond files in edit form
                    const editImageInput = document.getElementById('edit_image');
                    if (editImageInput && editImageInput._filepond) {
                        editImageInput._filepond.removeFiles();
                    }

                    // Show the edit modal
                    $('#update_modal').modal('show');
                } else {
                    showToastMessage(data.message, 'error');
                }
            }).fail(function() {
                showToastMessage('Failed to load SEO settings data. Please try again.', 'error');
            });
        };

        // Delete SEO settings - using standard project pattern
        window.delete_seo_setting = function(id) {
            Swal.fire({
                title: "<?= labels('are_your_sure', 'Are you sure?') ?>",
                text: "<?= labels('you_wont_be_able_to_revert_this', 'You won\'t be able to revert this!') ?>",
                icon: "error",
                showCancelButton: true,
                confirmButtonText: '<?= labels('yes_proceed', 'Yes, proceed!') ?>',
                cancelButtonText: '<?= labels('cancel', 'Cancel') ?>'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post(
                        BASE_URL + "/admin/settings/delete-seo-settings", {
                            [csrfName]: csrfHash,
                            id: id,
                        },
                        function(data) {
                            csrfName = data.csrfName;
                            csrfHash = data.csrfHash;

                            if (data.error == false) {
                                showToastMessage(data.message, "success");

                                // Refresh the table and reload existing pages
                                setTimeout(() => {
                                    $("#user_list").bootstrapTable("refresh");
                                    loadExistingPages();
                                }, 1000);
                            } else {
                                showToastMessage(data.message, "error");
                            }
                        }
                    );
                }
            });
        };

        /** BOOTSTRAP TABLE ACTION EVENTS */
        window.action_events = {
            'click .edit_seo_setting': function(e, value, row, index) {
                e.preventDefault();
                e.stopPropagation();
                edit_seo_setting(row.id);
            },
            'click .delete_seo_setting': function(e, value, row, index) {
                e.preventDefault();
                e.stopPropagation();
                delete_seo_setting(row.id);
            }
        };

        /** INITIALIZATION */

        // Initialize page dropdown functionality
        loadExistingPages();
        initializeTagify();

        // Function to reset SEO counters after form submission
        function resetSeoCounters() {
            // Use the external reset function for counters
            if (window.SEOCounters && window.SEOCounters.resetCounters) {
                window.SEOCounters.resetCounters();
            }

            // Clear Tagify tags in main form (the form reset doesn't clear Tagify)
            const keywordsInput = document.getElementById('keywords');
            if (keywordsInput && keywordsInput._tagify) {
                keywordsInput._tagify.removeAllTags();
            }
        }

        // Setup form submission listeners to refresh dropdown
        // Listen for successful form submissions using the standard project pattern
        $(document).ajaxSuccess(function(event, xhr, settings) {
            // Check if this is a successful SEO settings form submission
            if (settings.url &&
                (settings.url.includes('add-seo-settings') || settings.url.includes('update-seo-settings')) &&
                settings.type === 'POST' &&
                xhr.responseJSON &&
                xhr.responseJSON.error === false) {

                // Reset SEO counters after successful form submission (only for add, not update)
                if (settings.url.includes('add-seo-settings')) {
                    setTimeout(() => {
                        resetSeoCounters();
                    }, 100);
                }

                // Reload existing pages to update dropdown and form visibility
                setTimeout(() => {
                    loadExistingPages();
                }, 500);
            }
        });

        // Listen for form reset events triggered by the global form handler
        $('#add').on('reset', function() {
            // Reset counters when form is reset
            setTimeout(() => {
                resetSeoCounters();
            }, 50);
        });

        // Refresh dropdown after modal closes (for update operations)
        $('#update_modal').on('hidden.bs.modal', function() {
            setTimeout(() => {
                loadExistingPages();
            }, 500);
        });

        // Reset edit form counters when modal is closed
        $('#update_modal').on('hidden.bs.modal', function() {
            // Clear Tagify tags in edit form
            const editKeywordsInput = document.getElementById('edit_keywords');
            if (editKeywordsInput && editKeywordsInput._tagify) {
                editKeywordsInput._tagify.removeAllTags();
            }

            // Reset edit form counters
            setTimeout(() => {
                window.SEOCounters.updateCharacterCounter('edit_title', window.SEOCounters.MAX_LENGTHS.title);
                window.SEOCounters.updateCharacterCounter('edit_description', window.SEOCounters.MAX_LENGTHS.description);
                window.SEOCounters.updateKeywordCounter('edit_keywords');
            }, 100);
        });

        // Update character counters when edit modal is shown
        $('#update_modal').on('shown.bs.modal', function() {
            // Reinitialize Tagify for edit keywords field if not already initialized
            const editKeywordsInput = document.querySelector('input[id=edit_keywords]');
            if (editKeywordsInput && !editKeywordsInput._tagify) {
                initializeTagify();

                // Add keyword counter events for Tagify
                setTimeout(() => {
                    if (editKeywordsInput._tagify) {
                        editKeywordsInput._tagify.on('add', () => window.SEOCounters.updateKeywordCounter('edit_keywords'));
                        editKeywordsInput._tagify.on('remove', () => window.SEOCounters.updateKeywordCounter('edit_keywords'));
                    }
                }, 100);
            }

            // Update counters for current content
            window.SEOCounters.updateCharacterCounter('edit_title', window.SEOCounters.MAX_LENGTHS.title);
            window.SEOCounters.updateCharacterCounter('edit_description', window.SEOCounters.MAX_LENGTHS.description);
            setTimeout(() => {
                window.SEOCounters.updateKeywordCounter('edit_keywords');
            }, 100);
        });
    });
</script>