<?php

/**
 * API Messages Constants
 * 
 * This file contains constants for API messages used throughout the application
 * Centralized location for managing API messages
 */

define('MOBILE_OR_UID_FAILD_IS_REQUIRED', 'mobile_or_uid_feild_is_required');
define('ENTER_MOBILE_OR_UID', 'enter_mobile_or_uid');
define('USER_NOT_FOUND', 'user_not_found');
define('USER_LOGGED_SUCCESSFULLY', 'user_logged_successfully');
define('FAILED_TO_CREATE_PROFILES_FOLDERS', 'failed_to_create_profiles_folders');
define('USER_REGISTERED_SUCCESSFULLY', 'user_registered_successfully');
define('REGISTRATION_FAILED', 'registration_failed');
define('PLEASE_USE_POST_REQUEST', 'please_use_post_request');
define('INVALID_USER_ID', 'invalid_user_id');
define('PLEASE_ATTACH_A_VALID_IMAGE_FILE', 'please_attach_a_valid_image_file');
define('USER_UPDATED_SUCCESSFULLY', 'user_updated_successfully');
define('PLEASE_INSERT_ANY_ONE_FIELD_TO_UPDATE', 'please_insert_any_one_field_to_update');
define('FCM_ID_UPDATED_SUCCESSFULLY', 'fcm_id_updated_successfully');
define('SETTING_RECIEVED_SUCCESSFULLY', 'setting_recieved_successfully');
define('NO_DATA_FOUND_IN_SETTING', 'no_data_found_in_setting');
define('PAYMENT_FOR_ADDITIONAL_CHARGES', 'payment_for_additional_charges');
define('STATUS_UPDATED', 'status_updated');
define('TRANSACTIONS_RECIEVED_SUCCESSFULLY', 'transactions_recieved_successfully');
define('NO_DATA_FOUND', 'no_data_found');
define('ADDRESS_NOT_EXIST', 'address_not_exist');
define('ADDRESS_UPDATED_SUCCESSFULLY', 'address_updated_successfully');
define('ADDRESS_NOT_UPDATED', 'address_not_updated');
define('ADDRESS_ADDED_SUCCESSFULLY', 'address_added_successfully');
define('ADDRESS_NOT_ADDED', 'address_not_added');
define('ADDRESS_DELETED_SUCCESSFULLY', 'address_deleted_successfully');
define('ADDRESS_NOT_DELETED', 'address_not_deleted');
define('ADDRESSES_FETCHED_SUCCESSFULLY', 'addresses_fetched_successfully');
define('ADDRESS_NOT_FOUND', 'address_not_found');
define('PARTNER_ID_OR_PROVIDER_SLUG_IS_REQUIRED', 'partner_id_or_provider_slug_is_required');
define('PROMO_CODES_FETCHED_SUCCESSFULLY', 'promo_codes_fetched_successfully');
define('CATEGORIES_NOT_FOUND', 'categories_not_found');
define('CATEGORIES_FETCHED_SUCCESSFULLY', 'categories_fetched_successfully');
define('CATEGORY_NOT_FOUND_WITH_GIVEN_SLUG', 'category_not_found_with_given_slug');
define('SUB_CATEGORIES_NOT_FOUND', 'sub_categories_not_found');
define('SUB_CATEGORIES_FETCHED_SUCCESSFULLY', 'sub_categories_fetched_successfully');
define('SLIDERS_NOT_FOUND', 'sliders_not_found');
define('SLIDERS_FETCHED_SUCCESSFULLY', 'sliders_fetched_successfully');
define('FINISH_THE_GENERAL_SETTINGS_IN_PANEL', 'finish_the_general_settings_in_panel');
define('FIRST_SET_MAX_SERVICEABLE_DISTANCE_IN_PANEL', 'first_set_max_serviceable_distance_in_panel');
define('CATEGORY_NOT_FOUND', 'category_not_found');
define('DATA_ARRAY_MISSING_OR_NOT_AN_ARRAY', 'data_array_missing_or_not_an_array');
define('PARTNERS_FETCHED_SUCCESSFULLY', 'partners_fetched_successfully');
define('SERVICES_NOT_FOUND', 'services_not_found');
define('SERVICES_FETCHED_SUCCESSFULLY', 'services_fetched_successfully');
define('SERVICE_NOT_FOUND', 'service_not_found');
define('MAX_QUANTITY_ALLOWED', 'max_quantity_allowed');
define('CART_UPDATED_SUCCESSFULLY', 'cart_updated_successfully');
define('CART_NOT_ADDED', 'cart_not_added');
define('CART_ADDED_SUCCESSFULLY', 'cart_added_successfully');
define('SOME_ITEMS_WERE_NOT_FROM_THE_SPECIFIED_PROVIDER_AND_HAVE_BEEN_REMOVED_FROM_THE_CART', 'some_items_were_not_from_the_specified_provider_and_have_been_removed_from_the_cart');
define('CART_DELETED_SUCCESSFULLY', 'cart_deleted_successfully');
define('SERVICE_REMOVED_FROM_CART', 'service_removed_from_cart');
define('SERVICE_NOT_REMOVED_FROM_CART', 'service_not_removed_from_cart');
define('ORDER_NOT_FOUND', 'order_not_found');
define('CART_FETCHED_SUCCESSFULLY', 'cart_fetched_successfully');
define('THE_FOLLOWING_SERVICES_ARE_NOT_AVAILABLE_AND_HAVE_BEEN_REMOVED_FROM_CART', 'the_following_services_are_not_available_and_have_been_removed_from_cart');
define('THE_FOLLOWING_SERVICES_WERE_REMOVED_FROM_CART_AS_THEY_ARE_NO_LONGER_AVAILABLE', 'the_following_services_were_removed_from_cart_as_they_are_no_longer_available');
define('PLEASE_ADD_SOME_SERVICE_IN_CART', 'please_add_some_service_in_cart');
define('ORDER_PLACED_SUCCESSFULLY', 'order_placed_successfully');
define('ORDER_NOT_PLACED', 'order_not_placed');
define('CUSTOM_BOOKING_FETCHED_SUCCESSFULLY', 'custom_booking_fetched_successfully');
define('ORDER_FETCHED_SUCCESSFULLY', 'order_fetched_successfully');
define('NOTIFICATION_NOT_FOUND', 'notification_not_found');
define('NOTIFICATION_DELETED_SUCCESSFULLY', 'notification_deleted_successfully');
define('NOTIFICATION_UPDATED_SUCCESSFULLY', 'notification_updated_successfully');
define('COULD_NOT_ADD_TO_THE_BOOK_MARKS', 'could_not_add_to_the_book_marks');
define('ADDED_TO_BOOK_MARKS', 'added_to_book_marks');
define('THIS_PARTNER_IS_ALREADY_BOOKMARKED', 'this_partner_is_already_bookmarked');
define('COULD_NOT_REMOVE_FROM_BOOK_MARKS', 'could_not_remove_from_book_marks');
define('REMOVED_FROM_BOOK_MARKS', 'removed_from_book_marks');
define('NO_PARTNER_SELECTED', 'no_partner_selected');
define('BOOKMARKS_RETRIEVED_SUCCESSFULLY', 'bookmarks_retrieved_successfully');
define('NO_BOOKMARKS_FOUND', 'no_bookmarks_found');
define('DATA_RETRIEVED_SUCCESSFULLY', 'data_retrieved_successfully');
define('ORDER_IS_IN_AWAITING', 'order_is_in_awaiting');
define('ORDER_IS_CONFIRMED', 'order_is_confirmed');
define('ORDER_COMPLETED_SUCCESSFULLY', 'order_completed_successfully');
define('ORDER_SCHEDULED_FOR_THE_MULTIPLE_DAYS', 'order_scheduled_for_the_multiple_days');
define('PROVIDER_IS_CLOSED', 'provider_is_closed');
define('YOU_CAN_NOT_CHOOSE_DATE_BEYOND_AVAILABLE_BOOKING_DAYS_WHICH_IS', 'you_can_not_choose_date_beyond_available_booking_days_which_is');
define('DAYS', 'days');
define('ADVANCED_BOOKING_FOR_THIS_PARTNER_IS_NOT_AVAILABLE', 'advanced_booking_for_this_partner_is_not_available');
define('NO_PARTNER_FOUND', 'no_partner_found');
define('FOUND_TIME_SLOTS', 'found_time_slots');
define('NO_SLOT_IS_AVAILABLE_ON_THIS_DATE', 'no_slot_is_available_on_this_date');
define('PROVIDER_NOT_FOUND', 'provider_not_found');
define('SERVICE_NOT_FOUND_FOR_THIS_PROVIDER', 'service_not_found_for_this_provider');
define('INVALID_IMAGE', 'invalid_image');
define('FAILED_TO_CREATE_RATINGS_FOLDERS', 'failed_to_create_ratings_folders');
define('COULD_NOT_SAVE_RATINGS', 'could_not_save_ratings');
define('RATING_SAVED', 'rating_saved');
define('RATING_COULD_NOT_BE_UPDATED', 'rating_could_not_be_updated');
define('RATING_UPDATED_SUCCESSFULLY', 'rating_updated_successfully');
define('CAN_NOT_RATE_MORE_THAN_5', 'can_not_rate_more_than_5');
define('RANKING_UPDATED_UNSUCCESSFUL', 'ranking_updated_unsuccessful');
define('RANKING_UPDATED_SUCCESSFULLY', 'ranking_updated_successfully');
define('THERE_IS_NO_DATA', 'there_is_no_data');
define('RAZORPAY_ORDER_CREATED', 'razorpay_order_created');
define('RAZORPAY_ORDER_NOT_CREATED', 'razorpay_order_not_created');
define('DETAILS_NOT_FOUND', 'details_not_found');
define('SERVICE_STATUS_UPDATED_SUCCESSFULLY', 'service_status_updated_successfully');
define('SERVICE_STATUS_CANT_BE_CHANGED', 'service_status_cant_be_changed');
define('PLEASE_ENTER_VALID_STATUS', 'please_enter_valid_status');
define('FAQS_NOT_FOUND', 'faqs_not_found');
define('FAQS_FETCHED_SUCCESSFULLY', 'faqs_fetched_successfully');
define('OTP_SEND_SUCCESSFULLY', 'otp_send_successfully');
define('USER_DOES_NOT_EXIST_PLEASE_ENTER_VALID_USER_ID', 'user_does_not_exist_please_enter_valid_user_id');
define('USER_ACCOUNT_DELETED_SUCCESSFULLY', 'user_account_deleted_successfully');
define('USER_ACCOUNT_DOES_NOT_DELETE', 'user_account_does_not_delete');
define('THIS_USER_S_ACCOUNT_CAN_T_DELETE', 'this_user_s_account_can_t_delete');
define('PROVIDER_IS_AVAILABLE', 'provider_is_available');
define('PROVIDER_IS_NOT_AVAILABLE', 'provider_is_not_available');
define('PROVIDERS_ARE_AVAILABLE', 'providers_are_available');
define('PROVIDERS_ARE_NOT_AVAILABLE', 'providers_are_not_available');
define('ORDER_DETAIL_FOUNDED', 'order_detail_founded');
define('PAYMENT_COMPLETED_SUCCESSFULLY', 'payment_completed_successfully');
define('YOUR_PAYMENT_IS_HAS_BEEN_AUTHORIZED_SUCCESSFULLY_WE_WILL_CAPTURE_YOUR_TRANSACTION_WITHIN_30_MINUTES_ONCE_WE_PROCESS_YOUR_ORDER_AFTER_SUCCESSFUL_CAPTURE_COINS_WILL_BE_CREDITED_AUTOMATICALLY', 'your_payment_is_has_been_authorized_successfully_we_will_capture_your_transaction_within_30_minutes_once_we_process_your_order_after_successful_capture_coins_will_be_credited_automatically');
define('YOUR_PAYMENT_IS_PENDING_AND_IS_UNDER_PROCESS_WE_WILL_NOTIFY_YOU_ONCE_THE_STATUS_IS_UPDATED', 'your_payment_is_pending_and_is_under_process_we_will_notify_you_once_the_status_is_updated');
define('PAYMENT_CANCELLED_DECLINED', 'payment_cancelled_declined');
define('VERIFIED', 'verified');
define('QUERY_SEND_SUCCESSFULLY', 'query_send_successfully');
define('CHAT_RETRIEVED_SUCCESSFULLY', 'chat_retrieved_successfully');
define('USER_FETCHED_SUCCESSFULLY', 'user_fetched_successfully');
define('OTP_VERIFIED', 'otp_verified');
define('OTP_NOT_VERIFIED', 'otp_not_verified');
define('FAILED_TO_INITIALIZE_TRANSACTION', 'failed_to_initialize_transaction');
define('PAYMENT_LINK_GENERATED_FOLLOW_THE_LINK_TO_MAKE_THE_PAYMENT', 'payment_link_generated_follow_the_link_to_make_the_payment');
define('COULD_NOT_INITIATE_PAYMENT', 'could_not_initiate_payment');
define('COULD_NOT_INITIATE_PAYMENT_TRY_AGAIN_LATER', 'could_not_initiate_payment_try_again_later');
define('AN_ERROR_OCCURRED_PLEASE_TRY_AGAIN_LATER', 'an_error_occurred_please_try_again_later');
define('PAYMENT_HAS_BEEN_COMPLETED_SUCCESSFULLY', 'payment_has_been_completed_successfully');
define('PAYMENT_IS', 'payment_is');
define('TRANSACTION_NOT_FOUND', 'transaction_not_found');
define('INVALID_REQUEST', 'invalid_request');
define('SETTINGS_RECEIVED_SUCCESSFULLY', 'settings_received_successfully');
define('PLEASE_SELECT_AN_UPCOMING_START_DATE', 'please_select_an_upcoming_start_date');
define('PLEASE_SELECT_AN_UPCOMING_END_DATE', 'please_select_an_upcoming_end_date');
define('REQUEST_SUCCESSFUL', 'request_successful');
define('REQUEST_FAILED', 'request_failed');
define('MY_CUSTOM_JOBS_NOT_FOUND', 'my_custom_jobs_not_found');
define('MY_CUSTOM_JOBS_FETCHED_SUCCESSFULLY', 'my_custom_jobs_fetched_successfully');
define('BIDDERS_FETCHED_SUCCESSFULLY', 'bidders_fetched_successfully');
define('NO_BIDDERS_FOUND', 'no_bidders_found');
define('YOU_CAN_NOT_CANCEL_SERVICE', 'you_can_not_cancel_service');
define('CUSTOM_JOB_REQUEST_CANCELLED_SUCCESSFULLY', 'custom_job_request_cancelled_successfully');
define('PLACES_API_KEY_NOT_SET', 'places_api_key_not_set');
define('NO_SUBCATEGORY_FOUND', 'no_subcategory_found');
define('NO_CATEGORY_FOUND', 'no_category_found');
define('CATEGORY_RECEIVED_SUCCESSFULLY', 'category_received_successfully');
define('CATEGORIES_RETRIEVED_SUCCESSFULLY', 'categories_retrieved_successfully');
define('COUNTRY_CODES_LIST', 'country_codes_list');
define('NOTIFICATIONS_FETCHED_SUCCESSFULLY', 'notifications_fetched_successfully');
define('COUNTRY_CODES_FETCHED_SUCCESSFULLY', 'country_codes_fetched_successfully');
define('LOGOUT_SUCCESSFULLY', 'logout_successfully');
define('INVALID_REASON_SELECTED', 'invalid_reason_selected');
define('YOU_HAVE_ALREADY_REPORTED_THIS_USER', 'you_have_already_reported_this_user');
define('PROVIDER_BLOCKED_SUCCESSFULLY', 'provider_blocked_successfully');
define('USER_UNBLOCKED_SUCCESSFULLY', 'user_unblocked_successfully');
define('USER_BLOCKED_MESSAGE', 'user_blocked_message');
define('CHAT_DELETED_SUCCESSFULLY', 'chat_deleted_successfully');
define('REPORT_REASONS_FETCHED_SUCCESSFULLY', 'report_reasons_fetched_successfully');
define('PARENT_CATEGORY_FETCHED_SUCCESSFULLY', 'parent_category_fetched_successfully');
define('BLOCKED_USERS_FETCHED_SUCCESSFULLY', 'blocked_users_fetched_successfully');
define('INVALID_PAGE', 'invalid_page');
define('SEO_SETTINGS_FETCHED_SUCCESSFULLY', 'seo_settings_fetched_successfully');
define('ERROR_CREATING_PAYMENT_PLEASE_TRY_AGAIN', 'error_creating_payment_please_try_again');
define('PAYMENT_SYSTEM_ERROR_PLEASE_TRY_AGAIN', 'payment_system_error_please_try_again');
define('PAYMENT_FAILED_OR_CANCELLED', 'payment_failed_or_cancelled');
define('FAILED', 'failed');
define('NO_BLOGS_FOUND', 'no_blogs_found');
define('BLOGS_FETCHED_SUCCESSFULLY', 'blogs_fetched_successfully');
define('EITHER_ID_OR_SLUG_IS_REQUIRED', 'either_id_or_slug_is_required');
define('BLOG_NOT_FOUND', 'blog_not_found');
define('BLOG_FETCHED_SUCCESSFULLY', 'blog_fetched_successfully');
define('BLOG_CATEGORIES_FETCHED_SUCCESSFULLY', 'blog_categories_fetched_successfully');
define('BLOG_TAGS_FETCHED_SUCCESSFULLY', 'blog_tags_fetched_successfully');
define('LATITUDE_MUST_BE_A_NUMBER', 'latitude_must_be_a_number');
define('LATITUDE_MUST_BE_GREATER_THAN_OR_EQUAL_TO', 'latitude_must_be_greater_than_or_equal_to');
define('LATITUDE_MUST_BE_LESS_THAN_OR_EQUAL_TO', 'latitude_must_be_less_than_or_equal_to');
define('LONGITUDE_MUST_BE_A_NUMBER', 'longitude_must_be_a_number');
define('LONGITUDE_MUST_BE_GREATER_THAN_OR_EQUAL_TO', 'longitude_must_be_greater_than_or_equal_to');
define('LONGITUDE_MUST_BE_LESS_THAN_OR_EQUAL_TO', 'longitude_must_be_less_than_or_equal_to');
define('PROVIDERS_FETCHED_SUCCESSFULLY', 'providers_fetched_successfully');
define('PAGE_IS_REQUIRED', 'page_is_required');
define('INVALID_PAGE_NAME', 'invalid_page_name');
define('CATEGORY_OR_SUBCATEGORY_NOT_FOUND', 'category_or_subcategory_not_found');
define('NOT_FOUND', 'not_found');
define('EMAIL', 'email');
define('PASSWORD', 'password');
define('IDENTITY', 'identity');
define('OPS_IT_SEES_LIKE_THIS_NUMBER_ISNT_REGISTERED_PLEASE_REGISTER_TO_USE_OUR_SERVICES', 'oops_it_sees_like_this_number_isnt_registered_please_register_to_use_our_services');
define('USER_DOES_NOT_EXISTS', 'user_does_not_exists');
define('INCORRECT_LOGIN_CREDENTIALS_PLEASE_CHECK_AND_TRY_AGAIN', 'incorrect_login_credentials_please_check_and_try_again');
define('ORDERS_FETCHED_SUCCESSFULLY', 'orders_fetched_successfully');
define('NO_SUB_CATEGORIES_FOUND', 'no_sub_categories_found');
define('TAXES_NOT_FOUND', 'taxes_not_found');
define('TAXES_FETCHED_SUCCESSFULLY', 'taxes_fetched_successfully');
define('NO_ORDER_FOUND', 'no_order_found');
define('ORDER_DELETED_SUCCESSFULLY', 'order_deleted_successfully');
define('ORDER_DOES_NOT_EXIST', 'order_does_not_exist');
define('PROMOCODE_NOT_FOUND', 'promocode_not_found');
define('PROMOCODE_FETCHED_SUCCESSFULLY', 'promocode_fetched_successfully');
define('FAILED_TO_CREATE_PROMOCODES_FOLDERS', 'failed_to_create_promocodes_folders');
define('PROMOCODE_UPDATED_SUCCESSFULLY', 'promocode_updated_successfully');
define('PROMOCODE_SAVED_SUCCESSFULLY', 'promocode_saved_successfully');
define('PROMOCODE_DOES_NOT_EXIST', 'promocode_does_not_exist');
define('PROMOCODE_DELETED_SUCCESSFULLY', 'promocode_deleted_successfully');
define('PAYMENT_REQUEST_SENT', 'payment_request_sent');
define('INSUFFICIENT_BALANCE', 'insufficient_balance');
define('PAYMENT_REQUEST_NOT_FOUND', 'payment_request_not_found');
define('PAYMENT_REQUEST_FETCHED_SUCCESSFULLY', 'payment_request_fetched_successfully');
define('PAYMENT_REQUEST_DELETED_SUCCESSFULLY', 'payment_request_deleted_successfully');
define('PAYMENT_REQUEST_DOES_NOT_EXIST', 'payment_request_does_not_exist');
define('TAGS_REQUIRED', 'tags_required');
define('DISCOUNTED_PRICE_CAN_NOT_BE_HIGHER_THAN_THE_PRICE', 'discounted_price_can_not_be_higher_than_the_price');
define('DISCOUNTED_PRICE_CAN_NOT_EQUAL_TO_THE_PRICE', 'discounted_price_can_not_equal_to_the_price');
define('FAILED_TO_SAVE_SEO_SETTINGS', 'failed_to_save_seo_settings');
define('SERVICE_SAVED_SUCCESSFULLY', 'service_saved_successfully');
define('SERVICE_UPDATED_SUCCESSFULLY', 'service_updated_successfully');
define('SERVICE_CAN_NOT_BE_SAVED', 'service_can_not_be_saved');
define('SERVICE_DELETED_SUCCESSFULLY', 'service_deleted_successfully');
define('SERVICE_DOES_NOT_EXIST', 'service_does_not_exist');
define('ORDER_RESCHEDULED_SUCCESSFULLY', 'order_rescheduled_successfully');
define('ORDER_STARTED_SUCCESSFULLY', 'order_started_successfully');
define('ORDER_ENDED_SUCCESSFULLY', 'order_ended_successfully');
define('HELLO_DEAR', 'hello_dear');
define('ORDER_STATUS_UPDATED_TO', 'order_status_updated_to');
define('FOR_YOUR_ORDER_ID', 'for_your_order_id');
define('PLEASE_TAKE_NOTE_OF_IT', 'please_take_note_of_it');
define('THANK_YOU_FOR_SHOPPING_WITH_US', 'thank_you_for_shopping_with_us');
define('YOU_CAN_NOT_CHOOSE_DATE_BEYOND_AVAILABLE_BOOKING_DAYS', 'you_can_not_choose_date_beyond_available_booking_days');
define('NO_SLOT_AVAILABLE_FOR_THIS_DATE', 'no_slot_available_for_this_date');
define('NO_SLOT_AVAILABLE_ON_THIS_DATE', 'no_slot_available_on_this_date');
define('THIS_USERS_ACCOUNT_CAN_T_DELETE', 'this_users_account_can_t_delete');
define('PASSWORD_CHANGED_SUCCESSFULLY', 'password_changed_successfully');
define('OLD_PASSWORD_DID_NOT_MATCHED', 'old_password_did_not_matched');
define('USER_DOES_NOT_EXIST', 'user_does_not_exist');
define('FORGOT_PASSWORD_SUCCESSFULLY', 'forgot_password_successfully');
define('FORGOT_PASSWORD_FAILED', 'forgot_password_failed');
define('CASH_COLLECTION_HISTORY_RECEIVED_SUCCESSFULLY', 'cash_collection_history_recieved_successfully');
define('SETTLEMENT_HISTORY_RECEIVED_SUCCESSFULLY', 'settlement_history_recieved_successfully');
define('SUBSCRIPTIONS_NOT_FOUND', 'subscriptions_not_found');
define('SUBSCRIPTIONS_FETCHED_SUCCESSFULLY', 'subscriptions_fetched_successfully');
define('ALREADY_HAVE_AN_ACTIVE_SUBSCRIPTION', 'already_have_an_active_subscription');
define('CONGRATULATIONS_ON_YOUR_SUBSCRIPTION_NOW_IS_THE_TIME_TO_SHINE_ON_EDEMAND_AND_SEIZE_NEW_BUSINESS_OPPORTUNITIES_WELCOME_ABOARD_AND_BEST_OF_LUCK', 'congratulations_on_your_subscription_now_is_the_time_to_shine_on_edemand_and_seize_new_business_opportunities_welcome_aboard_and_best_of_luck');
define('TRANSACTION_UPDATED_SUCCESSFULLY', 'transaction_updated_successfully');
define('TRANSACTION_ADDED_SUCCESSFULLY', 'transaction_added_successfully');
define('SUBSCRIPTION_HISTORY_RECEIVED_SUCCESSFULLY', 'subscription_history_recieved_successfully');
define('BOOKING_PAYMENT_HISTORY_RECEIVED_SUCCESSFULLY', 'booking_payment_history_recieved_successfully');
define('RETRIVED_SUCCESSFULLY', 'retrived_successfully');
define('NO_BOOKING_FOUND', 'no_booking_found');
define('OPS_IT_SEEMS_LIKE_THIS_NUMBER_ISNT_REGISTERED_PLEASE_REGISTER_TO_USE_OUR_SERVICES', 'oops_it_sees_like_this_number_isnt_registered_please_register_to_use_our_services');
define('YOUR_BID_HAS_BEEN_PLACED_SUCCESSFULLY', 'your_bid_has_been_placed_successfully');
define('CUSTOM_JOB_FETCHED_SUCCESSFULLY', 'custom_job_fetched_successfully');
define('SELECT_AT_LEAST_ONE_CATEGORY', 'select_at_least_one_category');
define('CATEGORY_PREFERENCE_SET_SUCCESSFULLY', 'category_preference_set_successfully');
define('YOUR_SETTING_HAS_BEEN_SUCCESSFULLY', 'your_setting_has_been_successfully');
define('PLACES_API_KEY_IS_NOT_SET', 'places_api_key_is_not_set');
define('NOTIFICATIONS_NOT_FOUND', 'notifications_not_found');
define('CUSTOMER_NOT_FOUND', 'customer_not_found');
define('CUSTOMER_BLOCKED_SUCCESSFULLY', 'customer_blocked_successfully');
define('CHAT_NOT_FOUND', 'chat_not_found');
define('FAILED_TO_CREATE_PAYMENT_INVOICE', 'failed_to_create_payment_invoice');
define('PAYMENT_FAILED_OR_CANCELLED_BY_USER', 'payment_failed_or_cancelled_by_user');
define('FAILED_TO_UPLOAD_SEO_IMAGE', 'failed_to_upload_seo_image');
define('SEO_IMAGE_UPLOAD_FAILED', 'seo_image_upload_failed');
define('THE_PROMO_CODE_IS_VALID', 'the_promo_code_is_valid');
define('THIS_PROMO_CODE_CANNOT_BE_REDEEMED_AS_IT_EXCEEDS_THE_USAGE_LIMIT', 'this_promo_code_cannot_be_redeemed_as_it_exceeds_the_usage_limit');
define('SERVICE_NOT_EXIST_IN_CART', 'service_not_exist_in_cart');
define('THE_PROVIDER_IS_CURRENTLY_UNAVAILABLE_DURING_THE_REQUESTED_TIME_SLOT_KINDLY_PROPOSE_AN_ALTERNATIVE_TIME', 'the_provider_is_currently_unavailable_during_the_requested_time_slot_kindly_propose_an_alternative_time');
define('PROVIDER_IS_CLOSED_AT_THIS_TIME', 'provider_is_closed_at_this_time');
define('SLOT_IS_NOT_AVAILABLE_AT_THIS_TIME', 'slot_is_not_available_at_this_time');
define('SLOT_IS_AVAILABLE_AT_THIS_TIME', 'slot_is_available_at_this_time');
define('PLEASE_SELECT_UPCOMING_DATE', 'please_select_upcoming_date');
define('YOU_CANT_UPDATE_THE_SAME_STATUS_AGAIN', 'you_cant_update_the_same_status_again');
define('YOU_CANT_UPDATE_STATUS_ONCE_ITEM_CANCELLED_OR_COMPLETED', 'you_can_t_update_status_once_item_cancelled_or_completed');
define('ONCE_YOU_BEGIN_THE_BOOKING_PROCESS_YOU_CANNOT_CHANGE_THE_BOOKING_TIME', 'once_you_begin_the_booking_process_you_cannot_change_the_booking_time');
define('INVALID_BOOKING_OR_STATUS_DATA', 'invalid_booking_or_status_data');
define('BOOKING_CANNOT_BE_COMPLETED_WITH_A_PENDING_PAYMENT_OF_ADDITIONAL_CHARGES', 'booking_cannot_be_completed_with_a_pending_payment_of_additional_charges');
define('OTP_IS_REQUIRED', 'otp_is_required');
define('OTP_DOES_NOT_MATCH', 'otp_does_not_match');
define('BOOKING_IS_CANCELLED', 'booking_is_cancelled');
define('BOOKING_IS_NOT_CANCELABLE', 'booking_is_not_cancelable');
define('BOOKING_UPDATED_SUCCESSFULLY', 'booking_updated_successfully');
define('BOOKING_DATA_NOT_FOUND', 'booking_data_not_found');
define('ALL_ADDITIONAL_CHARGE_FIELDS_ARE_REQUIRED', 'all_additional_charge_fields_are_required');
define('CHARGE_AMOUNT_MUST_BE_GREATER_THAN_0', 'charge_amount_must_be_greater_than_0');
define('INVALID_STATUS_PASSED', 'invalid_status_passed');
define('SENT_MESSAGE_SUCCESSFULLY', 'sent_message_successfully');
define('NO_BLOG_CATEGORIES_FOUND', 'no_blog_categories_found');
define('QUANTITY_MUST_BE_GREATER_THAN_0', 'quantity_must_be_greater_than_0');
define('CART_NOT_UPDATED', 'cart_not_updated');
define('THE_PROMO_CODE_HAS_ALREADY_BEEN_REDEEMED_CANNOT_BE_REUSED', 'the_promo_code_has_already_been_redeemed_cannot_be_redeemed');
define('THIS_PROMO_CODE_IS_APPLICABLE_ONLY_FOR_AMOUNT_GREATER_THAN_OR_EQUAL_TO', 'this_promo_code_is_applicable_only_for_amount_greater_than_or_equal_to');
define('PROMOCODE_USAGE_EXCEEDED', 'promocode_usage_exceeded');
define('THE_PROMO_CODE_IS_NOT_AVAILABLE_OR_EXPIRED', 'the_promo_code_is_not_available_or_expired');
define('THERE_ARE_CURRENTLY_NO_AVAILABLE_SLOTS', 'there_are_currently_no_available_slots');
define('A_TIME_SLOT_IS_CURRENTLY_UNAVAILABLE_AT_THE_PRESENT_MOMENT', 'a_time_slot_is_currently_unavailable_at_the_present_moment');
define('THE_BOOKING_HAS_BEEN_SUCCESSFULLY_RESCHEDULED', 'the_booking_has_been_successfully_rescheduled');
define('COMMISSION_SETTLEMENT', 'commission_settlement');
define('ADMIN_PANEL', 'admin_panel');
define('PROVIDERS', 'providers');
define('PERMISSIONS_UPDATED', 'permissions_updated');
define('COULD_NOT_UPDATE_PERMISSION', 'could_not_update_permission');
define('PERMISSIONS_ADDED', 'permissions_added');
define('COULD_NOT_ADD_PERMISSION', 'could_not_add_permission');
define('EMAIL_ALREADY_EXISTS_PLEASE_USE_ANOTHER_ONE', 'email_already_exists_please_use_another_one');
define('PLEASE_SELECT_ROLE', 'please_select_role');
define('PLEASE_SELECT_USER', 'please_select_user');
define('THIS_USER_WAS_ALREADY_SELECTED_FOR_PERMISSIONS', 'this_user_was_already_selected_for_permissions');
define('UNSUCCESSFUL_ATTEMPT_TO_DELETE_THE_USER', 'unsuccessful_attempt_to_delete_the_user');
define('SUCCESS_IN_DELETING_USER', 'success_in_deleting_user');
define('CANNOT_DELETE', 'cannot_delete');
define('SUCCESSFULLY_DEACTIVATED', 'successfully_deactivated');
define('ADDITIONAL_INFORMATION_IS_REQUIRED_FOR_THIS_REASON', 'additional_information_is_required_for_this_reason');
define('REASONS_FETCHED_SUCCESSFULLY', 'reasons_fetched_successfully');
define('UNAUTHORIZED_ACCESS', 'unauthorized_access');
define('USER_REPORTED_AND_BLOCKED_SUCCESSFULLY', 'user_reported_and_blocked_successfully');
define('PLEASE_LOGIN_FIRST', 'please_login_first');
define('BLOCK_STATUS_RETRIEVED_SUCCESSFULLY', 'block_status_retrieved_successfully');
define('SERVICE_TITLE_IN_DEFAULT_LANGUAGE_IS_REQUIRED', 'service_title_in_default_language_is_required');
define('SERVICE_DESCRIPTION_IN_DEFAULT_LANGUAGE_IS_REQUIRED', 'service_description_in_default_language_is_required');
define('SERVICE_LONG_DESCRIPTION_IN_DEFAULT_LANGUAGE_IS_REQUIRED', 'service_long_description_in_default_language_is_required');
define('SERVICE_TAGS_IN_DEFAULT_LANGUAGE_ARE_REQUIRED', 'service_tags_in_default_language_are_required');
define('PLEASE_SELECT_CATEGORY', 'please_select_category');
define('PLEASE_ENTER_PRICE', 'please_enter_price');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_PRICE', 'please_enter_numeric_value_for_price');
define('PLEASE_ENTER_DISCOUNTED_PRICE', 'please_enter_discounted_price');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_DISCOUNTED_PRICE', 'please_enter_numeric_value_for_discounted_price');
define('DISCOUNTED_PRICE_SHOULD_BE_LESS_THAN_PRICE', 'discounted_price_should_be_less_than_price');
define('PLEASE_ENTER_REQUIRED_MEMBER_FOR_SERVICE', 'please_enter_required_member_for_service');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_REQUIRED_MEMBER', 'please_enter_numeric_value_for_required_member');
define('PLEASE_ENTER_DURATION_TO_PERFORM_TASK', 'please_enter_duration_to_perform_task');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_DURATION_OF_TASK', 'please_enter_numeric_value_for_duration_of_task');
define('PLEASE_ENTER_MAX_QUANTITY_ALLOWED_FOR_SERVICES', 'please_enter_max_quantity_allowed_for_services');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_MAX_QUANTITY_ALLOWED_FOR_SERVICES', 'please_enter_numeric_value_for_max_quantity_allowed_for_services');
define('PLEASE_ENTER_SERVICE_SLUG', 'please_enter_service_slug');
define('META_TITLE_IS_OPTIONAL', 'meta_title_is_optional');
define('META_DESCRIPTION_IS_OPTIONAL', 'meta_description_is_optional');
define('META_KEYWORDS_ARE_OPTIONAL', 'meta_keywords_are_optional');
define('META_IMAGE_IS_OPTIONAL', 'meta_image_is_optional');
define('META_IMAGE_MUST_BE_A_VALID_IMAGE', 'meta_image_must_be_a_valid_image');
define('SCHEMA_MARKUP_IS_OPTIONAL', 'schema_markup_is_optional');
define('INVALID_META_IMAGE', 'invalid_meta_image');
define('FAILED_TO_CREATE_SERVICES_FOLDERS', 'failed_to_create_services_folders');
define('FAILED_TO_UPLOAD_FILES', 'failed_to_upload_files');
define('DISCOUNTED_PRICE_CANNOT_BE_HIGHER_THAN_OR_EQUAL_TO_PRICE', 'discounted_price_cannot_be_higher_than_or_equal_to_price');
define('PLEASE_ADD_MINUTES', 'please_add_minutes');
define('SERVICE_CANNOT_BE_SAVED', 'service_cannot_be_saved');
define('PLEASE_SELECT_ANYTHING_OTHER_THAN_SELECT_CATEGORY', 'please_select_anything_other_than_select_category');
define('SERVICE_CANNOT_BE_DELETED', 'service_cannot_be_deleted');
define('FAILED_TO_ADD_SERVICE', 'failed_to_add_service');
define('PROVIDER_ID', 'provider_id');
define('THE_PROVIDER_ID_MUST_MATCH_THE_LOGGED_IN_USER_ID', 'the_provider_id_must_match_the_logged_in_user_id');
define('CATEGORY_ID', 'category_id');
define('TAX_ID', 'tax_id');
define('FAILED_TO_UPDATE_SERVICE', 'failed_to_update_service');
define('SERVICES_UPDATED_SUCCESSFULLY', 'services_updated_successfully');
define('FAILED_TO_OPEN_OUTPUT_STREAM', 'failed_to_open_output_stream');
define('FAILED_TO_UPLOAD_SEO_IMAGE_FOR_SERVICE', 'failed_to_upload_seo_image_for_service');
define('PLEASE_ENTER_COUNTER_PRICE', 'please_enter_counter_price');
define('PLEASE_ENTER_COVER_NOTE', 'please_enter_cover_note');
define('PLEASE_ENTER_DURATION', 'please_enter_duration');
define('PAYMENT_REQUEST_CANNOT_BE_DELETED', 'payment_request_cannot_be_deleted');
define('REQUEST_SENT', 'request_sent');
define('AMOUNT_MUST_BE_LESS_THAN_OR_EQUAL_TO_BALANCE', 'amount_must_be_less_than_or_equal_to_balance');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_AMOUNT', 'please_enter_numeric_value_for_amount');
define('PLEASE_ENTER_AMOUNT', 'please_enter_amount');
define('PLEASE_ENTER_PROMO_CODE_NAME', 'please_enter_promo_code_name');
define('PLEASE_SELECT_START_DATE', 'please_select_start_date');
define('PLEASE_SELECT_END_DATE', 'please_select_end_date');
define('PLEASE_ENTER_NUMBER_OF_USERS', 'please_enter_number_of_users');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_NUMBER_OF_USERS', 'please_enter_numeric_value_for_number_of_users');
define('NUMBER_OF_USERS_MUST_BE_GREATER_THAN_0', 'number_of_users_must_be_greater_than_0');
define('PLEASE_ENTER_MINIMUM_ORDER_AMOUNT', 'please_enter_minimum_order_amount');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_MINIMUM_ORDER_AMOUNT', 'please_enter_numeric_value_for_minimum_order_amount');
define('MINIMUM_ORDER_AMOUNT_MUST_BE_GREATER_THAN_0', 'minimum_order_amount_must_be_greater_than_0');
define('PLEASE_ENTER_DISCOUNT', 'please_enter_discount');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_DISCOUNT', 'please_enter_numeric_value_for_discount');
define('DISCOUNT_MUST_BE_GREATER_THAN_0', 'discount_must_be_greater_than_0');
define('PLEASE_ENTER_MAX_DISCOUNT_AMOUNT', 'please_enter_max_discount_amount');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_MAX_DISCOUNT_AMOUNT', 'please_enter_numeric_value_for_max_discount_amount');
define('DISCOUNT_AMOUNT_MUST_BE_GREATER_THAN_0', 'discount_amount_must_be_greater_than_0');
define('PLEASE_ENTER_NUMBER_OF_REPEAT_USAGE', 'please_enter_number_of_repeat_usage');
define('PLEASE_ENTER_NUMERIC_VALUE_FOR_NUMBER_OF_REPEAT_USAGE', 'please_enter_numeric_value_for_number_of_repeat_usage');
define('NUMBER_OF_REPEAT_USAGE_MUST_BE_GREATER_THAN_0', 'number_of_repeat_usage_must_be_greater_than_0');
define('PLEASE_ENTER_MESSAGE_FOR_DEFAULT_LANGUAGE', 'please_enter_message_for_default_language');
define('PROMOCODE_CANNOT_BE_DELETED', 'promocode_cannot_be_deleted');
define('PLEASE_ENTER_QUESTION_FOR_FAQ_IN_DEFAULT_LANGUAGE', 'please_enter_question_for_faq_in_default_language');
define('PLEASE_ENTER_ANSWER_FOR_FAQ_IN_DEFAULT_LANGUAGE', 'please_enter_answer_for_faq_in_default_language');
define('FAQ_ID_IS_REQUIRED', 'faq_id_is_required');
define('FAQ_NOT_FOUND', 'faq_not_found');
define('PROVIDER_DISAPPROVED', 'provider_disapproved');
define('COULD_NOT_DISAPPROVE_PROVIDER', 'could_not_disapprove_provider');
define('FIRST_ADD_CURRENCY_AND_BASIC_DETAILS_IN_GENERAL_SETTINGS', 'first_add_currency_and_basic_details_in_general_settings');
define('PROVIDER_APPROVED', 'provider_approved');
define('COULD_NOT_APPROVE_PROVIDER', 'could_not_approve_provider');
define('PROVIDER_REMOVED', 'provider_removed');
define('COULD_NOT_DELETE_PROVIDER', 'could_not_delete_provider');
define('DEBITED_AMOUNT', 'debited_amount');
define('DELETED_PAYMENT_REQUEST_SUCCESS', 'deleted_payment_request_success');
define('COULD_NOT_DELETE_PAYMENT_REQUEST', 'could_not_delete_payment_request');
define('PLEASE_ENTER_A_NUMERIC_VALUE_FOR_COMMISSION', 'please_enter_a_numeric_value_for_commission');
define('COMMISSION_SETTLED_SUCCESSFULLY', 'commission_settled_successfully');
define('UNSUCCESSFUL_WHILE_ADDING_TRANSACTION', 'unsuccessful_while_adding_transaction');
define('UNSUCCESSFUL_WHILE_UPDATING_SETTING_STATUS', 'unsuccessful_while_updating_settling_status');
define('RATING_DELETED_SUCCESSFULLY', 'rating_deleted_successfully');
define('UNSUCCESSFUL_IN_DELETION_OF_RATING', 'unsuccessful_in_deletion_of_rating');
define('COMPANY_NAME_IS_REQUIRED_FOR_DEFAULT_LANGUAGE', 'company_name_is_required_for_default_language');
define('ABOUT_PROVIDER_IS_REQUIRED_FOR_DEFAULT_LANGUAGE', 'about_provider_is_required_for_default_language');
define('DESCRIPTION_IS_REQUIRED_FOR_DEFAULT_LANGUAGE', 'description_is_required_for_default_language');
define('BULK_UPDATE_SUCCESSFULLY', 'bulk_update_successfully');
define('PAYMENT_REQUEST_SETTLED_SUCCESSFULLY', 'payment_request_settled_successfully');
define('ASSIGNED_SUBSCRIPTION_SUCCESSFULLY', 'assigned_subscription_successfully');
define('SUBSCRIPTION_CANCELLED_SUCCESSFULLY', 'subscription_cancelled_successfully');
define('PLEASE_FIRST_ADD_CURRENCY_AND_BASIC_DETAILS_IN_GENERAL_SETTINGS', 'please_first_add_currency_and_basic_details_in_general_settings');
define('PROVIDERS_IMPORTED_SUCCESSFULLY', 'providers_imported_successfully');
define('PROVIDERS_UPDATED_SUCCESSFULLY', 'providers_updated_successfully');
define('NUMBER_OF_MEMBERS_IS_REQUIRED', 'number_of_members_is_required');
define('NUMBER_OF_MEMBERS_MUST_BE_A_NUMBER', 'number_of_members_must_be_a_number');
define('VISITING_CHARGES_IS_REQUIRED', 'visiting_charges_is_required');
define('VISITING_CHARGES_MUST_BE_A_NUMBER', 'visiting_charges_must_be_a_number');
define('ADVANCE_BOOKING_DAYS_IS_REQUIRED', 'advance_booking_days_is_required');
define('ADVANCE_BOOKING_DAYS_MUST_BE_A_NUMBER', 'advance_booking_days_must_be_a_number');
define('START_TIME_IS_REQUIRED', 'start_time_is_required');
define('END_TIME_IS_REQUIRED', 'end_time_is_required');
define('PROVIDER_NAME_IS_REQUIRED', 'provider_name_is_required');
define('EMAIL_IS_REQUIRED', 'email_is_required');
define('PHONE_NUMBER_IS_REQUIRED', 'phone_number_is_required');
define('PHONE_NUMBER_MUST_BE_A_NUMBER', 'phone_number_must_be_a_number');
define('PROVIDER_SLUG_IS_REQUIRED', 'provider_slug_is_required');
define('PASSWORD_IS_REQUIRED', 'password_is_required');
define('PROFILE_PICTURE_IS_REQUIRED', 'profile_picture_is_required');
define('BANNER_IMAGE_IS_REQUIRED', 'banner_image_is_required');
define('USER_CREATION_FAILED_PLEASE_TRY_AGAIN', 'user_creation_failed_please_try_again');
define('PARTNER_CREATION_FAILED_PLEASE_TRY_AGAIN', 'partner_creation_failed_please_try_again');
define('NO_SEO_IMAGE_FOUND_TO_REMOVE', 'no_seo_image_found_to_remove');
define('SEO_IMAGE_REMOVED_SUCCESSFULLY', 'seo_image_removed_successfully');
define('UNSUCCESSFUL_WHILE_UPDATING_SETTLING_STATUS', 'unsuccessful_while_updating_settling_status');
define('FAILED_TO_LOAD_SEO_SETTINGS', 'failed_to_load_seo_settings');
define('INVALID_RECORD_ID_PROVIDED', 'invalid_record_id_provided');
define('FAILED_TO_LOAD_DATA', 'failed_to_load_data');
define('PLEASE_UPLOAD_AN_IMAGE_FILE', 'upload_an_image_file');
define('FILE_MUST_BE_A_VALID_IMAGE', 'file_must_be_a_valid_image');
define('ONLY_JPEG_JPG_AND_PNG_FILES_ARE_ALLOWED', 'only_jpeg_jpg_and_png_files_are_allowed');
define('IMAGE_FILE_SIZE_MUST_NOT_EXCEED_5MB', 'image_file_size_must_not_exceed_5mb');
define('FAILED_TO_UPLOAD_IMAGE', 'failed_to_upload_image');
define('THE_APP_IMAGE_FIELD_IS_REQUIRED', 'the_app_image_field_is_required');
define('THE_WEB_IMAGE_FIELD_IS_REQUIRED', 'the_web_image_field_is_required');
define('PLEASE_SELECT_TYPE_OF_SLIDER', 'please_select_type_of_slider');
define('FAILED_TO_CREATE_SLIDERS_FOLDERS', 'failed_to_create_sliders_folders');
define('FAILED_TO_UPLOAD_APP_IMAGE', 'failed_to_upload_app_image');
define('FAILED_TO_UPLOAD_WEB_IMAGE', 'failed_to_upload_web_image');
define('SLIDER_NOT_FOUND', 'slider_not_found');
define('SUCCESSFULLY_DELETED', 'successfully_deleted');
define('DATA_DELETED_SUCCESSFULLY', 'data_deleted_successfully');
define('SECTION_ID_REQUIRED', 'section_id_required');
define('SECTION_NOT_FOUND', 'section_not_found');
define('FAILED_TO_RETRIEVE_SECTION_DATA', 'failed_to_retrieve_section_data');
define('ORDER_UPDATED_SUCCESSFULLY', 'order_updated_successfully');
define('BLOG_ID_REQUIRED', 'blog_id_required');
define('SEO_SETTINGS_NOT_FOUND_FOR_THIS_BLOG', 'seo_settings_not_found_for_this_blog');
define('SEO_SETTINGS_FOR_THIS_SERVICE_ALREADY_EXISTS', 'seo_settings_for_this_service_already_exists');
define('SEO_SETTINGS_FOR_THIS_CATEGORY_ALREADY_EXISTS', 'seo_settings_for_this_category_already_exists');
define('SEO_SETTINGS_FOR_THIS_PROVIDER_ALREADY_EXISTS', 'seo_settings_for_this_provider_already_exists');
define('SEO_SETTINGS_FOR_THIS_BLOG_ALREADY_EXISTS', 'seo_settings_for_this_blog_already_exists');
define('SEO_SETTINGS_FOR_THIS_PAGE_ALREADY_EXISTS', 'seo_settings_for_this_page_already_exists');
define('SEO_SETTINGS_FOR_THE_SELECTED_SERVICE_ALREADY_EXISTS', 'seo_settings_for_the_selected_service_already_exists');
define('SEO_SETTINGS_FOR_THE_SELECTED_CATEGORY_ALREADY_EXISTS', 'seo_settings_for_the_selected_category_already_exists');
define('SEO_SETTINGS_FOR_THE_SELECTED_PROVIDER_ALREADY_EXISTS', 'seo_settings_for_the_selected_provider_already_exists');
define('SEO_SETTINGS_FOR_THE_SELECTED_PAGE_ALREADY_EXISTS', 'seo_settings_for_the_selected_page_already_exists');
define('CANNOT_DELETE_CATEGORY_AS_IT_IS_BEING_USED_BY_BLOG_POSTS', 'cannot_delete_category_as_it_is_being_used_by_blog_posts');
define('A_CATEGORY_WITH_THIS_NAME_ALREADY_EXISTS', 'a_category_with_this_name_already_exists');
define('A_CATEGORY_WITH_THIS_SLUG_ALREADY_EXISTS', 'a_category_with_this_slug_already_exists');
define('YOU_CANT_ALTER_THE_STATUS_THAT_HAS_ALREADY_BEEN_MARKED_AS', 'you_cant_alter_the_status_that_has_already_been_marked_as');
define('FAILED_TO_SAVE_TRANSLATIONS_FOR_SERVICE_ID', 'failed_to_save_translations_for_service_id');
define('TRANSACTION_FAILED', 'transaction_failed');
define('REFUND_IS_ALREADY_PROCESSED', 'refund_is_already_processed');
define('REFUND_ID_IS_REQUIRED', 'refund_id_is_required');
define('USERNAME_IS_REQUIRED_FOR_DEFAULT_LANGUAGE', 'username_is_required_for_default_language');
define('FAILED_TO_DELETE_SEO_SETTINGS', 'failed_to_delete_seo_settings');
define('OLD_PASSWORD_DID_NOT_MATCH', 'old_password_did_not_match');
define('PLEASE_UPLOAD_A_VALID_NATIONAL_ID_DOCUMENT', 'please_upload_a_valid_national_id_document');
define('PLEASE_UPLOAD_A_VALID_ADDRESS_ID_DOCUMENT', 'please_upload_a_valid_address_id_document');
define('PLEASE_UPLOAD_A_VALID_PASSPORT_DOCUMENT', 'please_upload_a_valid_passport_document');
define('NATIONAL_ID_FILE_SIZE_SHOULD_NOT_EXCEED_2MB', 'national_id_file_size_should_not_exceed_2mb');
define('ADDRESS_ID_FILE_SIZE_SHOULD_NOT_EXCEED_2MB', 'address_id_file_size_should_not_exceed_2mb');
define('PASSPORT_FILE_SIZE_SHOULD_NOT_EXCEED_2MB', 'passport_file_size_should_not_exceed_2mb');
define('NATIONAL_ID_MUST_BE_A_VALID_IMAGE_FILE', 'national_id_must_be_a_valid_image_file');
define('ADDRESS_ID_MUST_BE_A_VALID_IMAGE_FILE', 'address_id_must_be_a_valid_image_file');
define('PASSPORT_MUST_BE_A_VALID_IMAGE_FILE', 'passport_must_be_a_valid_image_file');
define('THIS_PHONE_NUMBER_IS_ALREADY_REGISTERED', 'this_phone_number_is_already_registered');
define('PLEASE_ENTER_VALID_TIME_FOR_PROVIDERS_WORKING_DAYS', 'please_enter_valid_time_for_providers_working_days');
define('PLEASE_ENTER_VALID_TIME_FOR_PROVIDERS_WORKING_PROPERLY', 'please_enter_valid_time_for_providers_working_properly');
define('PLEASE_SELECT_PARENT_CATEGORY', 'please_select_parent_category');
define('FAILED_TO_CREATE_CATEGORIES_FOLDERS', 'failed_to_create_categories_folders');
define('PLEASE_ENTER_NAME_FOR_CATEGORY', 'please_enter_name_for_category');
define('PLEASE_ENTER_SLUG_FOR_CATEGORY', 'please_enter_slug_for_category');
define('CATEGORY_ID_IS_REQUIRED', 'category_id_is_required');
define('ADVANCE_BOOKING_DAYS_MUST_BE_AT_LEAST_1', 'advance_booking_days_must_be_at_least_1');
define('NO_PERMISSION_TO_TAKE_THIS_ACTION', 'no_permission_to_take_this_action');
