<?php

namespace App\Controllers;

use App\Controllers\BaseController;

class Language extends BaseController
{
    // public function index($lang)
    // {
    //     $session = session();
    //     $session->remove('lang');
    //     // $session->remove('is_rtl');
    //     $session->set('lang', $lang);
    //     $fetch_lang=fetch_details('languages',['code'=>$lang],['is_rtl']);
    //     $session->set('is_rtl',   $fetch_lang[0]['is_rtl']);
    //     $url = base_url();
    //     return redirect()->to($url);
    // }
    public function index($lang)
    {
        $session = session();
        $session->remove('lang');
        $session->set('lang', $lang);

        // Fetch language details including is_rtl from database
        $fetch_lang = fetch_details('languages', ['code' => $lang], ['is_rtl']);

        // Check if fetch_details returned a valid result
        if (!empty($fetch_lang) && isset($fetch_lang[0]['is_rtl'])) {
            $is_rtl = $fetch_lang[0]['is_rtl'];
            $session->set('is_rtl', $is_rtl);

            // Update user's preferred language in users table if user is an admin or provider
            // This ensures the language preference persists across sessions
            try {
                $ionAuth = new \IonAuth\Libraries\IonAuth();
                if ($ionAuth->loggedIn()) {
                    $user = $ionAuth->user()->row();
                    if (!empty($user)) {
                        // Check if user is an admin (group_id = 1) or provider (group_id = 3)
                        $db = \Config\Database::connect();
                        $builder = $db->table('users_groups');
                        $userGroup = $builder->select('group_id')
                            ->where('user_id', $user->id)
                            ->whereIn('group_id', [1, 3])
                            ->get()
                            ->getRow();

                        // If user is an admin or provider, update their preferred_language in users table
                        if (!empty($userGroup)) {
                            update_details(['preferred_language' => $lang], ['id' => $user->id], 'users');
                            // log_message('debug', 'PREFERRED LANGUAGE (LANGUAGE CONTROLLER) UPDATE TO ' . $lang);
                        }
                    }
                }
            } catch (\Exception $e) {
                // Log error but don't break language change process
                log_message('error', 'Failed to update user language preference: ' . $e->getMessage());
            }

            // Prepare the response data
            $response = [
                'is_rtl' => $is_rtl,
                'language' => $lang
            ];
            return $this->response->setJSON($response);
        } else {
            // Handle case where fetch_details did not return expected data
            // For example, redirect back with an error message or default value
            return redirect()->back()->with('error', 'Failed to fetch language details.');
        }
    }
    public function updateIsRtl()
    {


        $session = \Config\Services::session();
        $request = \Config\Services::request();
        $lang = $request->getPost('language');
        $is_rtl = $request->getPost('is_rtl');

        if ($is_rtl !== null && $lang != null) {
            $session->set('is_rtl', $is_rtl);
            $session->remove('lang');
            $session->set('lang', $lang);
            $language = \Config\Services::language();
            $language->setLocale($lang);
            echo 'Session updated';
        } else {
            echo 'No value received';
        }
    }
}
