INSERT INTO `email_templates` (`id`, `type`, `subject`, `to`, `template`, `bcc`, `cc`, `parameters`) VALUES (104, 'provider_edits_service_details', 'Provider [[provider_name]] Has Edited Service Details', '', '<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Service Details Edited</title>\n</head>\n<body style=\"font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;\">\n    <div style=\"background-color: #f8f9fa; padding: 20px; border-radius: 5px; margin-bottom: 20px;\">\n        <h2 style=\"color: #2c3e50; margin-top: 0;\">Service Details Edited</h2>\n        <p>Hello Admin,</p>\n        <p>The provider <strong>[[provider_name]]</strong> has edited the details of their service.</p>\n    </div>\n    \n    <div style=\"background-color: #ffffff; border: 1px solid #dee2e6; padding: 20px; border-radius: 5px; margin-bottom: 20px;\">\n        <h3 style=\"color: #495057; margin-top: 0;\">Service Information</h3>\n        <table style=\"width: 100%; border-collapse: collapse;\">\n            <tr>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6; font-weight: bold; width: 40%;\">Service ID:</td>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6;\">[[service_id]]</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6; font-weight: bold;\">Service Title:</td>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6;\">[[service_title]]</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6; font-weight: bold;\">Category:</td>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6;\">[[category_name]]</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6; font-weight: bold;\">Price:</td>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6;\">[[currency]] [[service_price]]</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6; font-weight: bold;\">Discounted Price:</td>\n                <td style=\"padding: 8px; border-bottom: 1px solid #dee2e6;\">[[currency]] [[service_discounted_price]]</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 8px; font-weight: bold;\">Provider:</td>\n                <td style=\"padding: 8px;\">[[provider_name]] (ID: [[provider_id]])</td>\n            </tr>\n        </table>\n    </div>\n    \n    <div style=\"background-color: #e7f3ff; padding: 15px; border-radius: 5px; border-left: 4px solid #0066cc;\">\n        <p style=\"margin: 0;\"><strong>Note:</strong> Please review the updated service details in the admin panel to ensure all changes comply with your platform guidelines.</p>\n    </div>\n    \n    <div style=\"margin-top: 20px; padding-top: 20px; border-top: 1px solid #dee2e6; text-align: center; color: #6c757d; font-size: 12px;\">\n        <p>This is an automated notification from [[company_name]].</p>\n        <p>Visit <a href=\"[[site_url]]\" style=\"color: #0066cc;\">[[site_url]]</a> for more information.</p>\n        <p>[[company_contact_info]]</p>\n    </div>\n</body>\n</html>', NULL, NULL, '[\"provider_name\",\"provider_id\",\"service_id\",\"service_title\",\"service_description\",\"category_name\",\"category_id\",\"service_price\",\"service_discounted_price\",\"currency\",\"company_name\",\"site_url\",\"company_contact_info\"]');
INSERT INTO `notification_templates` (`id`, `event_key`, `title`, `body`, `parameters`, `created_at`, `updated_at`) VALUES (52, 'provider_edits_service_details', 'Service Details Edited', 'Provider [[provider_name]] has edited service \"[[service_title]]\". Please review the changes.', '[\"provider_name\",\"service_title\"]', '2025-12-18 16:13:16', '2025-12-18 16:13:16');
INSERT INTO `sms_templates` (`id`, `type`, `template`, `parameters`, `created_at`, `updated_at`, `title`) VALUES (70, 'provider_edits_service_details', 'Provider [[provider_name]] has edited service details. Service: [[service_title]] (ID: [[service_id]]). Category: [[category_name]]. Price: [[currency]] [[service_price]]. Please review in admin panel.', '[\"provider_name\",\"service_id\",\"service_title\",\"category_name\",\"service_price\",\"currency\"]', '2025-12-18 16:13:01', '2025-12-18 16:13:01', 'Provider Edits Service Details');
ALTER TABLE `services_ratings` CHANGE `updated_at` `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;
INSERT IGNORE INTO migrations (version, class, `group`, namespace, time) VALUES('2025-12-22-095732', 'AdoptExistingSchema', 'default', 'App\\Database\\Migrations', UNIX_TIMESTAMP());